/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ccm.report.overdue.function;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.algo.Field;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BigIntProp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scmc.ccm.business.core.DimensionValue;
import kd.scmc.ccm.business.core.Role;
import kd.scmc.ccm.business.scheme.BillStrategy;
import kd.scmc.ccm.business.scheme.CreditScheme;
import kd.scmc.ccm.business.service.CreditServiceFacade;
import kd.scmc.ccm.business.setting.DimensionEntryFieldMapper;
import kd.scmc.ccm.business.setting.EntityConfig;
import kd.scmc.ccm.common.helper.CurrencyHelper;
import kd.scmc.ccm.common.util.DateUtils;

public class ModifyUnionDataFunction
extends GroupReduceFunction {
    private RowMeta rptRowMeta;
    private Map<String, Integer> rptIndexMap;
    private Map<String, Integer> billIndexMap;
    private Long schemeId;
    private Long checkTypeId;
    private Map<String, Object[]> normalQuotaMap;
    private Map<Long, BigDecimal> tmpQuotaMap;

    public ModifyUnionDataFunction(RowMeta rptRowMeta, RowMeta billRowMeta, Long schemeId, Long checkTypeId, Map<String, Object[]> normalQuotaMap, Map<Long, BigDecimal> tmpQuotaMap) {
        this.rptRowMeta = rptRowMeta;
        this.schemeId = schemeId;
        this.checkTypeId = checkTypeId;
        this.normalQuotaMap = normalQuotaMap;
        this.tmpQuotaMap = tmpQuotaMap;
        Field[] rptFields = rptRowMeta.getFields();
        if (this.rptIndexMap == null) {
            this.rptIndexMap = new HashMap<String, Integer>(rptFields.length);
        }
        for (int i = 0; i < rptFields.length; ++i) {
            this.rptIndexMap.put(rptFields[i].getName(), i);
        }
        Field[] billFields = billRowMeta.getFields();
        if (this.billIndexMap == null) {
            this.billIndexMap = new HashMap<String, Integer>(billFields.length);
        }
        for (int i = 0; i < billFields.length; ++i) {
            this.billIndexMap.put(billFields[i].getName(), i);
        }
    }

    public void reduce(Iterable<RowX> iterable, Collector collector) {
        Iterator<RowX> iterator = iterable.iterator();
        CreditServiceFacade facade = new CreditServiceFacade();
        while (iterator.hasNext()) {
            Long normalArchiveId;
            Object[] normalQuotaData;
            RowX billRow = iterator.next();
            CreditScheme scheme = facade.getScheme(this.schemeId.longValue());
            BillStrategy billStrategy = (BillStrategy)scheme.getBillStrategies().get(0);
            String entityKey = billStrategy.getAssingEntityKey();
            int cusuniCodeIndex = -1;
            Long cusuniCodeId = 0L;
            List roles = scheme.getDimension().getRoles();
            DimensionValue dimensionValue = new DimensionValue(scheme.getDimension());
            DimensionEntryFieldMapper dimensionEntryFieldMapper = new DimensionEntryFieldMapper((Object)scheme.getDimension().getId());
            String assingEntityKey = billStrategy.getAssingEntityKey();
            EntityConfig entityConfig = facade.getConfig(entityKey);
            int roleIndex = 0;
            for (Role role : roles) {
                String roleType;
                QFilter q;
                DynamicObject roleId;
                MainEntityType assEntityType;
                Object roleValue = billRow.get(this.billIndexMap.get("role" + roleIndex).intValue());
                kd.scmc.ccm.business.core.Field field = entityConfig.getField(role.getElement());
                String fullName = field.getFullName();
                String baseDataKey = dimensionEntryFieldMapper.getBaseDataKey(role.getRoleType());
                MainEntityType roleBDEntityType = MetadataServiceHelper.getDataEntityType((String)baseDataKey);
                if (roleBDEntityType != null && roleBDEntityType.findProperty("masterid") != null && (assEntityType = MetadataServiceHelper.getDataEntityType((String)assingEntityKey)).getProperty(fullName) instanceof BigIntProp && (roleId = QueryServiceHelper.queryOne((String)baseDataKey, (String)"masterid", (QFilter[])new QFilter[]{q = new QFilter("id", "=", roleValue)})) != null) {
                    roleValue = roleId.getLong("masterid");
                    cusuniCodeIndex = roleIndex;
                    cusuniCodeId = (Long)roleValue;
                }
                if ("CUSUNICODE".equals(roleType = role.getRoleType())) {
                    DynamicObjectCollection cusunicodes = QueryServiceHelper.query((String)"ccm_cusunicode", (String)"id,entry.e_customer", (QFilter[])new QFilter[]{new QFilter("entry.e_customer", "=", roleValue)});
                    if (cusunicodes != null && !cusunicodes.isEmpty()) {
                        roleValue = ((DynamicObject)cusunicodes.get(0)).getLong("id");
                    }
                    cusuniCodeIndex = roleIndex;
                    cusuniCodeId = (Long)roleValue;
                }
                dimensionValue.putValue(role, roleValue);
                ++roleIndex;
            }
            String dimensionString = dimensionValue.getValue();
            BigDecimal quota_overdueday = BigDecimal.ZERO;
            BigDecimal tmp_overdueday = BigDecimal.ZERO;
            BigDecimal actual_overdueday = BigDecimal.ZERO;
            BigDecimal quota_overdueamt = BigDecimal.ZERO;
            BigDecimal tmp_overdueamt = BigDecimal.ZERO;
            BigDecimal actual_overdueamt = BigDecimal.ZERO;
            BigDecimal bill_overdueamt = BigDecimal.ZERO;
            String isover = "0";
            String quotaType = scheme.getQuotaType().getQuotaType();
            if ("days".equals(quotaType)) {
                Date now;
                Date overdueBillsDate;
                int billOverdueDays;
                normalQuotaData = this.normalQuotaMap.get(dimensionString);
                if (normalQuotaData != null) {
                    normalArchiveId = (Long)normalQuotaData[0];
                    quota_overdueday = (BigDecimal)normalQuotaData[1];
                    if (this.tmpQuotaMap.get(normalArchiveId) != null) {
                        tmp_overdueday = this.tmpQuotaMap.get(normalArchiveId);
                    }
                }
                if ((billOverdueDays = DateUtils.getDiffDays((Date)(overdueBillsDate = (Date)billRow.get(this.billIndexMap.get("calculateDate").intValue())), (Date)(now = new Date()))) > 0) {
                    actual_overdueday = new BigDecimal(billOverdueDays);
                }
                if (actual_overdueday.compareTo(quota_overdueday.add(tmp_overdueday)) > 0) {
                    isover = "1";
                }
            } else if ("overdueamt".equals(quotaType)) {
                normalQuotaData = this.normalQuotaMap.get(dimensionString);
                if (normalQuotaData != null) {
                    normalArchiveId = (Long)normalQuotaData[0];
                    quota_overdueamt = (BigDecimal)normalQuotaData[1];
                    if (this.tmpQuotaMap.get(normalArchiveId) != null) {
                        tmp_overdueamt = this.tmpQuotaMap.get(normalArchiveId);
                    }
                }
                bill_overdueamt = (BigDecimal)billRow.get(this.billIndexMap.get("calculateAmt").intValue());
                Long schemeCurrencyId = scheme.getCurrency();
                Long schemeExchangeRateTableId = scheme.getExchangeRateTable();
                Long billCurrencyId = (Long)billRow.get(this.billIndexMap.get("billcurrency").intValue());
                if (schemeCurrencyId.longValue() != billCurrencyId.longValue()) {
                    BigDecimal rate = CurrencyHelper.getExChangeRate((Long)billCurrencyId, (Long)schemeCurrencyId, (Long)schemeExchangeRateTableId, (Date)new Date());
                    if (rate != null) {
                        actual_overdueamt = bill_overdueamt.multiply(rate);
                    }
                } else {
                    actual_overdueamt = bill_overdueamt;
                }
                if (actual_overdueamt.compareTo(quota_overdueamt.add(tmp_overdueamt)) > 0) {
                    isover = "1";
                }
            }
            RowX rptRow = new RowX(this.rptIndexMap.size());
            Field[] rptFields = this.rptRowMeta.getFields();
            for (int i = 0; i < rptFields.length; ++i) {
                String fieldKey = rptFields[i].getName();
                String fieldType = rptFields[i].getDataType().getName();
                if ("scheme".equals(fieldKey)) {
                    rptRow.set(this.rptIndexMap.get(fieldKey).intValue(), (Object)this.schemeId);
                    continue;
                }
                if ("checktype".equals(fieldKey)) {
                    rptRow.set(this.rptIndexMap.get(fieldKey).intValue(), (Object)this.checkTypeId);
                    continue;
                }
                if ("dimensionvalue".equals(fieldKey)) {
                    rptRow.set(this.rptIndexMap.get(fieldKey).intValue(), (Object)dimensionString);
                    continue;
                }
                if ("billkey".equals(fieldKey)) {
                    rptRow.set(this.rptIndexMap.get(fieldKey).intValue(), (Object)entityKey);
                    continue;
                }
                if ("quota_overdueday".equals(fieldKey)) {
                    rptRow.set(this.rptIndexMap.get(fieldKey).intValue(), (Object)quota_overdueday);
                    continue;
                }
                if ("tmp_overdueday".equals(fieldKey)) {
                    rptRow.set(this.rptIndexMap.get(fieldKey).intValue(), (Object)tmp_overdueday);
                    continue;
                }
                if ("actual_overdueday".equals(fieldKey)) {
                    rptRow.set(this.rptIndexMap.get(fieldKey).intValue(), (Object)actual_overdueday);
                    continue;
                }
                if ("quota_overdueamt".equals(fieldKey)) {
                    rptRow.set(this.rptIndexMap.get(fieldKey).intValue(), (Object)quota_overdueamt);
                    continue;
                }
                if ("tmp_overdueamt".equals(fieldKey)) {
                    rptRow.set(this.rptIndexMap.get(fieldKey).intValue(), (Object)tmp_overdueamt);
                    continue;
                }
                if ("bill_overdueamt".equals(fieldKey)) {
                    rptRow.set(this.rptIndexMap.get(fieldKey).intValue(), (Object)bill_overdueamt);
                    continue;
                }
                if ("actual_overdueamt".equals(fieldKey)) {
                    rptRow.set(this.rptIndexMap.get(fieldKey).intValue(), (Object)actual_overdueamt);
                    continue;
                }
                if ("currency".equals(fieldKey)) {
                    rptRow.set(this.rptIndexMap.get(fieldKey).intValue(), (Object)scheme.getCurrency());
                    continue;
                }
                if ("isover".equals(fieldKey)) {
                    rptRow.set(this.rptIndexMap.get(fieldKey).intValue(), (Object)isover);
                    continue;
                }
                if (cusuniCodeIndex != -1 && ("role" + cusuniCodeIndex).equals(fieldKey)) {
                    rptRow.set(this.rptIndexMap.get(fieldKey).intValue(), (Object)cusuniCodeId);
                    continue;
                }
                if (this.billIndexMap.get(fieldKey) != null) {
                    rptRow.set(this.rptIndexMap.get(fieldKey).intValue(), billRow.get(this.billIndexMap.get(fieldKey).intValue()));
                    continue;
                }
                if ("Long".equals(fieldType)) {
                    rptRow.set(this.rptIndexMap.get(fieldKey).intValue(), (Object)0L);
                    continue;
                }
                if ("BigDecimal".equals(fieldType)) {
                    rptRow.set(this.rptIndexMap.get(fieldKey).intValue(), (Object)BigDecimal.ZERO);
                    continue;
                }
                if ("Integer".equals(fieldType)) {
                    rptRow.set(this.rptIndexMap.get(fieldKey).intValue(), (Object)0);
                    continue;
                }
                if ("String".equals(fieldType)) {
                    rptRow.set(this.rptIndexMap.get(fieldKey).intValue(), (Object)"");
                    continue;
                }
                rptRow.set(this.rptIndexMap.get(fieldKey).intValue(), null);
            }
            collector.collect(rptRow);
        }
    }

    public RowMeta getResultRowMeta() {
        return this.rptRowMeta;
    }
}

