/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ccm.opplugin.archive;

import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.db.DB;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scmc.ccm.business.archives.IArchiveGenerator;
import kd.scmc.ccm.business.setting.BillFieldAssociatedCheckTypeMapper;
import kd.scmc.ccm.business.setting.CheckTypeFieldTempImpl;
import kd.scmc.ccm.business.setting.DimensionEntryFieldMapper;
import kd.scmc.ccm.common.util.DateUtils;

public class ApplytoArchiveGenerator
implements IArchiveGenerator {
    private CheckTypeFieldTempImpl checkTypeFieldTempImpl;
    private BillFieldAssociatedCheckTypeMapper billMapper;

    public Collection<DynamicObject> generate(DynamicObject[] archiveApplys) {
        this.checkTypeFieldTempImpl = new CheckTypeFieldTempImpl();
        LinkedList<DynamicObject> archives = new LinkedList<DynamicObject>();
        long[] archiveIds = this.genArchiveIds(archiveApplys);
        int count = 0;
        for (DynamicObject archiveApply : archiveApplys) {
            this.billMapper = new BillFieldAssociatedCheckTypeMapper(archiveApply);
            DynamicObject scheme = archiveApply.getDynamicObject("scheme");
            DynamicObject dimension = scheme.getDynamicObject("dimension");
            DimensionEntryFieldMapper mapper = new DimensionEntryFieldMapper(dimension.getPkValue());
            DynamicObjectCollection entry = archiveApply.getDynamicObjectCollection("entry");
            for (DynamicObject row : entry) {
                DynamicObject archive = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"ccm_archive"));
                archive.set("id", (Object)archiveIds[count]);
                row.set("archiveid", (Object)archiveIds[count]);
                ++count;
                this.setArchiveFields(archive, row, archiveApply, mapper);
                archives.add(archive);
            }
        }
        this.setRelatedId(archives);
        return archives;
    }

    private long[] genArchiveIds(DynamicObject[] bills) {
        int archiveIdCount = 0;
        for (DynamicObject bill : bills) {
            DynamicObjectCollection entry = bill.getDynamicObjectCollection("entry");
            archiveIdCount += entry.size();
        }
        long[] archiveIds = DB.genLongIds((String)"ccm_archive", (int)archiveIdCount);
        return archiveIds;
    }

    private void setArchiveFields(DynamicObject archive, DynamicObject row, DynamicObject archiveApply, DimensionEntryFieldMapper mapper) {
        DynamicObject measureUnit;
        List associatedFieldList;
        DynamicObject scheme = archiveApply.getDynamicObject("scheme");
        String checkType = scheme.getDynamicObject("checktype").getString("number");
        String validity = scheme.getString("validity");
        DynamicObject dimension = scheme.getDynamicObject("dimension");
        List fieldKeys = mapper.getRoleFieldKeys();
        List fieldTypeKeys = mapper.getFieldTypeKeys();
        for (String fieldKey : fieldKeys) {
            DynamicObject roleValue = row.getDynamicObject(fieldKey);
            DynamicProperty property = roleValue.getDynamicObjectType().getProperty("masterid");
            String pk = property == null ? "id" : "masterid";
            archive.set(fieldKey, (Object)roleValue.getLong(pk));
        }
        for (String fieldTypeKey : fieldTypeKeys) {
            archive.set(fieldTypeKey, (Object)mapper.getBaseDataKey(fieldTypeKey));
        }
        archive.set("scheme", (Object)scheme);
        archive.set("dimension", (Object)dimension.getLong("id"));
        String dimensionValue = this.getDimensionValue(fieldKeys, row);
        archive.set("dimensionvalue", (Object)dimensionValue);
        archive.set("begindate", (Object)DateUtils.getStartOfDay((Date)archiveApply.getDate("begindate")));
        archive.set("enddate", (Object)DateUtils.getEndOfDay((Date)archiveApply.getDate("enddate")));
        if ("PERPETUAL".equals(validity)) {
            archive.set("effectstate", (Object)"ISEFFECT");
        } else if (archiveApply.getDate("enddate").compareTo(new Date()) < 0) {
            archive.set("effectstate", (Object)"EXPRIED");
        } else {
            archive.set("effectstate", (Object)"NOEFFECT");
        }
        archive.set("archivetype", (Object)"normal");
        String fieldName = this.checkTypeFieldTempImpl.getFieldKey(checkType);
        archive.set("quota", row.get(fieldName));
        archive.set("balance", row.get(fieldName));
        String relatedMark = this.checkTypeFieldTempImpl.getRelatedFieldMark(checkType);
        archive.set("quotatype", (Object)relatedMark);
        archive.set("grade", row.get("grade"));
        if ("KZFW001".equals(checkType) || "KZFW006".equals(checkType) || "KZFW010".equals(checkType)) {
            archive.set("unit", (Object)scheme.getLong("currency.id"));
        }
        if ((associatedFieldList = this.billMapper.getAssociatedFieldList()).contains("measureunit_qty") && (measureUnit = row.getDynamicObject("measureunit_qty")) != null) {
            archive.set("unit", (Object)measureUnit.getLong("id"));
        }
    }

    private String getDimensionValue(List<String> fieldKeys, DynamicObject row) {
        LinkedList<String> pkValues = new LinkedList<String>();
        for (String fieldKey : fieldKeys) {
            DynamicProperty property = row.getDynamicObject(fieldKey).getDynamicObjectType().getProperty("masterid");
            if (property == null) {
                pkValues.add(row.getDynamicObject(fieldKey).getString("id"));
                continue;
            }
            pkValues.add(row.getDynamicObject(fieldKey).getString("masterid"));
        }
        return String.join((CharSequence)"-", pkValues);
    }

    private void setRelatedId(List<DynamicObject> archives) {
        HashSet<String> dimensionValues = new HashSet<String>(archives.size());
        HashSet<Long> schemeIds = new HashSet<Long>(archives.size());
        for (DynamicObject archive : archives) {
            schemeIds.add(archive.getDynamicObject("scheme").getLong("id"));
            dimensionValues.add(archive.getString("dimensionvalue"));
        }
        DynamicObjectCollection existingArchives = QueryServiceHelper.query((String)"ccm_archive", (String)"scheme,dimensionvalue,relatedid", (QFilter[])new QFilter[]{new QFilter("scheme", "in", schemeIds), new QFilter("dimensionvalue", "in", dimensionValues)});
        Map<String, Long> existingArchiveRelatedIdMap = this.recordArchiveRelatedIdMap(existingArchives);
        for (DynamicObject archive : archives) {
            String schemeId = archive.getDynamicObject("scheme").getString("id");
            String dimensionValue = archive.getString("dimensionvalue");
            Long relatedId = existingArchiveRelatedIdMap.get(schemeId + dimensionValue);
            if (relatedId == null) {
                archive.set("relatedid", (Object)archive.getLong("id"));
                continue;
            }
            archive.set("relatedid", (Object)relatedId);
        }
    }

    private Map<String, Long> recordArchiveRelatedIdMap(DynamicObjectCollection archives) {
        HashMap<String, Long> archiveRelatedIdMap = new HashMap<String, Long>();
        for (DynamicObject archive : archives) {
            String schemeId = archive.getString("scheme");
            String dimensionValue = archive.getString("dimensionvalue");
            archiveRelatedIdMap.put(schemeId + dimensionValue, archive.getLong("relatedid"));
        }
        return archiveRelatedIdMap;
    }
}

