/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ccm.opplugin.archive;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.scmc.ccm.business.setting.CheckTypeFieldTempImpl;
import kd.scmc.ccm.business.setting.FieldMapper;
import kd.scmc.ccm.common.helper.BillEntityHelper;
import kd.scmc.ccm.common.util.DateUtils;
import kd.scmc.ccm.common.util.OrmFacade;
import kd.scmc.ccm.opplugin.archive.ApplytoArchiveGenerator;
import kd.scmc.ccm.opplugin.archive.ArchiveUniqueDimensionValidator;

public class ArchiveApplyAuditOp
extends AbstractOperationServicePlugIn {
    private FieldMapper checkTypeFieldMapper = new CheckTypeFieldTempImpl();
    private OrmFacade ormFacade = new OrmFacade();
    private static final String KEY_SCHEME = "scheme";

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new ArchiveUniqueDimensionValidator());
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List keys = e.getFieldKeys();
        keys.add(KEY_SCHEME);
        for (String fieldKey : this.checkTypeFieldMapper.getFieldKeys()) {
            keys.add(fieldKey);
        }
        keys.add("begindate");
        keys.add("enddate");
        keys.add("archiveid");
        keys.add("grade");
        keys.add("applyyear");
        for (String roleField : BillEntityHelper.getAllRoleFields()) {
            keys.add(roleField);
        }
        for (String roleType : BillEntityHelper.getAllRoleTypeFields()) {
            keys.add(roleType);
        }
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] archiveApplys;
        super.beginOperationTransaction(e);
        for (DynamicObject archiveApply : archiveApplys = e.getDataEntities()) {
            DynamicObject scheme = archiveApply.getDynamicObject(KEY_SCHEME);
            String validity = scheme.getString("validity");
            if (!"PERPETUAL".equals(validity)) continue;
            archiveApply.set("begindate", (Object)new Date());
            archiveApply.set("enddate", (Object)DateUtils.getYearsLaterDate((Date)new Date(), (int)100));
        }
        ApplytoArchiveGenerator generator = new ApplytoArchiveGenerator();
        Collection archives = generator.generate(archiveApplys);
        if (!archives.isEmpty()) {
            this.ormFacade.save(archives);
        }
    }
}

