/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ccm.opplugin.archive;

import java.util.LinkedList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.scmc.ccm.business.setting.CheckTypeFieldTempImpl;
import kd.scmc.ccm.business.setting.FieldMapper;
import kd.scmc.ccm.common.helper.BillEntityHelper;
import kd.scmc.ccm.common.util.OrmFacade;
import kd.scmc.ccm.opplugin.archive.ArchiveUnAuditValidator;

public class ArchiveApplyUnAuditOp
extends AbstractOperationServicePlugIn {
    private FieldMapper checkTypeFieldMapper = new CheckTypeFieldTempImpl();
    private OrmFacade ormFacade = new OrmFacade();
    private static final String KEY_SCHEME = "scheme";
    private static final String KEY_ENTRY = "entry";
    private static final String KEY_ARCHIVE = "ccm_archive";

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new ArchiveUnAuditValidator());
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List keys = e.getFieldKeys();
        keys.add(KEY_SCHEME);
        for (String fieldKey : this.checkTypeFieldMapper.getFieldKeys()) {
            keys.add(fieldKey);
        }
        keys.add("archiveid");
        for (String roleField : BillEntityHelper.getAllRoleFields()) {
            keys.add(roleField);
        }
        for (String roleType : BillEntityHelper.getAllRoleTypeFields()) {
            keys.add(roleType);
        }
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] entities;
        super.beginOperationTransaction(e);
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)KEY_ARCHIVE);
        LinkedList<Long> archiveIds = new LinkedList<Long>();
        for (DynamicObject entity : entities = e.getDataEntities()) {
            DynamicObjectCollection entry = entity.getDynamicObjectCollection(KEY_ENTRY);
            for (DynamicObject row : entry) {
                archiveIds.add(row.getLong("archiveid"));
            }
        }
        DynamicObjectCollection archives = this.ormFacade.query(KEY_ARCHIVE, "id,quota,balance", new QFilter[]{new QFilter("id", "in", archiveIds)});
        LinkedList<Long> deleteList = new LinkedList<Long>();
        for (DynamicObject archive : archives) {
            if (archive.getBigDecimal("quota").compareTo(archive.getBigDecimal("balance")) != 0) continue;
            deleteList.add(archive.getLong("id"));
        }
        if (!deleteList.isEmpty()) {
            this.ormFacade.delete((IDataEntityType)dt, deleteList);
        }
    }
}

