/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ccm.opplugin.archive;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.scmc.ccm.business.setting.CheckTypeFieldTempImpl;
import kd.scmc.ccm.common.helper.BillEntityHelper;
import kd.scmc.ccm.common.util.DateUtils;
import kd.scmc.ccm.common.util.OrmFacade;
import kd.scmc.ccm.opplugin.archive.ArchiveChangeUniqueDimensionArchiveValidator;

public class ArchiveChangeAuditOp
extends AbstractOperationServicePlugIn {
    private static final Log log = LogFactory.getLog(ArchiveChangeAuditOp.class);
    private OrmFacade ormFacade = new OrmFacade();
    private CheckTypeFieldTempImpl checkTypeFieldTempImpl;

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List keys = e.getFieldKeys();
        keys.add("schemeentry.seq");
        keys.add("archiveid");
        keys.add("scheme");
        keys.add("scheme.checktype.number");
        keys.add("dimension");
        keys.add("dimensionvalue");
        keys.add("currency");
        keys.add("grade");
        keys.add("quota_amount");
        keys.add("balance");
        keys.add("quota_days");
        keys.add("quota_qty");
        keys.add("quota_overdueamt");
        keys.add("begindate");
        keys.add("enddate");
        for (String roleField : BillEntityHelper.getAllRoleFields()) {
            keys.add(roleField);
        }
        for (String roleType : BillEntityHelper.getAllRoleTypeFields()) {
            keys.add(roleType);
        }
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new ArchiveChangeUniqueDimensionArchiveValidator());
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        try (TraceSpan span = Tracer.create((String)"ArchiveChangeAuditOp", (String)"endOperationTransaction");){
            DynamicObject[] changeBills = e.getDataEntities();
            HashSet<Long> changeBillArchiveIDSet = new HashSet<Long>(16);
            this.checkTypeFieldTempImpl = new CheckTypeFieldTempImpl();
            for (DynamicObject changeBill : changeBills) {
                DynamicObjectCollection entrys = changeBill.getDynamicObjectCollection("schemeentry");
                if (entrys == null || entrys.size() <= 0) continue;
                for (DynamicObject entry : entrys) {
                    changeBillArchiveIDSet.add(entry.getLong("archiveid"));
                }
            }
            if (changeBillArchiveIDSet.size() > 0) {
                QFilter archiveIDFilter = new QFilter("id", "in", changeBillArchiveIDSet);
                DynamicObject[] archives = BusinessDataServiceHelper.load((String)"ccm_archive", (String)"dimensionvalue,quotatype,quota,balance,begindate,enddate,grade", (QFilter[])new QFilter[]{archiveIDFilter});
                HashMap<Long, DynamicObject> destMap = new HashMap<Long, DynamicObject>(16);
                for (DynamicObject cbill : changeBills) {
                    if (cbill == null || cbill.getDynamicObject("scheme") == null || cbill.getDynamicObject("scheme").getDynamicObject("checktype") == null) {
                        log.info("cbill == null \u6216\u8005 cbill.scheme == null \u6216\u8005 cbill.scheme.checktype == null");
                        continue;
                    }
                    String checkType = cbill.getDynamicObject("scheme").getDynamicObject("checktype").getString("number");
                    DynamicObjectCollection rows = cbill.getDynamicObjectCollection("schemeentry");
                    for (DynamicObject row : rows) {
                        long archiveIDInRow = row.getLong("archiveid");
                        for (DynamicObject archive : archives) {
                            if (archive == null || archiveIDInRow != archive.getLong("id")) continue;
                            this.changeArchive(archive, row, checkType);
                            destMap.put(archiveIDInRow, archive);
                        }
                    }
                }
                if (destMap.size() > 0) {
                    this.ormFacade.save(destMap.values());
                }
            }
        }
    }

    private void changeArchive(DynamicObject archive, DynamicObject archiveChangeBillRow, String checkType) {
        StringBuilder changeArchiveLog = new StringBuilder();
        changeArchiveLog.append("archiveid:").append(archive.getPkValue()).append(',');
        changeArchiveLog.append("oldbegindate: ").append(archive.get("begindate")).append(',');
        changeArchiveLog.append("oldenddate: ").append(archive.get("enddate")).append(',');
        changeArchiveLog.append("oldquota: ").append(archive.get("quota")).append(',');
        changeArchiveLog.append("oldbalance: ").append(archive.get("balance")).append('\n');
        changeArchiveLog.append("entryid:").append(archiveChangeBillRow.getPkValue()).append(',');
        changeArchiveLog.append("newbegindate:").append(archiveChangeBillRow.get("begindate")).append(',');
        changeArchiveLog.append("newenddate:").append(archiveChangeBillRow.get("enddate")).append(',');
        archive.set("grade", (Object)archiveChangeBillRow.getLong("grade.id"));
        archive.set("begindate", (Object)DateUtils.getStartOfDay((Date)archiveChangeBillRow.getDate("begindate")));
        archive.set("enddate", (Object)DateUtils.getEndOfDay((Date)archiveChangeBillRow.getDate("enddate")));
        String fieldKey = this.checkTypeFieldTempImpl.getFieldKey(checkType);
        BigDecimal diffrenceOfQuota = archiveChangeBillRow.getBigDecimal(fieldKey).subtract(archive.getBigDecimal("quota"));
        archive.set("quota", (Object)archiveChangeBillRow.getBigDecimal(fieldKey));
        changeArchiveLog.append("newquota: ").append(archiveChangeBillRow.getBigDecimal(fieldKey)).append(',');
        BigDecimal oldBalance = archive.getBigDecimal("balance");
        archive.set("balance", (Object)oldBalance.add(diffrenceOfQuota));
        changeArchiveLog.append("newbalance: ").append(oldBalance.add(diffrenceOfQuota)).append(';');
        log.info(changeArchiveLog.toString());
    }
}

