/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ccm.opplugin.archive;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scmc.ccm.business.setting.DimensionEntryFieldMapper;
import kd.scmc.ccm.common.util.DateUtils;

public class ArchiveChangeUniqueDimensionArchiveValidator
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity[] datas = this.getDataEntities();
        HashSet<Long> changeBillArchiveIDSet = new HashSet<Long>(16);
        HashSet<Long> schemeIds = new HashSet<Long>(16);
        HashSet<String> dimensionValueSet = new HashSet<String>(16);
        for (ExtendedDataEntity data : datas) {
            DynamicObject scheme;
            DynamicObject archiveChange = data.getDataEntity();
            if (archiveChange == null || (scheme = archiveChange.getDynamicObject("scheme")) == null || scheme.getDynamicObject("dimension") == null) continue;
            schemeIds.add(scheme.getLong("id"));
            DynamicObject dimension = scheme.getDynamicObject("dimension");
            DimensionEntryFieldMapper mapper = new DimensionEntryFieldMapper(dimension.getPkValue());
            List fieldKeys = mapper.getRoleFieldKeys();
            DynamicObjectCollection entrys = archiveChange.getDynamicObjectCollection("schemeentry");
            if (entrys == null || entrys.size() == 0) {
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u8bf7\u5148\u65b0\u589e\u4e00\u884c\u5206\u5f55\u3002", (String)"ArchiveChangeUniqueDimensionArchiveValidator_2", (String)"scmc-ccm-opplugin", (Object[])new Object[0]));
                continue;
            }
            for (DynamicObject entry : entrys) {
                if (entry == null || entry.getLong("archiveid") <= 0L) continue;
                changeBillArchiveIDSet.add(entry.getLong("archiveid"));
                String dimensionValue = this.getDimensionValue(fieldKeys, entry);
                dimensionValueSet.add(dimensionValue);
            }
        }
        Map exsistArchives = BusinessDataServiceHelper.loadFromCache((Object[])changeBillArchiveIDSet.toArray(), (String)"ccm_archive");
        QFilter schemeFilter = new QFilter("scheme", "in", schemeIds);
        QFilter schemeValidityFilter = new QFilter("scheme.validity", "in", (Object)"YEAR");
        QFilter typeFilter = new QFilter("archivetype", "=", (Object)"normal");
        QFilter dimensionValueFilter = new QFilter("dimensionvalue", "in", dimensionValueSet);
        DataSet archiveDS = QueryServiceHelper.queryDataSet((String)ArchiveChangeUniqueDimensionArchiveValidator.class.getName(), (String)"ccm_archive", (String)"id,scheme,archivetype,dimensionvalue,begindate,enddate", (QFilter[])new QFilter[]{schemeFilter, schemeValidityFilter, typeFilter, dimensionValueFilter}, null);
        for (ExtendedDataEntity data : datas) {
            DynamicObject scheme;
            DynamicObject secArchiveChange = data.getDataEntity();
            if (secArchiveChange == null || (scheme = secArchiveChange.getDynamicObject("scheme")) == null || scheme.getDynamicObject("dimension") == null) continue;
            long secSchemeID = scheme.getLong("id");
            DynamicObject dimension = scheme.getDynamicObject("dimension");
            DimensionEntryFieldMapper mapper = new DimensionEntryFieldMapper(dimension.getPkValue());
            List fieldKeys = mapper.getRoleFieldKeys();
            DynamicObjectCollection rows = secArchiveChange.getDynamicObjectCollection("schemeentry");
            if (rows == null) continue;
            for (int i = 0; i < rows.size(); ++i) {
                DynamicObject row = (DynamicObject)rows.get(i);
                if (row == null) continue;
                long archiveIDInRow = row.getLong("archiveid");
                if (archiveIDInRow == 0L || exsistArchives != null && !exsistArchives.containsKey(archiveIDInRow)) {
                    this.addMessage(data, String.format(ResManager.loadKDString((String)"\u4fe1\u7528\u6863\u6848\u8bbe\u7f6e\u7b2c%1$s\u884c\u6863\u6848\u4e0d\u5b58\u5728\uff0c\u8bf7\u4fee\u6539\u3002", (String)"ArchiveChangeUniqueDimensionArchiveValidator_0", (String)"scmc-ccm-opplugin", (Object[])new Object[0]), i + 1), ErrorLevel.Error);
                    continue;
                }
                if (!"YEAR".equals(scheme.getString("validity"))) continue;
                Date newBeginDate = row.getDate("begindate");
                Date newEndDate = row.getDate("enddate");
                if (newBeginDate == null || newEndDate == null) continue;
                String secRowDV = this.getDimensionValue(fieldKeys, row);
                if (archiveDS == null) continue;
                DataSet archiveCopyDS = archiveDS.copy();
                while (archiveCopyDS.hasNext()) {
                    Row archive = archiveCopyDS.next();
                    long archiveSchemeID = archive.getLong("scheme");
                    String archiveDV = archive.getString("dimensionvalue");
                    Date archiveBeginDate = archive.getDate("begindate");
                    Date archiveEndDate = archive.getDate("enddate");
                    if (archiveBeginDate == null || archiveEndDate == null || secSchemeID != archiveSchemeID || !secRowDV.equals(archiveDV) || archiveIDInRow == archive.getLong("id")) continue;
                    Date newBeginDateSt = DateUtils.getStartOfDay((Date)newBeginDate);
                    Date newEndDateSt = DateUtils.getEndOfDay((Date)newEndDate);
                    if (archiveBeginDate.after(newEndDateSt) || archiveEndDate.before(newBeginDateSt)) continue;
                    SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd");
                    this.addMessage(data, String.format(ResManager.loadKDString((String)"\u4fe1\u7528\u6863\u6848\u8bbe\u7f6e\u7b2c%1$s\u884c\u201c\u7ef4\u5ea6\u6210\u5458\u503c\u201d\u7ec4\u5408\u7684\u201c\u751f\u6548\u65e5\u671f\u8303\u56f4\u201d\u4e0e\u5df2\u5b58\u5728\u7684\u4fe1\u7528\u6863\u6848\u751f\u6548\u65e5\u671f\u8303\u56f4\u201c%2$s-%3$s\u201d\u6709\u4ea4\u53c9\uff0c\u8bf7\u4fee\u6539\u3002", (String)"ArchiveChangeUniqueDimensionArchiveValidator_1", (String)"scmc-ccm-opplugin", (Object[])new Object[0]), i + 1, format.format(archiveBeginDate), format.format(archiveEndDate)), ErrorLevel.Error);
                }
            }
        }
        if (archiveDS != null) {
            archiveDS.close();
        }
    }

    private String getDimensionValue(List<String> fieldKeys, DynamicObject row) {
        LinkedList<String> pkValues = new LinkedList<String>();
        for (String fieldKey : fieldKeys) {
            if (row.getDynamicObject(fieldKey) == null) {
                pkValues.add(String.valueOf(0L));
                continue;
            }
            DynamicProperty property = row.getDynamicObject(fieldKey).getDynamicObjectType().getProperty("masterid");
            if (property == null) {
                pkValues.add(row.getDynamicObject(fieldKey).getString("id"));
                continue;
            }
            pkValues.add(row.getDynamicObject(fieldKey).getString("masterid"));
        }
        return String.join((CharSequence)"-", pkValues);
    }
}

