/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ccm.opplugin.archive;

import java.util.HashSet;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.validate.AbstractValidator;
import kd.scmc.ccm.common.util.OrmFacade;

public class ArchiveGradeValidator
extends AbstractValidator {
    private OrmFacade ormFacade = new OrmFacade();

    public void validate() {
        ExtendedDataEntity[] datas = this.getDataEntities();
        HashSet<Long> schemeIds = new HashSet<Long>(datas.length);
        for (ExtendedDataEntity data : datas) {
            schemeIds.add(data.getDataEntity().getDynamicObject("scheme").getLong("id"));
        }
        Set<DynamicObject> schemeSet = this.getSchemeSet(schemeIds);
        for (ExtendedDataEntity data : datas) {
            DynamicObject archive = data.getDataEntity();
            String archiveName = archive.getDataEntityType().getName();
            String rowName = "";
            if ("ccm_archive_apply".equals(archiveName)) {
                rowName = "entry";
            } else if ("ccm_archive_change".equals(archiveName)) {
                rowName = "schemeentry";
            } else if ("ccm_temp_archive".equals(archiveName)) {
                rowName = "temparchiveentry";
            }
            DynamicObject scheme = archive.getDynamicObject("scheme");
            scheme = this.matchScheme(scheme.getLong("id"), schemeSet);
            DynamicObject dimension = scheme.getDynamicObject("dimension");
            boolean isExistCustomer = this.getIsExistCustomer(dimension);
            if (!isExistCustomer) continue;
            DynamicObjectCollection rows = archive.getDynamicObjectCollection(rowName);
            int rowCount = 0;
            for (DynamicObject row : rows) {
                ++rowCount;
                if (!ObjectUtils.isEmpty((Object)row.get("grade"))) continue;
                String errMessage = ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u7b2c%s\u884c\u4fe1\u7528\u7b49\u7ea7\u5b57\u6bb5\u3002", (String)"ArchiveGradeValidator_1", (String)"scmc-ccm-opplugin", (Object[])new Object[0]);
                this.addErrorMessage(data, String.format(errMessage, rowCount));
            }
        }
    }

    private Set<DynamicObject> getSchemeSet(Set<Long> schemeId) {
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)"ccm_scheme");
        DynamicObject[] schemes = this.ormFacade.load(schemeId.toArray(), dt);
        HashSet<DynamicObject> schemeSet = new HashSet<DynamicObject>(schemes.length);
        for (DynamicObject scheme : schemes) {
            schemeSet.add(scheme);
        }
        return schemeSet;
    }

    private DynamicObject matchScheme(long schemeId, Set<DynamicObject> schemeSet) {
        DynamicObject nowScheme = new DynamicObject();
        for (DynamicObject scheme : schemeSet) {
            if (scheme.getLong("id") != schemeId) continue;
            nowScheme = scheme;
        }
        return nowScheme;
    }

    private boolean getIsExistCustomer(DynamicObject dimension) {
        DynamicObjectCollection rows = dimension.getDynamicObjectCollection("entry");
        for (DynamicObject row : rows) {
            if (!"CUSTOMER".equals(row.getDynamicObject("role").getString("number"))) continue;
            return true;
        }
        return false;
    }
}

