/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ccm.opplugin.archive;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.scmc.ccm.common.util.OrmFacade;

public class ArchiveUnAuditValidator
extends AbstractValidator {
    private OrmFacade ormFacade = new OrmFacade();

    public void validate() {
        ExtendedDataEntity[] datas = this.getDataEntities();
        HashSet<Long> archiveApplyByArchiveIds = new HashSet<Long>(datas.length);
        for (ExtendedDataEntity data : datas) {
            DynamicObject archiveApply = data.getDataEntity();
            DynamicObjectCollection rows = archiveApply.getDynamicObjectCollection("entry");
            for (DynamicObject row : rows) {
                archiveApplyByArchiveIds.add(row.getLong("archiveid"));
            }
        }
        this.existJournalValidate(datas, archiveApplyByArchiveIds);
        this.existTempArchiveValidate(datas, archiveApplyByArchiveIds);
        this.existArchiveChangeValidate(datas, archiveApplyByArchiveIds);
    }

    private void existJournalValidate(ExtendedDataEntity[] datas, Set<Long> archiveApplyByArchiveIds) {
        QFilter[] filters = new QFilter[]{new QFilter("archiveid", "in", archiveApplyByArchiveIds)};
        DynamicObjectCollection journals = this.ormFacade.query("ccm_journal", "archiveid", filters);
        HashSet<Long> journalByArchiveIds = new HashSet<Long>();
        for (DynamicObject journal : journals) {
            journalByArchiveIds.add(journal.getLong("archiveid"));
        }
        block1: for (ExtendedDataEntity data : datas) {
            DynamicObject archiveApply = data.getDataEntity();
            DynamicObjectCollection rows = archiveApply.getDynamicObjectCollection("entry");
            for (DynamicObject row : rows) {
                if (!journalByArchiveIds.contains(row.getLong("archiveid"))) continue;
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u5b58\u5728\u4fe1\u7528\u6d41\u6c34\uff0c\u65e0\u6cd5\u53cd\u5ba1\u6838\u3002", (String)"ArchiveUnAuditValidator_0", (String)"scmc-ccm-opplugin", (Object[])new Object[0]));
                continue block1;
            }
        }
    }

    private void existTempArchiveValidate(ExtendedDataEntity[] datas, Set<Long> archiveApplyByArchiveIds) {
        Object[] tempArchives = this.ormFacade.load("ccm_temp_archive", "temparchiveentry.mainarchiveid", new QFilter[]{new QFilter("temparchiveentry.mainarchiveid", "in", archiveApplyByArchiveIds)});
        if (ObjectUtils.isEmpty((Object[])tempArchives)) {
            return;
        }
        LinkedList<Long> tempArchiveByArchiveIds = new LinkedList<Long>();
        for (Object tempArchive : tempArchives) {
            DynamicObjectCollection temparchiveRows = tempArchive.getDynamicObjectCollection("temparchiveentry");
            for (DynamicObject temparchiveRow : temparchiveRows) {
                tempArchiveByArchiveIds.add(temparchiveRow.getLong("mainarchiveid"));
            }
        }
        block2: for (ExtendedDataEntity data : datas) {
            DynamicObject archiveApply = data.getDataEntity();
            DynamicObjectCollection archiveApplyRows = archiveApply.getDynamicObjectCollection("entry");
            for (DynamicObject archiveApplyRow : archiveApplyRows) {
                if (!tempArchiveByArchiveIds.contains(archiveApplyRow.getLong("archiveid"))) continue;
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u5b58\u5728\u4e34\u65f6\u4fe1\u7528\u6863\u6848\u7533\u8bf7\u5355\uff0c\u65e0\u6cd5\u53cd\u5ba1\u6838\u3002", (String)"ArchiveUnAuditValidator_1", (String)"scmc-ccm-opplugin", (Object[])new Object[0]));
                continue block2;
            }
        }
    }

    private void existArchiveChangeValidate(ExtendedDataEntity[] datas, Set<Long> archiveApplyByArchiveIds) {
        Object[] archiveChanges = this.ormFacade.load("ccm_archive_change", "schemeentry.archiveid", new QFilter[]{new QFilter("schemeentry.archiveid", "in", archiveApplyByArchiveIds)});
        if (ObjectUtils.isEmpty((Object[])archiveChanges)) {
            return;
        }
        LinkedList<Long> archiveChangeByArchiveIds = new LinkedList<Long>();
        for (Object archiveChange : archiveChanges) {
            DynamicObjectCollection archiveChangeRows = archiveChange.getDynamicObjectCollection("schemeentry");
            for (DynamicObject archiveChangeRow : archiveChangeRows) {
                archiveChangeByArchiveIds.add(archiveChangeRow.getLong("archiveid"));
            }
        }
        block2: for (ExtendedDataEntity data : datas) {
            DynamicObject archiveApply = data.getDataEntity();
            DynamicObjectCollection archiveApplyRows = archiveApply.getDynamicObjectCollection("entry");
            for (DynamicObject archiveApplyRow : archiveApplyRows) {
                if (!archiveChangeByArchiveIds.contains(archiveApplyRow.getLong("archiveid"))) continue;
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u5b58\u5728\u4fe1\u7528\u6863\u6848\u53d8\u66f4\u7533\u8bf7\u5355\uff0c\u65e0\u6cd5\u53cd\u5ba1\u6838\u3002", (String)"ArchiveUnAuditValidator_2", (String)"scmc-ccm-opplugin", (Object[])new Object[0]));
                continue block2;
            }
        }
    }
}

