/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ccm.opplugin.archive;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scmc.ccm.business.core.DimensionValue;
import kd.scmc.ccm.business.core.Role;
import kd.scmc.ccm.business.scheme.CreditScheme;
import kd.scmc.ccm.business.scheme.SchemeReader;
import kd.scmc.ccm.business.setting.DimensionEntryFieldMapper;
import kd.scmc.ccm.common.util.OrmFacade;

public class ArchiveUniqueDimensionValidator
extends AbstractValidator {
    private static final Log logger = LogFactory.getLog(ArchiveUniqueDimensionValidator.class);
    private OrmFacade ormFacade = new OrmFacade();

    public void validate() {
        ExtendedDataEntity[] datas = this.getDataEntities();
        HashMap dimensonValueMap = new HashMap(datas.length);
        HashSet<Long> schemeIds = new HashSet<Long>(datas.length);
        HashSet<String> allDimensionValues = new HashSet<String>(datas.length);
        for (ExtendedDataEntity data : datas) {
            DynamicObject archiveApply = data.getDataEntity();
            if (archiveApply == null || archiveApply.getDynamicObject("scheme") == null) continue;
            DynamicObject scheme = archiveApply.getDynamicObject("scheme");
            schemeIds.add(scheme.getLong("id"));
            DynamicObjectCollection entry = archiveApply.getDynamicObjectCollection("entry");
            long dimensionId = archiveApply.getDynamicObject("scheme").getDynamicObject("dimension").getLong("id");
            DimensionEntryFieldMapper roleFieldMapperImpl = new DimensionEntryFieldMapper((Object)dimensionId);
            List fieldKeys = roleFieldMapperImpl.getRoleFieldKeys();
            HashSet<String> thisBillDimensionValues = new HashSet<String>();
            for (DynamicObject row : entry) {
                String dimensionValue = this.getDimensionValue(fieldKeys, row);
                allDimensionValues.add(String.join((CharSequence)"-", dimensionValue));
                thisBillDimensionValues.add(String.join((CharSequence)"-", dimensionValue));
            }
            dimensonValueMap.put(data.getBillPkId(), thisBillDimensionValues);
            if (thisBillDimensionValues.size() == entry.size()) continue;
            this.addErrorMessage(data, ResManager.loadKDString((String)"\u5b58\u5728\u91cd\u590d\u7684\u7ef4\u5ea6\u6210\u5458\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"ArchiveUniqueDimensionValidator_0", (String)"scmc-ccm-opplugin", (Object[])new Object[0]));
        }
        DynamicObjectCollection archives = this.getArchives(schemeIds, allDimensionValues);
        block2: for (ExtendedDataEntity data : datas) {
            DynamicObject archiveApply = data.getDataEntity();
            if (archiveApply == null || archiveApply.getDynamicObject("scheme") == null) continue;
            Date beginDate = archiveApply.getDate("begindate");
            Date endDate = archiveApply.getDate("enddate");
            Set dimensionValues = (Set)dimensonValueMap.get(data.getBillPkId());
            long schemeId = archiveApply.getDynamicObject("scheme").getLong("id");
            for (ExtendedDataEntity residueData : datas) {
                DynamicObject residueArchiveApply = residueData.getDataEntity();
                if (residueArchiveApply == null || residueArchiveApply.getDynamicObject("scheme") == null) continue;
                long residueSchemeId = residueArchiveApply.getDynamicObject("scheme").getLong("id");
                Date residueBeginDate = residueArchiveApply.getDate("begindate");
                Date residueEndDate = residueArchiveApply.getDate("enddate");
                if (Objects.equals(data.getBillPkId(), residueData.getBillPkId()) || (schemeId != residueSchemeId || beginDate.compareTo(residueBeginDate) < 0 || beginDate.compareTo(residueEndDate) > 0) && (endDate.compareTo(residueBeginDate) < 0 || endDate.compareTo(residueEndDate) > 0)) continue;
                Set residueDimensionValues = (Set)dimensonValueMap.get(residueData.getBillPkId());
                HashSet dmValues = new HashSet(datas.length);
                dmValues.addAll(residueDimensionValues);
                if (!dmValues.removeAll(dimensionValues)) continue;
                String errMessage = ResManager.loadKDString((String)"\u5b58\u5728\u4e0e\u201c%s\u201d\u76f8\u540c\u7684\u7ef4\u5ea6\u6210\u5458\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"ArchiveUniqueDimensionValidator_1", (String)"scmc-ccm-opplugin", (Object[])new Object[0]);
                this.addErrorMessage(data, String.format(errMessage, residueData.getBillNo()));
                break;
            }
            for (DynamicObject archive : archives) {
                CreditScheme scheme;
                long archiveSchemeId = archive.getLong("scheme");
                String validity = archive.getString("scheme.validity");
                String archiveDimensionValue = archive.getString("dimensionvalue");
                if (schemeId != archiveSchemeId || !dimensionValues.contains(archiveDimensionValue) || (scheme = new SchemeReader().getScheme(schemeId)) == null) continue;
                DimensionValue dimensionValue = new DimensionValue(scheme.getDimension());
                dimensionValue.setValue(archiveDimensionValue);
                String dimensionValueName = this.getDimensionValueDisplayName(dimensionValue);
                if ("PERPETUAL".equals(validity)) {
                    this.addErrorMessage(data, String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u5df2\u5b58\u5728\u4fe1\u7528\u6863\u6848\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"ArchiveUniqueDimensionValidator_2", (String)"scmc-ccm-opplugin", (Object[])new Object[0]), dimensionValueName));
                    continue block2;
                }
                if (!"YEAR".equals(validity)) continue;
                Date archiveBeginDate = archive.getDate("begindate");
                Date archiveEndDate = archive.getDate("enddate");
                SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
                if ((beginDate.compareTo(archiveBeginDate) < 0 || beginDate.compareTo(archiveEndDate) > 0) && (endDate.compareTo(archiveBeginDate) < 0 || endDate.compareTo(archiveEndDate) > 0)) continue;
                String errorMsg = ResManager.loadKDString((String)"\u201c%1$s\u201d\u5df2\u5b58\u5728\u751f\u6548\u65e5\u671f\u8303\u56f4\u662f\u201c%2$s - %3$s\u201d\u7684\u4fe1\u7528\u6863\u6848\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"ArchiveUniqueDimensionValidator_3", (String)"scmc-ccm-opplugin", (Object[])new Object[0]);
                this.addErrorMessage(data, String.format(errorMsg, dimensionValueName, format.format(archiveBeginDate), format.format(archiveEndDate)));
                continue block2;
            }
        }
    }

    private DynamicObjectCollection getArchives(Set<Long> schemeIds, Set<String> archiveDimensionValues) {
        String selector = "scheme,scheme.validity,dimensionvalue,begindate,enddate";
        QFilter[] filters = new QFilter[]{new QFilter("scheme", "in", schemeIds), new QFilter("dimensionvalue", "in", archiveDimensionValues), new QFilter("archivetype", "=", (Object)"normal")};
        return QueryServiceHelper.query((String)"ccm_archive", (String)selector, (QFilter[])filters);
    }

    private String getDimensionValue(List<String> fieldKeys, DynamicObject row) {
        LinkedList<String> pkValues = new LinkedList<String>();
        for (String fieldKey : fieldKeys) {
            DynamicObject dym = row.getDynamicObject(fieldKey);
            if (dym == null) continue;
            DynamicProperty property = dym.getDynamicObjectType().getProperty("masterid");
            if (property == null) {
                pkValues.add(dym.getString("id"));
                continue;
            }
            pkValues.add(dym.getString("masterid"));
        }
        return String.join((CharSequence)"-", pkValues);
    }

    private String getDimensionValueDisplayName(DimensionValue dimensionValue) {
        StringBuilder displayNameBuilder = new StringBuilder();
        List roles = dimensionValue.getDimension().getRoles();
        DimensionEntryFieldMapper dimensionEntryFieldMapper = new DimensionEntryFieldMapper((Object)dimensionValue.getDimension().getId());
        for (int i = 0; i < roles.size(); ++i) {
            DynamicObject roleObj;
            Role role = (Role)roles.get(i);
            Object roleValue = dimensionValue.getValue(role);
            if ("CUSUNICODE".equals(role.getRoleType()) && ObjectUtils.isEmpty((Object)roleValue)) break;
            if (roleValue instanceof DynamicObject) {
                roleObj = (DynamicObject)roleValue;
            } else {
                String basedataKey = dimensionEntryFieldMapper.getBaseDataKey(role.getRoleType());
                if (roleValue instanceof Long) {
                    roleObj = this.ormFacade.loadSingleFromCache((Object)((Long)roleValue), basedataKey);
                } else if (roleValue instanceof String) {
                    roleObj = this.ormFacade.loadSingleFromCache((Object)Long.parseLong((String)roleValue), basedataKey);
                } else {
                    logger.info("roleValue is not of Long or String : {}", roleValue);
                    logger.info("It is not supported roleValueType and we will set current roleOjb is null.");
                    roleObj = null;
                }
            }
            displayNameBuilder.append(role.getRoleName()).append(':');
            displayNameBuilder.append(roleObj == null || ObjectUtils.isEmpty((Object)roleObj) ? "null" : roleObj.getString("name"));
            if (i >= roles.size() - 1) continue;
            displayNameBuilder.append('+');
        }
        return displayNameBuilder.toString();
    }

    public Set<String> preparePropertys() {
        Set propertySet = super.preparePropertys();
        propertySet.add("scheme.validate");
        propertySet.add("scheme.dimension");
        return propertySet;
    }
}

