/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ccm.opplugin.archive;

import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.db.DB;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scmc.ccm.business.archives.IArchiveGenerator;
import kd.scmc.ccm.business.setting.BillFieldAssociatedCheckTypeMapper;
import kd.scmc.ccm.business.setting.CheckTypeFieldTempImpl;
import kd.scmc.ccm.business.setting.DimensionEntryFieldMapper;
import kd.scmc.ccm.common.util.DateUtils;

public class TempApplytoArchiveGenerator
implements IArchiveGenerator {
    private BillFieldAssociatedCheckTypeMapper billMapper;
    private CheckTypeFieldTempImpl checkTypeFieldTempImpl;

    public Collection<DynamicObject> generate(DynamicObject[] tempApplys) {
        this.checkTypeFieldTempImpl = new CheckTypeFieldTempImpl();
        LinkedList<DynamicObject> archives = new LinkedList<DynamicObject>();
        long[] archiveIds = this.genArchiveIds(tempApplys);
        int count = 0;
        for (DynamicObject tempApply : tempApplys) {
            this.billMapper = new BillFieldAssociatedCheckTypeMapper(tempApply);
            DynamicObject scheme = tempApply.getDynamicObject("scheme");
            DynamicObject dimension = scheme.getDynamicObject("dimension");
            DimensionEntryFieldMapper mapper = new DimensionEntryFieldMapper(dimension.getPkValue());
            DynamicObjectCollection entry = tempApply.getDynamicObjectCollection("temparchiveentry");
            for (int i = 0; i < entry.size(); ++i) {
                DynamicObject archive = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"ccm_archive"));
                archive.set("id", (Object)archiveIds[count]);
                ((DynamicObject)entry.get(i)).set("archiveid", (Object)archiveIds[count]);
                ++count;
                this.setArchiveFields(archive, (DynamicObject)entry.get(i), tempApply, mapper);
                archives.add(archive);
            }
        }
        this.setRelatedId(archives, tempApplys);
        return archives;
    }

    private long[] genArchiveIds(DynamicObject[] tempApplys) {
        int archiveIdCount = 0;
        for (DynamicObject tempApply : tempApplys) {
            DynamicObjectCollection entry = tempApply.getDynamicObjectCollection("temparchiveentry");
            archiveIdCount += entry.size();
        }
        long[] archiveIds = DB.genLongIds((String)"ccm_archive", (int)archiveIdCount);
        return archiveIds;
    }

    private void setArchiveFields(DynamicObject archive, DynamicObject row, DynamicObject tempApply, DimensionEntryFieldMapper mapper) {
        DynamicObject unit;
        List fieldKeys = mapper.getRoleFieldKeys();
        List fieldTypeKeys = mapper.getFieldTypeKeys();
        for (String fieldKey : fieldKeys) {
            DynamicObject roleValue = row.getDynamicObject(fieldKey);
            DynamicProperty property = roleValue.getDynamicObjectType().getProperty("masterid");
            String pk = property == null ? "id" : "masterid";
            archive.set(fieldKey, (Object)roleValue.getLong(pk));
        }
        for (String fieldTypeKey : fieldTypeKeys) {
            archive.set(fieldTypeKey, (Object)mapper.getBaseDataKey(fieldTypeKey));
        }
        DynamicObject scheme = tempApply.getDynamicObject("scheme");
        DynamicObject dimension = scheme.getDynamicObject("dimension");
        archive.set("scheme", (Object)scheme);
        archive.set("dimension", (Object)dimension.getLong("id"));
        String dimensionValue = this.getDimensionValue(fieldKeys, row);
        archive.set("dimensionvalue", (Object)dimensionValue);
        archive.set("begindate", (Object)DateUtils.getStartOfDay((Date)row.getDate("begindate")));
        archive.set("enddate", (Object)DateUtils.getEndOfDay((Date)row.getDate("enddate")));
        archive.set("archivetype", (Object)"temp");
        String checkType = scheme.getDynamicObject("checktype").getString("number");
        String relatedMark = this.checkTypeFieldTempImpl.getRelatedFieldMark(checkType);
        archive.set("quota", row.get("temp_" + relatedMark));
        archive.set("balance", row.get("temp_" + relatedMark));
        archive.set("quotatype", (Object)relatedMark);
        List associatedFieldList = this.billMapper.getAssociatedFieldList();
        if (associatedFieldList.contains("measureunit_qty") && (unit = row.getDynamicObject("measureunit_qty")) != null) {
            archive.set("unit", (Object)unit.getLong("id"));
        }
        if ("KZFW001".equals(checkType) || "KZFW006".equals(checkType) || "KZFW010".equals(checkType)) {
            archive.set("unit", (Object)scheme.getLong("currency.id"));
        }
    }

    private String getDimensionValue(List<String> fieldKeys, DynamicObject row) {
        LinkedList<String> pkValues = new LinkedList<String>();
        for (String fieldKey : fieldKeys) {
            DynamicProperty property = row.getDynamicObject(fieldKey).getDynamicObjectType().getProperty("masterid");
            if (property == null) {
                pkValues.add(row.getDynamicObject(fieldKey).getString("id"));
                continue;
            }
            pkValues.add(row.getDynamicObject(fieldKey).getString("masterid"));
        }
        return String.join((CharSequence)"-", pkValues);
    }

    private void setRelatedId(List<DynamicObject> archives, DynamicObject[] tempApplys) {
        LinkedList<Long> mainArchiveIds = new LinkedList<Long>();
        HashMap<Long, Long> rowArchiveIdMap = new HashMap<Long, Long>();
        for (DynamicObject tempApply : tempApplys) {
            DynamicObjectCollection entry = tempApply.getDynamicObjectCollection("temparchiveentry");
            for (DynamicObject row : entry) {
                mainArchiveIds.add(row.getLong("mainarchiveid"));
                rowArchiveIdMap.put(row.getLong("archiveid"), row.getLong("mainarchiveid"));
            }
        }
        DynamicObjectCollection existingArchives = QueryServiceHelper.query((String)"ccm_archive", (String)"id,relatedid", (QFilter[])new QFilter[]{new QFilter("id", "in", mainArchiveIds)});
        for (DynamicObject existingArchive : existingArchives) {
            long existingArchiveId = existingArchive.getLong("id");
            for (DynamicObject archive : archives) {
                long mainarchiveid;
                long archiveid;
                if (archive == null || rowArchiveIdMap.get(archiveid = archive.getLong("id")) == null || existingArchiveId != (mainarchiveid = ((Long)rowArchiveIdMap.get(archiveid)).longValue())) continue;
                archive.set("relatedid", (Object)existingArchive.getLong("relatedid"));
            }
        }
    }
}

