/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ccm.opplugin.archive;

import java.util.Date;
import java.util.LinkedList;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.scmc.ccm.common.util.DateUtils;
import kd.scmc.ccm.common.util.OrmFacade;

public class TempArchiveApplySubmitValidator
extends AbstractValidator {
    private OrmFacade ormFacade = new OrmFacade();

    public void validate() {
        ExtendedDataEntity[] datas = this.getDataEntities();
        LinkedList<Long> tempArchiveByMainArchiveIds = new LinkedList<Long>();
        for (ExtendedDataEntity data : datas) {
            DynamicObject tempArchive = data.getDataEntity();
            DynamicObjectCollection rows = tempArchive.getDynamicObjectCollection("temparchiveentry");
            for (DynamicObject row : rows) {
                tempArchiveByMainArchiveIds.add(row.getLong("mainarchiveid"));
            }
        }
        DynamicObjectCollection archives = this.ormFacade.query("ccm_archive", "id,begindate,enddate", new QFilter[]{new QFilter("id", "in", tempArchiveByMainArchiveIds)});
        block2: for (ExtendedDataEntity data : datas) {
            DynamicObject tempArchive = data.getDataEntity();
            DynamicObjectCollection rows = tempArchive.getDynamicObjectCollection("temparchiveentry");
            if (ObjectUtils.isEmpty((Object)rows)) {
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u8bf7\u5148\u65b0\u589e\u4e00\u884c\u5206\u5f55\u3002", (String)"TempArchiveApplySubmitValidator_2", (String)"scmc-ccm-opplugin", (Object[])new Object[0]));
                continue;
            }
            for (DynamicObject row : rows) {
                if (row.getLong("mainarchiveid") == 0L) {
                    this.addErrorMessage(data, ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5b58\u5728\u7684\u4fe1\u7528\u6863\u6848\u3002", (String)"TempArchiveApplySubmitValidator_0", (String)"scmc-ccm-opplugin", (Object[])new Object[0]));
                    continue block2;
                }
                DynamicObject archive = this.matchArchive(row.getLong("mainarchiveid"), archives);
                if (archive == null || ObjectUtils.isEmpty((Object)archive.getDate("begindate")) || ObjectUtils.isEmpty((Object)row.getDate("begindate")) || row.getDate("begindate").compareTo(DateUtils.getStartOfDay((Date)archive.getDate("begindate"))) >= 0 && row.getDate("enddate").compareTo(DateUtils.getEndOfDay((Date)archive.getDate("enddate"))) <= 0) continue;
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u4e34\u65f6\u4fe1\u7528\u6863\u6848\u7684\u751f\u6548\u65e5\u671f\u8303\u56f4\u4e0d\u80fd\u5927\u4e8e\u4e3b\u6863\u6848\u7684\u751f\u6548\u65e5\u671f\u8303\u56f4\u3002", (String)"TempArchiveApplySubmitValidator_1", (String)"scmc-ccm-opplugin", (Object[])new Object[0]));
                continue block2;
            }
        }
    }

    private DynamicObject matchArchive(long mainArchiveId, DynamicObjectCollection archives) {
        for (DynamicObject archive : archives) {
            if (archive.getLong("id") != mainArchiveId) continue;
            return archive;
        }
        return null;
    }
}

