/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ccm.opplugin.basesetting;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.property.ItemClassTypeProp;
import kd.bos.entity.validate.AbstractValidator;
import kd.scmc.ccm.common.util.MetadataUtils;

public class RoleSaveValidator
extends AbstractValidator {
    private List<String> validBills = Arrays.asList("ccm_temp_archive", "ccm_archive_change", "ccm_archive_apply", "ccm_balanceadjustment", "ccm_achive_privilege");
    private List<String> validProps = Arrays.asList("roletype0", "roletype1", "roletype2", "roletype3");

    public void validate() {
        ExtendedDataEntity[] dataEntities;
        for (ExtendedDataEntity extendedDataEntity : dataEntities = this.getDataEntities()) {
            DynamicObject basedata = extendedDataEntity.getDataEntity().getDynamicObject("basedata");
            if (basedata == null) {
                return;
            }
            String basedataEntityNum = basedata.getString("number");
            String basedataEntityName = basedata.getString("name");
            for (String billEntity : this.validBills) {
                for (String validProp : this.validProps) {
                    Set itemClassEntityKeys;
                    DynamicProperty property = MetadataUtils.getProperty((String)billEntity, (String)validProp);
                    String validBillName = property.getParent().getDisplayName().getLocaleValue();
                    String validPropName = property.getDisplayName().getLocaleValue();
                    String propName = property.getName();
                    if (!(property instanceof ItemClassTypeProp) || (itemClassEntityKeys = ((ItemClassTypeProp)property).getComboItems().stream().map(ValueMapItem::getValue).collect(Collectors.toSet())).contains(basedataEntityNum)) continue;
                    String message = String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u672a\u5728\u5355\u636e \u201c%2$s\u201d \u5143\u6570\u636e\u5b57\u6bb5\u201c%3$s\u201d\uff08\u6807\u8bc6\uff1a%4$s\uff09\u7684\u591a\u7c7b\u522b\u57fa\u7840\u8d44\u6599\u7c7b\u578b\u4e2d\u6dfb\u52a0\u3002", (String)"RoleSaveValidator_0", (String)"scmc-ccm-opplugin", (Object[])new Object[0]), basedataEntityName, validBillName, validPropName, propName);
                    this.addErrorMessage(extendedDataEntity, message);
                    return;
                }
            }
        }
    }
}

