/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ccm.opplugin.journal;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.scmc.ccm.business.archives.ArchiveCollection;
import kd.scmc.ccm.business.archives.CreditArchive;
import kd.scmc.ccm.business.core.Dimension;
import kd.scmc.ccm.business.core.DimensionValue;
import kd.scmc.ccm.business.core.Direction;
import kd.scmc.ccm.business.journal.AdjustJournalBuilder;
import kd.scmc.ccm.business.journal.Journal;
import kd.scmc.ccm.business.journal.JournalGroup;
import kd.scmc.ccm.business.scheme.CreditScheme;
import kd.scmc.ccm.business.service.CreditServiceFacade;
import kd.scmc.ccm.common.helper.BillEntityHelper;
import kd.scmc.ccm.common.util.Lock;

public class BalanceAdjustmentAuditOp
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(BalanceAdjustmentAuditOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("scheme");
        fieldKeys.add("org");
        fieldKeys.add("currency");
        fieldKeys.add("amount");
        fieldKeys.add("billno");
        fieldKeys.add("archiveid");
        fieldKeys.add("dimensionvalue");
        for (String roleField : BillEntityHelper.getAllRoleFields()) {
            fieldKeys.add(roleField);
        }
        for (String roleType : BillEntityHelper.getAllRoleTypeFields()) {
            fieldKeys.add(roleType);
        }
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        DynamicObject[] balanceAdjustments = e.getDataEntities();
        logger.info("\u989d\u5ea6\u8c03\u6574\u5355\u3001\u6279\u91cf\u5ba1\u6838\u7684\u6570\u91cf\u662f\uff1a{}", (Object)balanceAdjustments.length);
        LinkedList<String> dimensionValueList = new LinkedList<String>();
        for (DynamicObject balanceAdjustment : balanceAdjustments) {
            DynamicObjectCollection entry = balanceAdjustment.getDynamicObjectCollection("entry");
            for (DynamicObject row : entry) {
                String dimensionValueStr = row.getString("dimensionvalue");
                dimensionValueList.add(dimensionValueStr);
            }
        }
        CreditServiceFacade facade = new CreditServiceFacade();
        AdjustJournalBuilder builder = new AdjustJournalBuilder();
        LinkedList toUpdateArchives = new LinkedList();
        try (Lock lock = new Lock();){
            List journalGroups = builder.buildJournals(Arrays.asList(balanceAdjustments));
            this.tryLock(journalGroups, lock);
            HashMap<Long, CreditArchive> allLongCreditArchive = new HashMap<Long, CreditArchive>(16);
            for (JournalGroup journalGroup : journalGroups) {
                CreditScheme scheme = journalGroup.getScheme();
                ArchiveCollection archives = this.getArchive(facade, dimensionValueList, scheme);
                this.addMemoryArchive(allLongCreditArchive, archives);
                this.updateBalance(journalGroup, archives, false, allLongCreditArchive);
            }
            toUpdateArchives.addAll(allLongCreditArchive.values());
            facade.saveJournals(journalGroups);
            facade.saveArchives(toUpdateArchives);
            logger.info("\u6279\u91cf\u8c03\u6574\u5355\u5ba1\u6838\u6210\u529f\uff0c\u6d41\u6c34\u5206\u7ec4\u6570\uff1a{}\uff0c\u6863\u6848\u66f4\u65b0\u6570\uff1a{}", (Object)journalGroups.size(), (Object)toUpdateArchives.size());
        }
    }

    private void addMemoryArchive(Map<Long, CreditArchive> allLongCreditArchive, ArchiveCollection archives) {
        for (Map.Entry map : archives.entrySet()) {
            CreditArchive value = (CreditArchive)map.getValue();
            CreditArchive creditArchive = allLongCreditArchive.get(value.getId());
            if (creditArchive != null) continue;
            allLongCreditArchive.put(value.getId(), value);
        }
    }

    public void updateBalance(JournalGroup journalGroup, ArchiveCollection archives, boolean isReverse, Map<Long, CreditArchive> allLongCreditArchive) {
        List journals = journalGroup.getJournals();
        String billNo = journalGroup.getBillNo();
        logger.info("\u5355\u636e\u7f16\u7801\uff1a{}\u7684\u6d41\u6c34\u6570\u91cf\uff1a{}", (Object)billNo, (Object)journals.size());
        for (Journal journal : journals) {
            CreditArchive archive;
            if (journal == null || (archive = (CreditArchive)archives.get((Object)journal.getDimensionValue())) == null) continue;
            CreditArchive creditArchive = allLongCreditArchive.get(archive.getId());
            if (creditArchive != null) {
                archive = creditArchive;
            }
            DynamicObject mainArchive = archive.getMainArchive();
            long archiveId = mainArchive.getLong("id");
            journal.setArchiveId(archiveId);
            BigDecimal balance = mainArchive.getBigDecimal("balance");
            BigDecimal reduceSum = mainArchive.getBigDecimal("reducesum");
            BigDecimal increaseSum = mainArchive.getBigDecimal("increasesum");
            String direction = journal.getDirection();
            BigDecimal amount = journal.getAmount();
            this.collectUsefulMsg(billNo, archiveId, isReverse, direction, balance, reduceSum, increaseSum, amount);
            if (Direction.REDUCE.name().equals(direction)) {
                if (isReverse) {
                    archive.increaseBalance(amount);
                    mainArchive.set("balance", (Object)balance.add(amount));
                    mainArchive.set("reducesum", (Object)reduceSum.subtract(amount));
                    continue;
                }
                archive.reduceBalance(journal.getAmount());
                mainArchive.set("balance", (Object)balance.subtract(amount));
                mainArchive.set("reducesum", (Object)reduceSum.add(amount));
                continue;
            }
            if (isReverse) {
                archive.reduceBalance(amount);
                mainArchive.set("balance", (Object)balance.subtract(amount));
                mainArchive.set("increasesum", (Object)increaseSum.subtract(amount));
                continue;
            }
            archive.increaseBalance(amount);
            mainArchive.set("balance", (Object)balance.add(amount));
            mainArchive.set("increasesum", (Object)increaseSum.add(amount));
        }
        logger.info("\u5355\u636e\u7f16\u7801\uff1a{}\u7684\u6d41\u6c34\u66f4\u65b0\u6863\u6848\u7ed3\u675f", (Object)billNo);
    }

    private void collectUsefulMsg(String billNo, Long archiveId, boolean isReverse, String direction, BigDecimal balance, BigDecimal reduceSum, BigDecimal increaseSum, BigDecimal amount) {
        HashMap<String, Object> usefulMsg = new HashMap<String, Object>(16);
        usefulMsg.put("archiveid", archiveId);
        usefulMsg.put("isreverse", isReverse);
        usefulMsg.put("direction", direction);
        usefulMsg.put("balance", balance);
        usefulMsg.put("reducesum", reduceSum);
        usefulMsg.put("increasesum", increaseSum);
        usefulMsg.put("amount", amount);
        logger.info("\u5355\u636e\u7f16\u7801\uff1a{}\uff0c\u66f4\u65b0\u6863\u6848\u8fc7\u7a0b\u6d88\u606f\u5982\u4e0b\uff1a{}", (Object)billNo, usefulMsg);
    }

    private void tryLock(List<JournalGroup> journalGroups, Lock lock) {
        for (JournalGroup journalGroup : journalGroups) {
            for (Journal journal : journalGroup.getJournals()) {
                String lockKey = journal.getScheme().getId() + ":" + journal.getDimensionValue().getValue();
                if (lock.tryLock(lockKey)) continue;
                String messageTemplate = ResManager.loadKDString((String)"\u5355\u636e\u5bf9\u5e94\u7684\u4fe1\u7528\u6863\u6848\u5b58\u5728\u5e76\u53d1\u9501\u201c%s\u201d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"BalanceAdjustmentAuditOp_0", (String)"scmc-ccm-opplugin", (Object[])new Object[0]);
                throw new KDBizException(String.format(messageTemplate, lockKey));
            }
        }
    }

    private ArchiveCollection getArchive(CreditServiceFacade facade, List<String> dimensionValueList, CreditScheme scheme) {
        LinkedList<DimensionValue> dimensionValues = new LinkedList<DimensionValue>();
        Dimension dimension = scheme.getDimension();
        for (String dimensionValueStr : dimensionValueList) {
            DimensionValue dimensionValue = new DimensionValue(dimension);
            dimensionValue.setValue(dimensionValueStr);
            dimensionValues.add(dimensionValue);
        }
        ArchiveCollection archives = facade.loadArchives(scheme, dimensionValues);
        return archives;
    }
}

