/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ccm.opplugin.journal;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.exception.KDBizException;
import kd.scmc.ccm.business.archives.ArchiveCollection;
import kd.scmc.ccm.business.archives.ArchiveService;
import kd.scmc.ccm.business.core.Dimension;
import kd.scmc.ccm.business.core.DimensionValue;
import kd.scmc.ccm.business.journal.Journal;
import kd.scmc.ccm.business.journal.JournalGroup;
import kd.scmc.ccm.business.scheme.CreditScheme;
import kd.scmc.ccm.business.service.CreditServiceFacade;
import kd.scmc.ccm.common.helper.BillEntityHelper;
import kd.scmc.ccm.common.util.Lock;

public class BalanceAdjustmentUnauditOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("scheme");
        fieldKeys.add("org");
        fieldKeys.add("currency");
        fieldKeys.add("amount");
        fieldKeys.add("billno");
        fieldKeys.add("archiveid");
        fieldKeys.add("dimensionvalue");
        for (String roleField : BillEntityHelper.getAllRoleFields()) {
            fieldKeys.add(roleField);
        }
        for (String roleType : BillEntityHelper.getAllRoleTypeFields()) {
            fieldKeys.add(roleType);
        }
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        DynamicObject[] balanceAdjustments = e.getDataEntities();
        LinkedList<String> dimensionValueList = new LinkedList<String>();
        for (DynamicObject balanceAdjustment : balanceAdjustments) {
            DynamicObjectCollection entry = balanceAdjustment.getDynamicObjectCollection("entry");
            for (DynamicObject row : entry) {
                String dimensionValueStr = row.getString("dimensionvalue");
                dimensionValueList.add(dimensionValueStr);
            }
        }
        Set billIds = Arrays.stream(balanceAdjustments).map(bill -> bill.getLong("id")).collect(Collectors.toSet());
        Set schemeIds = Arrays.stream(balanceAdjustments).map(bill -> bill.getLong("scheme.id")).collect(Collectors.toSet());
        LinkedList toDeleteJournalGroups = new LinkedList();
        LinkedList toUpdateArchives = new LinkedList();
        ArchiveService service = new ArchiveService();
        CreditServiceFacade facade = new CreditServiceFacade();
        List schemes = facade.getSchemes(schemeIds);
        try (Lock lock = new Lock();){
            for (CreditScheme creditScheme : schemes) {
                List journalGroups = facade.loadJournals(creditScheme, "ccm_balanceadjustment", "audit", billIds);
                toDeleteJournalGroups.addAll(journalGroups);
                this.tryLock(journalGroups, lock);
                ArchiveCollection archives = this.getArchive(facade, dimensionValueList, creditScheme);
                for (JournalGroup journalGroup : journalGroups) {
                    service.updateBalance(journalGroup, archives, true);
                }
                toUpdateArchives.addAll(archives.values());
            }
            facade.deleteJournals(toDeleteJournalGroups);
            facade.saveArchives(toUpdateArchives);
        }
    }

    private void tryLock(List<JournalGroup> journalGroups, Lock lock) {
        for (JournalGroup journalGroup : journalGroups) {
            for (Journal journal : journalGroup.getJournals()) {
                String lockKey = journal.getScheme().getId() + ":" + journal.getDimensionValue().getValue();
                if (lock.tryLock(lockKey)) continue;
                String messageTemplate = ResManager.loadKDString((String)"\u5355\u636e\u5bf9\u5e94\u7684\u4fe1\u7528\u6863\u6848\u5b58\u5728\u5e76\u53d1\u9501\u201c%s\u201d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"BalanceAdjustmentUnauditOp_0", (String)"scmc-ccm-opplugin", (Object[])new Object[]{lockKey});
                throw new KDBizException(messageTemplate);
            }
        }
    }

    private ArchiveCollection getArchive(CreditServiceFacade facade, List<String> dimensionValueList, CreditScheme scheme) {
        LinkedList<DimensionValue> dimensionValues = new LinkedList<DimensionValue>();
        Dimension dimension = scheme.getDimension();
        for (String dimensionValueStr : dimensionValueList) {
            DimensionValue dimensionValue = new DimensionValue(dimension);
            dimensionValue.setValue(dimensionValueStr);
            dimensionValues.add(dimensionValue);
        }
        ArchiveCollection archives = facade.loadArchives(scheme, dimensionValues);
        return archives;
    }
}

