/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ccm.opplugin.journal;

import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;

public class JournalDeleteValidator
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity[] datas = this.getDataEntities();
        HashSet archiveIds = new HashSet(datas.length);
        Arrays.stream(datas).forEach(data -> archiveIds.add(data.getDataEntity().getLong("archiveid")));
        if (!ObjectUtils.isEmpty(archiveIds)) {
            MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)"ccm_archive");
            Map archiveMap = BusinessDataServiceHelper.loadFromCache((DynamicObjectType)dataEntityType, (QFilter[])new QFilter[]{new QFilter("id", "in", archiveIds)});
            for (ExtendedDataEntity data2 : datas) {
                DynamicObject journal = data2.getDataEntity();
                DynamicObject archive = (DynamicObject)archiveMap.get(journal.get("archiveid"));
                String effectState = archive.getString("effectstate");
                Date endDate = archive.getDate("enddate");
                if (!"EXPRIED".equals(effectState) && endDate.compareTo(new Date()) >= 0) continue;
                this.addErrorMessage(data2, ResManager.loadKDString((String)"\u6d41\u6c34\u5bf9\u5e94\u7684\u540e\u53f0\u6863\u6848\u5df2\u5931\u6548\uff0c\u5220\u9664\u5931\u8d25\u3002", (String)"JournalDeleteValidator_0", (String)"scmc-ccm-opplugin", (Object[])new Object[0]));
            }
        }
    }
}

