/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ccm.opplugin.journal;

import java.util.ArrayList;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.scmc.ccm.business.archives.ArchiveCollection;
import kd.scmc.ccm.business.core.DimensionValue;
import kd.scmc.ccm.business.journal.Journal;
import kd.scmc.ccm.business.journal.JournalGroup;
import kd.scmc.ccm.business.journal.JournalReader;
import kd.scmc.ccm.business.scheme.CreditScheme;
import kd.scmc.ccm.business.scheme.SchemeReader;
import kd.scmc.ccm.business.service.CreditServiceFacade;

public class JournalDeleteWithBalanceOp
extends AbstractOperationServicePlugIn {
    private SchemeReader schemeReader = new SchemeReader();
    private JournalReader journalReader = new JournalReader();
    private CreditServiceFacade facade = new CreditServiceFacade();

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("scheme");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] journalObjects;
        super.beginOperationTransaction(e);
        for (DynamicObject journalObject : journalObjects = e.getDataEntities()) {
            long schemeId = journalObject.getLong("scheme.id");
            CreditScheme scheme = this.schemeReader.getScheme(schemeId);
            JournalGroup journalGroup = this.journalReader.loadJournal(scheme, Long.valueOf(journalObject.getLong("id")));
            ArrayList<DimensionValue> dimensionValues = new ArrayList<DimensionValue>(journalGroup.getJournals().size());
            for (Journal journal : journalGroup.getJournals()) {
                dimensionValues.add(journal.getDimensionValue());
            }
            ArchiveCollection archives = this.facade.loadArchives(scheme, dimensionValues);
            this.facade.updateBalance(journalGroup, archives, true);
            this.facade.saveArchives(archives.values());
        }
    }
}

