/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ccm.opplugin.journal;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scmc.ccm.opplugin.journal.JournalDeleteValidator;

public class UpdateArchiveByDeleteJournalOp
extends AbstractOperationServicePlugIn {
    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new JournalDeleteValidator());
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("archiveid");
        fieldKeys.add("amount");
        fieldKeys.add("direction");
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        DynamicObject[] archives;
        DynamicObject[] journals = e.getDataEntities();
        Map<Long, List<DynamicObject>> journalGroupbyArchive = Stream.of(journals).collect(Collectors.groupingBy(journal -> journal.getLong("archiveid")));
        Set<Long> archiveIds = journalGroupbyArchive.keySet();
        for (DynamicObject archive : archives = BusinessDataServiceHelper.load((String)"ccm_archive", (String)"balance,reducesum,increasesum", (QFilter[])new QFilter[]{new QFilter("id", "in", archiveIds)})) {
            BigDecimal reduceSum = BigDecimal.ZERO;
            BigDecimal increaseSum = BigDecimal.ZERO;
            List<DynamicObject> journalGroup = journalGroupbyArchive.get(archive.getLong("id"));
            for (DynamicObject journal2 : journalGroup) {
                BigDecimal amount = journal2.getBigDecimal("amount");
                if ("REDUCE".equals(journal2.getString("direction"))) {
                    reduceSum = reduceSum.add(amount);
                    continue;
                }
                increaseSum = increaseSum.add(amount);
            }
            BigDecimal archiveReduceSum = archive.getBigDecimal("reducesum");
            BigDecimal archiveIncreaseSum = archive.getBigDecimal("increasesum");
            BigDecimal archiveBalance = archive.getBigDecimal("balance");
            archive.set("reducesum", (Object)archiveReduceSum.subtract(reduceSum));
            archive.set("increasesum", (Object)archiveIncreaseSum.subtract(increaseSum));
            archive.set("balance", (Object)archiveBalance.subtract(increaseSum).add(reduceSum));
        }
        SaveServiceHelper.save((DynamicObject[])archives);
    }
}

