/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ccm.opplugin.scheme;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;

public class CreditSchemeValidator
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity[] datas;
        for (ExtendedDataEntity data : datas = this.dataEntities) {
            DynamicObjectCollection entry;
            DynamicObject creditScheme = data.getDataEntity();
            String orgScope = creditScheme.getString("orgscope");
            if (!"GLOBAL".equals(orgScope)) {
                DynamicObjectCollection orgEntry = creditScheme.getDynamicObjectCollection("orgentry");
                if (orgEntry.size() == 0) {
                    this.addErrorMessage(data, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u989d\u5ea6\u5171\u4eab\u8303\u56f4\u7684\u7ec4\u7ec7\u3002", (String)"CreditSchemeValidator_0", (String)"scmc-ccm-opplugin", (Object[])new Object[0]));
                }
                for (DynamicObject row : orgEntry) {
                    DynamicObject org = row.getDynamicObject("org");
                    if (org != null) continue;
                    this.addErrorMessage(data, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u989d\u5ea6\u5171\u4eab\u8303\u56f4\u7684\u7ec4\u7ec7\u3002", (String)"CreditSchemeValidator_0", (String)"scmc-ccm-opplugin", (Object[])new Object[0]));
                }
            }
            if ((entry = creditScheme.getDynamicObjectCollection("entry")) == null) continue;
            for (int i = 0; i < entry.size(); ++i) {
                for (int j = i + 1; j < entry.size(); ++j) {
                    if (!this.isAddErrorMessage(((DynamicObject)entry.get(i)).getDynamicObject("billstrategy"), ((DynamicObject)entry.get(j)).getDynamicObject("billstrategy"))) continue;
                    this.addErrorMessage(data, ResManager.loadKDString((String)"\u5b58\u5728\u540c\u4e00\u4e1a\u52a1\u5355\u636e\u4e14\u64cd\u4f5c\u76f8\u540c\uff08\u5360\u7528\u3001\u8fd4\u8fd8\u3001\u68c0\u67e5\uff09\u7684\u591a\u4e2a\u5355\u636e\u7b56\u7565\uff0c\u4e0d\u80fd\u63d0\u4ea4\u3002", (String)"CreditSchemeValidator_2", (String)"scmc-ccm-opplugin", (Object[])new Object[0]));
                }
            }
        }
    }

    private boolean isAddErrorMessage(DynamicObject billstrategy, DynamicObject otherBillstrategy) {
        if (billstrategy.getString("entity.number").equals(otherBillstrategy.getString("entity.number")) && billstrategy.getString("forwardaction").equals(otherBillstrategy.getString("forwardaction"))) {
            String forwardAction = billstrategy.getString("forwardaction");
            String reduceOps = billstrategy.getString("reduceops");
            String otherReduceops = otherBillstrategy.getString("reduceops");
            String increaseOps = billstrategy.getString("increaseops");
            String otherIncreaseOps = otherBillstrategy.getString("increaseops");
            boolean isReduceOpsEquals = false;
            boolean isIncreaseOpsEquals = false;
            if ("reduce".equals(forwardAction)) {
                if (StringUtils.isNotEmpty((CharSequence)reduceOps) && StringUtils.isNotEmpty((CharSequence)otherReduceops) && Objects.equals(reduceOps, otherReduceops)) {
                    isReduceOpsEquals = true;
                }
            } else if (StringUtils.isNotEmpty((CharSequence)increaseOps) && StringUtils.isNotEmpty((CharSequence)otherIncreaseOps) && Objects.equals(increaseOps, otherIncreaseOps)) {
                isIncreaseOpsEquals = true;
            }
            List checkops = Stream.of(billstrategy.getString("checkops").split(",")).filter(StringUtils::isNotEmpty).collect(Collectors.toList());
            List otherCheckOps = Stream.of(otherBillstrategy.getString("checkops").split(",")).filter(StringUtils::isNotEmpty).collect(Collectors.toList());
            return isReduceOpsEquals || isIncreaseOpsEquals || !Collections.disjoint(checkops, otherCheckOps);
        }
        return false;
    }
}

