/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ccm.opplugin.setting;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scmc.ccm.common.util.OrmFacade;
import kd.scmc.ccm.opplugin.setting.BillRegisterSaveValidator;
import kd.scmc.ccm.opplugin.setting.EntityConfigSelectorBuilder;

public class BillRegisterSaveOp
extends AbstractOperationServicePlugIn {
    private OrmFacade ormFacade = new OrmFacade();

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new BillRegisterSaveValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        DynamicObject billRegisterModel = e.getDataEntities()[0];
        DynamicObject entity = billRegisterModel.getDynamicObject("entity");
        Object entityKey = entity.getPkValue();
        QFilter[] filters = new QFilter[]{new QFilter("status", "=", (Object)"C"), new QFilter("enable", "=", (Object)Boolean.TRUE)};
        DynamicObjectCollection roles = QueryServiceHelper.query((String)"ccm_role", (String)"id,number,name", (QFilter[])filters);
        HashMap<Long, String> fieldInfoMap = new HashMap<Long, String>();
        for (DynamicObject role : roles) {
            String value = billRegisterModel.getString(role.getString("number").toLowerCase());
            if (StringUtils.isEmpty((CharSequence)value)) continue;
            fieldInfoMap.put(role.getLong("id"), value);
        }
        DynamicObject entityConfigObj = null;
        boolean hasConfig = QueryServiceHelper.exists((String)"ccm_entityconfig", (Object)entityKey);
        if (!hasConfig) {
            MainEntityType dt = EntityMetadataCache.getDataEntityType((String)"ccm_entityconfig");
            entityConfigObj = new DynamicObject((DynamicObjectType)dt);
            entityConfigObj.set("id", entityKey);
            entityConfigObj.set("number", entityKey);
            entityConfigObj.set("name", (Object)entity.getLocaleString("name"));
            entityConfigObj.set("status", (Object)"A");
            entityConfigObj.set("enable", (Object)"1");
            this.setCommonConfigFields(entityConfigObj, billRegisterModel);
            this.buildConfigDimensions(fieldInfoMap, entityConfigObj);
        } else {
            entityConfigObj = this.ormFacade.loadSingle(entityKey, "ccm_entityconfig");
            this.setCommonConfigFields(entityConfigObj, billRegisterModel);
            this.buildConfigDimensions(fieldInfoMap, entityConfigObj);
        }
        EntityConfigSelectorBuilder selectorBuilder = new EntityConfigSelectorBuilder(entityConfigObj);
        selectorBuilder.build(false);
        this.ormFacade.save(entityConfigObj);
    }

    private void setCommonConfigFields(DynamicObject entityConfigObj, DynamicObject billRegisterModel) {
        entityConfigObj.set("orgKey", (Object)billRegisterModel.getString("org"));
        entityConfigObj.set("currencyKey", (Object)billRegisterModel.getString("currency"));
    }

    private void buildConfigDimensions(Map<Long, String> fieldInfoMap, DynamicObject entityConfigObj) {
        DynamicObjectCollection dimensions = entityConfigObj.getDynamicObjectCollection("dimensions");
        if (!ObjectUtils.isEmpty((Object)dimensions)) {
            dimensions.clear();
        }
        Set<Map.Entry<Long, String>> entrySet = fieldInfoMap.entrySet();
        for (Map.Entry<Long, String> entry : entrySet) {
            DynamicObject row = dimensions.addNew();
            DynamicObject role = this.ormFacade.loadSingleFromCache((Object)entry.getKey(), "ccm_role");
            row.set("role", (Object)role);
            row.set("rolekey", (Object)entry.getValue());
        }
    }
}

