/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ccm.opplugin.setting;

import java.util.LinkedList;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class BillStrategySaveValidator
extends AbstractValidator {
    private static final Log log = LogFactory.getLog(BillStrategySaveValidator.class);

    public void validate() {
        ExtendedDataEntity[] datas;
        for (ExtendedDataEntity data : datas = this.getDataEntities()) {
            this.validate(data);
        }
    }

    private void validate(ExtendedDataEntity data) {
        DynamicObject billStrategy = data.getDataEntity();
        String reduceOp = billStrategy.getString("reduceops");
        String increaseOp = billStrategy.getString("increaseops");
        String checkOp = billStrategy.getString("checkops");
        String forwardAction = billStrategy.getString("forwardaction");
        LinkedList<String> reduceOps = new LinkedList<String>();
        LinkedList<String> increaseOps = new LinkedList<String>();
        LinkedList<String> checkOps = new LinkedList<String>();
        if (!StringUtils.isBlank((CharSequence)reduceOp)) {
            String[] reduceCreditOps;
            for (String op : reduceCreditOps = reduceOp.substring(1).split(",")) {
                if (!StringUtils.isNotBlank((CharSequence)op)) continue;
                reduceOps.add(op);
            }
        }
        if (!StringUtils.isBlank((CharSequence)increaseOp)) {
            String[] increaseCreditOps = increaseOp.substring(1).split(",");
            boolean isContainSameOp = false;
            String[] stringArray = increaseCreditOps;
            int n = stringArray.length;
            for (int op = 0; op < n; ++op) {
                String op2 = stringArray[op];
                if (!StringUtils.isNotBlank((CharSequence)op2)) continue;
                increaseOps.add(op2);
                if (!reduceOps.contains(op2)) continue;
                isContainSameOp = true;
            }
            if (isContainSameOp) {
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u4fe1\u7528\u5360\u7528\u548c\u4fe1\u7528\u8fd4\u8fd8\u4e0d\u5141\u8bb8\u5b58\u5728\u76f8\u540c\u64cd\u4f5c\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"BillStrategySaveValidator_1", (String)"scmc-ccm-opplugin", (Object[])new Object[0]));
            }
        }
        if (!StringUtils.isBlank((CharSequence)checkOp)) {
            String[] checkCreditOps;
            for (String op : checkCreditOps = checkOp.substring(1).split(",")) {
                if (!StringUtils.isNotBlank((CharSequence)op)) continue;
                checkOps.add(op);
            }
        }
        int reduceOpSize = reduceOps.size();
        int increaseOpSize = increaseOps.size();
        if (reduceOpSize == 0 && increaseOpSize > 0 || reduceOpSize > 0 && increaseOpSize == 0) {
            this.addErrorMessage(data, ResManager.loadKDString((String)"\u201c\u4fe1\u7528\u5360\u7528\u64cd\u4f5c\u201d\u548c\u201c\u4fe1\u7528\u8fd4\u8fd8\u64cd\u4f5c\u201d\u9700\u540c\u65f6\u914d\u7f6e\u6216\u4e0d\u914d\u7f6e\uff0c\u8bf7\u4fee\u6539\u3002", (String)"BillStrategySaveValidator_0", (String)"scmc-ccm-opplugin", (Object[])new Object[0]));
        }
        if (reduceOpSize > 1 && "reduce".equals(forwardAction)) {
            this.addErrorMessage(data, ResManager.loadKDString((String)"\u4fe1\u7528\u65b9\u5411\u4e3a\u201c\u5360\u7528\u201d\u65f6\uff0c\u4fe1\u7528\u5360\u7528\u64cd\u4f5c\u53ea\u5141\u8bb8\u9009\u62e9\u4e00\u4e2a\u3002", (String)"BillStrategySaveValidator_2", (String)"scmc-ccm-opplugin", (Object[])new Object[0]));
        }
        if (increaseOpSize > 1 && "increase".equals(forwardAction)) {
            this.addErrorMessage(data, ResManager.loadKDString((String)"\u4fe1\u7528\u65b9\u5411\u4e3a\u201c\u8fd4\u8fd8\u201d\u65f6\uff0c\u4fe1\u7528\u8fd4\u8fd8\u64cd\u4f5c\u53ea\u5141\u8bb8\u9009\u62e9\u4e00\u4e2a\u3002", (String)"BillStrategySaveValidator_3", (String)"scmc-ccm-opplugin", (Object[])new Object[0]));
        }
        String checkType = billStrategy.getString("checktype.number");
        if (checkOps.size() == 0 && ("KZFW002".equals(checkType) || "KZFW006".equals(checkType))) {
            this.addErrorMessage(data, ResManager.loadKDString((String)"\u5f53\u524d\u4fe1\u7528\u63a7\u5236\u5f62\u5f0f\u9700\u8981\u914d\u7f6e\u201c\u68c0\u67e5\u4fe1\u7528\u64cd\u4f5c\u201d\u3002", (String)"BillStrategySaveValidator_4", (String)"scmc-ccm-opplugin", (Object[])new Object[0]));
        }
    }
}

