/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ccm.opplugin.setting;

import java.util.LinkedList;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.scmc.ccm.common.ks.KsLoader;

public class BillStrategySubmitValidator
extends AbstractValidator {
    private static final Log log = LogFactory.getLog(BillStrategySubmitValidator.class);

    public void validate() {
        ExtendedDataEntity[] datas;
        for (ExtendedDataEntity data : datas = this.getDataEntities()) {
            this.validate(data);
        }
    }

    private void validate(ExtendedDataEntity data) {
        DynamicObject billStrategy = data.getDataEntity();
        String reduceOp = billStrategy.getString("reduceops");
        String increaseOp = billStrategy.getString("increaseops");
        String checkOp = billStrategy.getString("checkops");
        String forwardAction = billStrategy.getString("forwardaction");
        LinkedList<String> reduceOps = new LinkedList<String>();
        LinkedList<String> increaseOps = new LinkedList<String>();
        LinkedList<String> checkOps = new LinkedList<String>();
        if (!StringUtils.isBlank((CharSequence)reduceOp)) {
            String[] reduceCreditOps;
            for (String op : reduceCreditOps = reduceOp.substring(1).split(",")) {
                if (!StringUtils.isNotBlank((CharSequence)op)) continue;
                reduceOps.add(op);
            }
        }
        if (!StringUtils.isBlank((CharSequence)increaseOp)) {
            String[] increaseCreditOps = increaseOp.substring(1).split(",");
            boolean isContainSameOp = false;
            String[] stringArray = increaseCreditOps;
            int n = stringArray.length;
            for (int op = 0; op < n; ++op) {
                String op2 = stringArray[op];
                if (!StringUtils.isNotBlank((CharSequence)op2)) continue;
                increaseOps.add(op2);
                if (!reduceOps.contains(op2)) continue;
                isContainSameOp = true;
            }
            if (isContainSameOp) {
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u4fe1\u7528\u5360\u7528\u548c\u4fe1\u7528\u8fd4\u8fd8\u4e0d\u5141\u8bb8\u5b58\u5728\u76f8\u540c\u64cd\u4f5c\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"BillStrategySubmitValidator_9", (String)"scmc-ccm-opplugin", (Object[])new Object[0]));
            }
        }
        if (!StringUtils.isBlank((CharSequence)checkOp)) {
            String[] checkCreditOps;
            for (String op : checkCreditOps = checkOp.substring(1).split(",")) {
                if (!StringUtils.isNotBlank((CharSequence)op)) continue;
                checkOps.add(op);
            }
        }
        int reduceOpSize = reduceOps.size();
        int increaseOpSize = increaseOps.size();
        int checkOpSize = checkOps.size();
        if (reduceOpSize == 0 && increaseOpSize > 0 || reduceOpSize > 0 && increaseOpSize == 0) {
            this.addErrorMessage(data, ResManager.loadKDString((String)"\u201c\u4fe1\u7528\u5360\u7528\u64cd\u4f5c\u201d\u548c\u201c\u4fe1\u7528\u8fd4\u8fd8\u64cd\u4f5c\u201d\u9700\u540c\u65f6\u914d\u7f6e\u6216\u4e0d\u914d\u7f6e\uff0c\u8bf7\u4fee\u6539\u3002", (String)"BillStrategySubmitValidator_8", (String)"scmc-ccm-opplugin", (Object[])new Object[0]));
        }
        if (reduceOpSize > 1 && "reduce".equals(forwardAction)) {
            this.addErrorMessage(data, ResManager.loadKDString((String)"\u4fe1\u7528\u65b9\u5411\u4e3a\u201c\u5360\u7528\u201d\u65f6\uff0c\u4fe1\u7528\u5360\u7528\u64cd\u4f5c\u53ea\u5141\u8bb8\u9009\u62e9\u4e00\u4e2a\u3002", (String)"BillStrategySubmitValidator_1", (String)"scmc-ccm-opplugin", (Object[])new Object[0]));
        }
        if (increaseOpSize > 1 && "increase".equals(forwardAction)) {
            this.addErrorMessage(data, ResManager.loadKDString((String)"\u4fe1\u7528\u65b9\u5411\u4e3a\u201c\u8fd4\u8fd8\u201d\u65f6\uff0c\u4fe1\u7528\u8fd4\u8fd8\u64cd\u4f5c\u53ea\u5141\u8bb8\u9009\u62e9\u4e00\u4e2a\u3002", (String)"BillStrategySubmitValidator_2", (String)"scmc-ccm-opplugin", (Object[])new Object[0]));
        }
        String checkPluginType = billStrategy.getString("plugintype");
        String checkPlugin = billStrategy.getString("plugin");
        String recalPluginType = billStrategy.getString("recalculateplugintype");
        String recalPlugin = billStrategy.getString("recalculateplugin");
        if (StringUtils.isNotBlank((CharSequence)checkPlugin)) {
            this.checkPluginExist(data, checkPluginType, checkPlugin, true);
        }
        if (StringUtils.isNotBlank((CharSequence)recalPlugin)) {
            this.checkPluginExist(data, recalPluginType, recalPlugin, false);
        }
        String checkType = billStrategy.getString("checktype.number");
        if (checkOpSize == 0 && ("KZFW002".equals(checkType) || "KZFW006".equals(checkType))) {
            this.addErrorMessage(data, ResManager.loadKDString((String)"\u5f53\u524d\u4fe1\u7528\u63a7\u5236\u5f62\u5f0f\u9700\u8981\u914d\u7f6e\u201c\u68c0\u67e5\u4fe1\u7528\u64cd\u4f5c\u201d\u3002", (String)"BillStrategySubmitValidator_10", (String)"scmc-ccm-opplugin", (Object[])new Object[0]));
        }
        DynamicObjectCollection checkEntry = billStrategy.getDynamicObjectCollection("checkentry");
        if ("KZFW001".equals(checkType) || "KZFW011".equals(checkType) || "KZFW010".equals(checkType)) {
            if (reduceOpSize == 0 && increaseOpSize == 0 && checkOpSize == 0 && checkEntry != null && checkEntry.size() > 0) {
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u8bf7\u5148\u914d\u7f6e\u4fe1\u7528\u5360\u7528\u64cd\u4f5c\u6216\u4fe1\u7528\u8fd4\u8fd8\u64cd\u4f5c\u6216\u68c0\u67e5\u4fe1\u7528\u64cd\u4f5c\uff0c\u518d\u7ef4\u62a4\u68c0\u67e5\u53d6\u503c\u914d\u7f6e\u3002", (String)"BillStrategySubmitValidator_11", (String)"scmc-ccm-opplugin", (Object[])new Object[0]));
            }
            if ("KZFW001".equals(checkType)) {
                if (!(reduceOpSize <= 0 && increaseOpSize <= 0 && checkOpSize <= 0 || checkEntry != null && checkEntry.size() > 0)) {
                    this.addErrorMessage(data, ResManager.loadKDString((String)"\u4fe1\u7528\u5360\u7528\u64cd\u4f5c\u6216\u4fe1\u7528\u8fd4\u8fd8\u64cd\u4f5c\u6216\u68c0\u67e5\u4fe1\u7528\u64cd\u4f5c\u5df2\u7ecf\u914d\u7f6e\uff0c\u8bf7\u7ef4\u62a4\u68c0\u67e5\u53d6\u503c\u914d\u7f6e\u5e76\u8bbe\u7f6e\u53d6\u503c\u516c\u5f0f\u3002", (String)"BillStrategySubmitValidator_15", (String)"scmc-ccm-opplugin", (Object[])new Object[0]));
                }
                this.checkValueConfiguration(data, true);
            } else {
                this.checkValueConfiguration(data, false);
            }
        }
    }

    private void checkPluginExist(ExtendedDataEntity data, String pluginType, String pluginName, boolean isCheckPlugin) {
        String check = ResManager.loadKDString((String)"\u68c0\u67e5\u7b56\u7565", (String)"BillStrategySubmitValidator_3", (String)"scmc-ccm-opplugin", (Object[])new Object[0]);
        String recal = ResManager.loadKDString((String)"\u521d\u59cb\u5316\u7b56\u7565", (String)"BillStrategySubmitValidator_4", (String)"scmc-ccm-opplugin", (Object[])new Object[0]);
        String message = ResManager.loadKDString((String)"\u201c%1$s\u201d\u4e2d\u6ce8\u518c\u7684\u63d2\u4ef6\u201c%2$s\u201d\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"BillStrategySubmitValidator_5", (String)"scmc-ccm-opplugin", (Object[])new Object[0]);
        if ("ks".equals(pluginType)) {
            KsLoader ksLoader = new KsLoader();
            Map script = ksLoader.getScript(pluginName);
            if (script == null) {
                this.addErrorMessage(data, String.format(message, isCheckPlugin ? check : recal, pluginName));
            }
        } else {
            try {
                Class.forName(pluginName);
            }
            catch (ClassNotFoundException e) {
                log.error(e.getMessage());
                this.addErrorMessage(data, String.format(message, isCheckPlugin ? check : recal, pluginName));
            }
        }
    }

    private void checkValueConfiguration(ExtendedDataEntity data, boolean needCheckRecalEntry) {
        DynamicObject billStrategy = data.getDataEntity();
        DynamicObjectCollection checkEntry = billStrategy.getDynamicObjectCollection("checkentry");
        DynamicObjectCollection recalEntry = billStrategy.getDynamicObjectCollection("recalentry");
        if (needCheckRecalEntry && recalEntry.size() == 0 && checkEntry.size() == 0 || !needCheckRecalEntry && checkEntry.size() == 0) {
            this.addErrorMessage(data, ResManager.loadKDString((String)"\u8bf7\u7ef4\u62a4\u68c0\u67e5\u7b56\u7565\u3001\u68c0\u67e5\u53d6\u503c\u914d\u7f6e\u5e76\u8bbe\u7f6e\u53d6\u503c\u516c\u5f0f\u3002", (String)"BillStrategySubmitValidator_13", (String)"scmc-ccm-opplugin", (Object[])new Object[0]));
        }
        if (recalEntry.size() == 0) {
            for (int i = 0; i < checkEntry.size(); ++i) {
                DynamicObject checkRow = (DynamicObject)checkEntry.get(i);
                String checkFormual = checkRow.getString("newcheckformula_tag");
                if (!StringUtils.isBlank((CharSequence)checkFormual)) continue;
                this.addErrorMessage(data, String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u68c0\u67e5\u53d6\u503c\u914d\u7f6e\u5206\u5f55\u201d\u7b2c%1$s\u884c\uff1a\u201c\u53d6\u503c\u516c\u5f0f\u201d\u3002", (String)"BillStrategySubmitValidator_14", (String)"scmc-ccm-opplugin", (Object[])new Object[0]), i + 1));
            }
        }
    }
}

