/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ccm.opplugin.setting;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.botp.CRFormula;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.ItemClassProp;
import kd.bos.entity.property.ItemClassTypeProp;
import kd.bos.formula.FormulaEngine;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.scmc.ccm.business.core.CreditFormula;
import kd.scmc.ccm.business.core.Field;
import kd.scmc.ccm.business.plugin.ICreditPlugin;
import kd.scmc.ccm.business.plugin.PluginFactory;
import kd.scmc.ccm.business.recalculate.IRecalculatePlugin;
import kd.scmc.ccm.business.setting.EntityConfig;
import kd.scmc.ccm.business.setting.EntityConfigReader;
import kd.scmc.ccm.common.util.OrmFacade;

public class EntityConfigSelectorBuilder {
    private OrmFacade ormFacade = new OrmFacade();
    private DynamicObject entityConfig;
    private String entityKey;
    private Set<String> selectors = new HashSet<String>(20);
    private Set<String> oldSelectors = new HashSet<String>(20);

    public EntityConfigSelectorBuilder(DynamicObject entityConfig) {
        this.entityConfig = entityConfig;
        EntityConfigReader entityConfigReader = new EntityConfigReader();
        EntityConfig configObj = entityConfigReader.toConfigObj(entityConfig);
        this.entityKey = configObj.getEntityKey();
        Field orgField = configObj.getOrgField();
        this.selectors.add(orgField.getKey());
        Field currencyField = configObj.getCurrencyField();
        this.selectors.add(currencyField.getKey());
        Collection roleFields = configObj.getCreditRolesKeyMap().values();
        for (Field field : roleFields) {
            this.selectors.add(field.getKey());
        }
        this.selectors.add("billno");
        DynamicObjectCollection selectorsEntry = entityConfig.getDynamicObjectCollection("selectors");
        for (DynamicObject selectorRow : selectorsEntry) {
            this.oldSelectors.add(selectorRow.getString("field"));
        }
    }

    private void buildByBillStrategies(DynamicObject[] billstrategies) {
        for (DynamicObject strategy : billstrategies) {
            DynamicObject assingEntity;
            DynamicObjectCollection recalEntry;
            if (!Objects.equals(this.entityKey, strategy.getString("entity.id"))) continue;
            DynamicObjectCollection checkEntry = strategy.getDynamicObjectCollection("checkentry");
            if (!ObjectUtils.isEmpty((Object)checkEntry)) {
                for (Object row : checkEntry) {
                    this.selectors.addAll(this.getFilterFields((DynamicObject)row, "newcheckfilter_tag", this.entityKey));
                    this.selectors.addAll(this.getFormulaFields((DynamicObject)row, "newcheckformula_tag", this.entityKey));
                }
            }
            if (!ObjectUtils.isEmpty((Object)(recalEntry = strategy.getDynamicObjectCollection("recalentry")))) {
                Object row;
                row = recalEntry.iterator();
                while (row.hasNext()) {
                    DynamicObject row2 = (DynamicObject)row.next();
                    this.selectors.addAll(this.getFilterFields(row2, "newrecalfilter_tag", this.entityKey));
                    this.selectors.addAll(this.getFormulaFields(row2, "newrecalformula_tag", this.entityKey));
                }
            }
            if ((assingEntity = strategy.getDynamicObject("assingentity")) == null) continue;
            this.selectors.addAll(this.getFilterFields(strategy, "newdatafilter_tag", assingEntity.getString("number")));
        }
    }

    private void buildByPlugin(DynamicObject[] billstrategies) {
        for (DynamicObject strategy : billstrategies) {
            if (!Objects.equals(this.entityKey, strategy.getString("entity.id"))) continue;
            String pluginClassName = strategy.getString("plugin");
            String pluginType = strategy.getString("plugintype");
            ICreditPlugin plugin = PluginFactory.getCreditPlugin((String)pluginType, (String)pluginClassName);
            List requiredFields = plugin.getRequiredFields(this.entityKey);
            this.selectors.addAll(requiredFields);
            String recalculatePluginClassName = strategy.getString("recalculateplugin");
            String recalculatePluginType = strategy.getString("recalculateplugintype");
            IRecalculatePlugin recalculatePlugin = PluginFactory.getRecalculatePlugin((String)recalculatePluginType, (String)recalculatePluginClassName);
            List recalculateRequiredFields = recalculatePlugin.getRequiredFields(this.entityKey);
            this.selectors.addAll(recalculateRequiredFields);
        }
    }

    public void build(boolean autoSave) {
        DynamicObject[] billStrategies = this.loadBillStrategies();
        this.buildByBillStrategies(billStrategies);
        this.buildByPlugin(billStrategies);
        if (!Objects.equals(this.selectors, this.oldSelectors)) {
            this.buildSelectorEntry();
            if (autoSave) {
                this.ormFacade.save(this.entityConfig);
            }
        }
    }

    private DynamicObject[] loadBillStrategies() {
        QFilter statusFilter = new QFilter("status", "=", (Object)"C");
        QFilter enableFilter = new QFilter("enable", "=", (Object)Boolean.TRUE);
        QFilter entityFilter = new QFilter("entity", "=", (Object)this.entityKey);
        QFilter[] filters = new QFilter[]{statusFilter, enableFilter, entityFilter};
        return this.ormFacade.load("ccm_billstrategy", "entity,plugintype,plugin,recalculateplugintype,recalculateplugin,newcheckfilter_tag,newcheckformula_tag,newrecalfilter_tag,newrecalformula_tag,newdatafilter_tag,assingentity", filters);
    }

    private void buildSelectorEntry() {
        DynamicObjectCollection selectorsEntry = this.entityConfig.getDynamicObjectCollection("selectors");
        selectorsEntry.clear();
        if (StringUtils.isNotEmpty((CharSequence)this.entityKey)) {
            LinkedList<String> ItemClassSelector = new LinkedList<String>();
            LinkedList<String> ItemClassTypeSelector = new LinkedList<String>();
            MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)this.entityKey);
            DataEntityPropertyCollection properties = dataEntityType.getProperties();
            for (IDataEntityProperty property : properties) {
                if (property instanceof ItemClassTypeProp) {
                    ItemClassTypeSelector.add(property.getName());
                    continue;
                }
                if (property instanceof ItemClassProp) {
                    ItemClassSelector.add(property.getName());
                    continue;
                }
                if (!(property instanceof EntryProp)) continue;
                DataEntityPropertyCollection entryProperties = ((EntryProp)property)._collectionItemPropertyType.getProperties();
                for (IDataEntityProperty entityProperty : entryProperties) {
                    if (entityProperty instanceof ItemClassTypeProp) {
                        ItemClassTypeSelector.add(entityProperty.getName());
                        continue;
                    }
                    if (!(entityProperty instanceof ItemClassProp)) continue;
                    ItemClassSelector.add(entityProperty.getName());
                }
            }
            if (!ObjectUtils.isEmpty(ItemClassTypeSelector)) {
                for (String itemClassFieldValue : ItemClassSelector) {
                    if (!this.selectors.contains(itemClassFieldValue)) continue;
                    this.selectors.addAll(ItemClassTypeSelector);
                    break;
                }
            }
        }
        for (String field : this.selectors) {
            DynamicObject addNew = selectorsEntry.addNew();
            addNew.set("field", (Object)field);
        }
    }

    private List<String> getFilterFields(DynamicObject row, String fieldKey, String entityKey) {
        CRCondition crCondition;
        String fullFormula;
        LinkedList<String> filterFields = new LinkedList<String>();
        String filterTag = row.getString(fieldKey);
        if (StringUtils.isNotBlank((CharSequence)filterTag) && StringUtils.isNotEmpty((CharSequence)(fullFormula = (crCondition = (CRCondition)SerializationUtils.fromJsonString((String)filterTag, CRCondition.class)).buildFullFormula(MetadataServiceHelper.getDataEntityType((String)entityKey))))) {
            String[] vars = FormulaEngine.extractVariables((String)fullFormula);
            Collections.addAll(filterFields, vars);
        }
        return filterFields;
    }

    private List<String> getFormulaFields(DynamicObject row, String fieldKey, String entityKey) {
        LinkedList<String> formulaFields = new LinkedList<String>();
        String formulaTag = row.getString(fieldKey);
        if (StringUtils.isNotBlank((CharSequence)formulaTag)) {
            CRFormula crFormula = (CRFormula)SerializationUtils.fromJsonString((String)formulaTag, CRFormula.class);
            CreditFormula formula = new CreditFormula(entityKey, crFormula.getExpression());
            List fields = formula.getFields();
            for (Field field : fields) {
                formulaFields.add(field.getKey());
            }
        }
        return formulaFields;
    }
}

