/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ccm.formplugin.archive;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IBillModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.ImportDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scmc.ccm.business.setting.BillFieldAssociatedCheckTypeMapper;
import kd.scmc.ccm.business.setting.DimensionEntryFieldMapper;
import kd.scmc.ccm.common.helper.BillEntityHelper;
import kd.scmc.ccm.common.util.CommonUtils;
import kd.scmc.ccm.common.util.DateUtils;

public class ArchiveApplyEdit
extends AbstractBillPlugIn {
    private static final String KEY_ARCHIVE_APPLY = "ccm_archive_apply";
    private static final String KEY_SCHEME = "scheme";
    private static final String KEY_DIMENSION = "dimension";
    private static final String KEY_ORG = "org";
    private static final String KEY_CURRENCY = "currency";
    private static final String KEY_APPLYYEAR = "applyyear";
    private static final String KEY_DATERANGE = "daterange";
    private static final String KEY_ENTRY = "entry";
    private static final String KEY_GRADE = "grade";
    private static final String KEY_SCHEME_ID = "ccm_scheme";
    private static final String KEY_SCHEME_DIMENSION = "dimension";
    private static final String CACHE_SCHEME = "cache_scheme";
    private DimensionEntryFieldMapper mapper;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        super.addClickListeners(new String[]{KEY_ARCHIVE_APPLY});
        this.addRoleFiledListener();
        this.filterScheme();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        ChangeData[] changeSet;
        String stopChange = this.getPageCache().get("stopChange");
        if ("true".equals(stopChange)) {
            return;
        }
        String key = e.getProperty().getName();
        for (ChangeData data : changeSet = e.getChangeSet()) {
            DynamicObject role;
            String roleName;
            if (!CommonUtils.isRealChanged((ChangeData)data)) continue;
            Object oldValue = data.getOldValue();
            Object newValue = data.getNewValue();
            if (KEY_SCHEME.equals(key)) {
                this.schemeChange(oldValue);
                continue;
            }
            if (KEY_GRADE.equals(key)) {
                this.gradeChange();
                continue;
            }
            if (KEY_APPLYYEAR.equals(key)) {
                this.setDateRange((String)newValue);
                continue;
            }
            if (!key.contains("role") || !(newValue instanceof DynamicObject) || !"bd_material".equals(roleName = (role = (DynamicObject)newValue).getDataEntityType().getName())) continue;
            this.materialChanged(role);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        DynamicObject scheme = (DynamicObject)this.getModel().getValue(KEY_SCHEME);
        this.setVisableByCheckType();
        this.setApplyYearCom(scheme);
        this.setControlRoleField();
        this.showHiddenControlByGrade();
        this.setMustInputDimensionMember();
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        DynamicObject org = (DynamicObject)this.getModel().getValue(KEY_ORG);
        BillShowParameter parameter = (BillShowParameter)this.getView().getFormShowParameter();
        String schemeId = (String)parameter.getCustomParam("schemeId");
        if (StringUtils.isNotBlank((CharSequence)schemeId) && org != null) {
            QFilter filter = new QFilter("enable", "=", (Object)"1");
            filter.and(new QFilter("status", "=", (Object)"C"));
            filter.and("id", "=", (Object)Long.valueOf(schemeId));
            filter.and("mainorg", "=", (Object)org.getLong("id"));
            DynamicObject scheme = QueryServiceHelper.queryOne((String)KEY_SCHEME_ID, (String)"id,currency,validity,yearbegindate", (QFilter[])new QFilter[]{filter});
            if (ObjectUtils.isEmpty((Object)scheme)) {
                return;
            }
            this.getModel().setValue(KEY_SCHEME, (Object)scheme.getLong("id"));
            this.getModel().setValue(KEY_CURRENCY, (Object)scheme.getLong(KEY_CURRENCY));
            this.setApplyYearCom(scheme);
            this.setDateRangeByScheme(scheme);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        super.beforeDoOperation(e);
        FormOperate op = (FormOperate)e.getSource();
        switch (op.getOperateKey()) {
            case "save": 
            case "submit": {
                IDataModel model = this.getModel();
                DynamicObject scheme = (DynamicObject)model.getValue(KEY_SCHEME);
                this.setDateRangeByScheme(scheme);
                break;
            }
        }
    }

    private void addRoleFiledListener() {
        String validity;
        DynamicObject scheme = (DynamicObject)this.getModel().getValue(KEY_SCHEME);
        if (!ObjectUtils.isEmpty((Object)scheme) && "PERPETUAL".equals(validity = scheme.getString("validity"))) {
            String fieldKey;
            BasedataEdit roleValueF7;
            DimensionEntryFieldMapper mapper = this.getMapper();
            String[] stringArray = BillEntityHelper.getAllRoleFields();
            int n = stringArray.length;
            for (int i = 0; i < n && (roleValueF7 = (BasedataEdit)this.getControl(fieldKey = stringArray[i])) != null; ++i) {
                roleValueF7.addBeforeF7SelectListener(event -> {
                    if (this.getIsOnlyDimensionMember()) {
                        List<Long> existValues = this.getArchiveData(fieldKey);
                        List<Long> viewData = this.getViewData(fieldKey);
                        LinkedList<Long> allValues = new LinkedList<Long>();
                        allValues.addAll(existValues);
                        allValues.addAll(viewData);
                        Object[] roleValues = BusinessDataServiceHelper.load((String)mapper.getFieldBaseDataKey(fieldKey), (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "in", allValues)});
                        String filterField = "id";
                        HashSet<Long> roleValueKeys = new HashSet<Long>(roleValues.length);
                        if (!ObjectUtils.isEmpty((Object[])roleValues)) {
                            DynamicProperty property = roleValues[0].getDynamicObjectType().getProperty("masterid");
                            if (!ObjectUtils.isEmpty((Object)property)) {
                                filterField = "masterid";
                            }
                            for (Object roleValue : roleValues) {
                                roleValueKeys.add(roleValue.getLong(filterField));
                            }
                        }
                        QFilter filter = new QFilter(filterField, "not in", roleValueKeys);
                        ListShowParameter showParameter = (ListShowParameter)event.getFormShowParameter();
                        ListFilterParameter listFilterParameter = showParameter.getListFilterParameter();
                        listFilterParameter.getQFilters().add(filter);
                    }
                });
            }
        }
    }

    private List<Long> getArchiveData(String fieldKey) {
        IBillModel model = (IBillModel)this.getModel();
        ArrayList<Long> existValues = new ArrayList<Long>();
        DynamicObject scheme = (DynamicObject)model.getValue(KEY_SCHEME);
        QFilter qFilter = new QFilter("scheme.id", "=", (Object)scheme.getLong("id"));
        DynamicObjectCollection archives = QueryServiceHelper.query((String)"ccm_archive", (String)fieldKey, (QFilter[])new QFilter[]{qFilter});
        for (DynamicObject archive : archives) {
            existValues.add(archive.getLong(fieldKey));
        }
        return existValues;
    }

    private List<Long> getViewData(String key) {
        IBillModel model = (IBillModel)this.getModel();
        int entryRowCount = model.getEntryRowCount(KEY_ENTRY);
        LinkedList<Long> roleValueIds = new LinkedList<Long>();
        for (int i = 0; i < entryRowCount; ++i) {
            DynamicObject roleValue = (DynamicObject)model.getValue(key, i);
            if (roleValue == null) continue;
            roleValueIds.add(roleValue.getLong("id"));
        }
        return roleValueIds;
    }

    private void gradeChange() {
        IBillModel model = (IBillModel)this.getModel();
        DynamicObject grade = (DynamicObject)model.getValue(KEY_GRADE);
        if (ObjectUtils.isEmpty((Object)grade)) {
            return;
        }
        DynamicObjectCollection entryList = grade.getDynamicObjectCollection(KEY_ENTRY);
        int index = model.getEntryCurrentRowIndex(KEY_ENTRY);
        if (entryList != null && entryList.size() > 0) {
            model.setValue("quota_amount", ((DynamicObject)entryList.get(0)).get("balance"), index);
            model.setValue("quota_days", ((DynamicObject)entryList.get(0)).get("day"), index);
        }
    }

    private void schemeChange(Object oldValue) {
        if (oldValue == null) {
            String[] allRoleTypeFields;
            DynamicObject newValue = (DynamicObject)this.getModel().getValue(KEY_SCHEME);
            this.getModel().setValue(KEY_CURRENCY, newValue.get(KEY_CURRENCY));
            this.setApplyYearCom(newValue);
            this.setDateRangeByScheme(newValue);
            this.getModel().deleteEntryData(KEY_ENTRY);
            this.getModel().createNewEntryRow(KEY_ENTRY);
            for (String clearFiledTypeKey : allRoleTypeFields = BillEntityHelper.getAllRoleTypeFields()) {
                if (!StringUtils.isNotBlank((Object)this.getModel().getProperty(clearFiledTypeKey))) continue;
                this.getModel().setValue(clearFiledTypeKey, null);
            }
            this.setVisableByCheckType();
            this.showHiddenControlByGrade();
            this.setMustInputDimensionMember();
            this.setControlRoleField();
        } else {
            DynamicObject scheme_old = (DynamicObject)oldValue;
            ConfirmCallBackListener confirmCallBack = new ConfirmCallBackListener("changeScheme", (IFormPlugin)this);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u5207\u6362\u201c\u4fe1\u63a7\u65b9\u6848\u201d\u5c06\u6e05\u9664\u5355\u636e\u4fe1\u606f\uff0c\u662f\u5426\u5207\u6362\uff1f", (String)"ArchiveApplyEdit_4", (String)"scmc-ccm-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, ConfirmTypes.Default, confirmCallBack);
            this.getView().getPageCache().put(CACHE_SCHEME, scheme_old.getPkValue().toString());
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        String callBackId = e.getCallBackId();
        if ("changeScheme".equals(callBackId)) {
            if (e.getResult().equals((Object)MessageBoxResult.Yes)) {
                String[] allRoleTypeFields;
                IBillModel model = (IBillModel)this.getModel();
                DynamicObject scheme = (DynamicObject)model.getValue(KEY_SCHEME);
                if (scheme == null) {
                    model.setValue(KEY_CURRENCY, null);
                } else {
                    model.setValue(KEY_CURRENCY, (Object)scheme.getDynamicObject(KEY_CURRENCY).getLong("id"));
                }
                model.deleteEntryData(KEY_ENTRY);
                model.createNewEntryRow(KEY_ENTRY);
                this.setApplyYearCom(scheme);
                this.getModel().setValue(KEY_APPLYYEAR, null);
                this.setDateRangeByScheme(scheme);
                for (String clearFiledTypeKey : allRoleTypeFields = BillEntityHelper.getAllRoleTypeFields()) {
                    if (!StringUtils.isNotBlank((Object)this.getModel().getProperty(clearFiledTypeKey))) continue;
                    this.getModel().setValue(clearFiledTypeKey, null);
                }
                this.setVisableByCheckType();
                this.showHiddenControlByGrade();
                this.setMustInputDimensionMember();
                this.setControlRoleField();
            } else {
                this.getPageCache().put("stopChange", "true");
                String schemeID = this.getView().getPageCache().get(CACHE_SCHEME);
                this.getModel().setValue(KEY_SCHEME, schemeID == null ? null : Long.valueOf(Long.parseLong(schemeID)));
                this.getPageCache().put("stopChange", "false");
            }
        }
    }

    private void materialChanged(DynamicObject role) {
        DynamicObject material = QueryServiceHelper.queryOne((String)"bd_material", (String)"baseunit", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)role.getLong("id"))});
        this.getModel().setValue("measureunit_qty", material.get("baseunit"));
    }

    private void showHiddenControlByGrade() {
        boolean containsCustomer = this.isDimensionContainsCustomer();
        if (containsCustomer) {
            this.getView().setVisible(Boolean.TRUE, new String[]{KEY_GRADE});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{KEY_GRADE});
        }
    }

    private boolean isDimensionContainsCustomer() {
        DynamicObject scheme = (DynamicObject)this.getModel().getValue(KEY_SCHEME);
        if (!ObjectUtils.isEmpty((Object)scheme)) {
            DimensionEntryFieldMapper fieldMapper = this.getMapper();
            List fieldTypeKeys = fieldMapper.getFieldTypeKeys();
            for (String fieldTypeKey : fieldTypeKeys) {
                String baseDataKey = fieldMapper.getBaseDataKey(fieldTypeKey);
                if (!"bd_customer".equals(baseDataKey)) continue;
                return true;
            }
        }
        return false;
    }

    private void setVisableByCheckType() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        BillFieldAssociatedCheckTypeMapper billMapper = new BillFieldAssociatedCheckTypeMapper(dataEntity);
        List associatedFieldList = billMapper.getAssociatedFieldList();
        for (String associatedField : associatedFieldList) {
            this.getView().setVisible(Boolean.TRUE, new String[]{associatedField});
        }
        List noAssociatedFieldList = billMapper.getNoAssociatedFieldList();
        for (String noAssociatedField : noAssociatedFieldList) {
            this.getView().setVisible(Boolean.FALSE, new String[]{noAssociatedField});
        }
    }

    private boolean getIsOnlyDimensionMember() {
        DimensionEntryFieldMapper roleFieldMapper;
        List fieldKeys;
        DynamicObject scheme = (DynamicObject)this.getModel().getValue(KEY_SCHEME);
        return !ObjectUtils.isEmpty((Object)scheme) && (fieldKeys = (roleFieldMapper = this.getMapper()).getRoleFieldKeys()).size() == 1;
    }

    private void setMustInputDimensionMember() {
        DynamicObject scheme = (DynamicObject)this.getModel().getValue(KEY_SCHEME);
        if (ObjectUtils.isEmpty((Object)scheme)) {
            return;
        }
        DimensionEntryFieldMapper roleFieldMapper = this.getMapper();
        List fieldKeys = roleFieldMapper.getRoleFieldKeys();
        for (String fieldKey : fieldKeys) {
            BasedataEdit dimensionMemberControl = (BasedataEdit)this.getControl(fieldKey);
            dimensionMemberControl.setMustInput(true);
        }
    }

    private void filterScheme() {
        DynamicObject org = (DynamicObject)this.getModel().getValue(KEY_ORG);
        BasedataEdit schemeF7 = (BasedataEdit)this.getControl(KEY_SCHEME);
        schemeF7.addBeforeF7SelectListener(beforeF7SelectListener -> {
            QFilter orgFilter = new QFilter("mainorg", "=", null);
            if (!ObjectUtils.isEmpty((Object)org)) {
                orgFilter = new QFilter("mainorg", "=", (Object)org.getLong("id"));
            }
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectListener.getFormShowParameter();
            ListFilterParameter listFilterParameter = showParameter.getListFilterParameter();
            listFilterParameter.getQFilters().add(orgFilter);
        });
    }

    public void afterImportData(ImportDataEventArgs e) {
        super.afterImportData(e);
        Date beginDate = (Date)this.getModel().getValue("begindate");
        Date endDate = (Date)this.getModel().getValue("enddate");
        if (beginDate == null || endDate == null) {
            return;
        }
        if (beginDate.compareTo(endDate) > 0) {
            String errorMessage = ResManager.loadKDString((String)"\u751f\u6548\u65e5\u671f\u8303\u56f4\u7684\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u5927\u4e8e\u7ed3\u675f\u65f6\u95f4\u3002", (String)"ArchiveApplyEdit_0", (String)"scmc-ccm-formplugin", (Object[])new Object[0]);
            throw new KDBizException(errorMessage);
        }
        DynamicObject scheme = (DynamicObject)this.getModel().getValue(KEY_SCHEME);
        DynamicObject org = (DynamicObject)this.getModel().getValue(KEY_ORG);
        if (scheme == null || org == null) {
            return;
        }
        DynamicObject schemeOrg = scheme.getDynamicObject("mainorg");
        if (!Objects.equals(schemeOrg.getPkValue(), org.getPkValue())) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6863\u6848\u7533\u8bf7\u5355\u6388\u4fe1\u7ec4\u7ec7\u4e0e\u4fe1\u7528\u65b9\u6848\u6388\u4fe1\u7ec4\u7ec7\u4e0d\u4e00\u81f4\u3002", (String)"ArchiveApplyEdit_1", (String)"scmc-ccm-formplugin", (Object[])new Object[0]));
        }
        if (scheme.getDynamicObject(KEY_CURRENCY) != null) {
            this.getModel().setValue(KEY_CURRENCY, (Object)scheme.getDynamicObject(KEY_CURRENCY).getLong("id"));
        }
        DimensionEntryFieldMapper roleFieldMapper = this.getMapper();
        List roleNumbers = roleFieldMapper.getRoleNumbers();
        for (int i = 0; i < roleNumbers.size(); ++i) {
            String roleType = (String)roleNumbers.get(i);
            String fieldTypeKey = roleFieldMapper.getFieldTypeKey(roleType);
            String baseDataKey = roleFieldMapper.getBaseDataKey(roleType);
            String actualRoleBaseDataKey = (String)this.getModel().getValue(fieldTypeKey);
            if (Objects.equals(actualRoleBaseDataKey, baseDataKey)) continue;
            String aimBaseDataName = MetadataServiceHelper.getDataEntityType((String)baseDataKey).getDisplayName().getLocaleValue();
            if (StringUtils.isBlank((CharSequence)actualRoleBaseDataKey)) {
                String messageTemplate = ResManager.loadKDString((String)"\u7ef4\u5ea6\u6210\u5458\u7c7b\u578b\u201c%1$s\u201d\u8bbe\u7f6e\u4e0d\u6b63\u786e\uff0c\u8bf7\u9009\u62e9\u201c%2$s\u201d\u3002", (String)"ArchiveApplyEdit_2", (String)"scmc-ccm-formplugin", (Object[])new Object[0]);
                throw new KDBizException(String.format(messageTemplate, i, aimBaseDataName));
            }
            String actualBaseDataName = MetadataServiceHelper.getDataEntityType((String)actualRoleBaseDataKey).getDisplayName().getLocaleValue();
            String errorMessage = ResManager.loadKDString((String)"\u7ef4\u5ea6\u6210\u5458\u7c7b\u578b\u201c%1$s\u201d\u8bbe\u7f6e\u4e0d\u6b63\u786e\u3002\u8bf7\u9009\u62e9\u201c%2$s\u201d\uff0c\u800c\u975e\u201c%3$s\u201d\u3002", (String)"ArchiveApplyEdit_3", (String)"scmc-ccm-formplugin", (Object[])new Object[0]);
            throw new KDBizException(String.format(errorMessage, i, aimBaseDataName, actualBaseDataName));
        }
    }

    private void setApplyYearCom(DynamicObject scheme) {
        ComboEdit applyYearControl = (ComboEdit)this.getControl(KEY_APPLYYEAR);
        if (scheme == null || scheme.getLong("id") == 0L) {
            applyYearControl.setMustInput(false);
            this.getView().setVisible(Boolean.FALSE, new String[]{KEY_APPLYYEAR, KEY_DATERANGE});
            return;
        }
        String validity = scheme.getString("validity");
        if ("YEAR".equals(validity)) {
            applyYearControl.setMustInput(true);
            this.getView().setVisible(Boolean.TRUE, new String[]{KEY_APPLYYEAR, KEY_DATERANGE});
            ArrayList<ComboItem> applyYearList = new ArrayList<ComboItem>(5);
            int applyYear = DateUtils.getDateYear((Date)new Date());
            ComboEdit applyYearCom = (ComboEdit)this.getControl(KEY_APPLYYEAR);
            for (int i = applyYear - 1; i < applyYear + 4; ++i) {
                ComboItem comboItem = new ComboItem();
                LocaleString caption = new LocaleString(String.valueOf(i));
                comboItem.setCaption(caption);
                comboItem.setValue(String.valueOf(i));
                applyYearList.add(comboItem);
            }
            applyYearCom.setComboItems(applyYearList);
        } else if ("PERPETUAL".equals(validity)) {
            applyYearControl.setMustInput(false);
            this.getView().setVisible(Boolean.FALSE, new String[]{KEY_APPLYYEAR, KEY_DATERANGE});
        }
    }

    private void setDateRangeByScheme(DynamicObject scheme) {
        if (scheme == null || scheme.getLong("id") == 0L) {
            this.getModel().setValue(KEY_APPLYYEAR, null);
            this.getModel().setValue("begindate", null);
            this.getModel().setValue("enddate", null);
            return;
        }
        String validity = scheme.getString("validity");
        if ("PERPETUAL".equals(validity)) {
            this.getModel().setValue(KEY_APPLYYEAR, null);
            this.getModel().setValue("begindate", (Object)new Date());
            this.getModel().setValue("enddate", (Object)DateUtils.getYearsLaterDate((Date)new Date(), (int)100));
        } else if ("YEAR".equals(validity)) {
            String applyYear = (String)this.getModel().getValue(KEY_APPLYYEAR);
            this.setDateRange(applyYear);
        }
    }

    private void setDateRange(String applyYear) {
        if (StringUtils.isBlank((CharSequence)applyYear)) {
            this.getModel().setValue("begindate", null);
            this.getModel().setValue("enddate", null);
            return;
        }
        DynamicObject scheme = (DynamicObject)this.getModel().getValue(KEY_SCHEME);
        if (ObjectUtils.isEmpty((Object)scheme)) {
            return;
        }
        String validity = scheme.getString("validity");
        if ("YEAR".equals(validity)) {
            Date yearBeginDate = scheme.getDate("yearbegindate");
            int month = DateUtils.getDateMonth((Date)yearBeginDate);
            int day = DateUtils.getDateDay((Date)yearBeginDate);
            Date beginDate = DateUtils.getSpecialDate((int)Integer.parseInt(applyYear), (int)month, (int)day);
            Date endDate = DateUtils.getYearsLaterDate((Date)beginDate, (int)1);
            this.getModel().setValue("begindate", (Object)beginDate);
            this.getModel().setValue("enddate", (Object)endDate);
        }
    }

    private DimensionEntryFieldMapper getMapper() {
        DynamicObject scheme = (DynamicObject)this.getModel().getValue(KEY_SCHEME);
        if (!ObjectUtils.isEmpty((Object)scheme)) {
            DynamicObject dimension = scheme.getDynamicObject("dimension");
            this.mapper = new DimensionEntryFieldMapper(dimension.getPkValue());
        }
        return this.mapper;
    }

    private void setControlRoleField() {
        DynamicObject scheme = (DynamicObject)this.getModel().getValue(KEY_SCHEME);
        LinkedList<String> unvisiableKeys = new LinkedList<String>();
        String[] allRoleFields = BillEntityHelper.getAllRoleFields();
        unvisiableKeys.addAll(Arrays.asList(allRoleFields));
        LinkedList<String> visiableKeys = new LinkedList<String>();
        EntryGrid grid = (EntryGrid)this.getControl(KEY_ENTRY);
        if (scheme != null) {
            Object dimensionId = scheme.get("dimension.id");
            DimensionEntryFieldMapper fieldMapper = new DimensionEntryFieldMapper(dimensionId);
            List fieldTypeKeys = fieldMapper.getFieldTypeKeys();
            for (String filedKey : fieldTypeKeys) {
                String baseDataKey = fieldMapper.getBaseDataKey(filedKey);
                this.getModel().setValue(filedKey, (Object)baseDataKey);
            }
            List roleFieldKeys = fieldMapper.getRoleFieldKeys();
            for (String fieldKey : roleFieldKeys) {
                FieldEdit control = (FieldEdit)this.getControl(fieldKey);
                LocaleString roleDisplayName = fieldMapper.getRoleDisplayName(fieldKey);
                control.setCaption(roleDisplayName);
                visiableKeys.add(fieldKey);
                unvisiableKeys.remove(fieldKey);
            }
        }
        if (!visiableKeys.isEmpty()) {
            this.getView().setVisible(Boolean.TRUE, visiableKeys.toArray(new String[0]));
        }
        if (!unvisiableKeys.isEmpty()) {
            this.getView().setVisible(Boolean.FALSE, unvisiableKeys.toArray(new String[0]));
        }
    }
}

