/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ccm.formplugin.archive;

import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IBillModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.DateRangeEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.scmc.ccm.business.setting.BillFieldAssociatedCheckTypeMapper;
import kd.scmc.ccm.business.setting.DimensionEntryFieldMapper;
import kd.scmc.ccm.common.helper.BillEntityHelper;
import kd.scmc.ccm.common.util.CommonUtils;
import kd.scmc.ccm.common.util.DateUtils;

public class ArchiveChangeEdit
extends AbstractBillPlugIn {
    private static final String KEY_SCHEME = "scheme";
    private static final String KEY_DIMENSION = "dimension";
    private static final String KEY_CURRENCY = "currency";
    private static final String KEY_ORG = "org";
    private static final String KEY_SCHEMEENTRY = "schemeentry";
    private static final String KEY_GRADE = "grade";
    private static final String KEY_BEGINDATE = "begindate";
    private static final String KEY_ENDDATE = "enddate";
    private static final String KEY_GRADEBEFORE = "gradebefore";
    private static final String KEY_BEGINDATEBEFORE = "begindatebefore";
    private static final String KEY_ENDDATEBEFORE = "enddatebefore";
    private static final String KEY_MEASUREUNIT = "measureunit_qty";
    private static final String CACHE_SCHEME = "cache_scheme";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.filterDimension();
        this.filterScheme();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        ChangeData[] valueSet;
        String stopChange = this.getPageCache().get("stopChange");
        if ("true".equals(stopChange)) {
            return;
        }
        String key = e.getProperty().getName();
        block0: for (ChangeData data : valueSet = e.getChangeSet()) {
            if (!CommonUtils.isRealChanged((ChangeData)data)) continue;
            Object oldValue = data.getOldValue();
            if (KEY_SCHEME.equals(key)) {
                this.schemeChange(oldValue);
                continue;
            }
            if (!key.startsWith("role")) continue;
            DynamicObject dimension = this.getDimension();
            if (dimension == null) {
                return;
            }
            DimensionEntryFieldMapper mapper = new DimensionEntryFieldMapper(dimension.getPkValue());
            List roleFieldKeys = mapper.getRoleFieldKeys();
            for (String roleField : roleFieldKeys) {
                if (!Objects.equals(roleField, key)) continue;
                this.roleValueChanged(roleFieldKeys);
                continue block0;
            }
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setControlRoleField();
        this.showHiddenControlByGrade();
        this.setControlsVisibilityByCheckType();
        this.setMustInputDimensionMember();
        DateRangeEdit date = (DateRangeEdit)this.getView().getControl("daterange");
        if (date != null) {
            DynamicObject scheme = (DynamicObject)this.getModel().getValue(KEY_SCHEME);
            if (scheme != null) {
                if ("YEAR".equals(scheme.getString("validity"))) {
                    date.setMinDate(new Date());
                } else {
                    date.setMinDate(DateUtils.getDateBySpecifyValue((int)2000, (int)1, (int)1));
                }
            }
            date.setMaxDate(DateUtils.getDateBySpecifyValue((int)2999, (int)12, (int)31));
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        BillShowParameter parameter = (BillShowParameter)this.getView().getFormShowParameter();
        String schemeId = (String)parameter.getCustomParam("schemeId");
        DynamicObject org = (DynamicObject)this.getModel().getValue(KEY_ORG);
        if (StringUtils.isNotBlank((CharSequence)schemeId) && org != null) {
            QFilter filter = new QFilter("enable", "=", (Object)"1");
            filter.and(new QFilter("status", "=", (Object)"C"));
            filter.and("id", "=", (Object)Long.valueOf(schemeId));
            filter.and("mainorg", "=", (Object)org.getLong("id"));
            DynamicObject scheme = QueryServiceHelper.queryOne((String)"ccm_scheme", (String)"id,currency,validity", (QFilter[])new QFilter[]{filter});
            if (ObjectUtils.isEmpty((Object)scheme)) {
                return;
            }
            this.getModel().setValue(KEY_SCHEME, (Object)scheme.getLong("id"));
            this.getModel().setValue(KEY_CURRENCY, (Object)scheme.getLong(KEY_CURRENCY));
            this.schemeChange(null);
        }
    }

    private void roleValueChanged(List<String> roleFieldKeys) {
        DynamicObject schemeObj = (DynamicObject)this.getModel().getValue(KEY_SCHEME);
        if (schemeObj == null) {
            return;
        }
        int currentRowIndex = this.getModel().getEntryCurrentRowIndex(KEY_SCHEMEENTRY);
        LinkedList<QFilter> filters = new LinkedList<QFilter>();
        LinkedList<String> pkValues = new LinkedList<String>();
        for (String roleField : roleFieldKeys) {
            DynamicObject roleObj = (DynamicObject)this.getModel().getValue(roleField, currentRowIndex);
            if (roleObj != null) {
                DynamicProperty property = roleObj.getDynamicObjectType().getProperty("masterid");
                pkValues.add(property == null ? String.valueOf(roleObj.get("id")) : String.valueOf(roleObj.get("masterid")));
                continue;
            }
            this.setEntryFieldValueIsNull(currentRowIndex);
            return;
        }
        filters.add(new QFilter("dimensionvalue", "=", (Object)String.join((CharSequence)"-", pkValues)));
        filters.add(new QFilter(KEY_SCHEME, "=", (Object)schemeObj.getLong("id")));
        filters.add(new QFilter("archivetype", "=", (Object)"normal"));
        QFilter yearFilter = new QFilter(KEY_BEGINDATE, "<=", (Object)DateUtils.getEndOfDay((Date)TimeServiceHelper.now())).and(new QFilter(KEY_ENDDATE, ">=", (Object)DateUtils.getStartOfDay((Date)TimeServiceHelper.now()))).and(new QFilter("scheme.validity", "=", (Object)"YEAR"));
        QFilter perpetualFilter = new QFilter("scheme.validity", "=", (Object)"PERPETUAL");
        filters.add(yearFilter.or(perpetualFilter));
        QFilter[] archiveFilers = filters.toArray(new QFilter[0]);
        DataSet archiveDS = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"ccm_archive", (String)"id,grade,quota,begindate,enddate,quotatype,unit", (QFilter[])archiveFilers, (String)"enddate desc,id desc");
        DataSet topArchiveDS = archiveDS.top(1);
        if (topArchiveDS.hasNext()) {
            Row archive = topArchiveDS.next();
            this.setEntryFieldValue(currentRowIndex, archive);
        } else {
            this.setEntryFieldValueIsNull(currentRowIndex);
        }
        archiveDS.close();
        topArchiveDS.close();
    }

    private void schemeChange(Object oldValue) {
        if (oldValue == null) {
            String[] allRoleTypeFields;
            DynamicObject newValue = (DynamicObject)this.getModel().getValue(KEY_SCHEME);
            this.getModel().setValue(KEY_CURRENCY, newValue.get(KEY_CURRENCY));
            this.getModel().deleteEntryData(KEY_SCHEMEENTRY);
            this.getModel().createNewEntryRow(KEY_SCHEMEENTRY);
            for (String clearFiledTypeKey : allRoleTypeFields = BillEntityHelper.getAllRoleTypeFields()) {
                if (!StringUtils.isNotBlank((Object)this.getModel().getProperty(clearFiledTypeKey))) continue;
                this.getModel().setValue(clearFiledTypeKey, null);
            }
            this.showHiddenControlByGrade();
            this.setControlsVisibilityByCheckType();
            this.setControlRoleField();
            this.setMustInputDimensionMember();
            DateRangeEdit date = (DateRangeEdit)this.getView().getControl("daterange");
            if (date != null) {
                if ("YEAR".equals(newValue.getString("validity"))) {
                    date.setMinDate(new Date());
                } else {
                    date.setMinDate(DateUtils.getDateBySpecifyValue((int)2000, (int)1, (int)1));
                }
            }
        } else {
            DynamicObject scheme_old = (DynamicObject)oldValue;
            ConfirmCallBackListener confirmCallBack = new ConfirmCallBackListener("changeScheme", (IFormPlugin)this);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u5207\u6362\u201c\u4fe1\u63a7\u65b9\u6848\u201d\u5c06\u6e05\u9664\u5355\u636e\u4fe1\u606f\uff0c\u662f\u5426\u5207\u6362\uff1f", (String)"ArchiveChangeEdit_0", (String)"scmc-ccm-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, ConfirmTypes.Default, confirmCallBack);
            this.getView().getPageCache().put(CACHE_SCHEME, scheme_old.getPkValue().toString());
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        String callBackId = e.getCallBackId();
        if ("changeScheme".equals(callBackId)) {
            if (e.getResult().equals((Object)MessageBoxResult.Yes)) {
                String[] allRoleTypeFields;
                IBillModel model = (IBillModel)this.getModel();
                DynamicObject scheme = (DynamicObject)model.getValue(KEY_SCHEME);
                if (scheme == null) {
                    this.getModel().setValue(KEY_CURRENCY, null);
                } else {
                    this.getModel().setValue(KEY_CURRENCY, (Object)scheme.getDynamicObject(KEY_CURRENCY).getLong("id"));
                    DateRangeEdit date = (DateRangeEdit)this.getView().getControl("daterange");
                    if (date != null) {
                        if ("YEAR".equals(scheme.getString("validity"))) {
                            date.setMinDate(new Date());
                        } else {
                            date.setMinDate(DateUtils.getDateBySpecifyValue((int)2000, (int)1, (int)1));
                        }
                    }
                }
                this.getModel().deleteEntryData(KEY_SCHEMEENTRY);
                this.getModel().createNewEntryRow(KEY_SCHEMEENTRY);
                for (String clearFiledTypeKey : allRoleTypeFields = BillEntityHelper.getAllRoleTypeFields()) {
                    if (!StringUtils.isNotBlank((Object)this.getModel().getProperty(clearFiledTypeKey))) continue;
                    this.getModel().setValue(clearFiledTypeKey, null);
                }
                this.setControlsVisibilityByCheckType();
                this.showHiddenControlByGrade();
                this.setControlRoleField();
                this.setMustInputDimensionMember();
            } else {
                this.getPageCache().put("stopChange", "true");
                String schemeID = this.getView().getPageCache().get(CACHE_SCHEME);
                this.getModel().setValue(KEY_SCHEME, schemeID == null ? null : Long.valueOf(Long.parseLong(schemeID)));
                this.getPageCache().put("stopChange", "false");
            }
        }
    }

    private void filterDimension() {
        String[] allRoleFields = BillEntityHelper.getAllRoleFields();
        DynamicObject dimension = this.getDimension();
        if (dimension != null) {
            DimensionEntryFieldMapper mapper = new DimensionEntryFieldMapper(dimension.getPkValue());
            for (String roleFileldKey : allRoleFields) {
                BasedataEdit roleF7 = (BasedataEdit)this.getControl(roleFileldKey);
                if (roleF7 == null) continue;
                roleF7.addBeforeF7SelectListener(beforeF7SelectListener -> {
                    DynamicObjectCollection archives = this.getArchivesByRoleListener(roleFileldKey, dimension, mapper);
                    HashSet roleIds = new HashSet();
                    archives.stream().forEach(archive -> roleIds.add(archive.getLong(roleFileldKey)));
                    Object[] roles = BusinessDataServiceHelper.load((String)mapper.getFieldBaseDataKey(roleFileldKey), (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "in", roleIds)});
                    HashSet<Long> roleValueKeys = new HashSet<Long>(roles.length);
                    String filterField = "id";
                    if (!ObjectUtils.isEmpty((Object[])roles)) {
                        DynamicProperty property = roles[0].getDynamicObjectType().getProperty("masterid");
                        if (property != null) {
                            filterField = "masterid";
                        }
                        for (Object role : roles) {
                            roleValueKeys.add(role.getLong(filterField));
                        }
                    }
                    QFilter qFilter = new QFilter(filterField, "in", roleValueKeys);
                    ListShowParameter showParameter = (ListShowParameter)beforeF7SelectListener.getFormShowParameter();
                    ListFilterParameter listFilterParameter = showParameter.getListFilterParameter();
                    listFilterParameter.getQFilters().add(qFilter);
                });
            }
        }
    }

    private DynamicObject getDimension() {
        IBillModel model = (IBillModel)this.getModel();
        DynamicObject scheme = (DynamicObject)model.getValue(KEY_SCHEME);
        if (scheme == null) {
            return null;
        }
        return scheme.getDynamicObject(KEY_DIMENSION);
    }

    private void showHiddenControlByGrade() {
        if (this.isDimensionContainsCustomer()) {
            this.getView().setVisible(Boolean.TRUE, new String[]{KEY_GRADE, KEY_GRADEBEFORE});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{KEY_GRADE, KEY_GRADEBEFORE});
        }
    }

    private boolean isDimensionContainsCustomer() {
        DynamicObject scheme = (DynamicObject)this.getModel().getValue(KEY_SCHEME);
        if (!ObjectUtils.isEmpty((Object)scheme)) {
            DynamicObject dimension = scheme.getDynamicObject(KEY_DIMENSION);
            DimensionEntryFieldMapper fieldMapper = new DimensionEntryFieldMapper(dimension.getPkValue());
            List fieldTypeKeys = fieldMapper.getFieldTypeKeys();
            for (String fieldTypeKey : fieldTypeKeys) {
                String baseDataKey = fieldMapper.getBaseDataKey(fieldTypeKey);
                if (!"bd_customer".equals(baseDataKey)) continue;
                return true;
            }
        }
        return false;
    }

    private void filterScheme() {
        DynamicObject org = (DynamicObject)this.getModel().getValue(KEY_ORG);
        BasedataEdit schemeF7 = (BasedataEdit)this.getControl(KEY_SCHEME);
        schemeF7.addBeforeF7SelectListener(beforeF7SelectListener -> {
            QFilter qFilter = new QFilter("mainorg", "=", null);
            if (!ObjectUtils.isEmpty((Object)org)) {
                qFilter = new QFilter("mainorg", "=", (Object)org.getLong("id"));
            }
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectListener.getFormShowParameter();
            ListFilterParameter listFilterParameter = showParameter.getListFilterParameter();
            listFilterParameter.getQFilters().add(qFilter);
        });
    }

    private void setControlsVisibilityByCheckType() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        BillFieldAssociatedCheckTypeMapper billMapper = new BillFieldAssociatedCheckTypeMapper(dataEntity);
        List associatedFieldList = billMapper.getAssociatedFieldList();
        for (String associatedField : associatedFieldList) {
            this.getView().setVisible(Boolean.TRUE, new String[]{associatedField});
        }
        List noAssociatedFieldList = billMapper.getNoAssociatedFieldList();
        for (String noAssociatedField : noAssociatedFieldList) {
            this.getView().setVisible(Boolean.FALSE, new String[]{noAssociatedField});
        }
    }

    private void setEntryFieldValue(int rowIndex, Row archive) {
        IDataModel model = this.getModel();
        BillFieldAssociatedCheckTypeMapper billMapper = new BillFieldAssociatedCheckTypeMapper(model.getDataEntity());
        List associatedFieldList = billMapper.getAssociatedFieldList();
        model.setValue(KEY_GRADE, (Object)archive.getLong(KEY_GRADE), rowIndex);
        model.setValue(KEY_GRADEBEFORE, (Object)archive.getLong(KEY_GRADE), rowIndex);
        Date beginDate = new Date();
        model.setValue(KEY_BEGINDATE, (Object)beginDate, rowIndex);
        if (((Date)archive.get(KEY_ENDDATE)).before(beginDate)) {
            if (((Date)archive.get(KEY_ENDDATE)).after(DateUtils.getStartOfDay((Date)beginDate))) {
                model.setValue(KEY_ENDDATE, (Object)DateUtils.getEndOfDay((Date)archive.getDate(KEY_ENDDATE)), rowIndex);
            } else {
                model.setValue(KEY_ENDDATE, (Object)DateUtils.getYearsLaterDate((Date)beginDate, (int)100), rowIndex);
            }
        } else {
            model.setValue(KEY_ENDDATE, (Object)archive.getDate(KEY_ENDDATE), rowIndex);
        }
        model.setValue(KEY_BEGINDATEBEFORE, (Object)archive.getDate(KEY_BEGINDATE), rowIndex);
        model.setValue(KEY_ENDDATEBEFORE, (Object)archive.getDate(KEY_ENDDATE), rowIndex);
        model.setValue("archiveid", (Object)archive.getLong("id"), rowIndex);
        for (String associatedField : associatedFieldList) {
            if (KEY_MEASUREUNIT.equals(associatedField)) {
                if (archive.getLong("unit") == 0L) {
                    model.setValue(KEY_MEASUREUNIT, null, rowIndex);
                    continue;
                }
                model.setValue(KEY_MEASUREUNIT, (Object)archive.getLong("unit"), rowIndex);
                continue;
            }
            model.setValue(associatedField, (Object)archive.getBigDecimal("quota"), rowIndex);
        }
    }

    private void setEntryFieldValueIsNull(int rowIndex) {
        IDataModel model = this.getModel();
        BillFieldAssociatedCheckTypeMapper billMapper = new BillFieldAssociatedCheckTypeMapper(model.getDataEntity());
        List associatedFieldList = billMapper.getAssociatedFieldList();
        for (String associatedField : associatedFieldList) {
            model.setValue(associatedField, null);
        }
        model.setValue(KEY_GRADE, null, rowIndex);
        model.setValue(KEY_GRADEBEFORE, null, rowIndex);
        model.setValue(KEY_BEGINDATE, null, rowIndex);
        model.setValue(KEY_ENDDATE, null, rowIndex);
        model.setValue(KEY_BEGINDATEBEFORE, null, rowIndex);
        model.setValue(KEY_ENDDATEBEFORE, null, rowIndex);
        model.setValue("archiveid", null, rowIndex);
    }

    private DynamicObjectCollection getArchivesByRoleListener(String roleFileldKey, DynamicObject dimension, DimensionEntryFieldMapper roleFieldMapper) {
        List roleFileldKeys = roleFieldMapper.getRoleFieldKeys();
        int rowIndex = this.getModel().getEntryCurrentRowIndex(KEY_SCHEMEENTRY);
        DynamicObject scheme = (DynamicObject)this.getModel().getValue(KEY_SCHEME);
        QFilter filter = new QFilter(KEY_SCHEME, "=", (Object)scheme.getLong("id"));
        filter.and(new QFilter("archivetype", "=", (Object)"normal"));
        for (String roleKey : roleFileldKeys) {
            DynamicObject role = (DynamicObject)this.getModel().getValue(roleKey, rowIndex);
            if (ObjectUtils.isEmpty((Object)role) || Objects.equals(roleKey, roleFileldKey)) continue;
            if (role.getDynamicObjectType().getProperty("masterid") != null) {
                filter.and(new QFilter(roleKey, "=", (Object)role.getLong("masterid")));
                continue;
            }
            filter.and(new QFilter(roleKey, "=", (Object)role.getLong("id")));
        }
        DynamicObjectCollection archives = QueryServiceHelper.query((String)"ccm_archive", (String)roleFileldKey, (QFilter[])new QFilter[]{filter});
        return archives;
    }

    private void setControlRoleField() {
        DynamicObject scheme = (DynamicObject)this.getModel().getValue(KEY_SCHEME);
        LinkedList<String> unvisiableKeys = new LinkedList<String>();
        String[] allRoleFields = BillEntityHelper.getAllRoleFields();
        unvisiableKeys.addAll(Arrays.asList(allRoleFields));
        LinkedList<String> visiableKeys = new LinkedList<String>();
        if (scheme != null) {
            Object dimensionId = scheme.get("dimension.id");
            DimensionEntryFieldMapper fieldMapper = new DimensionEntryFieldMapper(dimensionId);
            List fieldTypeKeys = fieldMapper.getFieldTypeKeys();
            for (String filedKey : fieldTypeKeys) {
                String baseDataKey = fieldMapper.getBaseDataKey(filedKey);
                this.getModel().setValue(filedKey, (Object)baseDataKey);
            }
            List roleFieldKeys = fieldMapper.getRoleFieldKeys();
            for (String fieldKey : roleFieldKeys) {
                FieldEdit control = (FieldEdit)this.getControl(fieldKey);
                LocaleString roleDisplayName = fieldMapper.getRoleDisplayName(fieldKey);
                control.setCaption(roleDisplayName);
                visiableKeys.add(fieldKey);
                unvisiableKeys.remove(fieldKey);
            }
        }
        if (!visiableKeys.isEmpty()) {
            this.getView().setVisible(Boolean.TRUE, visiableKeys.toArray(new String[0]));
        }
        if (!unvisiableKeys.isEmpty()) {
            this.getView().setVisible(Boolean.FALSE, unvisiableKeys.toArray(new String[0]));
        }
    }

    private void setMustInputDimensionMember() {
        DynamicObject scheme = (DynamicObject)this.getModel().getValue(KEY_SCHEME);
        if (ObjectUtils.isEmpty((Object)scheme)) {
            return;
        }
        Object dimensionId = scheme.get("dimension.id");
        DimensionEntryFieldMapper roleFieldMapper = new DimensionEntryFieldMapper(dimensionId);
        List fieldKeys = roleFieldMapper.getRoleFieldKeys();
        for (String fieldKey : fieldKeys) {
            BasedataEdit dimensionMemberControl = (BasedataEdit)this.getControl(fieldKey);
            dimensionMemberControl.setMustInput(true);
        }
    }
}

