/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ccm.formplugin.archive;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.BeforeImportDataEventArgs;
import kd.bos.entity.datamodel.events.ImportDataEventArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.scmc.ccm.business.setting.DimensionEntryFieldMapper;
import kd.scmc.ccm.common.enums.StatusEnum;
import kd.scmc.ccm.common.util.DateUtils;

public class ArchiveChangeImportPlugin
extends AbstractBillPlugIn {
    public void beforeImportData(BeforeImportDataEventArgs e) {
        Map<Object, Object> schemeEntryMap;
        Map<Object, Object> schemeMap = this.format4ImportAndApi(e.getSourceData().get("scheme"));
        List fieldTypeKeys = new ArrayList();
        if (schemeMap != null) {
            QFilter schemeFilter = new QFilter((String)schemeMap.get("importprop"), "=", schemeMap.get(schemeMap.get("importprop")));
            DynamicObject scheme = BusinessDataServiceHelper.loadSingleFromCache((String)"ccm_scheme", (QFilter[])new QFilter[]{schemeFilter});
            if (scheme != null) {
                Object dimensionId = scheme.get("dimension.id");
                DimensionEntryFieldMapper fieldMapper = new DimensionEntryFieldMapper(dimensionId);
                fieldTypeKeys = fieldMapper.getFieldTypeKeys();
                for (String filedKey : fieldTypeKeys) {
                    String baseDataKey = fieldMapper.getBaseDataKey(filedKey);
                    e.getSourceData().put(filedKey, baseDataKey);
                }
            }
        }
        if ((schemeEntryMap = this.format4ImportAndApi(e.getSourceData().get("schemeentry"))) != null) {
            List schemeEntry = (List)schemeEntryMap.get("sourceData");
            JSONArray billEntryArray = new JSONArray();
            for (Map entry : schemeEntry) {
                entry.put("begindate", entry.get("enddate"));
                int roleNum = fieldTypeKeys.size();
                for (int i = 3; i >= roleNum; --i) {
                    entry.put("role" + i, null);
                }
                billEntryArray.add((Object)entry);
            }
            e.getSourceData().put("schemeentry", billEntryArray);
        }
    }

    public void afterImportData(ImportDataEventArgs e) {
        IDataModel model = this.getModel();
        DynamicObject org = (DynamicObject)model.getValue("org");
        if (org == null) {
            return;
        }
        DynamicObject scheme = (DynamicObject)model.getValue("scheme");
        if (scheme == null) {
            return;
        }
        DynamicObject currency = scheme.getDynamicObject("currency");
        Object dimensionId = scheme.get("dimension.id");
        DimensionEntryFieldMapper fieldMapper = new DimensionEntryFieldMapper(dimensionId);
        List fieldTypeKeys = fieldMapper.getFieldTypeKeys();
        Long userId = RequestContext.get().getCurrUserId();
        Date nowDate = DateUtils.getStartOfDay((Date)new Date());
        model.setValue("billstatus", (Object)StatusEnum.SAVE.getValue());
        model.setValue("currency", (Object)currency);
        model.setValue("creator", (Object)userId);
        model.setValue("changeperson", (Object)userId);
        model.setValue("modifier", (Object)userId);
        model.setValue("changedate", (Object)nowDate);
        model.setValue("createtime", (Object)nowDate);
        model.setValue("modifytime", (Object)nowDate);
        String billNo = (String)model.getValue("billno");
        if (StringUtils.isEmpty((CharSequence)billNo)) {
            billNo = CodeRuleServiceHelper.getNumber((String)"ccm_archive_change", (DynamicObject)model.getDataEntity(), (String)String.valueOf(org.getPkValue()));
            model.setValue("billno", (Object)billNo);
        }
        DynamicObjectCollection billEntrys = (DynamicObjectCollection)model.getValue("schemeentry");
        for (DynamicObject billEntry : billEntrys) {
            int roleNum = fieldTypeKeys.size();
            for (int i = 3; i >= roleNum; --i) {
                billEntry.set("role" + i, null);
            }
            LinkedList<String> pkValues = new LinkedList<String>();
            for (int i = 0; i < roleNum; ++i) {
                DynamicObject roleObj = (DynamicObject)billEntry.get("role" + i);
                if (roleObj == null) continue;
                DynamicProperty property = roleObj.getDynamicObjectType().getProperty("masterid");
                pkValues.add(property == null ? String.valueOf(roleObj.get("id")) : String.valueOf(roleObj.get("masterid")));
            }
            String dimensionValue = String.join((CharSequence)"-", pkValues);
            billEntry.set("begindate", (Object)nowDate);
            billEntry.set("measureunit_qty", null);
            billEntry.set("before_qty", null);
            billEntry.set("quota_qty", null);
            QFilter beginDateFilter = new QFilter("begindate", "<=", (Object)DateUtils.getEndOfDay((Date)nowDate));
            QFilter endDateFilter = new QFilter("enddate", ">=", (Object)DateUtils.getStartOfDay((Date)nowDate));
            QFilter schemeFilter = new QFilter("scheme", "=", scheme.getPkValue());
            QFilter dimensionValueFilter = new QFilter("dimensionvalue", "=", (Object)dimensionValue);
            QFilter archiveTypeFilter = new QFilter("archivetype", "=", (Object)"normal");
            DynamicObject[] archives = BusinessDataServiceHelper.load((String)"ccm_archive", (String)"id,grade,quota,begindate,enddate,quotatype,unit", (QFilter[])new QFilter[]{beginDateFilter, endDateFilter, schemeFilter, dimensionValueFilter, archiveTypeFilter});
            if (archives != null && archives.length > 0) {
                DynamicObject archive = archives[0];
                Object quota = archive.get("quota");
                billEntry.set("begindatebefore", archive.get("begindate"));
                billEntry.set("enddatebefore", archive.get("enddate"));
                if (billEntry.get("enddate") == null) {
                    billEntry.set("enddate", archive.get("enddate"));
                }
                billEntry.set("gradebefore", archive.get("grade"));
                if (billEntry.get("grade") == null) {
                    billEntry.set("grade", archive.get("grade"));
                }
                DynamicObject checkType = scheme.getDynamicObject("checktype");
                this.setArchiveValues(checkType, "KZFW001", billEntry, quota, "before_amount", "quota_amount");
                this.setArchiveValues(checkType, "KZFW002", billEntry, quota, "before_days", "quota_days");
                this.setArchiveValues(checkType, "KZFW006", billEntry, quota, "before_overdueamt", "quota_overdueamt");
                this.setArchiveValues(checkType, "KZFW010", billEntry, quota, "before_privilegeamt", "quota_privilegeamt");
                this.setArchiveValues(checkType, "KZFW011", billEntry, quota, "before_privilegeday", "quota_privilegeday");
                billEntry.set("archiveid", archive.get("id"));
            }
            if (billEntry.get("enddate") != null) continue;
            billEntry.set("enddate", (Object)nowDate);
        }
    }

    private void setArchiveValues(DynamicObject checkType, String checkTypeNumber, DynamicObject billEntry, Object quota, String beforeField, String nowField) {
        if (checkType != null && checkTypeNumber.equals(checkType.getString("number"))) {
            billEntry.set(beforeField, quota);
            if (billEntry.get(nowField) == null) {
                billEntry.set(nowField, quota);
            }
        } else {
            billEntry.set(beforeField, null);
            billEntry.set(nowField, null);
        }
    }

    public Map<Object, Object> format4ImportAndApi(Object sourceData) {
        if (sourceData instanceof JSONObject) {
            return (Map)SerializationUtils.fromJsonString((String)sourceData.toString(), Map.class);
        }
        if (sourceData instanceof Map) {
            Map propMap = (Map)sourceData;
            if (propMap.get("id") != null) {
                propMap.put("importprop", "id");
            } else if (propMap.get("number") != null) {
                propMap.put("importprop", "number");
            } else if (propMap.get("name") != null) {
                propMap.put("importprop", "name");
            }
            return (Map)sourceData;
        }
        if (sourceData instanceof JSONArray) {
            ArrayList<Object> list = new ArrayList<Object>(((JSONArray)sourceData).size());
            HashMap<Object, Object> propMap = new HashMap<Object, Object>(((JSONArray)sourceData).size());
            JSONArray Ids = (JSONArray)sourceData;
            for (int i = 0; i < Ids.size(); ++i) {
                Object obj1 = Ids.toArray()[i];
                list.add(obj1);
            }
            propMap.put("sourceData", list);
            return propMap;
        }
        if (sourceData instanceof ArrayList) {
            HashMap<Object, Object> propMap = new HashMap<Object, Object>(((ArrayList)sourceData).size());
            propMap.put("sourceData", sourceData);
            return propMap;
        }
        return null;
    }
}

