/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ccm.formplugin.archive;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.filter.ControlFilters;
import kd.bos.filter.CommonBaseDataFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.list.BillList;
import kd.bos.list.IListColumn;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.scmc.ccm.business.setting.CheckTypeFieldPriviTempImpl;
import kd.scmc.ccm.business.setting.CheckTypeFieldTempImpl;

public class ArchiveProcessingCommonList
extends AbstractListPlugin {
    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        List commonFilterColumns = args.getCommonFilterColumns();
        String billEntityKey = ((FilterColumn)commonFilterColumns.get(0)).getEntryEntity();
        Object orgDefaultValue = null;
        for (FilterColumn filterColumn : commonFilterColumns) {
            ControlFilters controlFilters;
            String fieldName = filterColumn.getFieldName();
            if ("org.name".equals(fieldName)) {
                orgDefaultValue = this.getNowCreditOrgId(filterColumn);
            }
            if (!"scheme.name".equals(fieldName)) continue;
            CommonBaseDataFilterColumn commonFilterColumn = (CommonBaseDataFilterColumn)filterColumn;
            ArrayList<ComboItem> newComboItems = new ArrayList<ComboItem>();
            List<DynamicObject> schemeIds = this.getInitSchemeDOList(orgDefaultValue, billEntityKey);
            if (schemeIds == null || schemeIds.size() <= 0) {
                commonFilterColumn.setComboItems(newComboItems);
            } else {
                for (DynamicObject schemeDO : schemeIds) {
                    ComboItem schemeItem = new ComboItem();
                    schemeItem.setCaption(new LocaleString(schemeDO.getString("name")));
                    schemeItem.setValue(String.valueOf(schemeDO.get("id")));
                    newComboItems.add(schemeItem);
                }
            }
            commonFilterColumn.setComboItems(newComboItems);
            if (newComboItems.size() > 0) {
                commonFilterColumn.getDefaultValues().add(((ComboItem)newComboItems.get(0)).getValue());
            }
            if ((controlFilters = commonFilterColumn.getContext().getControlFilters()) == null && ObjectUtils.isEmpty(newComboItems)) {
                this.setRoleFieldVisable(true);
                continue;
            }
            if (controlFilters != null && ObjectUtils.isEmpty((Object)controlFilters.getFilter("scheme.id"))) {
                this.setRoleFieldVisable(true);
                continue;
            }
            this.setRoleFieldVisable(false);
        }
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent evt) {
        super.filterContainerBeforeF7Select(evt);
        String fieldName = evt.getFieldName();
        IListView listview = (IListView)this.getView();
        String billEntityKey = listview.getListModel().getDataEntityType().getName();
        if (StringUtils.equals((CharSequence)fieldName, (CharSequence)"scheme.id")) {
            QFilter schemeFilter = new QFilter("status", "=", (Object)"C");
            schemeFilter.and(new QFilter("enable", "=", (Object)Boolean.TRUE));
            Object orgDefaultValue = null;
            if (this.getControlFilters() != null && this.getControlFilters().getFilter("org.id") != null && this.getControlFilters().getFilter("org.id").size() > 0) {
                orgDefaultValue = this.getControlFilters().getFilter("org.id").get(0);
            }
            if (!StringUtils.isBlank(orgDefaultValue)) {
                schemeFilter.and(new QFilter("mainorg", "=", (Object)Long.valueOf(String.valueOf(orgDefaultValue))));
            } else {
                ListShowParameter showParameter = (ListShowParameter)this.getView().getFormShowParameter();
                String billFormId = showParameter.getBillFormId();
                long userId = RequestContext.get().getCurrUserId();
                HasPermOrgResult userHasPermOrgs = PermissionServiceHelper.getAllPermOrgs((Long)userId, (String)"ccm", (String)billFormId, (String)"47150e89000000ac");
                if (!userHasPermOrgs.hasAllOrgPerm()) {
                    List hasPermOrgs = userHasPermOrgs.getHasPermOrgs();
                    schemeFilter.and(new QFilter("mainorg", "in", (Object)hasPermOrgs));
                }
            }
            if ("ccm_achive_privilege".equals(billEntityKey)) {
                schemeFilter.and(new QFilter("checktype.number", "in", (Object)new String[]{"KZFW010", "KZFW011"}));
            } else if ("ccm_balanceadjustment".equals(billEntityKey)) {
                schemeFilter.and(new QFilter("checktype.number", "in", (Object)new String[]{"KZFW001", "KZFW010"}));
            }
            evt.addCustomQFilter(schemeFilter);
        }
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        super.filterContainerSearchClick(args);
        Map currentCommonFilter = args.getCurrentCommonFilter();
        if (currentCommonFilter != null) {
            for (Map.Entry entry : currentCommonFilter.entrySet()) {
                List customfilter;
                Map filterValues;
                String clickField;
                Object clickFieldObj;
                List value;
                String key = (String)entry.getKey();
                if (!"FieldName".equals(key) || (value = (List)entry.getValue()) == null || !((clickFieldObj = value.get(0)) instanceof String) || (clickField = (String)clickFieldObj) == null || !"org.id".equals(clickField) || (filterValues = args.getFilterValues()) == null || (customfilter = (List)filterValues.get("customfilter")) == null) continue;
                customfilter.removeIf(t -> ((List)t.get("FieldName")).get(0).equals("scheme.id"));
            }
        }
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        List qFilters = e.getQFilters();
        Long schemeId = 0L;
        for (QFilter filter : qFilters) {
            Object filterValue;
            DynamicObject filterScheme;
            Object value;
            if ("scheme.id".equals(filter.getProperty()) && (value = filter.getValue()) instanceof Long) {
                schemeId = (Long)value;
            }
            if (!"scheme.name".equals(filter.getProperty()) || !"=".equals(filter.getCP()) || ObjectUtils.isEmpty((Object)(filterScheme = QueryServiceHelper.queryOne((String)"ccm_scheme", (String)"id", (QFilter[])new QFilter[]{new QFilter("name", "=", filterValue = filter.getValue())})))) continue;
            schemeId = filterScheme.getLong("id");
        }
        if (schemeId == 0L) {
            return;
        }
        DynamicObject scheme = BusinessDataServiceHelper.loadSingleFromCache((Object)schemeId, (String)"ccm_scheme");
        if (scheme == null) {
            return;
        }
        BillList billList = (BillList)this.getControl("billlistap");
        String billEntityKey = billList.getEntryEntity();
        String checkType = scheme.getDynamicObject("checktype").getString("number");
        List noRelatedFieldMarkList = new ArrayList();
        String relatedFieldMark = "";
        if ("ccm_achive_privilege".equals(billEntityKey)) {
            CheckTypeFieldPriviTempImpl priviTempImpl = new CheckTypeFieldPriviTempImpl();
            noRelatedFieldMarkList = priviTempImpl.getNoRelatedFieldMarkList(checkType);
            relatedFieldMark = priviTempImpl.getRelatedFieldMark(checkType);
        } else {
            CheckTypeFieldTempImpl tempImpl = new CheckTypeFieldTempImpl();
            noRelatedFieldMarkList = tempImpl.getNoRelatedFieldMarkList(checkType);
            relatedFieldMark = tempImpl.getRelatedFieldMark(checkType);
        }
        List showListColumns = billList.getShowListColumns();
        for (IListColumn column : showListColumns) {
            String columnKey = column.getListFieldKey();
            if (StringUtils.isBlank((CharSequence)columnKey)) continue;
            for (String norelatedMark : noRelatedFieldMarkList) {
                if (columnKey.contains("_" + norelatedMark) || columnKey.contains(norelatedMark)) {
                    column.setVisible(0);
                }
                if (!columnKey.contains(relatedFieldMark)) continue;
                column.setVisible(1);
            }
        }
    }

    private List<DynamicObject> getInitSchemeDOList(Object orgDefaultValue, String billEntityKey) {
        LinkedList<DynamicObject> schemeDOList = new LinkedList<DynamicObject>();
        QFilter schemeFilter = new QFilter("status", "=", (Object)"C");
        schemeFilter.and(new QFilter("enable", "=", (Object)Boolean.TRUE));
        if (!StringUtils.isBlank((Object)orgDefaultValue)) {
            schemeFilter.and(new QFilter("mainorg", "=", (Object)Long.valueOf(String.valueOf(orgDefaultValue))));
        } else {
            ListShowParameter showParameter = (ListShowParameter)this.getView().getFormShowParameter();
            String billFormId = showParameter.getBillFormId();
            long userId = RequestContext.get().getCurrUserId();
            HasPermOrgResult userHasPermOrgs = PermissionServiceHelper.getAllPermOrgs((Long)userId, (String)"ccm", (String)billFormId, (String)"47150e89000000ac");
            if (!userHasPermOrgs.hasAllOrgPerm()) {
                List hasPermOrgs = userHasPermOrgs.getHasPermOrgs();
                schemeFilter.and(new QFilter("mainorg", "in", (Object)hasPermOrgs));
            }
        }
        if ("ccm_achive_privilege".equals(billEntityKey)) {
            schemeFilter.and(new QFilter("checktype.number", "in", (Object)new String[]{"KZFW010", "KZFW011"}));
        } else if ("ccm_balanceadjustment".equals(billEntityKey)) {
            schemeFilter.and(new QFilter("checktype.number", "in", (Object)new String[]{"KZFW001", "KZFW010"}));
        }
        DynamicObject[] schemes = BusinessDataServiceHelper.load((String)"ccm_scheme", (String)"checktype", (QFilter[])new QFilter[]{schemeFilter});
        Arrays.stream(schemes).forEach(scheme -> schemeDOList.add((DynamicObject)scheme));
        return schemeDOList;
    }

    private Object getNowCreditOrgId(FilterColumn filterColumn) {
        Object orgId = null;
        ControlFilters controlFilters = filterColumn.getContext().getControlFilters();
        if (controlFilters == null) {
            List defaultValues = filterColumn.getDefaultValues();
            if (!defaultValues.isEmpty()) {
                orgId = defaultValues.get(0);
            }
        } else if (!ObjectUtils.isEmpty((Object)controlFilters.getFilter("org.id")) && !ObjectUtils.isEmpty(controlFilters.getFilter("org.id").get(0))) {
            orgId = controlFilters.getFilter("org.id").get(0);
        }
        return orgId;
    }

    private void setRoleFieldVisable(boolean isHide) {
        BillList billList = (BillList)this.getControl("billlistap");
        List showListColumns = billList.getShowListColumns();
        for (IListColumn column : showListColumns) {
            String columnKey = column.getListFieldKey();
            if (StringUtils.isBlank((CharSequence)columnKey) || !columnKey.startsWith("role")) continue;
            if (isHide) {
                column.setVisible(0);
                continue;
            }
            column.setVisible(1);
        }
    }
}

