/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ccm.formplugin.archive;

import java.util.Arrays;
import java.util.EventObject;
import java.util.LinkedList;
import java.util.List;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.field.FieldEdit;
import kd.scmc.ccm.business.setting.DimensionEntryFieldMapper;
import kd.scmc.ccm.common.helper.BillEntityHelper;

public class ArchiveProcessingaboutDimensionsEdit
extends AbstractBillPlugIn {
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.controlRoleField();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        if ("scheme".equals(key)) {
            this.controlRoleField();
        }
    }

    private void controlRoleField() {
        DynamicObject scheme = (DynamicObject)this.getModel().getValue("scheme");
        LinkedList<String> unvisiableKeys = new LinkedList<String>();
        String[] allRoleFields = BillEntityHelper.getAllRoleFields();
        unvisiableKeys.addAll(Arrays.asList(allRoleFields));
        LinkedList<String> visiableKeys = new LinkedList<String>();
        if (scheme != null) {
            Object dimensionId = scheme.get("dimension.id");
            DimensionEntryFieldMapper fieldMapper = new DimensionEntryFieldMapper(dimensionId);
            List fieldTypeKeys = fieldMapper.getFieldTypeKeys();
            for (String filedKey : fieldTypeKeys) {
                String baseDataKey = fieldMapper.getBaseDataKey(filedKey);
                this.getModel().setValue(filedKey, (Object)baseDataKey);
            }
            List roleFieldKeys = fieldMapper.getRoleFieldKeys();
            for (String fieldKey : roleFieldKeys) {
                FieldEdit control = (FieldEdit)this.getControl(fieldKey);
                LocaleString roleDisplayName = fieldMapper.getRoleDisplayName(fieldKey);
                control.setCaption(roleDisplayName);
                visiableKeys.add(fieldKey);
                unvisiableKeys.remove(fieldKey);
            }
        }
        if (!visiableKeys.isEmpty()) {
            this.getView().setVisible(Boolean.TRUE, visiableKeys.toArray(new String[0]));
        }
        if (!unvisiableKeys.isEmpty()) {
            this.getView().setVisible(Boolean.FALSE, unvisiableKeys.toArray(new String[0]));
        }
    }
}

