/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ccm.formplugin.base;

import java.util.EventObject;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.designer.botp.BillTreeBuildParameter;
import kd.bos.designer.botp.EntityParseHelper;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.OperationTypeCache;
import kd.bos.entity.property.AmountProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;

public class StrategySettingEdit
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        BasedataEdit assingentityEdit;
        super.registerListener(e);
        BasedataEdit entityEdit = (BasedataEdit)this.getView().getControl("entity");
        if (entityEdit != null) {
            entityEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((assingentityEdit = (BasedataEdit)this.getView().getControl("assingentity")) != null) {
            assingentityEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        this.addClickListeners(new String[]{"checkfilter", "checkformula", "recalfilter", "recalformula", "datafilter"});
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setOpItems();
        this.showHiddenControlByCheckType();
        this.setFiledMustInputByCheckType();
        DynamicObject assingEntity = (DynamicObject)this.getModel().getValue("assingentity");
        if (!ObjectUtils.isEmpty((Object)assingEntity)) {
            this.setCalculateDateValue(assingEntity.getString("id"));
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if ("checkfilter".equals(key) || "recalfilter".equals(key)) {
            DynamicObject entity = (DynamicObject)this.getModel().getValue("entity");
            if (entity == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e1a\u52a1\u5355\u636e\u3002", (String)"StrategySettingEdit_0", (String)"scmc-ccm-formplugin", (Object[])new Object[0]));
                return;
            }
            String entityKey = (String)entity.getPkValue();
            MainEntityType convertType = EntityMetadataCache.getDataEntityType((String)entityKey);
            BillTreeBuildParameter prop = new BillTreeBuildParameter(convertType);
            prop.setIncludePKField(true);
            TreeNode para = EntityParseHelper.buildBillTreeNodes((BillTreeBuildParameter)prop);
            String billNodeJson = SerializationUtils.toJsonString((Object)para);
            int entryIndex = this.getEntryIndex(key);
            String filterCondition = (String)this.getModel().getValue("new" + key + "_tag", entryIndex);
            FormShowParameter fsp = new FormShowParameter();
            fsp.setFormId("ccm_condition");
            fsp.getOpenStyle().setShowType(ShowType.Modal);
            fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, key));
            fsp.setCustomParam("entitynumber", (Object)entityKey);
            fsp.setCustomParam("treenodes", (Object)billNodeJson);
            fsp.setCustomParam("formula", (Object)filterCondition);
            fsp.setCustomParam("filtercondition", (Object)filterCondition);
            fsp.setCustomParam("onlyheadfield", (Object)"false");
            this.getView().showForm(fsp);
        } else if ("checkformula".equals(key) || "recalformula".equals(key)) {
            DynamicObject entity = (DynamicObject)this.getModel().getValue("entity");
            if (entity == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e1a\u52a1\u5355\u636e\u3002", (String)"StrategySettingEdit_0", (String)"scmc-ccm-formplugin", (Object[])new Object[0]));
                return;
            }
            String entityKey = (String)entity.getPkValue();
            MainEntityType convertType = EntityMetadataCache.getDataEntityType((String)entityKey);
            BillTreeBuildParameter prop = new BillTreeBuildParameter(convertType);
            prop.setIncludePKField(true);
            TreeNode para = EntityParseHelper.buildBillTreeNodes((BillTreeBuildParameter)prop);
            String billNodeJson = SerializationUtils.toJsonString((Object)para);
            int entryIndex = this.getEntryIndex(key);
            String formula = (String)this.getModel().getValue("new" + key + "_tag", entryIndex);
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("ccm_formula");
            showParameter.getCustomParams().put("formula", formula);
            showParameter.getCustomParams().put("entitynumber", entityKey);
            showParameter.getCustomParams().put("treenodes", billNodeJson);
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, key));
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            this.getView().showForm(showParameter);
        } else if ("datafilter".equals(key)) {
            DynamicObject assingEntity = (DynamicObject)this.getModel().getValue("assingentity");
            if (assingEntity == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u903e\u671f\u5355\u636e\u3002", (String)"StrategySettingEdit_1", (String)"scmc-ccm-formplugin", (Object[])new Object[0]));
                return;
            }
            String entityKey = (String)assingEntity.getPkValue();
            MainEntityType convertType = EntityMetadataCache.getDataEntityType((String)entityKey);
            BillTreeBuildParameter prop = new BillTreeBuildParameter(convertType);
            prop.setIncludePKField(true);
            TreeNode para = EntityParseHelper.buildBillTreeNodes((BillTreeBuildParameter)prop);
            String billNodeJson = SerializationUtils.toJsonString((Object)para);
            String filterCondition = (String)this.getModel().getValue("new" + key + "_tag");
            FormShowParameter fsp = new FormShowParameter();
            fsp.setFormId("ccm_condition");
            fsp.getOpenStyle().setShowType(ShowType.Modal);
            fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, key));
            fsp.setCustomParam("entitynumber", (Object)entityKey);
            fsp.setCustomParam("treenodes", (Object)billNodeJson);
            fsp.setCustomParam("formula", (Object)filterCondition);
            fsp.setCustomParam("filtercondition", (Object)filterCondition);
            fsp.setCustomParam("onlyheadfield", (Object)"false");
            this.getView().showForm(fsp);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String fieldKey = e.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        switch (fieldKey) {
            case "entity": {
                this.filterEntity(showParameter);
                break;
            }
            case "assingentity": {
                DynamicObject entity = (DynamicObject)this.getModel().getValue("entity");
                if (entity == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e1a\u52a1\u5355\u636e\u3002", (String)"StrategySettingEdit_0", (String)"scmc-ccm-formplugin", (Object[])new Object[0]));
                    e.setCancel(true);
                    break;
                }
                this.filterEntity(showParameter);
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String value;
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        if ("entity".equals(key)) {
            this.entityOrChecktypeChangedinitPageInfo();
            this.setOpItems();
        } else if ("checktype".equals(key)) {
            this.showHiddenControlByCheckType();
            this.entityOrChecktypeChangedinitPageInfo();
            this.setFiledMustInputByCheckType();
        } else if ("assingentity".equals(key)) {
            this.getModel().setValue("calculatedate", null);
            this.getModel().setValue("calculateamt", null);
            this.getModel().setValue("datafilter", null);
            DynamicObject assingEntity = (DynamicObject)this.getModel().getValue("assingentity");
            if (ObjectUtils.isEmpty((Object)assingEntity)) {
                ComboEdit dateCombo = (ComboEdit)this.getControl("calculatedate");
                dateCombo.setComboItems(null);
                ComboEdit amtCombo = (ComboEdit)this.getControl("calculateamt");
                amtCombo.setComboItems(null);
                return;
            }
            this.setCalculateDateValue(assingEntity.getString("id"));
        } else if (("checkfilter".equals(key) || "checkformula".equals(key) || "recalfilter".equals(key) || "recalformula".equals(key) || "datafilter".equals(key)) && StringUtils.isBlank((String)(value = (String)this.getView().getModel().getValue(key)))) {
            this.getView().getModel().setValue("new" + key + "_tag", null);
        }
    }

    private void setOpItems() {
        List<ComboItem> operationItems = this.getOpItems();
        ComboEdit reduceopsEdit = (ComboEdit)this.getControl("reduceops");
        reduceopsEdit.setComboItems(operationItems);
        ComboEdit increaseOpsEdit = (ComboEdit)this.getControl("increaseops");
        increaseOpsEdit.setComboItems(operationItems);
        ComboEdit checkOpsEdit = (ComboEdit)this.getControl("checkops");
        checkOpsEdit.setComboItems(operationItems);
    }

    private List<ComboItem> getOpItems() {
        LinkedList<ComboItem> operationItems = new LinkedList<ComboItem>();
        DynamicObject entity = (DynamicObject)this.getModel().getValue("entity");
        if (entity == null) {
            return operationItems;
        }
        String entityKey = (String)entity.getPkValue();
        List entityOperates = EntityMetadataCache.getDataEntityOperate((String)entityKey);
        for (Map op : entityOperates) {
            String opType = (String)op.get("type");
            if (!OperationTypeCache.isEntityOperation((String)opType)) continue;
            ComboItem comboItem = new ComboItem(LocaleString.fromMap((Map)((Map)op.get("name"))), (String)op.get("key"));
            operationItems.add(comboItem);
        }
        return operationItems;
    }

    private int getEntryIndex(String fieldKey) {
        if ("checkfilter".equals(fieldKey) || "checkformula".equals(fieldKey)) {
            return this.getModel().getEntryCurrentRowIndex("checkentry");
        }
        return this.getModel().getEntryCurrentRowIndex("recalentry");
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        Object returnData = closedCallBackEvent.getReturnData();
        if (returnData == null) {
            return;
        }
        CRCondition formulaObj = (CRCondition)SerializationUtils.fromJsonString((String)((String)returnData), CRCondition.class);
        String description = formulaObj.getDescription().getLocaleValue();
        if (description == null || description.trim().isEmpty()) {
            description = formulaObj.getLocaleExprTran().getLocaleValue();
        }
        if (description.length() > 500) {
            description = description.substring(0, 500);
        }
        if ("checkfilter".equals(actionId) || "recalfilter".equals(actionId) || "checkformula".equals(actionId) || "recalformula".equals(actionId)) {
            int entryIndex = this.getEntryIndex(actionId);
            this.getModel().setValue(actionId, (Object)description, entryIndex);
            if (ObjectUtils.isEmpty((Object)description)) {
                this.getModel().setValue("new" + actionId + "_tag", null, entryIndex);
            } else {
                this.getModel().setValue("new" + actionId + "_tag", returnData, entryIndex);
            }
        } else if ("datafilter".equals(actionId)) {
            this.getModel().setValue(actionId, (Object)description);
            if (ObjectUtils.isEmpty((Object)description)) {
                this.getModel().setValue("new" + actionId + "_tag", null);
            } else {
                this.getModel().setValue("new" + actionId + "_tag", returnData);
            }
        }
    }

    private void showHiddenControlByCheckType() {
        DynamicObject checkType = (DynamicObject)this.getModel().getValue("checktype");
        if (ObjectUtils.isEmpty((Object)checkType) || "KZFW001".equals(checkType.getString("number")) || "KZFW003".equals(checkType.getString("number"))) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"plugin", "checkpluginexplain", "forwardaction", "reduceops", "increaseops", "checkformula", "flexpanelap1"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"fs_baseinfo1"});
            this.getView().setEnable(Boolean.TRUE, new String[]{"forwardaction"});
        } else if ("KZFW002".equals(checkType.getString("number"))) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"forwardaction", "reduceops", "increaseops", "checkformula", "flexpanelap1", "calculateamt"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"plugin", "checkpluginexplain", "fs_baseinfo1", "calculatedate"});
        } else if ("KZFW006".equals(checkType.getString("number"))) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"plugin", "checkpluginexplain", "forwardaction", "reduceops", "increaseops", "checkformula", "flexpanelap1"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"fs_baseinfo1", "calculatedate", "calculateamt"});
        } else if ("KZFW010".equals(checkType.getString("number")) || "KZFW011".equals(checkType.getString("number"))) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"plugin", "checkpluginexplain", "forwardaction", "reduceops", "increaseops", "checkformula", "flexpanelap1"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"fs_baseinfo1", "flexpanelap1"});
            if ("KZFW011".equals(checkType.getString("number"))) {
                this.getView().setEnable(Boolean.FALSE, new String[]{"forwardaction"});
            } else {
                this.getView().setEnable(Boolean.TRUE, new String[]{"forwardaction"});
            }
        }
    }

    private void setFiledMustInputByCheckType() {
        BasedataEdit assingEntity = (BasedataEdit)this.getControl("assingentity");
        ComboEdit calculateDate = (ComboEdit)this.getControl("calculatedate");
        ComboEdit calculateAmt = (ComboEdit)this.getControl("calculateamt");
        DynamicObject checkType = (DynamicObject)this.getModel().getValue("checktype");
        if (ObjectUtils.isEmpty((Object)checkType)) {
            return;
        }
        String checkTypeNumber = checkType.getString("number");
        if ("KZFW002".equals(checkTypeNumber)) {
            assingEntity.setMustInput(true);
            calculateDate.setMustInput(true);
        } else if ("KZFW006".equals(checkTypeNumber)) {
            assingEntity.setMustInput(true);
            calculateDate.setMustInput(true);
            calculateAmt.setMustInput(true);
        } else {
            assingEntity.setMustInput(false);
            calculateDate.setMustInput(false);
            calculateAmt.setMustInput(false);
        }
    }

    private void setCalculateDateValue(String entityKey) {
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)entityKey);
        DataEntityPropertyCollection properties = dataEntityType.getProperties();
        LinkedList<ComboItem> dateItems = new LinkedList<ComboItem>();
        LinkedList<ComboItem> amtItems = new LinkedList<ComboItem>();
        for (IDataEntityProperty prop : properties) {
            LocaleString dis;
            LocaleString displayName = prop.getDisplayName();
            String propAlias = prop.getAlias();
            if (prop instanceof DateTimeProp) {
                if (StringUtils.isEmpty((String)propAlias)) continue;
                dis = new LocaleString(displayName.getLocaleValue() + "(" + prop.getName() + ")");
                dateItems.add(new ComboItem(dis, prop.getName()));
                continue;
            }
            if (prop instanceof AmountProp) {
                if (StringUtils.isEmpty((String)propAlias)) continue;
                dis = new LocaleString(displayName.getLocaleValue() + "(" + prop.getName() + ")");
                amtItems.add(new ComboItem(dis, prop.getName()));
                continue;
            }
            if (!(prop instanceof EntryProp)) continue;
            DataEntityPropertyCollection entryProperties = ((EntryProp)prop)._collectionItemPropertyType.getProperties();
            for (IDataEntityProperty entryProp : entryProperties) {
                LocaleString dis2;
                String string;
                String entryPropAlias = entryProp.getAlias();
                if (entryProp instanceof DateTimeProp) {
                    if (StringUtils.isEmpty((String)entryPropAlias)) continue;
                    string = prop.getName() + "." + entryProp.getName();
                    dis2 = new LocaleString(prop.getDisplayName().getLocaleValue() + "." + entryProp.getDisplayName().getLocaleValue() + "(" + string + ")");
                    dateItems.add(new ComboItem(dis2, string));
                    continue;
                }
                if (!(entryProp instanceof AmountProp) || StringUtils.isEmpty((String)entryPropAlias)) continue;
                string = prop.getName() + "." + entryProp.getName();
                dis2 = new LocaleString(prop.getDisplayName().getLocaleValue() + "." + entryProp.getDisplayName().getLocaleValue() + "(" + string + ")");
                amtItems.add(new ComboItem(dis2, string));
            }
        }
        ComboEdit dateCombo = (ComboEdit)this.getControl("calculatedate");
        dateCombo.setComboItems(dateItems);
        ComboEdit amtCombo = (ComboEdit)this.getControl("calculateamt");
        amtCombo.setComboItems(amtItems);
    }

    private void entityOrChecktypeChangedinitPageInfo() {
        this.getModel().setValue("reduceops", null);
        this.getModel().setValue("increaseops", null);
        this.getModel().setValue("checkops", null);
        this.getModel().setValue("plugin", null);
        this.getModel().setValue("checkpluginexplain", null);
        this.getModel().setValue("recalculateplugin", null);
        this.getModel().setValue("recalpluginexplain", null);
        this.getModel().setValue("datafilter", null);
        this.getModel().setValue("newdatafilter", null);
        this.getModel().setValue("assingentity", null);
        this.getModel().setValue("calculatedate", null);
        this.getModel().setValue("calculateamt", null);
        this.getModel().setValue("forwardaction", (Object)"reduce");
        this.getModel().deleteEntryData("checkentry");
        this.getModel().deleteEntryData("recalentry");
        this.getModel().createNewEntryRow("checkentry");
    }

    private void filterEntity(ListShowParameter lsp) {
        DynamicObjectCollection configs = QueryServiceHelper.query((String)"ccm_entityconfig", (String)"number", null);
        Set entityKeys = configs.stream().map(config -> config.getString("number")).collect(Collectors.toSet());
        lsp.getListFilterParameter().setFilter(new QFilter("id", "in", entityKeys));
    }
}

