/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ccm.formplugin.base;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.BeforeImportDataEventArgs;
import kd.bos.entity.datamodel.events.ImportDataEventArgs;
import kd.bos.entity.datamodel.events.InitImportDataEventArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scmc.ccm.common.enums.EnableStatusEnum;
import kd.scmc.ccm.common.enums.StatusEnum;

public class StrategySettingImportPlugin
extends AbstractBillPlugIn {
    private Map<String, Object> tempCache = new HashMap<String, Object>();

    public void initImportData(InitImportDataEventArgs e) {
        DynamicObjectCollection configs = QueryServiceHelper.query((String)"ccm_entityconfig", (String)"id,number", null);
        Set entityKeys = configs.stream().map(config -> config.getString("id")).collect(Collectors.toSet());
        this.tempCache.put("ccm_entityconfig", entityKeys);
        QFilter enable = new QFilter("enable", "=", (Object)Boolean.TRUE);
        Map ccm_checktypeMaps = BusinessDataServiceHelper.loadFromCache((String)"ccm_checktype", (String)"name,number,id", (QFilter[])enable.toArray());
        this.tempCache.put("ccm_checktypes", ccm_checktypeMaps);
    }

    public void beforeImportData(BeforeImportDataEventArgs e) {
        if (e.getSourceData() != null && e.getSourceData().get("entity") == null) {
            e.setCancel(true);
            e.setCancelMessage(ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u4e1a\u52a1\u5355\u636e\u3002", (String)"StrategySettingImportPlugin_6", (String)"scmc-ccm-formplugin", (Object[])new Object[0]));
            e.setFireAfterImportData(false);
            return;
        }
        DynamicObject entity = this.getBaseDataFromCache(e.getSourceData(), "entity", "ccm_entityconfig", null, null);
        DynamicObject assingentity = this.getBaseDataFromCache(e.getSourceData(), "assingentity", "ccm_entityconfig", null, null);
        this.verifyEntityHasRegister(entity, assingentity, e);
        DynamicObject checkType = this.getBaseDataFromCache(e.getSourceData(), "checktype", "ccm_checktype", "id,number,name", null);
        this.verifyCheckTypeIsEnable(checkType, e);
        this.verifyOtherValuesByCheckType(checkType, e);
    }

    private void verifyEntityHasRegister(DynamicObject entity, DynamicObject assingentity, BeforeImportDataEventArgs e) {
        Set entityKeys = (Set)this.tempCache.get("ccm_entityconfig");
        if (!(e.getSourceData().get("entity") == null || entity != null && (entity == null || entityKeys != null && entityKeys.contains(entity.getPkValue())))) {
            Map<Object, Object> propEntiMap = this.format4ImportAndApi(e.getSourceData().get("entity"));
            e.setCancel(true);
            e.setCancelMessage(String.format(ResManager.loadKDString((String)"\u4e1a\u52a1\u5355\u636e\u201c%s\u201d\u672a\u8fdb\u884c\u5355\u636e\u6ce8\u518c\uff0c\u8bf7\u68c0\u67e5\u201c\u5355\u636e\u6ce8\u518c\u201d\u3002", (String)"StrategySettingImportPlugin_0", (String)"scmc-ccm-formplugin", (Object[])new Object[0]), propEntiMap.get(propEntiMap.get("importprop"))));
            e.setFireAfterImportData(false);
            return;
        }
        if (!(e.getSourceData().get("assingentity") == null || assingentity != null && (assingentity == null || entityKeys != null && entityKeys.contains(assingentity.getPkValue())))) {
            Map<Object, Object> propAssEntiMap = this.format4ImportAndApi(e.getSourceData().get("assingentity"));
            e.setCancel(true);
            e.setCancelMessage(String.format(ResManager.loadKDString((String)"\u903e\u671f\u5355\u636e\u201c%s\u201d\u672a\u8fdb\u884c\u5355\u636e\u6ce8\u518c\uff0c\u8bf7\u68c0\u67e5\u201c\u5355\u636e\u6ce8\u518c\u201d\u3002", (String)"StrategySettingImportPlugin_5", (String)"scmc-ccm-formplugin", (Object[])new Object[0]), propAssEntiMap.get(propAssEntiMap.get("importprop"))));
            e.setFireAfterImportData(false);
            return;
        }
    }

    private void verifyCheckTypeIsEnable(DynamicObject checkType, BeforeImportDataEventArgs e) {
        Map maps = (Map)this.tempCache.get("ccm_checktypes");
        if (!(checkType == null || maps != null && maps.containsKey(checkType.getPkValue()))) {
            Map<Object, Object> propMap = this.format4ImportAndApi(e.getSourceData().get("checktype"));
            e.setCancel(true);
            e.setCancelMessage(String.format(ResManager.loadKDString((String)"\u4fe1\u7528\u63a7\u5236\u5f62\u5f0f\u201c%s\u201d\u4e0d\u53ef\u7528\u3002", (String)"StrategySettingImportPlugin_1", (String)"scmc-ccm-formplugin", (Object[])new Object[0]), propMap.get(propMap.get("importprop"))));
            e.setFireAfterImportData(false);
            return;
        }
    }

    private void verifyOtherValuesByCheckType(DynamicObject checkType, BeforeImportDataEventArgs e) {
        if (checkType == null || e.getSourceData() == null) {
            return;
        }
        String checktypenumber = checkType.getString("number");
        Map<Object, Object> propMap = this.format4ImportAndApi(e.getSourceData().get("checktype"));
        if ("KZFW002".equals(checktypenumber) || "KZFW006".equals(checktypenumber)) {
            if (e.getSourceData().get("assingentity") == null || e.getSourceData().get("calculatedate") == null) {
                e.setCancel(true);
                e.setCancelMessage(String.format(ResManager.loadKDString((String)"\u4fe1\u7528\u63a7\u5236\u5f62\u5f0f\u201c%s\u201d\u9700\u8981\u914d\u7f6e\u201c\u903e\u671f\u5355\u636e\u201d\u53ca\u201c\u8ba1\u7b97\u65e5\u671f\u201d\u3002", (String)"StrategySettingImportPlugin_7", (String)"scmc-ccm-formplugin", (Object[])new Object[0]), propMap.get(propMap.get("importprop"))));
                e.setFireAfterImportData(false);
                return;
            }
            if ("KZFW006".equals(checktypenumber)) {
                if (e.getSourceData().get("calculateamt") == null) {
                    e.setCancel(true);
                    e.setCancelMessage(String.format(ResManager.loadKDString((String)"\u4fe1\u7528\u63a7\u5236\u5f62\u5f0f\u201c%s\u201d\u9700\u8981\u914d\u7f6e\u201c\u8ba1\u7b97\u91d1\u989d\u201d\u3002", (String)"StrategySettingImportPlugin_8", (String)"scmc-ccm-formplugin", (Object[])new Object[0]), propMap.get(propMap.get("importprop"))));
                    e.setFireAfterImportData(false);
                    return;
                }
                if (e.getSourceData().get("plugin") != null || e.getSourceData().get("checkpluginexplain") != null) {
                    e.setCancel(true);
                    e.setCancelMessage(String.format(ResManager.loadKDString((String)"\u4fe1\u7528\u63a7\u5236\u5f62\u5f0f\u201c%s\u201d\u4e0d\u652f\u6301\u914d\u7f6e\u68c0\u67e5\u7b56\u7565\u7684\u201c\u63d2\u4ef6\u201d\u53ca\u201c\u63d2\u4ef6\u8bf4\u660e\u201d\u3002", (String)"StrategySettingImportPlugin_9", (String)"scmc-ccm-formplugin", (Object[])new Object[0]), propMap.get(propMap.get("importprop"))));
                    e.setFireAfterImportData(false);
                    return;
                }
            }
            if (e.getSourceData().get("reduceops") != null || e.getSourceData().get("increaseops") != null) {
                e.setCancel(true);
                e.setCancelMessage(String.format(ResManager.loadKDString((String)"\u4fe1\u7528\u63a7\u5236\u5f62\u5f0f\u201c%s\u201d\u4e0d\u5141\u8bb8\u914d\u7f6e\u201c\u4fe1\u7528\u5360\u7528\u64cd\u4f5c\u201d\u53ca\u201c\u4fe1\u7528\u8fd4\u8fd8\u64cd\u4f5c\u201d\u3002", (String)"StrategySettingImportPlugin_2", (String)"scmc-ccm-formplugin", (Object[])new Object[0]), propMap.get(propMap.get("importprop"))));
                e.setFireAfterImportData(false);
                return;
            }
            Map<Object, Object> checkEntry = this.format4ImportAndApi(e.getSourceData().get("checkentry"));
            if (checkEntry != null) {
                List checkEntrys = (List)checkEntry.get("sourceData");
                for (Map entry : checkEntrys) {
                    if (entry.get("checkformula") == null && entry.get("newcheckformula") == null) continue;
                    e.setCancel(true);
                    e.setCancelMessage(String.format(ResManager.loadKDString((String)"\u4fe1\u7528\u63a7\u5236\u5f62\u5f0f\u201c%s\u201d\u4e0d\u5141\u8bb8\u914d\u7f6e\u201c\u68c0\u67e5\u53d6\u503c\u914d\u7f6e.\u53d6\u503c\u516c\u5f0f\u201d\u53ca\u201c\u68c0\u67e5\u53d6\u503c\u914d\u7f6e.\u53d6\u503c\u516c\u5f0f(\u540e\u53f0)\u201d\u3002", (String)"StrategySettingImportPlugin_10", (String)"scmc-ccm-formplugin", (Object[])new Object[0]), propMap.get(propMap.get("importprop"))));
                    e.setFireAfterImportData(false);
                    break;
                }
                if (e.isCancel()) {
                    return;
                }
            }
        } else {
            if (e.getSourceData().get("forwardaction") == null) {
                e.setCancel(true);
                e.setCancelMessage(String.format(ResManager.loadKDString((String)"\u4fe1\u7528\u63a7\u5236\u5f62\u5f0f\u201c%s\u201d\u9700\u8981\u5f55\u5165\u4fe1\u7528\u65b9\u5411\u3002", (String)"StrategySettingImportPlugin_11", (String)"scmc-ccm-formplugin", (Object[])new Object[0]), propMap.get(propMap.get("importprop"))));
                e.setFireAfterImportData(false);
                return;
            }
            if ("KZFW011".equals(checktypenumber) && !"reduce".equals(e.getSourceData().get("forwardaction"))) {
                e.setCancel(true);
                e.setCancelMessage(String.format(ResManager.loadKDString((String)"\u4fe1\u7528\u63a7\u5236\u5f62\u5f0f\u201c%s\u201d\u7684\u4fe1\u7528\u65b9\u5411\u5fc5\u987b\u662f\u5360\u7528\u3002", (String)"StrategySettingImportPlugin_15", (String)"scmc-ccm-formplugin", (Object[])new Object[0]), propMap.get(propMap.get("importprop"))));
                e.setFireAfterImportData(false);
                return;
            }
            if (e.getSourceData().get("assingentity") != null || e.getSourceData().get("datafilter") != null || e.getSourceData().get("newdatafilter") != null || e.getSourceData().get("calculatedate") != null) {
                e.setCancel(true);
                e.setCancelMessage(String.format(ResManager.loadKDString((String)"\u4fe1\u7528\u63a7\u5236\u5f62\u5f0f\u201c%s\u201d\u4e0d\u5141\u8bb8\u914d\u7f6e\u201c\u903e\u671f\u5355\u636e\u201d\u3001\u201c\u903e\u671f\u6761\u4ef6\u201d\u3001\u201c\u903e\u671f\u6761\u4ef6(\u540e\u53f0)\u201d\u53ca\u201c\u8ba1\u7b97\u65e5\u671f\u201d\u3002", (String)"StrategySettingImportPlugin_12", (String)"scmc-ccm-formplugin", (Object[])new Object[0]), propMap.get(propMap.get("importprop"))));
                e.setFireAfterImportData(false);
                return;
            }
        }
        if (!"KZFW006".equals(checktypenumber) && e.getSourceData().get("calculateamt") != null) {
            e.setCancel(true);
            e.setCancelMessage(String.format(ResManager.loadKDString((String)"\u4fe1\u7528\u63a7\u5236\u5f62\u5f0f\u201c%s\u201d\u4e0d\u5141\u8bb8\u914d\u7f6e\u201c\u8ba1\u7b97\u91d1\u989d\u201d\u3002", (String)"StrategySettingImportPlugin_13", (String)"scmc-ccm-formplugin", (Object[])new Object[0]), propMap.get(propMap.get("importprop"))));
            e.setFireAfterImportData(false);
            return;
        }
        if ("KZFW002".equals(checktypenumber) || "KZFW006".equals(checktypenumber) || "KZFW010".equals(checktypenumber) || "KZFW011".equals(checktypenumber)) {
            Map<Object, Object> recalEntry = this.format4ImportAndApi(e.getSourceData().get("recalentry"));
            List recalEntrys = new ArrayList(16);
            if (recalEntry != null) {
                recalEntrys = (List)recalEntry.get("sourceData");
            }
            if (e.getSourceData().get("recalculateplugin") != null || e.getSourceData().get("recalpluginexplain") != null || recalEntrys != null && recalEntrys.size() > 0) {
                e.setCancel(true);
                e.setCancelMessage(String.format(ResManager.loadKDString((String)"\u4fe1\u7528\u63a7\u5236\u5f62\u5f0f\u201c%s\u201d\u4e0d\u652f\u6301\u914d\u7f6e\u521d\u59cb\u5316\u7b56\u7565\u3002", (String)"StrategySettingImportPlugin_14", (String)"scmc-ccm-formplugin", (Object[])new Object[0]), propMap.get(propMap.get("importprop"))));
                e.setFireAfterImportData(false);
                return;
            }
        }
    }

    public void afterImportData(ImportDataEventArgs e) {
        IDataModel model = this.getModel();
        this.setImportDefaultValues(model);
    }

    private void setImportDefaultValues(IDataModel model) {
        model.setValue("enable", (Object)EnableStatusEnum.ENABLE.getValue());
        model.setValue("status", (Object)StatusEnum.SAVE.getValue());
        model.setValue("plugintype", (Object)"java");
        model.setValue("recalculateplugintype", (Object)"java");
        model.setValue("issys", (Object)Boolean.FALSE);
        DynamicObject checktype = (DynamicObject)model.getValue("checktype");
        if (checktype != null && ("KZFW002".equals(checktype.getString("number")) || "KZFW006".equals(checktype.getString("number")))) {
            model.setValue("forwardaction", (Object)"reduce");
        }
    }

    private DynamicObject getBaseDataFromCache(Map<String, Object> sourceData, String propName, String propEntityName, String select, QFilter[] qFilters) {
        if (sourceData == null) {
            return null;
        }
        Map<Object, Object> propMap = this.format4ImportAndApi(sourceData.get(propName));
        String importProp = null;
        if (propMap != null) {
            importProp = (String)propMap.get("importprop");
            DynamicObject value = (DynamicObject)this.tempCache.get(propName + "_" + propMap.get(importProp));
            if (value == null && !"id".equals(importProp)) {
                if (select == null) {
                    select = "id";
                }
                if (qFilters == null) {
                    qFilters = new QFilter[]{new QFilter(importProp, "=", (Object)((String)propMap.get(importProp)))};
                }
                value = BusinessDataServiceHelper.loadSingleFromCache((String)propEntityName, (String)select, (QFilter[])qFilters);
            }
            return value;
        }
        return null;
    }

    public Map<Object, Object> format4ImportAndApi(Object sourceData) {
        if (sourceData instanceof JSONObject) {
            return (Map)SerializationUtils.fromJsonString((String)sourceData.toString(), Map.class);
        }
        if (sourceData instanceof Map) {
            Map propMap = (Map)sourceData;
            if (propMap.get("id") != null) {
                propMap.put("importprop", "id");
            } else if (propMap.get("number") != null) {
                propMap.put("importprop", "number");
            } else if (propMap.get("name") != null) {
                propMap.put("importprop", "name");
            }
            return (Map)sourceData;
        }
        if (sourceData instanceof JSONArray) {
            ArrayList<Object> list = new ArrayList<Object>(((JSONArray)sourceData).size());
            HashMap<Object, Object> propMap = new HashMap<Object, Object>(((JSONArray)sourceData).size());
            JSONArray Ids = (JSONArray)sourceData;
            for (int i = 0; i < Ids.size(); ++i) {
                Object obj1 = Ids.toArray()[i];
                list.add(obj1);
            }
            propMap.put("sourceData", list);
            return propMap;
        }
        if (sourceData instanceof ArrayList) {
            HashMap<Object, Object> propMap = new HashMap<Object, Object>(((ArrayList)sourceData).size());
            propMap.put("sourceData", sourceData);
            return propMap;
        }
        return null;
    }
}

