/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ccm.formplugin.dev;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.EventObject;
import java.util.LinkedList;
import java.util.List;
import kd.bos.form.control.Control;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.scmc.ccm.common.apm.AuditDataConsumer;
import kd.scmc.ccm.common.apm.CostItem;
import kd.scmc.ccm.common.apm.SummaryCostItem;

public class ApmAuditEdit
extends AbstractFormPlugin {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"refresh_btn", "remove_btn", "resetall_btn"});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        if ("refresh_btn".equals(key)) {
            this.refresh();
            this.getView().updateView("entry");
        } else if ("remove_btn".equals(key)) {
            int rowIndex = this.getModel().getEntryCurrentRowIndex("entry");
            String name = (String)this.getModel().getValue("name", rowIndex);
            AuditDataConsumer.remove((String)name);
            this.getModel().deleteEntryRow("entry", rowIndex);
        } else if ("resetall_btn".equals(key)) {
            AuditDataConsumer.removeAll();
            this.getModel().deleteEntryData("entry");
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.refresh();
    }

    private void refresh() {
        this.getModel().deleteEntryData("entry");
        List auditDatas = AuditDataConsumer.getAuditDatas();
        for (SummaryCostItem costItemSummary : auditDatas) {
            int rowIndex = this.getModel().createNewEntryRow("entry");
            long totalTime_ms = costItemSummary.getTotalTime();
            BigDecimal totalTime_s = BigDecimal.valueOf(totalTime_ms).divide(BigDecimal.valueOf(1000L)).setScale(3, RoundingMode.HALF_UP);
            this.getModel().setValue("name", (Object)costItemSummary.getName(), rowIndex);
            this.getModel().setValue("times", (Object)costItemSummary.getTimes(), rowIndex);
            this.getModel().setValue("totaltime_ms", (Object)totalTime_ms, rowIndex);
            this.getModel().setValue("totaltime_s", (Object)totalTime_s, rowIndex);
            Object currentId = this.getModel().getEntryRowEntity("entry", rowIndex).get("id");
            LinkedList details = costItemSummary.getDetails();
            for (CostItem costItem : details) {
                this.createEntryRowByCostItem(costItem, currentId);
            }
        }
    }

    private void createEntryRowByCostItem(CostItem costItem, Object parentId) {
        int rowIndex = this.getModel().createNewEntryRow("entry");
        this.getModel().setValue("name", (Object)costItem.getName(), rowIndex);
        long totalTime_ms = costItem.getEndTime() - costItem.getBeginTime();
        BigDecimal totalTime_s = BigDecimal.valueOf(totalTime_ms).divide(BigDecimal.valueOf(1000L)).setScale(3, RoundingMode.HALF_UP);
        Date beginTime = new Date(costItem.getBeginTime());
        Date endTime = new Date(costItem.getEndTime());
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:SSS");
        this.getModel().setValue("begintime", (Object)simpleDateFormat.format(beginTime), rowIndex);
        this.getModel().setValue("endtime", (Object)simpleDateFormat.format(endTime), rowIndex);
        this.getModel().setValue("totaltime_ms", (Object)totalTime_ms, rowIndex);
        this.getModel().setValue("totaltime_s", (Object)totalTime_s, rowIndex);
        this.getModel().setValue("pid", parentId, rowIndex);
        Object currentId = this.getModel().getEntryRowEntity("entry", rowIndex).get("id");
        List subItems = costItem.getSubItems();
        for (CostItem subItem : subItems) {
            this.createEntryRowByCostItem(subItem, currentId);
        }
    }
}

