/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ccm.formplugin.dev;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.OperationTypeCache;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.OpBizRuleSetServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scmc.ccm.business.archives.ArchiveCollection;
import kd.scmc.ccm.business.archives.CreditArchive;
import kd.scmc.ccm.business.check.CheckResult;
import kd.scmc.ccm.business.journal.Journal;
import kd.scmc.ccm.business.journal.JournalGroup;
import kd.scmc.ccm.business.monitor.IDebugDetail;
import kd.scmc.ccm.business.monitor.IDebugInfo;
import kd.scmc.ccm.business.monitor.Monitor;
import kd.scmc.ccm.business.scheme.CreditScheme;
import kd.scmc.ccm.business.scheme.SchemeReader;
import kd.scmc.ccm.business.service.CreditService;

public class DebugEdit
extends AbstractFormPlugin {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"billno"});
        this.addClickListeners(new String[]{"monitor"});
        BasedataEdit entityF7 = (BasedataEdit)this.getControl("entitykey");
        entityF7.addBeforeF7SelectListener(listener -> {
            ListShowParameter lsp = (ListShowParameter)listener.getFormShowParameter();
            DynamicObjectCollection configs = QueryServiceHelper.query((String)"ccm_entityconfig", (String)"id", null);
            Set entityKeys = configs.stream().map(config -> config.getString("id")).collect(Collectors.toSet());
            lsp.getListFilterParameter().setFilter(new QFilter("id", "in", entityKeys));
        });
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        if ("bar_execute".equals(key)) {
            this.getModel().deleteEntryData("journalentry");
            this.getModel().deleteEntryData("archiveentry");
            this.getModel().deleteEntryData("resultentry");
            this.invokeCreditService(false);
        } else if ("bar_simulate".equals(key)) {
            this.simulate();
        }
    }

    private void simulate() {
        this.getModel().deleteEntryData("journalentry");
        this.getModel().deleteEntryData("archiveentry");
        this.getModel().deleteEntryData("resultentry");
        this.invokeCreditService(true);
        Collection creditDebugInfos = Monitor.getAll();
        IDebugDetail aimDebugInfo = null;
        for (IDebugDetail debugInfo : creditDebugInfos) {
            DynamicObject rawScheme = debugInfo.getScheme().getRawScheme();
            DynamicObject scheme = (DynamicObject)this.getModel().getValue("scheme");
            if (!Objects.equals(scheme.getPkValue(), rawScheme.getPkValue())) continue;
            aimDebugInfo = debugInfo;
            break;
        }
        StringBuilder baseInfo = new StringBuilder();
        String billOp = (String)this.getModel().getValue("billop");
        List opBizRuleSet = OpBizRuleSetServiceHelper.getOpBizRuleSet((String)this.getEntitykey(), (String)billOp);
        baseInfo.append("ServerBizOps=").append(opBizRuleSet).append('\n');
        if (aimDebugInfo == null) {
            this.orgAnalysis(baseInfo);
        }
        this.getModel().setValue("baseinfo", (Object)baseInfo.toString());
        StringBuilder otherInfo = new StringBuilder();
        if (aimDebugInfo != null) {
            this.showJournals(aimDebugInfo);
            this.showArchives(aimDebugInfo);
            this.showResults(aimDebugInfo);
            otherInfo.append((CharSequence)aimDebugInfo.getOtherInfo()).append('\n');
        }
        this.getModel().setValue("otherinfo", (Object)otherInfo.toString());
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u65e5\u5fd7\u91c7\u96c6\u5b8c\u6210", (String)"DebugEdit_1", (String)"scmc-ccm-formplugin", (Object[])new Object[0]));
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if ("billno".equals(key)) {
            String exportEntity = this.getEntitykey();
            if (exportEntity == null || exportEntity.trim().isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6307\u5b9a\u5355\u636e\u5b9e\u4f53\u3002", (String)"DebugEdit_0", (String)"scmc-ccm-formplugin", (Object[])new Object[0]));
            }
            ListShowParameter lsp = ShowFormHelper.createShowListForm((String)exportEntity, (boolean)false);
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "selectbill");
            lsp.setCloseCallBack(closeCallBack);
            this.getView().showForm((FormShowParameter)lsp);
        }
    }

    private void showResults(IDebugDetail aimDebugInfo) {
        List checkResults = aimDebugInfo.getCheckResults();
        for (CheckResult result : checkResults) {
            int rowIndex = this.getModel().createNewEntryRow("resultentry");
            this.getModel().setValue("resultbillno", (Object)result.getBillno(), rowIndex);
            this.getModel().setValue("success", (Object)result.isSuccess(), rowIndex);
            this.getModel().setValue("messagetype", (Object)result.getMessageType(), rowIndex);
            this.getModel().setValue("message", (Object)result.getMessage(), rowIndex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invokeCreditService(boolean simulate) {
        String entitykey = this.getEntitykey();
        Object billId = this.getModel().getValue("billid");
        DynamicObject bill = BusinessDataServiceHelper.loadSingle((Object)billId, (String)entitykey);
        DynamicObject[] bills = new DynamicObject[]{bill};
        String creditAction = (String)this.getModel().getValue("creditaction");
        String billOp = (String)this.getModel().getValue("billop");
        CreditService creditService = new CreditService();
        try {
            if (simulate) {
                Monitor.setDebugMode((Boolean)Boolean.TRUE);
            }
            if ("check".equals(creditAction)) {
                creditService.check(bills, billOp);
            } else if ("reduce".equals(creditAction)) {
                creditService.reduceBalance(bills, billOp);
            } else if ("increase".equals(creditAction)) {
                creditService.increaseBalance(bills, billOp);
            } else if ("update".equals(creditAction)) {
                creditService.update(bills, billOp);
            } else if ("rebuild".equals(creditAction)) {
                DynamicObject rawScheme = (DynamicObject)this.getModel().getValue("scheme");
                CreditScheme scheme = new SchemeReader().getScheme(((Long)rawScheme.getPkValue()).longValue());
                creditService.rebuildJournal(scheme, bills, billOp);
            }
        }
        finally {
            Monitor.setDebugMode((Boolean)Boolean.FALSE);
        }
    }

    private void showArchives(IDebugDetail debugInfo) {
        ArchiveCollection archiveCollection = debugInfo.getArchiveCollection();
        if (archiveCollection != null) {
            for (CreditArchive archive : archiveCollection.values()) {
                int rowIndex = this.getModel().createNewEntryRow("archiveentry");
                this.getModel().setValue("archiveid", (Object)archive.getId(), rowIndex);
                this.getModel().setValue("archivedimensionvalue", (Object)archive.getDimensionValue().getValue(), rowIndex);
                this.getModel().setValue("quota", (Object)archive.getQuota(), rowIndex);
                this.getModel().setValue("oldbalance", (Object)archive.getOldBalance(), rowIndex);
                this.getModel().setValue("balance", (Object)archive.getBalance(), rowIndex);
            }
        }
    }

    private void showJournals(IDebugDetail debugInfo) {
        List journalGroups = debugInfo.getJournalGroups();
        if (journalGroups != null) {
            for (JournalGroup journalGroup : journalGroups) {
                for (Journal journal : journalGroup.getJournals()) {
                    int rowIndex = this.getModel().createNewEntryRow("journalentry");
                    this.getModel().setValue("journalorg", (Object)journal.getOrg(), rowIndex);
                    this.getModel().setValue("journaldimensionvalue", (Object)journal.getDimensionValue().getValue(), rowIndex);
                    this.getModel().setValue("originalunit", (Object)journal.getOriginalUnit(), rowIndex);
                    this.getModel().setValue("originalamount", (Object)journal.getOriginalAmount(), rowIndex);
                    this.getModel().setValue("conversionrate", (Object)journal.getConversionRate(), rowIndex);
                    this.getModel().setValue("unit", (Object)journal.getUnit(), rowIndex);
                    this.getModel().setValue("amount", (Object)journal.getAmount(), rowIndex);
                    this.getModel().setValue("direction", (Object)journal.getDirection(), rowIndex);
                    this.getModel().setValue("journalbillid", (Object)journal.getBillId(), rowIndex);
                }
            }
        }
    }

    private void orgAnalysis(StringBuilder info) {
        IDebugInfo debugInfo = Monitor.getDebugInfo();
        Collection billOrgIds = debugInfo.getOrgIds();
        DynamicObject scheme = (DynamicObject)this.getModel().getValue("scheme");
        DynamicObjectCollection orgEntry = scheme.getDynamicObjectCollection("orgentry");
        ArrayList<Long> schemeOrgIds = new ArrayList<Long>();
        for (DynamicObject orgRow : orgEntry) {
            schemeOrgIds.add(orgRow.getLong("id"));
        }
        boolean isInSchemeOrgScopes = false;
        if ("GLOBAL".equals(scheme.getString("orgscope"))) {
            isInSchemeOrgScopes = true;
        } else {
            for (Long orgId : billOrgIds) {
                if (!schemeOrgIds.contains(orgId)) continue;
                isInSchemeOrgScopes = true;
                break;
            }
        }
        if (!isInSchemeOrgScopes) {
            info.append("Bill Orgs : ");
            for (Long orgId : billOrgIds) {
                info.append(orgId).append(',');
            }
            info.append('\n').append("Scheme Orgs : ");
            for (Long orgId : schemeOrgIds) {
                info.append(orgId).append(',');
            }
            info.append('\n');
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        if ("entitykey".equals(name)) {
            List<ComboItem> opItems = this.getOpItems();
            ComboEdit billOpEdit = (ComboEdit)this.getControl("billop");
            billOpEdit.setComboItems(opItems);
        } else if ("billno".equals(name)) {
            String entityKey = this.getEntitykey();
            if (entityKey == null) {
                return;
            }
            String billNo = (String)this.getModel().getValue("billno");
            if (StringUtils.isBlank((CharSequence)billNo)) {
                return;
            }
            QFilter billNoFilter = new QFilter("billno", "=", (Object)billNo);
            DynamicObjectCollection bills = QueryServiceHelper.query((String)entityKey, (String)"id", (QFilter[])billNoFilter.toArray());
            if (bills.isEmpty()) {
                String messageTemplate = ResManager.loadKDString((String)"\u7f16\u53f7\u4e3a%s\u7684\u5355\u636e\u4e0d\u5b58\u5728\u3002", (String)"DebugEdit_2", (String)"scmc-ccm-formplugin", (Object[])new Object[0]);
                this.getView().showTipNotification(String.format(messageTemplate, billNo));
                return;
            }
            if (bills.size() > 1) {
                String messageTemplate = ResManager.loadKDString((String)"\u7f16\u53f7\u4e3a\u201c%s\u201d\u7684\u5355\u636e\u4e0d\u552f\u4e00\uff0c\u8bf7\u6253\u5f00\u9009\u5355\u754c\u9762\u7cbe\u786e\u6307\u5b9a\u5355\u636e\u3002", (String)"DebugEdit_3", (String)"scmc-ccm-formplugin", (Object[])new Object[0]);
                this.getView().showTipNotification(String.format(messageTemplate, billNo));
                return;
            }
            this.getModel().setValue("billid", (Object)((DynamicObject)bills.get(0)).getLong("id"));
        }
    }

    private List<ComboItem> getOpItems() {
        LinkedList<ComboItem> operationItems = new LinkedList<ComboItem>();
        String entityKey = this.getEntitykey();
        if (entityKey == null) {
            return operationItems;
        }
        List entityOperates = EntityMetadataCache.getDataEntityOperate((String)entityKey);
        for (Map op : entityOperates) {
            String opType = (String)op.get("type");
            if (!OperationTypeCache.isEntityOperation((String)opType)) continue;
            ComboItem comboItem = new ComboItem(LocaleString.fromMap((Map)((Map)op.get("name"))), (String)op.get("key"));
            operationItems.add(comboItem);
        }
        return operationItems;
    }

    private String getEntitykey() {
        DynamicObject entity = (DynamicObject)this.getModel().getValue("entitykey");
        if (entity != null) {
            return (String)entity.getPkValue();
        }
        return null;
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Object returnData;
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if ("selectbill".equals(actionId) && (returnData = closedCallBackEvent.getReturnData()) instanceof ListSelectedRowCollection) {
            ListSelectedRowCollection listData = (ListSelectedRowCollection)returnData;
            Object[] primaryKeyValues = ((ListSelectedRowCollection)returnData).getPrimaryKeyValues();
            if (primaryKeyValues.length > 0) {
                this.getModel().setValue("billid", primaryKeyValues[0]);
                this.getModel().setValue("billno", (Object)listData.get(0).getBillNo());
            }
        }
    }
}

