/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ccm.formplugin.dev;

import com.alibaba.fastjson.JSONObject;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.serialization.DcBinder;
import kd.bos.dataentity.serialization.DcJsonSerializer;
import kd.bos.dataentity.serialization.DynamicObjectSerializationBinder;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.cache.BusinessAppCache;
import kd.bos.entity.cache.IBusinessAppCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.param.AppParam;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.FieldProp;
import kd.bos.entity.property.TextProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;

public class SysParamEdit
extends AbstractFormPlugin {
    private static final Log log = LogFactory.getLog(SysParamEdit.class);

    public void registerListener(EventObject evt) {
        super.registerListener(evt);
        this.addItemClickListeners(new String[]{"toolbarap"});
        this.addClickListeners(new String[]{"parmvalue"});
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        switch (evt.getItemKey()) {
            case "save": {
                this.save();
                break;
            }
            case "refresh": {
                this.load();
            }
        }
    }

    public void afterCreateNewData(EventObject evt) {
        this.load();
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "parmvalue": {
                String parmtype = (String)this.getModel().getValue("parmtype");
                if (!"jsonarray".equals(parmtype)) {
                    return;
                }
                FormShowParameter jsonParameter = new FormShowParameter();
                jsonParameter.getOpenStyle().setShowType(ShowType.Modal);
                jsonParameter.setFormId("msbd_customjson");
                jsonParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "customjson"));
                jsonParameter.setHasRight(true);
                String parmValue = (String)this.getModel().getValue("parmvalue");
                try {
                    jsonParameter.setCustomParam("jsonparameter", JSONObject.parseObject((String)parmValue, Map.class));
                }
                catch (Exception e) {
                    log.error(e.getMessage());
                }
                this.getView().showForm(jsonParameter);
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        Map result;
        super.closedCallBack(evt);
        String actionId = evt.getActionId();
        if ("customjson".equals(actionId) && (result = (Map)evt.getReturnData()) != null && result.size() > 0) {
            this.getModel().setValue("parmvalue", (Object)SerializationUtils.toJsonString((Object)result));
        }
    }

    private void load() {
        IDataModel model = this.getModel();
        String sql = "select fappparam,fcusparam from t_ccm_sysparam where fid = 0";
        Map map = (Map)DB.query((DBRoute)new DBRoute("scm"), (String)sql, null, (ResultSetHandler)new ResultSetHandler<Map<String, String>>(){

            public Map<String, String> handle(ResultSet resultSet) throws Exception {
                HashMap<String, String> map = new HashMap<String, String>(2);
                while (resultSet.next()) {
                    map.put("appparam", resultSet.getString("fappparam"));
                    map.put("cusparam", resultSet.getString("fcusparam"));
                }
                return map;
            }
        });
        if (map != null && !map.isEmpty()) {
            String cusparam;
            String appparam = (String)map.get("appparam");
            if (appparam != null && !appparam.isEmpty()) {
                Map appparamMap = (Map)SerializationUtils.fromJsonString((String)appparam, Map.class);
                DynamicObjectSerializationBinder binder = new DynamicObjectSerializationBinder(model.getDataEntity().getDynamicObjectType());
                binder.setOnlyDbProperty(false);
                DcJsonSerializer jser = new DcJsonSerializer((DcBinder)binder);
                jser.setSerializeComplexProperty(false);
                jser.deserializeFromMap(appparamMap, (Object)model.getDataEntity());
            }
            if ((cusparam = (String)map.get("cusparam")) != null && !cusparam.isEmpty()) {
                List customParameterList;
                List customParameterList1 = customParameterList = SerializationUtils.fromJsonStringToList((String)cusparam, Map.class);
                model.deleteEntryData("entryentity");
                customParameterList1.forEach(map1 -> {
                    int rowId = model.createNewEntryRow("entryentity");
                    model.setValue("parmname", map1.get("parmname"), rowId);
                    model.setValue("parmtype", map1.get("parmtype"), rowId);
                    model.setValue("parmvalue", map1.get("parmvalue"), rowId);
                    model.setValue("description", map1.get("description"), rowId);
                });
            }
            this.getView().updateView();
        } else {
            AppParam appParam = new AppParam("0N6JIY2ETSPF", "15", Long.valueOf(RequestContext.get().getOrgId()), Long.valueOf(0L));
            Map pmAppParameterMap = SystemParamServiceHelper.loadAppParameterFromCache((AppParam)appParam);
            if (pmAppParameterMap != null) {
                if (pmAppParameterMap.get("iswritelog") != null) {
                    model.setValue("iswritelog", pmAppParameterMap.get("iswritelog"));
                }
                if (pmAppParameterMap.get("locktime") != null) {
                    model.setValue("locktime", pmAppParameterMap.get("locktime"));
                }
            }
            this.save();
            this.getView().updateView();
        }
    }

    private void save() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        Map<String, Object> jsonStringMap = this.getJsonStringMap(dataEntity);
        String appparam = SerializationUtils.toJsonString(jsonStringMap);
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        List entryList = entryEntity.stream().map(row -> {
            HashMap<String, String> map = new HashMap<String, String>(4);
            map.put("parmname", row.getString("parmname"));
            map.put("parmtype", row.getString("parmtype"));
            map.put("parmvalue", row.getString("parmvalue"));
            map.put("description", row.getString("description"));
            return map;
        }).collect(Collectors.toList());
        String cusparam = SerializationUtils.toJsonString(entryList);
        String sql = "select fappparam,fcusparam from t_ccm_sysparam where fid = 0";
        Map map = (Map)DB.query((DBRoute)new DBRoute("scm"), (String)sql, null, (ResultSetHandler)new ResultSetHandler<Map<String, String>>(){

            public Map<String, String> handle(ResultSet resultSet) throws Exception {
                HashMap<String, String> map = new HashMap<String, String>(2);
                while (resultSet.next()) {
                    map.put("appparam", resultSet.getString("fappparam"));
                    map.put("cusparam", resultSet.getString("fcusparam"));
                }
                return map;
            }
        });
        ArrayList<SqlParameter> params = new ArrayList<SqlParameter>(2);
        if (map != null && !map.isEmpty()) {
            sql = "UPDATE t_ccm_sysparam SET fappparam=? , fcusparam=? WHERE FID = 0 ";
            params.add(new SqlParameter(":fappparam", 12, (Object)appparam));
            params.add(new SqlParameter(":fcusparam", 12, (Object)cusparam));
            this.saveOrUpdateParam(params, sql, true);
        } else {
            sql = "INSERT INTO t_ccm_sysparam (FID, fappparam,fcusparam) VALUES (0, ?, ?)";
            params.add(new SqlParameter(":fappparam", 12, (Object)appparam));
            params.add(new SqlParameter(":fcusparam", 12, (Object)cusparam));
            this.saveOrUpdateParam(params, sql, false);
        }
        IBusinessAppCache cache = BusinessAppCache.get((String)"ccm");
        Map map1 = (Map)cache.get("ccm_param", Map.class);
        if (map1 != null && !map1.isEmpty()) {
            cache.remove("ccm_param");
        }
    }

    private Map<String, Object> getJsonStringMap(DynamicObject dataEntity) {
        DynamicObjectSerializationBinder binder = new DynamicObjectSerializationBinder(dataEntity.getDynamicObjectType());
        binder.setOnlyDbProperty(false);
        DcJsonSerializer jser = new DcJsonSerializer((DcBinder)binder);
        jser.setSerializeComplexProperty(false);
        String jsonString = jser.serializeToString((Object)dataEntity, null);
        Map jsonStringMap = (Map)SerializationUtils.fromJsonString((String)jsonString, Map.class);
        DataEntityPropertyCollection properties = dataEntity.getDynamicObjectType().getProperties();
        Iterator iterator = properties.iterator();
        while (iterator.hasNext()) {
            IDataEntityProperty property = (IDataEntityProperty)iterator.next();
            if (property instanceof BooleanProp && ((BooleanProp)property).getDefValue() != null && jsonStringMap.get(property.getName()) == null) {
                if (((Boolean)((BooleanProp)property).getDefValue()).booleanValue()) {
                    jsonStringMap.put(property.getName(), Boolean.TRUE);
                } else {
                    jsonStringMap.put(property.getName(), Boolean.FALSE);
                }
            }
            if (!(property instanceof ComboProp) && !(property instanceof TextProp) || !(property instanceof FieldProp) || ((FieldProp)property).getDefValue() == null || jsonStringMap.get(property.getName()) != null) continue;
            jsonStringMap.put(property.getName(), null);
        }
        return jsonStringMap;
    }

    private void saveOrUpdateParam(List<SqlParameter> params, String sql, boolean isUpdate) {
        try (TXHandle tx = TX.requiresNew();){
            if (isUpdate) {
                DB.update((DBRoute)new DBRoute("scm"), (String)sql, (Object[])params.toArray(new SqlParameter[params.size()]));
            } else {
                DB.execute((DBRoute)new DBRoute("scm"), (String)sql, (Object[])params.toArray(new SqlParameter[params.size()]));
            }
        }
    }
}

