/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ccm.formplugin.journal;

import com.alibaba.fastjson.JSONArray;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IBillModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.BeforeImportDataEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.ImportDataEventArgs;
import kd.bos.entity.datamodel.events.InitImportDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.org.OrgViewServiceHelper;
import kd.scmc.ccm.business.archives.ArchiveCollection;
import kd.scmc.ccm.business.archives.CreditArchive;
import kd.scmc.ccm.business.core.Dimension;
import kd.scmc.ccm.business.core.DimensionValue;
import kd.scmc.ccm.business.scheme.CreditScheme;
import kd.scmc.ccm.business.service.CreditServiceFacade;
import kd.scmc.ccm.business.setting.DimensionEntryFieldMapper;
import kd.scmc.ccm.common.enums.StatusEnum;
import kd.scmc.ccm.common.helper.BillEntityHelper;
import kd.scmc.ccm.common.helper.BillImportHelper;
import kd.scmc.ccm.common.util.CommonUtils;

public class BalanceAdjustmentEdit
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    private static final String CACHE_SCHEME = "cache_scheme";
    private Map<String, Object> tempCache = new HashMap<String, Object>();

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit schemeF7 = (BasedataEdit)this.getControl("scheme");
        if (schemeF7 != null) {
            schemeF7.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        this.roleFieldListener();
    }

    private void roleFieldListener() {
        DimensionEntryFieldMapper mapper = this.getMapper();
        if (mapper == null) {
            return;
        }
        List roleNumbers = mapper.getRoleNumbers();
        for (String roleNumber : roleNumbers) {
            String roleFieldKey = mapper.getRoleFieldKey(roleNumber);
            BasedataEdit roleValueF7 = (BasedataEdit)this.getControl(roleFieldKey);
            if (roleValueF7 == null) continue;
            roleValueF7.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        BillShowParameter parameter = (BillShowParameter)this.getView().getFormShowParameter();
        String schemeId = (String)parameter.getCustomParam("schemeId");
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (StringUtils.isNotBlank((CharSequence)schemeId) && org != null) {
            QFilter filter = new QFilter("enable", "=", (Object)"1");
            filter.and(new QFilter("status", "=", (Object)"C"));
            filter.and("id", "=", (Object)Long.valueOf(schemeId));
            filter.and("mainorg", "=", (Object)org.getLong("id"));
            DynamicObject scheme = QueryServiceHelper.queryOne((String)"ccm_scheme", (String)"id,currency", (QFilter[])new QFilter[]{filter});
            if (ObjectUtils.isEmpty((Object)scheme)) {
                return;
            }
            this.getModel().setValue("scheme", (Object)scheme.getLong("id"));
            this.getModel().setValue("currency", (Object)scheme.getLong("currency"));
        }
    }

    public void afterCopyData(EventObject e) {
        super.afterCopyData(e);
        DynamicObject scheme = (DynamicObject)this.getModel().getValue("scheme");
        DynamicObjectCollection entry = (DynamicObjectCollection)this.getModel().getValue("entry");
        if (scheme == null || entry == null || entry.size() <= 0) {
            return;
        }
        ArrayList<String> dimensionValueStrList = new ArrayList<String>(16);
        for (DynamicObject row : entry) {
            String dimensionValuleStr = row.getString("dimensionvalue");
            if (StringUtils.isBlank((CharSequence)dimensionValuleStr)) continue;
            dimensionValueStrList.add(dimensionValuleStr);
        }
        ArchiveCollection archives = this.getArchives(dimensionValueStrList, scheme);
        for (DynamicObject row : entry) {
            long archiveID = row.getLong("archiveid");
            if (archiveID > 0L) {
                for (CreditArchive archive : archives.values()) {
                    if (archiveID != archive.getId()) continue;
                    row.set("balance", (Object)archive.getBalance());
                    break;
                }
            }
            BigDecimal balance = row.getBigDecimal("balance") != null ? row.getBigDecimal("balance") : BigDecimal.ZERO;
            BigDecimal amount = row.getBigDecimal("amount") != null ? row.getBigDecimal("amount") : BigDecimal.ZERO;
            row.set("adjustedbalance", (Object)balance.add(amount));
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setControlRoleField();
        this.setRoleValueMustInput();
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        DimensionEntryFieldMapper mapper;
        String fieldKey = e.getProperty().getName();
        IDataModel model = this.getModel();
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        DynamicObject org = (DynamicObject)model.getValue("org");
        DynamicObject scheme = (DynamicObject)model.getValue("scheme");
        if ("scheme".equals(fieldKey)) {
            if (ObjectUtils.isEmpty((Object)org)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u6388\u4fe1\u7ec4\u7ec7\u3002", (String)"BalanceAdjustmentEdit_6", (String)"scmc-ccm-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
                return;
            }
            QFilter orgFilter = new QFilter("mainorg", "=", (Object)org.getLong("id"));
            HashSet<String> checkType = new HashSet<String>();
            checkType.add("KZFW001");
            checkType.add("KZFW010");
            QFilter checkTypeFilter = new QFilter("checktype.number", "in", checkType);
            ListFilterParameter listFilterParameter = showParameter.getListFilterParameter();
            listFilterParameter.setFilter(orgFilter);
            listFilterParameter.setFilter(checkTypeFilter);
        } else if (!ObjectUtils.isEmpty((Object)scheme) && (mapper = this.getMapper()) != null) {
            List roleNumbers = mapper.getRoleNumbers();
            for (String roleNumber : roleNumbers) {
                String roleFieldKey = mapper.getRoleFieldKey(roleNumber);
                if (!roleFieldKey.equalsIgnoreCase(fieldKey)) continue;
                DynamicObjectCollection archives = this.getArchivesByRoleListener(roleFieldKey, mapper);
                Set roleIds = archives.stream().map(archive -> archive.getLong(roleFieldKey)).collect(Collectors.toSet());
                Object[] roles = BusinessDataServiceHelper.load((String)mapper.getFieldBaseDataKey(roleFieldKey), (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "in", roleIds)});
                HashSet<Long> roleValueKeys = new HashSet<Long>(roles.length);
                String filterField = "id";
                if (!ObjectUtils.isEmpty((Object[])roles)) {
                    DynamicProperty property = roles[0].getDynamicObjectType().getProperty("masterid");
                    if (property != null) {
                        filterField = "masterid";
                    }
                    for (Object role : roles) {
                        roleValueKeys.add(role.getLong(filterField));
                    }
                }
                QFilter qFilter = new QFilter(filterField, "in", roleValueKeys);
                ListFilterParameter listFilterParameter = showParameter.getListFilterParameter();
                listFilterParameter.setFilter(qFilter);
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String stopChange = this.getPageCache().get("stopChange");
        if ("true".equals(stopChange)) {
            return;
        }
        ChangeData[] changeSet = e.getChangeSet();
        String key = e.getProperty().getName();
        block0: for (ChangeData data : changeSet) {
            if (!CommonUtils.isRealChanged((ChangeData)data)) continue;
            Object oldValue = data.getOldValue();
            Object newValue = data.getNewValue();
            if (key.startsWith("role") && !key.startsWith("roletype")) {
                if (ObjectUtils.isEmpty((Object)newValue)) {
                    this.getModel().setValue("balance", null);
                    this.getModel().setValue("amount", null);
                    this.getModel().setValue("adjustedbalance", null);
                    return;
                }
                DimensionEntryFieldMapper fieldMapper = this.getMapper();
                if (fieldMapper == null) {
                    return;
                }
                List roleFieldKeys = fieldMapper.getRoleFieldKeys();
                for (String roleField : roleFieldKeys) {
                    if (!Objects.equals(roleField, key)) continue;
                    this.roleValueChanged(roleFieldKeys);
                    continue block0;
                }
                continue;
            }
            if (!"scheme".equals(key)) continue;
            this.schemeChange(oldValue);
        }
    }

    private void schemeChange(Object oldValue) {
        if (oldValue == null) {
            String[] allRoleTypeFields;
            DynamicObject newValue = (DynamicObject)this.getModel().getValue("scheme");
            this.getModel().setValue("currency", newValue.get("currency"));
            this.getModel().deleteEntryData("entry");
            this.getModel().createNewEntryRow("entry");
            for (String clearFiledTypeKey : allRoleTypeFields = BillEntityHelper.getAllRoleTypeFields()) {
                if (!StringUtils.isNotBlank((Object)this.getModel().getProperty(clearFiledTypeKey))) continue;
                this.getModel().setValue(clearFiledTypeKey, null);
            }
            this.setRoleValueMustInput();
            this.setControlRoleField();
        } else {
            DynamicObject scheme_old = (DynamicObject)oldValue;
            ConfirmCallBackListener confirmCallBack = new ConfirmCallBackListener("changeScheme", (IFormPlugin)this);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u5207\u6362\u201c\u4fe1\u63a7\u65b9\u6848\u201d\u5c06\u6e05\u9664\u5355\u636e\u4fe1\u606f\uff0c\u662f\u5426\u5207\u6362\uff1f", (String)"BalanceAdjustmentEdit_7", (String)"scmc-ccm-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, ConfirmTypes.Default, confirmCallBack);
            this.getView().getPageCache().put(CACHE_SCHEME, scheme_old.getPkValue().toString());
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        String callBackId = e.getCallBackId();
        if ("changeScheme".equals(callBackId)) {
            if (e.getResult().equals((Object)MessageBoxResult.Yes)) {
                String[] allRoleTypeFields;
                IBillModel model = (IBillModel)this.getModel();
                DynamicObject scheme = (DynamicObject)model.getValue("scheme");
                if (scheme == null) {
                    this.getModel().setValue("currency", null);
                } else {
                    this.getModel().setValue("currency", (Object)scheme.getDynamicObject("currency").getLong("id"));
                }
                this.getModel().deleteEntryData("entry");
                this.getModel().createNewEntryRow("entry");
                for (String clearFiledTypeKey : allRoleTypeFields = BillEntityHelper.getAllRoleTypeFields()) {
                    if (!StringUtils.isNotBlank((Object)this.getModel().getProperty(clearFiledTypeKey))) continue;
                    this.getModel().setValue(clearFiledTypeKey, null);
                }
                this.setRoleValueMustInput();
                this.setControlRoleField();
            } else {
                this.getPageCache().put("stopChange", "true");
                String schemeID = this.getView().getPageCache().get(CACHE_SCHEME);
                this.getModel().setValue("scheme", schemeID == null ? null : Long.valueOf(Long.parseLong(schemeID)));
                this.getPageCache().put("stopChange", "false");
            }
        }
    }

    private void setControlRoleField() {
        DynamicObject scheme = (DynamicObject)this.getModel().getValue("scheme");
        LinkedList<String> unvisiableKeys = new LinkedList<String>();
        String[] allRoleFields = BillEntityHelper.getAllRoleFields();
        unvisiableKeys.addAll(Arrays.asList(allRoleFields));
        LinkedList<String> visiableKeys = new LinkedList<String>();
        if (scheme != null) {
            Object dimensionId = scheme.get("dimension.id");
            DimensionEntryFieldMapper fieldMapper = new DimensionEntryFieldMapper(dimensionId);
            List fieldTypeKeys = fieldMapper.getFieldTypeKeys();
            for (String filedKey : fieldTypeKeys) {
                String baseDataKey = fieldMapper.getBaseDataKey(filedKey);
                this.getModel().setValue(filedKey, (Object)baseDataKey);
            }
            List roleFieldKeys = fieldMapper.getRoleFieldKeys();
            for (String fieldKey : roleFieldKeys) {
                FieldEdit control = (FieldEdit)this.getControl(fieldKey);
                LocaleString roleDisplayName = fieldMapper.getRoleDisplayName(fieldKey);
                control.setCaption(roleDisplayName);
                visiableKeys.add(fieldKey);
                unvisiableKeys.remove(fieldKey);
            }
        }
        if (!visiableKeys.isEmpty()) {
            this.getView().setVisible(Boolean.TRUE, visiableKeys.toArray(new String[0]));
        }
        if (!unvisiableKeys.isEmpty()) {
            this.getView().setVisible(Boolean.FALSE, unvisiableKeys.toArray(new String[0]));
        }
    }

    private void roleValueChanged(List<String> roleFieldKeys) {
        if (ObjectUtils.isEmpty(roleFieldKeys)) {
            return;
        }
        int currentRowIndex = this.getModel().getEntryCurrentRowIndex("entry");
        LinkedList<String> pkValues = new LinkedList<String>();
        for (String roleFieldKey : roleFieldKeys) {
            DynamicObject roleFieldValue = (DynamicObject)this.getModel().getValue(roleFieldKey, currentRowIndex);
            if (roleFieldValue != null) {
                DynamicProperty property = roleFieldValue.getDynamicObjectType().getProperty("masterid");
                if (property == null) {
                    pkValues.add(roleFieldValue.getString("id"));
                    continue;
                }
                pkValues.add(roleFieldValue.getString("masterid"));
                continue;
            }
            return;
        }
        String dimensionValue = "";
        if (pkValues.size() > 0) {
            dimensionValue = String.join((CharSequence)"-", pkValues);
        }
        this.getModel().setValue("dimensionvalue", (Object)dimensionValue, currentRowIndex);
        DynamicObject scheme = (DynamicObject)this.getModel().getValue("scheme");
        ArchiveCollection archives = this.getArchive(dimensionValue, scheme);
        for (CreditArchive archive : archives.values()) {
            this.getModel().setValue("archiveid", (Object)archive.getId(), currentRowIndex);
            this.getModel().setValue("balance", (Object)archive.getBalance(), currentRowIndex);
        }
    }

    private ArchiveCollection getArchive(String dimensionValueStr, DynamicObject schemeObj) {
        CreditServiceFacade facade = new CreditServiceFacade();
        CreditScheme scheme = facade.getScheme(schemeObj.getLong("id"));
        LinkedList<DimensionValue> dimensionValues = new LinkedList<DimensionValue>();
        Dimension dimension = scheme.getDimension();
        DimensionValue dimensionValue = new DimensionValue(dimension);
        dimensionValue.setValue(dimensionValueStr);
        dimensionValues.add(dimensionValue);
        ArchiveCollection archives = facade.loadArchives(scheme, dimensionValues);
        return archives;
    }

    private ArchiveCollection getArchives(List<String> dimensionValueStrList, DynamicObject schemeObj) {
        CreditServiceFacade facade = new CreditServiceFacade();
        CreditScheme scheme = facade.getScheme(schemeObj.getLong("id"));
        LinkedList<DimensionValue> dimensionValues = new LinkedList<DimensionValue>();
        Dimension dimension = scheme.getDimension();
        for (String dimensionValueStr : dimensionValueStrList) {
            DimensionValue dimensionValue = new DimensionValue(dimension);
            dimensionValue.setValue(dimensionValueStr);
            dimensionValues.add(dimensionValue);
        }
        ArchiveCollection archives = facade.loadArchives(scheme, dimensionValues);
        return archives;
    }

    private void setRoleValueMustInput() {
        DynamicObject scheme = (DynamicObject)this.getModel().getValue("scheme");
        if (ObjectUtils.isEmpty((Object)scheme)) {
            return;
        }
        DimensionEntryFieldMapper fieldMapper = this.getMapper();
        if (fieldMapper == null) {
            return;
        }
        List roleFieldKeys = fieldMapper.getRoleFieldKeys();
        for (String roleFieldKey : roleFieldKeys) {
            BasedataEdit dimensionMemberControl = (BasedataEdit)this.getControl(roleFieldKey);
            dimensionMemberControl.setMustInput(true);
        }
    }

    private DimensionEntryFieldMapper getMapper() {
        DimensionEntryFieldMapper mapper = null;
        DynamicObject scheme = (DynamicObject)this.getModel().getValue("scheme");
        if (!ObjectUtils.isEmpty((Object)scheme)) {
            DynamicObject dimension = scheme.getDynamicObject("dimension");
            mapper = new DimensionEntryFieldMapper(dimension.getPkValue());
        }
        return mapper;
    }

    private DynamicObjectCollection getArchivesByRoleListener(String roleFileldKey, DimensionEntryFieldMapper roleFieldMapper) {
        List roleFileldKeys = roleFieldMapper.getRoleFieldKeys();
        int rowIndex = this.getModel().getEntryCurrentRowIndex("entry");
        DynamicObject scheme = (DynamicObject)this.getModel().getValue("scheme");
        QFilter filter = new QFilter("scheme", "=", (Object)scheme.getLong("id"));
        filter.and(new QFilter("archivetype", "=", (Object)"normal"));
        for (String roleKey : roleFileldKeys) {
            DynamicObject role = (DynamicObject)this.getModel().getValue(roleKey, rowIndex);
            if (ObjectUtils.isEmpty((Object)role) || Objects.equals(roleKey, roleFileldKey)) continue;
            if (role.getDynamicObjectType().getProperty("masterid") != null) {
                filter.and(new QFilter(roleKey, "=", (Object)role.getLong("masterid")));
                continue;
            }
            filter.and(new QFilter(roleKey, "=", (Object)role.getLong("id")));
        }
        DynamicObjectCollection archives = QueryServiceHelper.query((String)"ccm_archive", (String)roleFileldKey, (QFilter[])new QFilter[]{filter});
        return archives;
    }

    public void initImportData(InitImportDataEventArgs e) {
        List sourceDataList = e.getSourceDataList();
        if (sourceDataList.isEmpty()) {
            return;
        }
        IDataModel model = (IDataModel)e.getSource();
        List<Long> hasPermissionOrg = (List<Long>)this.tempCache.get("hasPermissionOrg");
        if (hasPermissionOrg == null) {
            hasPermissionOrg = this.getHasPermissionOrg(model.getDataEntityType().getName(), "10");
            this.tempCache.put("hasPermissionOrg", hasPermissionOrg);
        }
    }

    public void beforeImportData(BeforeImportDataEventArgs e) {
        Map schemeEntryMap;
        super.beforeImportData(e);
        Map sourceData = e.getSourceData();
        if (sourceData == null) {
            e.setCancel(true);
            e.setFireAfterImportData(false);
            return;
        }
        String billno = (String)sourceData.get("billno");
        Map opMap = e.getOption();
        String type = (String)opMap.get("importtype");
        if ("new".equals(type) && QueryServiceHelper.exists((String)"ccm_balanceadjustment", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)billno)})) {
            e.setCancel(true);
            e.setCancelMessage(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"BalanceAdjustmentEdit_2", (String)"scmc-ccm-formplugin", (Object[])new Object[0]));
            e.setFireAfterImportData(false);
            return;
        }
        DynamicObject org = this.getBaseDataFromCache(sourceData, "org", "bos_org", null, null);
        if (org == null) {
            return;
        }
        if (!BalanceAdjustmentEdit.checkOrgFunction((Long)org.getPkValue(), "10")) {
            e.setCancel(true);
            e.setCancelMessage(String.format(ResManager.loadKDString((String)"\u6388\u4fe1\u7ec4\u7ec7\u201c%1$s\u201d \u4e0d\u662f\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"BalanceAdjustmentEdit_1", (String)"scmc-ccm-formplugin", (Object[])new Object[0]), org.get("number")));
            e.setFireAfterImportData(false);
            return;
        }
        List hasPermissionOrg = (List)this.tempCache.get("hasPermissionOrg");
        if (hasPermissionOrg == null || !hasPermissionOrg.contains(org.getPkValue())) {
            Map propMap = BillImportHelper.format4ImportAndApi(sourceData.get("org"));
            e.setCancel(true);
            e.setCancelMessage(String.format(ResManager.loadKDString((String)"\u6388\u4fe1\u7ec4\u7ec7\u201c%1$s\u201d\u4e0d\u5728\u7528\u6237\u6743\u9650\u8303\u56f4\u5185\u3002", (String)"BalanceAdjustmentEdit_5", (String)"scmc-ccm-formplugin", (Object[])new Object[0]), propMap.get(propMap.get("importprop"))));
            e.setFireAfterImportData(false);
            return;
        }
        DynamicObject scheme = this.getBaseDataFromCache(sourceData, "scheme", "ccm_scheme", "enable,status,mainorg,dimension.id", null);
        if (scheme == null || !"1".equals(scheme.getString("enable")) || !StatusEnum.AUDIT.getValue().equals(scheme.getString("status"))) {
            e.setCancel(true);
            e.setCancelMessage(ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u4fe1\u63a7\u65b9\u6848\u662f\u5426\u4e3a\u201c\u5ba1\u6838\u6001\u201d\uff0c\u5e76\u4e14\u201c\u5df2\u542f\u7528\u201d\u3002", (String)"BalanceAdjustmentEdit_0", (String)"scmc-ccm-formplugin", (Object[])new Object[0]));
            e.setFireAfterImportData(false);
            return;
        }
        DynamicObject schemeOrg = scheme.getDynamicObject("mainorg");
        if (!Objects.equals(schemeOrg.get("masterid"), org.get("masterid"))) {
            e.setCancel(true);
            e.setCancelMessage(ResManager.loadKDString((String)"\u6388\u4fe1\u7ec4\u7ec7\u4e0e\u4fe1\u63a7\u65b9\u6848\u7684\u6388\u4fe1\u7ec4\u7ec7\u4e0d\u4e00\u81f4\u3002", (String)"BalanceAdjustmentEdit_3", (String)"scmc-ccm-formplugin", (Object[])new Object[0]));
            e.setFireAfterImportData(false);
            return;
        }
        List fieldTypeKeys = new ArrayList();
        if (scheme != null) {
            Object dimensionId = scheme.get("dimension.id");
            DimensionEntryFieldMapper fieldMapper = new DimensionEntryFieldMapper(dimensionId);
            fieldTypeKeys = fieldMapper.getFieldTypeKeys();
            for (String filedKey : fieldTypeKeys) {
                String baseDataKey = fieldMapper.getBaseDataKey(filedKey);
                e.getSourceData().put(filedKey, baseDataKey);
            }
        }
        if ((schemeEntryMap = BillImportHelper.format4ImportAndApi(e.getSourceData().get("entry"))) != null) {
            List schemeEntry = (List)schemeEntryMap.get("sourceData");
            JSONArray billEntryArray = new JSONArray();
            for (Map entry : schemeEntry) {
                int roleNum = fieldTypeKeys.size();
                for (int i = 3; i >= roleNum; --i) {
                    entry.put("role" + i, null);
                }
                billEntryArray.add((Object)entry);
            }
            e.getSourceData().put("entry", billEntryArray);
        }
    }

    private DynamicObject getBaseDataFromCache(Map<String, Object> sourceData, String propName, String propEntityName, String select, QFilter[] qFilters) {
        if (sourceData == null) {
            return null;
        }
        Map propMap = BillImportHelper.format4ImportAndApi((Object)sourceData.get(propName));
        String importProp = null;
        if (propMap != null) {
            importProp = (String)propMap.get("importprop");
            DynamicObject value = (DynamicObject)this.tempCache.get(propName + "_" + propMap.get(importProp));
            if (value == null && !"id".equals(importProp)) {
                if (select == null) {
                    select = "id";
                }
                if (qFilters == null) {
                    qFilters = new QFilter[]{new QFilter(importProp, "=", (Object)((String)propMap.get(importProp)))};
                }
                value = BusinessDataServiceHelper.loadSingleFromCache((String)propEntityName, (String)select, (QFilter[])qFilters);
            }
            return value;
        }
        return null;
    }

    private List<Long> getHasPermissionOrg(String entityName, String orgViewType) {
        List hasPermissionOrgs = OrgViewServiceHelper.getAllPermissionOrgs((String)entityName, (String)orgViewType);
        if (CommonUtils.isNull((Object)hasPermissionOrgs)) {
            return null;
        }
        ArrayList<Long> orgs = new ArrayList<Long>(hasPermissionOrgs.size());
        for (Map tempOrg : hasPermissionOrgs) {
            Long tempOrgId = Long.valueOf((String)tempOrg.get("id"));
            orgs.add(tempOrgId);
        }
        return orgs;
    }

    private static boolean checkOrgFunction(Long orgID, String orgType) {
        return OrgUnitServiceHelper.checkOrgFunction((Long)orgID, (String)orgType);
    }

    public void afterImportData(ImportDataEventArgs e) {
        super.afterImportData(e);
        this.getModel().setValue("billstatus", (Object)StatusEnum.SAVE.getValue());
        DynamicObject scheme = (DynamicObject)this.getModel().getValue("scheme");
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (org == null || scheme == null) {
            return;
        }
        Object dimensionId = scheme.get("dimension.id");
        DimensionEntryFieldMapper fieldMapper = new DimensionEntryFieldMapper(dimensionId);
        List fieldTypeKeys = fieldMapper.getFieldTypeKeys();
        DynamicObjectCollection entry = this.getModel().getEntryEntity("entry");
        int rowCount = -1;
        for (DynamicObject row : entry) {
            ++rowCount;
            if (row == null) continue;
            int roleNum = fieldTypeKeys.size();
            for (int i = 3; i >= roleNum; --i) {
                row.set("role" + i, null);
            }
            LinkedList<String> pkValues = new LinkedList<String>();
            for (int i = 0; i < roleNum; ++i) {
                DynamicObject roleObj = (DynamicObject)row.get("role" + i);
                if (roleObj == null) continue;
                DynamicProperty property = roleObj.getDynamicObjectType().getProperty("masterid");
                pkValues.add(property == null ? String.valueOf(roleObj.get("id")) : String.valueOf(roleObj.get("masterid")));
            }
            int inputRoleValSize = pkValues.size();
            if (inputRoleValSize == 0 || inputRoleValSize < roleNum) {
                e.setCancel(true);
                e.addCancelMessage(Integer.valueOf(rowCount), Integer.valueOf(0), ResManager.loadKDString((String)"\u5bfc\u5165\u7684\u7ef4\u5ea6\u6210\u5458\u503c\u4e0e\u4fe1\u63a7\u65b9\u6848\u7684\u4fe1\u63a7\u7ef4\u5ea6\u4e0d\u5339\u914d\u3002", (String)"BalanceAdjustmentEdit_8", (String)"scmc-ccm-formplugin", (Object[])new Object[0]));
                continue;
            }
            String dimensionValue = String.join((CharSequence)"-", pkValues);
            row.set("dimensionvalue", (Object)dimensionValue);
            ArchiveCollection archives = this.getArchive(dimensionValue, scheme);
            if (archives.size() == 0) {
                e.setCancel(true);
                e.addCancelMessage(Integer.valueOf(rowCount), Integer.valueOf(0), ResManager.loadKDString((String)"\u5bfc\u5165\u7684\u7ef4\u5ea6\u548c\u4fe1\u63a7\u65b9\u6848\u65e0\u6cd5\u5339\u914d\u6709\u6548\u7684\u4fe1\u7528\u6863\u6848\u3002", (String)"BalanceAdjustmentEdit_4", (String)"scmc-ccm-formplugin", (Object[])new Object[0]));
                continue;
            }
            for (CreditArchive archive : archives.values()) {
                List aa = archive.getRawArchives();
                for (DynamicObject rawArchive : aa) {
                    if (!"normal".equals(rawArchive.getString("archivetype"))) continue;
                    row.set("archiveid", (Object)archive.getId());
                }
                row.set("balance", (Object)archive.getBalance());
                row.set("adjustedbalance", (Object)row.getBigDecimal("amount").add(archive.getBalance()));
            }
        }
    }
}

