/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ccm.formplugin.privilege;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.DecimalEdit;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scmc.ccm.business.archives.ArchiveCollection;
import kd.scmc.ccm.business.archives.CreditArchive;
import kd.scmc.ccm.business.core.Dimension;
import kd.scmc.ccm.business.core.DimensionValue;
import kd.scmc.ccm.business.scheme.CreditScheme;
import kd.scmc.ccm.business.service.CreditServiceFacade;
import kd.scmc.ccm.business.setting.DimensionEntryFieldMapper;
import kd.scmc.ccm.common.util.CommonUtils;

public class PrivilegeApplyEdit
extends AbstractBillPlugIn {
    private static final String KEY_ORG = "org";
    private DimensionEntryFieldMapper mapper;
    private Set<String> privilegeCheckTypes = Stream.of("KZFW010", "KZFW011").collect(Collectors.toSet());

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.filterScheme();
        this.filterPrivilegedOrg();
        this.addRoleFiledListener();
        this.filterBillEntity();
        this.addClickListeners(new String[]{"srcbillno"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String userId = RequestContext.get().getUserId();
        this.getModel().setValue("applicant", (Object)Long.valueOf(userId));
        long orgId = RequestContext.get().getOrgId();
        this.getModel().setValue("applyorg", (Object)orgId);
        DynamicObject org = (DynamicObject)this.getModel().getValue(KEY_ORG);
        BillShowParameter parameter = (BillShowParameter)this.getView().getFormShowParameter();
        String schemeId = (String)parameter.getCustomParam("schemeId");
        if (StringUtils.isNotBlank((CharSequence)schemeId) && org != null) {
            QFilter filter = new QFilter("enable", "=", (Object)"1");
            filter.and(new QFilter("status", "=", (Object)"C"));
            filter.and("id", "=", (Object)Long.valueOf(schemeId));
            filter.and("mainorg", "=", (Object)org.getLong("id"));
            DynamicObject scheme = QueryServiceHelper.queryOne((String)"ccm_scheme", (String)"id,currency,validity,yearbegindate", (QFilter[])new QFilter[]{filter});
            if (ObjectUtils.isEmpty((Object)scheme)) {
                return;
            }
            this.getModel().setValue("scheme", (Object)scheme.getLong("id"));
            this.getModel().setValue("currency", (Object)scheme.getLong("currency"));
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if ("srcbillno".equals(key)) {
            String exportEntity = this.getEntitykey();
            if (exportEntity == null || exportEntity.trim().isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u201c\u6e90\u5355\u7c7b\u578b\u201d\u3002", (String)"PrivilegeApplyEdit_3", (String)"scmc-ccm-formplugin", (Object[])new Object[0]));
                return;
            }
            ListShowParameter lsp = ShowFormHelper.createShowListForm((String)exportEntity, (boolean)false);
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "selectbill");
            lsp.setCloseCallBack(closeCallBack);
            this.getView().showForm((FormShowParameter)lsp);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Object returnData;
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if ("selectbill".equals(actionId) && (returnData = closedCallBackEvent.getReturnData()) instanceof ListSelectedRowCollection) {
            ListSelectedRowCollection listData = (ListSelectedRowCollection)returnData;
            Object[] primaryKeyValues = ((ListSelectedRowCollection)returnData).getPrimaryKeyValues();
            if (primaryKeyValues.length > 0) {
                this.getModel().setValue("srcbillid", primaryKeyValues[0]);
                this.getModel().setValue("srcbillno", (Object)listData.get(0).getBillNo());
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        ChangeData[] valueSet = e.getChangeSet();
        for (int i = 0; i < valueSet.length; ++i) {
            if (!CommonUtils.isRealChanged((ChangeData)valueSet[i])) continue;
            if ("scheme".equals(key)) {
                this.schemeChanged();
                this.setPrivilegeFieldVisibleByCheckType();
                continue;
            }
            if (key.startsWith("role") && !key.startsWith("roletype")) {
                DimensionEntryFieldMapper fieldMapper = this.getMapper();
                List roleFieldKeys = fieldMapper.getRoleFieldKeys();
                this.roleValueChanged(roleFieldKeys);
                continue;
            }
            if ("srcbillentity".equals(key)) {
                this.getModel().setValue("srcbillno", null);
                this.getModel().setValue("srcbillid", (Object)0L);
                continue;
            }
            if (!"srcbillno".equals(key)) continue;
            String entityKey = this.getEntitykey();
            if (entityKey == null) {
                return;
            }
            String billNo = (String)this.getModel().getValue("srcbillno");
            if (StringUtils.isBlank((CharSequence)billNo)) {
                this.getModel().setValue("srcbillid", null);
                return;
            }
            QFilter billNoFilter = new QFilter("billno", "=", (Object)billNo);
            DynamicObjectCollection bills = QueryServiceHelper.query((String)entityKey, (String)"id", (QFilter[])billNoFilter.toArray());
            if (bills.isEmpty()) {
                String messageTemplate = ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u7f16\u53f7\u4e3a\u201c%s\u201d\u7684\u5355\u636e\u3002", (String)"PrivilegeApplyEdit_0", (String)"scmc-ccm-formplugin", (Object[])new Object[0]);
                this.getView().showTipNotification(String.format(messageTemplate, billNo));
                this.getModel().setValue("srcbillno", null);
                this.getModel().setValue("srcbillid", null);
                return;
            }
            if (bills.size() > 1) {
                String messageTemplate = ResManager.loadKDString((String)"\u7f16\u53f7\u4e3a\u201c%s\u201d\u7684\u5355\u636e\u4e0d\u552f\u4e00\uff0c\u8bf7\u6253\u5f00\u9009\u5355\u754c\u9762\u7cbe\u786e\u6307\u5b9a\u5355\u636e\u3002", (String)"PrivilegeApplyEdit_1", (String)"scmc-ccm-formplugin", (Object[])new Object[0]);
                this.getView().showTipNotification(String.format(messageTemplate, billNo));
                return;
            }
            this.getModel().setValue("srcbillid", (Object)((DynamicObject)bills.get(0)).getLong("id"));
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setPrivilegeFieldVisibleByCheckType();
    }

    private void schemeChanged() {
        DynamicObject scheme = (DynamicObject)this.getModel().getValue("scheme");
        if (scheme == null) {
            this.getModel().setValue("currency", null);
        } else {
            this.getModel().setValue("currency", scheme.get("currency"));
        }
    }

    private void roleValueChanged(List<String> roleFieldKeys) {
        for (String roleFieldKey : roleFieldKeys) {
            DynamicObject roleValue = (DynamicObject)this.getModel().getValue(roleFieldKey);
            String fieldBaseDataKey = this.mapper.getFieldBaseDataKey(roleFieldKey);
            if ("bos_user".equals(fieldBaseDataKey)) {
                if (ObjectUtils.isEmpty((Object)roleValue)) {
                    this.getModel().setValue("privilegedorg", null);
                } else {
                    DynamicObject user = BusinessDataServiceHelper.loadSingleFromCache((Object)roleValue.getPkValue(), (String)"bos_user");
                    this.getModel().setValue("privilegedorg", ((DynamicObject)user.getDynamicObjectCollection("entryentity").get(0)).get("dpt"));
                }
            }
            if (!ObjectUtils.isEmpty((Object)roleValue)) continue;
            return;
        }
        String dimensionValue = this.getDimensionValue(roleFieldKeys);
        this.getModel().setValue("dimensionvalue", (Object)dimensionValue);
        DynamicObject scheme = (DynamicObject)this.getModel().getValue("scheme");
        ArchiveCollection archives = this.getArchive(dimensionValue, scheme);
        for (CreditArchive archive : archives.values()) {
            this.getModel().setValue("archiveid", (Object)archive.getId());
        }
    }

    private String getDimensionValue(List<String> roleFieldKeys) {
        ArrayList<String> pkValues = new ArrayList<String>(roleFieldKeys.size());
        for (String roleFieldKey : roleFieldKeys) {
            DynamicObject roleFieldValue = (DynamicObject)this.getModel().getValue(roleFieldKey);
            DynamicProperty property = roleFieldValue.getDynamicObjectType().getProperty("masterid");
            if (property == null) {
                pkValues.add(roleFieldValue.getString("id"));
                continue;
            }
            pkValues.add(roleFieldValue.getString("masterid"));
        }
        return String.join((CharSequence)"-", pkValues);
    }

    private ArchiveCollection getArchive(String dimensionValueStr, DynamicObject schemeObj) {
        CreditServiceFacade facade = new CreditServiceFacade();
        CreditScheme scheme = facade.getScheme(schemeObj.getLong("id"));
        LinkedList<DimensionValue> dimensionValues = new LinkedList<DimensionValue>();
        Dimension dimension = scheme.getDimension();
        DimensionValue dimensionValue = new DimensionValue(dimension);
        dimensionValue.setValue(dimensionValueStr);
        dimensionValues.add(dimensionValue);
        ArchiveCollection archives = facade.loadArchives(scheme, dimensionValues);
        return archives;
    }

    private DimensionEntryFieldMapper getMapper() {
        if (this.mapper == null) {
            DynamicObject scheme = (DynamicObject)this.getModel().getValue("scheme");
            DynamicObject dimension = scheme.getDynamicObject("dimension");
            this.mapper = new DimensionEntryFieldMapper(dimension.getPkValue());
        }
        return this.mapper;
    }

    private String getEntitykey() {
        DynamicObject entity = (DynamicObject)this.getModel().getValue("srcbillentity");
        if (entity != null) {
            return (String)entity.getPkValue();
        }
        return null;
    }

    private void filterScheme() {
        DynamicObject org = (DynamicObject)this.getModel().getValue(KEY_ORG);
        BasedataEdit schemeF7 = (BasedataEdit)this.getControl("scheme");
        schemeF7.addBeforeF7SelectListener(beforeF7SelectListener -> {
            QFilter qFilter = new QFilter("mainorg", "=", null);
            if (!ObjectUtils.isEmpty((Object)org)) {
                qFilter = new QFilter("mainorg", "=", (Object)org.getLong("id"));
            }
            qFilter.and(new QFilter("checktype.number", "in", this.privilegeCheckTypes));
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectListener.getFormShowParameter();
            ListFilterParameter listFilterParameter = showParameter.getListFilterParameter();
            listFilterParameter.getQFilters().add(qFilter);
        });
    }

    private void addRoleFiledListener() {
        DynamicObject scheme = (DynamicObject)this.getModel().getValue("scheme");
        if (scheme == null) {
            return;
        }
        DynamicObject dimension = scheme.getDynamicObject("dimension");
        DynamicObjectCollection archives = QueryServiceHelper.query((String)"ccm_archive", (String)"role0,role1,role2,role3", (QFilter[])new QFilter[]{new QFilter("scheme", "=", scheme.getPkValue())});
        DimensionEntryFieldMapper mapper = new DimensionEntryFieldMapper(dimension.getPkValue());
        List roleFieldKeys = mapper.getRoleFieldKeys();
        for (String roleField : roleFieldKeys) {
            BasedataEdit roleF7 = (BasedataEdit)this.getControl(roleField);
            roleF7.addBeforeF7SelectListener(beforeF7SelectListenre -> {
                HashSet<Long> archiveRoleIds = new HashSet<Long>(archives.size());
                for (DynamicObject archive : archives) {
                    archiveRoleIds.add(archive.getLong(roleField));
                }
                ListShowParameter showParameter = (ListShowParameter)beforeF7SelectListenre.getFormShowParameter();
                ListFilterParameter listFilterParameter = showParameter.getListFilterParameter();
                QFilter filter = new QFilter("id", "in", archiveRoleIds);
                listFilterParameter.getQFilters().add(filter);
            });
        }
    }

    private void filterPrivilegedOrg() {
        DynamicObject scheme = (DynamicObject)this.getModel().getValue("scheme");
        if (ObjectUtils.isEmpty((Object)scheme)) {
            return;
        }
        DimensionEntryFieldMapper mapper = this.getMapper();
        List roleFieldKeys = mapper.getRoleFieldKeys();
        LinkedList<Long> userDpts = new LinkedList<Long>();
        for (String roleFieldKey : roleFieldKeys) {
            String fieldBaseDataKey = mapper.getFieldBaseDataKey(roleFieldKey);
            DynamicObject roleValue = (DynamicObject)this.getModel().getValue(roleFieldKey);
            if (ObjectUtils.isEmpty((Object)roleValue) || !"bos_user".equals(fieldBaseDataKey)) continue;
            DynamicObject user = BusinessDataServiceHelper.loadSingleFromCache((Object)roleValue.getPkValue(), (String)"bos_user");
            DynamicObjectCollection entry = user.getDynamicObjectCollection("entryentity");
            for (DynamicObject row : entry) {
                long dptId = row.getDynamicObject("dpt").getLong("id");
                userDpts.add(dptId);
            }
        }
        BasedataEdit privilegedOrgF7 = (BasedataEdit)this.getControl("privilegedorg");
        privilegedOrgF7.addBeforeF7SelectListener(beforeF7SelectListener -> {
            QFilter filter = new QFilter("id", "in", (Object)userDpts);
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectListener.getFormShowParameter();
            ListFilterParameter listFilterParameter = showParameter.getListFilterParameter();
            listFilterParameter.getQFilters().add(filter);
        });
    }

    private void filterBillEntity() {
        BasedataEdit entityKeyF7 = (BasedataEdit)this.getControl("srcbillentity");
        entityKeyF7.addBeforeF7SelectListener(beforeF7SelectListener -> {
            ListShowParameter lsp = (ListShowParameter)beforeF7SelectListener.getFormShowParameter();
            DynamicObjectCollection configs = QueryServiceHelper.query((String)"ccm_entityconfig", (String)"number", null);
            Set entityKeys = configs.stream().map(config -> config.getString("number")).collect(Collectors.toSet());
            lsp.getListFilterParameter().setFilter(new QFilter("id", "in", entityKeys));
        });
    }

    private void setPrivilegeFieldVisibleByCheckType() {
        DynamicObject scheme = (DynamicObject)this.getModel().getValue("scheme");
        if (!ObjectUtils.isEmpty((Object)scheme)) {
            String checkType = scheme.getString("checktype.number");
            if ("KZFW010".equals(checkType)) {
                DecimalEdit privilegedAmount = (DecimalEdit)this.getView().getControl("privilegedamount");
                privilegedAmount.setMustInput(true);
                this.getView().setVisible(Boolean.TRUE, new String[]{"privilegedamount", "srccurrency", "srcbillamount"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"privilegedday"});
            } else if ("KZFW011".equals(checkType)) {
                DecimalEdit privilegedDay = (DecimalEdit)this.getView().getControl("privilegedday");
                privilegedDay.setMustInput(true);
                this.getView().setVisible(Boolean.TRUE, new String[]{"privilegedday"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"privilegedamount", "srccurrency", "srcbillamount"});
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{"privilegedamount", "srccurrency", "srcbillamount", "privilegedday"});
            }
        }
    }
}

