/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ccm.formplugin.recalculate;

import java.util.Arrays;
import java.util.EventObject;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.scmc.ccm.business.core.DimensionValue;
import kd.scmc.ccm.business.core.Role;
import kd.scmc.ccm.business.journal.Journal;
import kd.scmc.ccm.business.scheme.CreditScheme;
import kd.scmc.ccm.business.scheme.SchemeReader;
import kd.scmc.ccm.business.service.CreditServiceFacade;
import kd.scmc.ccm.business.setting.DimensionEntryFieldMapper;
import kd.scmc.ccm.common.helper.BillEntityHelper;

public class RecalDetailPreviewEdit
extends AbstractFormPlugin {
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String schemeIdStr = (String)customParams.get("schemeid");
        SchemeReader schemeReader = new SchemeReader();
        CreditScheme scheme = schemeReader.getScheme(Long.parseLong(schemeIdStr));
        String dimensionValueStr = (String)customParams.get("dimensionvalue");
        DimensionValue dimensionValue = new DimensionValue(scheme.getDimension());
        dimensionValue.setValue(dimensionValueStr);
        String checkType = (String)customParams.get("checktype");
        this.setVisibilityByCheckType(checkType);
        List<Journal> journals = this.getDetailJournals(scheme, dimensionValue);
        DynamicObject dimension = scheme.getRawScheme().getDynamicObject("dimension");
        List roles = scheme.getDimension().getRoles();
        DimensionEntryFieldMapper roleFieldMapper = new DimensionEntryFieldMapper(dimension.getPkValue());
        this.controlMultiRoleFields(roleFieldMapper, roles);
        this.showResults(journals, roles, roleFieldMapper);
    }

    private void showResults(List<Journal> journals, List<Role> roles, DimensionEntryFieldMapper roleFieldMapper) {
        if (ObjectUtils.isEmpty(journals)) {
            return;
        }
        this.getModel().batchCreateNewEntryRow("entry", journals.size());
        String quotaType = journals.get(0).getQuotaType();
        for (int i = 0; i < journals.size(); ++i) {
            Journal journal = journals.get(i);
            this.getModel().setValue("scheme", (Object)journal.getScheme().getId(), i);
            this.getModel().setValue("entity", (Object)journal.getEntityKey(), i);
            this.getModel().setValue("billno", (Object)journal.getBillNo(), i);
            this.getModel().setValue("direction", (Object)journal.getDirection(), i);
            if ("amount".equals(quotaType)) {
                this.getModel().setValue("currency", (Object)journal.getOriginalUnit(), i);
                this.getModel().setValue("amount", (Object)journal.getOriginalAmount(), i);
            } else if ("qty".equals(quotaType)) {
                this.getModel().setValue("measureunit", (Object)journal.getUnit(), i);
                this.getModel().setValue("quantity", (Object)journal.getAmount(), i);
            }
            DimensionValue journalDimensionValue = journal.getDimensionValue();
            for (Role role : roles) {
                String fieldKey = roleFieldMapper.getRoleFieldKey(role.getRoleType());
                Object roleValue = journalDimensionValue.getValue(role);
                this.getModel().setValue(fieldKey, (Object)Long.valueOf(roleValue.toString()), i);
            }
        }
    }

    private List<Journal> getDetailJournals(CreditScheme scheme, DimensionValue dimensionValue) {
        return new CreditServiceFacade().recalculateDetailPreview(scheme, dimensionValue);
    }

    private void controlMultiRoleFields(DimensionEntryFieldMapper roleFieldMapper, List<Role> roles) {
        LinkedList<String> hideableKeys = new LinkedList<String>();
        LinkedList<String> visiableKeys = new LinkedList<String>();
        String[] allRoleFields = BillEntityHelper.getAllRoleFields();
        hideableKeys.addAll(Arrays.asList(allRoleFields));
        for (Role role : roles) {
            String roleType = role.getRoleType();
            String fieldKey = roleFieldMapper.getRoleFieldKey(roleType);
            FieldEdit control = (FieldEdit)this.getControl(fieldKey);
            control.setCaption(roleFieldMapper.getRoleDisplayName(fieldKey));
            visiableKeys.add(fieldKey);
            hideableKeys.remove(fieldKey);
        }
        if (!hideableKeys.isEmpty()) {
            this.getView().setVisible(Boolean.FALSE, hideableKeys.toArray(new String[0]));
        }
        if (!visiableKeys.isEmpty()) {
            this.getView().setVisible(Boolean.TRUE, visiableKeys.toArray(new String[0]));
        }
    }

    public void getEntityType(GetEntityTypeEventArgs e) {
        super.getEntityType(e);
        MainEntityType originalEntityType = e.getOriginalEntityType();
        String dimensionIdStr = (String)this.getView().getFormShowParameter().getCustomParam("dimensionid");
        if (StringUtils.isBlank((CharSequence)dimensionIdStr)) {
            return;
        }
        MainEntityType newEntityType = null;
        try {
            newEntityType = (MainEntityType)originalEntityType.clone();
        }
        catch (CloneNotSupportedException e1) {
            throw new RuntimeException(e1);
        }
        DimensionEntryFieldMapper dimensionEntryFieldMapper = new DimensionEntryFieldMapper((Object)Long.valueOf(dimensionIdStr));
        List roleNumbers = dimensionEntryFieldMapper.getRoleNumbers();
        for (String roleNumber : roleNumbers) {
            String fieldTypeKey = dimensionEntryFieldMapper.getFieldTypeKey(roleNumber);
            String roleFieldKey = dimensionEntryFieldMapper.getRoleFieldKey(roleNumber);
            String baseDataKey = dimensionEntryFieldMapper.getBaseDataKey(fieldTypeKey);
            MainEntityType basedataType = EntityMetadataCache.getDataEntityType((String)baseDataKey);
            EntryProp entryProp = (EntryProp)newEntityType.getProperty("entry");
            BasedataProp roleProp = (BasedataProp)entryProp._collectionItemPropertyType.getProperty(roleFieldKey);
            roleProp.setBaseEntityId(baseDataKey);
            roleProp.setComplexType((IDataEntityType)basedataType);
        }
        e.setNewEntityType(newEntityType);
    }

    private void setVisibilityByCheckType(String checkType) {
        if ("KZFW001".equals(checkType)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"currency", "amount"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"measureunit", "quantity"});
        } else if ("KZFW003".equals(checkType)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"currency", "amount"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"measureunit", "quantity"});
        }
    }
}

