/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ccm.formplugin.recalculate;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scmc.ccm.business.archives.CreditArchive;
import kd.scmc.ccm.business.core.Dimension;
import kd.scmc.ccm.business.core.DimensionValue;
import kd.scmc.ccm.business.core.Role;
import kd.scmc.ccm.business.scheme.CreditScheme;
import kd.scmc.ccm.business.scheme.SchemeReader;
import kd.scmc.ccm.business.service.CreditServiceFacade;
import kd.scmc.ccm.business.setting.DimensionEntryFieldMapper;
import kd.scmc.ccm.common.helper.BillEntityHelper;
import kd.scmc.ccm.common.helper.PermissionHelper;
import kd.scmc.ccm.common.util.CommonUtils;
import kd.scmc.ccm.common.util.OrmFacade;

public class RecalculateEdit
extends AbstractFormPlugin
implements HyperLinkClickListener {
    private CreditServiceFacade serviceFacade = new CreditServiceFacade();
    private OrmFacade ormFacade = new OrmFacade();
    private SchemeReader schemeReader = new SchemeReader();

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"recalculate", "preview"});
        EntryGrid control = (EntryGrid)this.getControl("entry");
        control.addHyperClickListener((HyperLinkClickListener)this);
        this.schemesFilter();
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        if ("preview".equals(key)) {
            this.preview();
        } else if ("recalculate".equals(key)) {
            this.recalculate();
        }
    }

    private void preview() {
        List<CreditScheme> schemes = this.getSchemes();
        if (!this.checkSchemes(schemes)) {
            return;
        }
        LinkedList<CreditArchive> allArchives = new LinkedList<CreditArchive>();
        for (CreditScheme scheme : schemes) {
            List<DimensionValue> dimensionValues = this.getDimensionValues(scheme);
            String dimensionRangeMode = this.getDimensionRangeMode();
            List archives = this.serviceFacade.recalculatePreview(scheme, dimensionRangeMode, dimensionValues);
            allArchives.addAll(archives);
        }
        this.showResults(allArchives);
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u8ba1\u7b97\u5b8c\u6210\u3002", (String)"RecalculateEdit_0", (String)"scmc-ccm-formplugin", (Object[])new Object[0]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recalculate() {
        List<CreditScheme> schemes = this.getSchemes();
        if (!this.checkSchemes(schemes)) {
            return;
        }
        DynamicObject[] saveableSchemes = this.markSchemeIniting(schemes);
        try (TXHandle tx = TX.requiresNew();){
            LinkedList<CreditArchive> allArchives = new LinkedList<CreditArchive>();
            try {
                for (CreditScheme scheme : schemes) {
                    List<DimensionValue> dimensionValues = this.getDimensionValues(scheme);
                    String dimensionRangeMode = this.getDimensionRangeMode();
                    List archives = this.serviceFacade.recalculate(scheme, dimensionRangeMode, dimensionValues);
                    allArchives.addAll(archives);
                }
            }
            catch (Exception e) {
                tx.markRollback();
                throw e;
            }
            boolean rollback = this.checkWithPreviewResults(allArchives);
            if (rollback) {
                tx.markRollback();
            } else {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u8ba1\u7b97\u5b8c\u6210\u3002", (String)"RecalculateEdit_0", (String)"scmc-ccm-formplugin", (Object[])new Object[0]));
            }
        }
        finally {
            this.resetSchemeState(saveableSchemes);
        }
    }

    private void resetSchemeState(DynamicObject[] saveableSchemes) {
        for (DynamicObject scheme : saveableSchemes) {
            scheme.set("bizstate", (Object)"normal");
        }
        this.ormFacade.save(saveableSchemes);
    }

    private DynamicObject[] markSchemeIniting(List<CreditScheme> schemes) {
        DynamicObject[] saveableSchemes;
        MainEntityType schemeDt = MetadataServiceHelper.getDataEntityType((String)"ccm_scheme");
        Object[] schemeIds = new Object[schemes.size()];
        for (int i = 0; i < schemes.size(); ++i) {
            schemeIds[i] = schemes.get(i).getId();
        }
        for (DynamicObject scheme : saveableSchemes = this.ormFacade.load(schemeIds, schemeDt)) {
            scheme.set("bizstate", (Object)"initing");
        }
        SaveServiceHelper.save((DynamicObject[])saveableSchemes);
        return saveableSchemes;
    }

    private boolean checkWithPreviewResults(List<CreditArchive> allArchives) {
        int rowCount = this.getModel().getEntryRowCount("entry");
        if (allArchives.size() != rowCount) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u91cd\u7b97\u7ed3\u679c\u4e0e\u9884\u89c8\u7ed3\u679c\u4e0d\u4e00\u81f4\uff0c\u8bf7\u91cd\u65b0\u9884\u89c8\u540e\u786e\u8ba4\u8ba1\u7b97\u3002", (String)"RecalculateEdit_1", (String)"scmc-ccm-formplugin", (Object[])new Object[0]));
            return true;
        }
        for (int i = 0; i < rowCount; ++i) {
            String dimensionValue;
            DynamicObject scheme = (DynamicObject)this.getModel().getValue("scheme", i);
            long schemeId = scheme.getLong("id");
            CreditArchive matchedArchive = this.matchArchive(allArchives, schemeId, dimensionValue = (String)this.getModel().getValue("dimensionvalue", i));
            if (matchedArchive == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u91cd\u7b97\u7ed3\u679c\u4e0e\u9884\u89c8\u7ed3\u679c\u4e0d\u4e00\u81f4\uff0c\u8bf7\u91cd\u65b0\u9884\u89c8\u540e\u786e\u8ba4\u8ba1\u7b97\u3002", (String)"RecalculateEdit_1", (String)"scmc-ccm-formplugin", (Object[])new Object[0]));
                return true;
            }
            DynamicObject currency = (DynamicObject)this.getModel().getValue("currency", i);
            int precision = currency != null ? currency.getInt("amtprecision") : 4;
            BigDecimal oldBalance = matchedArchive.getOldBalance().setScale(precision, RoundingMode.HALF_UP);
            BigDecimal balance = matchedArchive.getBalance().setScale(precision, RoundingMode.HALF_UP);
            BigDecimal rowOldBalance = ((BigDecimal)this.getModel().getValue("oldbalance", i)).setScale(precision, RoundingMode.HALF_UP);
            BigDecimal rowNewBalance = ((BigDecimal)this.getModel().getValue("newbalance", i)).setScale(precision, RoundingMode.HALF_UP);
            if (rowOldBalance.compareTo(oldBalance) == 0 && rowNewBalance.compareTo(balance) == 0) continue;
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u91cd\u7b97\u7ed3\u679c\u4e0e\u9884\u89c8\u7ed3\u679c\u4e0d\u4e00\u81f4\uff0c\u8bf7\u91cd\u65b0\u9884\u89c8\u540e\u786e\u8ba4\u8ba1\u7b97\u3002", (String)"RecalculateEdit_1", (String)"scmc-ccm-formplugin", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    private CreditArchive matchArchive(List<CreditArchive> allArchives, long schemeId, String dimensionValue) {
        for (CreditArchive archive : allArchives) {
            if (schemeId != archive.getScheme().getId() || !Objects.equals(archive.getDimensionValue().getValue(), dimensionValue)) continue;
            return archive;
        }
        return null;
    }

    private void showResults(List<CreditArchive> allArchives) {
        this.getModel().deleteEntryData("entry");
        if (allArchives == null || allArchives.isEmpty()) {
            return;
        }
        DynamicObject dimension = (DynamicObject)this.getModel().getValue("dimension");
        DimensionEntryFieldMapper roleFieldMapper = new DimensionEntryFieldMapper(dimension.getPkValue());
        this.getModel().batchCreateNewEntryRow("entry", allArchives.size());
        for (int i = 0; i < allArchives.size(); ++i) {
            CreditArchive archive = allArchives.get(i);
            String quotaType = archive.getQuotaType();
            DimensionValue dimensionValue = archive.getDimensionValue();
            List roles = dimensionValue.getDimension().getRoles();
            this.getModel().setValue("scheme", (Object)archive.getScheme().getId(), i);
            this.getModel().setValue("dimensionvalue", (Object)dimensionValue.getValue(), i);
            if ("amount".equals(quotaType)) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"quota", "currency", "oldbalance", "newbalance"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"quantity", "measureunit", "oldquantity", "newquantity"});
                this.getModel().setValue("quota", (Object)archive.getQuota(), i);
                this.getModel().setValue("currency", (Object)archive.getUnit(), i);
                this.getModel().setValue("oldbalance", (Object)archive.getOldBalance(), i);
                this.getModel().setValue("newbalance", (Object)archive.getBalance(), i);
            } else if ("qty".equals(quotaType)) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"quota", "currency", "oldbalance", "newbalance"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"quantity", "measureunit", "oldquantity", "newquantity"});
                this.getModel().setValue("quantity", (Object)archive.getQuota(), i);
                this.getModel().setValue("measureunit", (Object)archive.getUnit(), i);
                this.getModel().setValue("oldquantity", (Object)archive.getOldBalance(), i);
                this.getModel().setValue("newquantity", (Object)archive.getBalance(), i);
            }
            for (Role role : roles) {
                String fieldKey = roleFieldMapper.getRoleFieldKey(role.getRoleType());
                Object roleValue = dimensionValue.getValue(role);
                this.getModel().setValue(fieldKey, (Object)Long.valueOf(roleValue.toString()), i);
            }
        }
    }

    private String getDimensionRangeMode() {
        return (String)this.getModel().getValue("dimensionrangemode");
    }

    private List<DimensionValue> getDimensionValues(CreditScheme scheme) {
        LinkedList<DimensionValue> dimensionValues = new LinkedList<DimensionValue>();
        if ("ALL".equals(this.getDimensionRangeMode())) {
            return dimensionValues;
        }
        DynamicObject dimensionObj = scheme.getRawScheme().getDynamicObject("dimension");
        DimensionEntryFieldMapper roleFieldMapper = new DimensionEntryFieldMapper(dimensionObj.getPkValue());
        List roleTypes = roleFieldMapper.getRoleNumbers();
        Dimension dimension = scheme.getDimension();
        if (roleTypes.size() == 1) {
            String roleFilterKey = roleFieldMapper.getRoleFilterKey((String)roleTypes.get(0));
            DynamicObjectCollection dimensionValueObjs = (DynamicObjectCollection)this.getModel().getValue(roleFilterKey);
            if (dimensionValueObjs.size() == 0) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7ef4\u5ea6\u53d6\u503c\u3002", (String)"RecalculateEdit_2", (String)"scmc-ccm-formplugin", (Object[])new Object[0]));
            }
            for (DynamicObject customer : dimensionValueObjs) {
                DimensionValue dimensionValue = new DimensionValue(dimension);
                dimensionValue.setValue(customer.getString("fbasedataid.masterid"));
                dimensionValues.add(dimensionValue);
            }
        } else {
            DimensionValue dimensionValue = new DimensionValue(dimension);
            for (Role role : dimension.getRoles()) {
                String roleFilterKey = roleFieldMapper.getRoleFilterKey(role.getRoleType());
                DynamicObjectCollection dimensionValueObjs = (DynamicObjectCollection)this.getModel().getValue(roleFilterKey);
                if (dimensionValueObjs.size() == 0) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7ef4\u5ea6\u53d6\u503c\u3002", (String)"RecalculateEdit_2", (String)"scmc-ccm-formplugin", (Object[])new Object[0]));
                }
                if (dimensionValueObjs.size() > 1) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u7ec4\u5408\u7ef4\u5ea6\u4e0d\u5141\u8bb8\u591a\u9009\u3002", (String)"RecalculateEdit_3", (String)"scmc-ccm-formplugin", (Object[])new Object[0]));
                }
                dimensionValue.putValue(role, (Object)((DynamicObject)dimensionValueObjs.get(0)).getString("fbasedataid.masterid"));
            }
            dimensionValues.add(dimensionValue);
        }
        return dimensionValues;
    }

    private List<CreditScheme> getSchemes() {
        ArrayList<CreditScheme> schemes = new ArrayList<CreditScheme>();
        DynamicObjectCollection rawSchemes = (DynamicObjectCollection)this.getModel().getValue("schemes");
        for (DynamicObject rawScheme : rawSchemes) {
            long schemeId = rawScheme.getLong("fbasedataid.id");
            CreditScheme scheme = this.schemeReader.getScheme(schemeId);
            schemes.add(scheme);
        }
        return schemes;
    }

    private boolean checkSchemes(List<CreditScheme> schemes) {
        if (schemes == null || schemes.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4fe1\u63a7\u65b9\u6848\u3002", (String)"RecalculateEdit_6", (String)"scmc-ccm-formplugin", (Object[])new Object[0]));
            return false;
        }
        Set dimensionIds = schemes.stream().map(scheme -> scheme.getDimension().getId()).collect(Collectors.toSet());
        if (dimensionIds.size() > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u65b9\u6848\u5fc5\u987b\u5177\u6709\u76f8\u540c\u7684\u4fe1\u7528\u7ba1\u7406\u7ef4\u5ea6\u3002", (String)"RecalculateEdit_5", (String)"scmc-ccm-formplugin", (Object[])new Object[0]));
            return false;
        }
        Set quotaTypes = schemes.stream().map(scheme -> scheme.getQuotaType().getQuotaType()).collect(Collectors.toSet());
        if (quotaTypes.size() > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u65b9\u6848\u5fc5\u987b\u5177\u6709\u76f8\u540c\u7684\u4fe1\u7528\u63a7\u5236\u5f62\u5f0f\u3002", (String)"RecalculateEdit_7", (String)"scmc-ccm-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.setDimensionControlsVisibility();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        ChangeData[] valueSet = e.getChangeSet();
        for (int i = 0; i < valueSet.length; ++i) {
            if (!CommonUtils.isRealChanged((ChangeData)valueSet[i])) continue;
            if ("schemes".equals(name)) {
                HashSet<Long> dimensionIds = new HashSet<Long>(1);
                DynamicObjectCollection schemes = (DynamicObjectCollection)this.getModel().getValue("schemes");
                for (DynamicObject scheme : schemes) {
                    dimensionIds.add(scheme.getLong("fbasedataid.dimension.id"));
                }
                if (dimensionIds.size() == 1) {
                    Long first = (Long)dimensionIds.iterator().next();
                    this.getModel().setValue("dimension", (Object)first);
                    continue;
                }
                this.getModel().setValue("dimension", null);
                continue;
            }
            if ("dimensionrangemode".equals(name)) {
                this.setDimensionControlsVisibility();
                continue;
            }
            if (!"dimension".equals(name)) continue;
            DynamicObject dimension = (DynamicObject)this.getModel().getValue("dimension");
            if (dimension == null) {
                this.getPageCache().remove("dimensionid");
            } else {
                this.getPageCache().put("dimensionid", dimension.getString("id"));
            }
            this.setDimensionControlsVisibility();
            this.clearDimensionRoleValue();
        }
    }

    private void clearDimensionRoleValue() {
        List<String> filterRoleControlKeys = this.getAllFilterControlKeys();
        for (String roleProKey : filterRoleControlKeys) {
            this.getModel().setValue(roleProKey, null);
        }
    }

    private void setDimensionControlsVisibility() {
        LinkedList<String> hideableKeys = new LinkedList<String>();
        LinkedList<String> visiableKeys = new LinkedList<String>();
        List<String> filterControlKeys = this.getAllFilterControlKeys();
        hideableKeys.addAll(filterControlKeys);
        String[] allRoleFields = BillEntityHelper.getAllRoleFields();
        hideableKeys.addAll(Arrays.asList(allRoleFields));
        DynamicObject dimension = (DynamicObject)this.getModel().getValue("dimension");
        if (dimension != null) {
            DimensionEntryFieldMapper roleFieldMapper = new DimensionEntryFieldMapper(dimension.getPkValue());
            List roleTypes = roleFieldMapper.getRoleNumbers();
            String dimensionRangeMode = this.getDimensionRangeMode();
            if (!"ALL".equals(dimensionRangeMode)) {
                String[] visiableFilterKeys = new String[roleTypes.size()];
                for (int i = 0; i < roleTypes.size(); ++i) {
                    String roleType = (String)roleTypes.get(i);
                    String roleFilterKey = roleFieldMapper.getRoleFilterKey(roleType);
                    FieldEdit control = (FieldEdit)this.getControl(roleFilterKey);
                    control.setCaption(roleFieldMapper.getRoleDisplayName(roleFieldMapper.getRoleFieldKey(roleType)));
                    visiableFilterKeys[i] = roleFilterKey;
                    hideableKeys.remove(roleFilterKey);
                    visiableKeys.add(roleFilterKey);
                }
            }
            for (String roleType : roleTypes) {
                String fieldKey = roleFieldMapper.getRoleFieldKey(roleType);
                FieldEdit control = (FieldEdit)this.getControl(fieldKey);
                control.setCaption(roleFieldMapper.getRoleDisplayName(fieldKey));
                hideableKeys.remove(fieldKey);
                visiableKeys.add(fieldKey);
            }
        }
        if (!hideableKeys.isEmpty()) {
            this.getView().setVisible(Boolean.FALSE, hideableKeys.toArray(new String[0]));
        }
        if (!visiableKeys.isEmpty()) {
            this.getView().setVisible(Boolean.TRUE, visiableKeys.toArray(new String[0]));
        }
    }

    private List<String> getAllFilterControlKeys() {
        LinkedList<String> filterControlKeys = new LinkedList<String>();
        MainEntityType dataEntityType = this.getModel().getDataEntityType();
        DataEntityPropertyCollection properties = dataEntityType.getProperties();
        for (IDataEntityProperty prop : properties) {
            if (!(prop instanceof MulBasedataProp) || "schemes".equals(prop.getName()) || !prop.getName().endsWith("_s")) continue;
            filterControlKeys.add(prop.getName());
        }
        filterControlKeys.remove("mulbasedatafield");
        return filterControlKeys;
    }

    public void hyperLinkClick(HyperLinkClickEvent arg0) {
        FormShowParameter fsp = new FormShowParameter();
        fsp.setFormId("ccm_recaldetailpreview");
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        int rowIndex = arg0.getRowIndex();
        DynamicObject scheme = (DynamicObject)this.getModel().getValue("scheme");
        String dimensionValue = (String)this.getModel().getValue("dimensionvalue", rowIndex);
        String checkType = scheme.getDynamicObject("checktype").getString("number");
        fsp.setCustomParam("schemeid", (Object)scheme.getString("id"));
        fsp.setCustomParam("dimensionid", (Object)this.getPageCache().get("dimensionid"));
        fsp.setCustomParam("dimensionvalue", (Object)dimensionValue);
        fsp.setCustomParam("checktype", (Object)checkType);
        this.getView().showForm(fsp);
    }

    private void schemesFilter() {
        BasedataEdit schemesF7 = (BasedataEdit)this.getView().getControl("schemes");
        schemesF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            QFilter filter = new QFilter("checktype.number", "=", (Object)"KZFW001").or(new QFilter("checktype.number", "=", (Object)"KZFW003"));
            HasPermOrgResult permOrgResult = PermissionHelper.getAllPermOrgs((String)"ccm_recalculate", (String)"0K6+MBJG6TZL");
            if (!permOrgResult.hasAllOrgPerm()) {
                filter.and("mainorg", "in", (Object)permOrgResult.getHasPermOrgs());
            }
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            ListFilterParameter listFilterParameter = showParameter.getListFilterParameter();
            listFilterParameter.setFilter(filter);
        });
    }

    public void getEntityType(GetEntityTypeEventArgs e) {
        super.getEntityType(e);
        MainEntityType originalEntityType = e.getOriginalEntityType();
        String dimensionIdStr = this.getPageCache().get("dimensionid");
        if (StringUtils.isBlank((CharSequence)dimensionIdStr)) {
            return;
        }
        MainEntityType newEntityType = null;
        try {
            newEntityType = (MainEntityType)originalEntityType.clone();
        }
        catch (CloneNotSupportedException e1) {
            throw new RuntimeException(e1);
        }
        DimensionEntryFieldMapper dimensionEntryFieldMapper = new DimensionEntryFieldMapper((Object)Long.valueOf(dimensionIdStr));
        List roleNumbers = dimensionEntryFieldMapper.getRoleNumbers();
        for (String roleNumber : roleNumbers) {
            String fieldTypeKey = dimensionEntryFieldMapper.getFieldTypeKey(roleNumber);
            String roleFieldKey = dimensionEntryFieldMapper.getRoleFieldKey(roleNumber);
            String baseDataKey = dimensionEntryFieldMapper.getBaseDataKey(fieldTypeKey);
            String roleFilterKey = dimensionEntryFieldMapper.getRoleFilterKey(roleNumber);
            MulBasedataProp prop = (MulBasedataProp)newEntityType.getProperty(roleFilterKey);
            prop.setBaseEntityId(baseDataKey);
            BasedataProp bPropMul = (BasedataProp)prop.getItemType().getProperties().get((Object)"fbasedataid");
            bPropMul.setBaseEntityId(baseDataKey);
            MainEntityType basedataType = EntityMetadataCache.getDataEntityType((String)baseDataKey);
            bPropMul.setComplexType((IDataEntityType)basedataType);
            DynamicProperty refProp = prop.getDynamicCollectionItemPropertyType().getProperty("fbasedataid_id");
            bPropMul.setRefIdProp((IDataEntityProperty)refProp);
            bPropMul.setRefIdPropName(refProp.getName());
            EntryProp entryProp = (EntryProp)newEntityType.getProperty("entry");
            BasedataProp roleProp = (BasedataProp)entryProp._collectionItemPropertyType.getProperty(roleFieldKey);
            roleProp.setBaseEntityId(baseDataKey);
            roleProp.setComplexType((IDataEntityType)basedataType);
        }
        e.setNewEntityType(newEntityType);
    }
}

