/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ccm.formplugin.recalculatenew;

import java.util.Arrays;
import java.util.EventObject;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scmc.ccm.business.core.DimensionValue;
import kd.scmc.ccm.business.core.Role;
import kd.scmc.ccm.business.recalculatenew.record.RecalculateRecordHelper;
import kd.scmc.ccm.business.scheme.CreditScheme;
import kd.scmc.ccm.business.scheme.SchemeReader;
import kd.scmc.ccm.business.setting.DimensionEntryFieldMapper;
import kd.scmc.ccm.common.helper.BillEntityHelper;

public class RecDetailPreviewPlugin
extends AbstractFormPlugin {
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String schemeIdStr = (String)customParams.get("schemeid");
        if (!StringUtils.isBlank((CharSequence)schemeIdStr)) {
            Long schemeId = Long.parseLong(schemeIdStr);
            SchemeReader schemeReader = new SchemeReader();
            CreditScheme scheme = schemeReader.getScheme(schemeId.longValue());
            QFilter s = new QFilter("scheme", "=", (Object)schemeId);
            String recrecordIdStr = (String)customParams.get("recrecordid");
            Long recrecordId = StringUtils.isBlank((CharSequence)recrecordIdStr) ? 0L : Long.parseLong(recrecordIdStr);
            QFilter r = new QFilter("recrecordid", "=", (Object)recrecordId);
            String dimensionValueStr = (String)customParams.get("dimensionvalue");
            QFilter d = new QFilter("dimensionvalue", "=", (Object)(StringUtils.isBlank((CharSequence)dimensionValueStr) ? "" : dimensionValueStr));
            DimensionValue dimensionValue = new DimensionValue(scheme.getDimension());
            dimensionValue.setValue(dimensionValueStr);
            DynamicObject dimension = scheme.getRawScheme().getDynamicObject("dimension");
            List roles = scheme.getDimension().getRoles();
            DimensionEntryFieldMapper roleFieldMapper = new DimensionEntryFieldMapper(dimension.getPkValue());
            this.controlMultiRoleFields(roleFieldMapper, roles);
            String selectors = RecalculateRecordHelper.getDetailsSelector((CreditScheme)scheme);
            DynamicObject[] recDetailInfoDOs = BusinessDataServiceHelper.load((String)"ccm_recalculatedetail", (String)selectors, (QFilter[])new QFilter[]{s, r, d});
            this.showResults(recDetailInfoDOs, roles, roleFieldMapper, dimensionValue);
        }
    }

    private void showResults(DynamicObject[] recDetailInfoDOs, List<Role> roles, DimensionEntryFieldMapper roleFieldMapper, DimensionValue dimensionValue) {
        if (ObjectUtils.isEmpty((Object[])recDetailInfoDOs)) {
            return;
        }
        this.getModel().batchCreateNewEntryRow("entry", recDetailInfoDOs.length);
        for (int i = 0; i < recDetailInfoDOs.length; ++i) {
            DynamicObject recDetailInfo = recDetailInfoDOs[i];
            this.getModel().setValue("entity", recDetailInfo.get("entitykey"), i);
            this.getModel().setValue("billno", recDetailInfo.get("billno"), i);
            this.getModel().setValue("direction", recDetailInfo.get("direction"), i);
            this.getModel().setValue("originalunit", recDetailInfo.get("originalunit"), i);
            this.getModel().setValue("originalamount", recDetailInfo.get("originalamount"), i);
            this.getModel().setValue("unit", recDetailInfo.get("unit"), i);
            this.getModel().setValue("amount", recDetailInfo.get("amount"), i);
            for (Role role : roles) {
                String fieldKey = roleFieldMapper.getRoleFieldKey(role.getRoleType());
                Object roleValue = dimensionValue.getValue(role);
                this.getModel().setValue(fieldKey, (Object)Long.valueOf(roleValue.toString()), i);
            }
        }
    }

    private void controlMultiRoleFields(DimensionEntryFieldMapper roleFieldMapper, List<Role> roles) {
        LinkedList<String> hideableKeys = new LinkedList<String>();
        LinkedList<String> visiableKeys = new LinkedList<String>();
        String[] allRoleFields = BillEntityHelper.getAllRoleFields();
        hideableKeys.addAll(Arrays.asList(allRoleFields));
        for (Role role : roles) {
            String roleType = role.getRoleType();
            String fieldKey = roleFieldMapper.getRoleFieldKey(roleType);
            FieldEdit control = (FieldEdit)this.getControl(fieldKey);
            control.setCaption(roleFieldMapper.getRoleDisplayName(fieldKey));
            visiableKeys.add(fieldKey);
            hideableKeys.remove(fieldKey);
        }
        if (!hideableKeys.isEmpty()) {
            this.getView().setVisible(Boolean.FALSE, hideableKeys.toArray(new String[0]));
        }
        if (!visiableKeys.isEmpty()) {
            this.getView().setVisible(Boolean.TRUE, visiableKeys.toArray(new String[0]));
        }
    }

    public void getEntityType(GetEntityTypeEventArgs e) {
        super.getEntityType(e);
        MainEntityType originalEntityType = e.getOriginalEntityType();
        String dimensionIdStr = (String)this.getView().getFormShowParameter().getCustomParam("dimensionid");
        if (StringUtils.isBlank((CharSequence)dimensionIdStr)) {
            return;
        }
        MainEntityType newEntityType = null;
        try {
            newEntityType = (MainEntityType)originalEntityType.clone();
        }
        catch (CloneNotSupportedException e1) {
            throw new RuntimeException(e1);
        }
        DimensionEntryFieldMapper dimensionEntryFieldMapper = new DimensionEntryFieldMapper((Object)Long.valueOf(dimensionIdStr));
        List roleNumbers = dimensionEntryFieldMapper.getRoleNumbers();
        for (String roleNumber : roleNumbers) {
            String fieldTypeKey = dimensionEntryFieldMapper.getFieldTypeKey(roleNumber);
            String roleFieldKey = dimensionEntryFieldMapper.getRoleFieldKey(roleNumber);
            String baseDataKey = dimensionEntryFieldMapper.getBaseDataKey(fieldTypeKey);
            MainEntityType basedataType = EntityMetadataCache.getDataEntityType((String)baseDataKey);
            EntryProp entryProp = (EntryProp)newEntityType.getProperty("entry");
            BasedataProp roleProp = (BasedataProp)entryProp._collectionItemPropertyType.getProperty(roleFieldKey);
            roleProp.setBaseEntityId(baseDataKey);
            roleProp.setComplexType((IDataEntityType)basedataType);
        }
        e.setNewEntityType(newEntityType);
    }
}

