/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ccm.formplugin.recalculatenew;

import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.scmc.ccm.business.archives.CreditArchive;
import kd.scmc.ccm.business.core.Dimension;
import kd.scmc.ccm.business.core.DimensionValue;
import kd.scmc.ccm.business.core.Role;
import kd.scmc.ccm.business.scheme.CreditScheme;
import kd.scmc.ccm.business.scheme.SchemeReader;
import kd.scmc.ccm.business.service.CreditServiceFacade;
import kd.scmc.ccm.business.setting.DimensionEntryFieldMapper;
import kd.scmc.ccm.common.helper.BillEntityHelper;
import kd.scmc.ccm.common.helper.PermissionHelper;
import kd.scmc.ccm.common.util.CommonUtils;

public class RecalculateNewEditPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener,
HyperLinkClickListener {
    private CreditServiceFacade serviceFacade = new CreditServiceFacade();
    private SchemeReader schemeReader = new SchemeReader();
    private static final String TOOBARAP = "toolbarap";
    private static final String CACHE_SCHEME = "cache_scheme";
    private static final String CACHE_DIMENSIONRMODE = "cache_dimensionrmode";

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.setDimensionControlsVisibility();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit schemeF7 = (BasedataEdit)this.getView().getControl("scheme");
        schemeF7.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        this.addItemClickListeners(new String[]{TOOBARAP});
        EntryGrid control = (EntryGrid)this.getControl("entry");
        control.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        ChangeData[] valueSet = e.getChangeSet();
        List<String> roleFilterKeys = this.getAllFilterControlKeys();
        for (int i = 0; i < valueSet.length; ++i) {
            if (!CommonUtils.isRealChanged((ChangeData)valueSet[i])) continue;
            ChangeData changeData = valueSet[i];
            Object oldValue = changeData.getOldValue();
            if ("scheme".equalsIgnoreCase(name)) {
                this.changeScheme(oldValue);
                continue;
            }
            if ("dimensionrangemode".equalsIgnoreCase(name)) {
                this.changeDimensionMode(oldValue);
                continue;
            }
            if ("dimension".equalsIgnoreCase(name)) {
                DynamicObject dimension = (DynamicObject)this.getModel().getValue("dimension");
                if (dimension == null) {
                    this.getPageCache().remove("dimensionid");
                } else {
                    this.getPageCache().put("dimensionid", dimension.getString("id"));
                }
                this.setDimensionControlsVisibility();
                this.clearDimensionRoleValue();
                continue;
            }
            if (!roleFilterKeys.contains(name)) continue;
            this.changeRoles(oldValue, name);
        }
    }

    private void changeScheme(Object oldValue) {
        DynamicObject scheme_old = (DynamicObject)oldValue;
        if (this.getModel().getEntryRowCount("entry") > 0) {
            ConfirmCallBackListener confirmCallBack = new ConfirmCallBackListener("changeScheme", (IFormPlugin)this);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u5207\u6362\u201c\u4fe1\u63a7\u65b9\u6848\u201d\u5c06\u6e05\u9664\u91cd\u7b97\u4fe1\u606f\uff0c\u662f\u5426\u5207\u6362\uff1f", (String)"RecalculateNewEditPlugin_0", (String)"scmc-ccm-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, ConfirmTypes.Default, confirmCallBack);
            this.getView().getPageCache().put(CACHE_SCHEME, scheme_old == null ? null : scheme_old.getPkValue().toString());
        } else {
            this.resetRecalParam("scheme");
        }
    }

    private void changeDimensionMode(Object oldValue) {
        String dimensionMode_old = (String)oldValue;
        if (this.getModel().getEntryRowCount("entry") > 0) {
            ConfirmCallBackListener confirmCallBack = new ConfirmCallBackListener("changeDimensionRMode", (IFormPlugin)this);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u5207\u6362\u201c\u7ef4\u5ea6\u8303\u56f4\u201d\u5c06\u6e05\u9664\u91cd\u7b97\u4fe1\u606f\uff0c\u662f\u5426\u5207\u6362\uff1f", (String)"RecalculateNewEditPlugin_1", (String)"scmc-ccm-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, ConfirmTypes.Default, confirmCallBack);
            this.getView().getPageCache().put(CACHE_DIMENSIONRMODE, dimensionMode_old == null ? null : dimensionMode_old);
        } else {
            this.resetRecalParam("dimensionrangemode");
        }
    }

    private void changeRoles(Object oldValue, String roleFilterKey) {
        MulBasedataDynamicObjectCollection roles_old = (MulBasedataDynamicObjectCollection)oldValue;
        if (this.getModel().getEntryRowCount("entry") > 0) {
            ConfirmCallBackListener confirmCallBack = new ConfirmCallBackListener(roleFilterKey, (IFormPlugin)this);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u5207\u6362\u201c\u7ef4\u5ea6\u6210\u5458\u503c\u201d\u5c06\u6e05\u9664\u91cd\u7b97\u4fe1\u606f\uff0c\u662f\u5426\u5207\u6362\uff1f", (String)"RecalculateNewEditPlugin_12", (String)"scmc-ccm-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, ConfirmTypes.Default, confirmCallBack);
            if (roles_old != null && roles_old.size() > 0) {
                StringBuilder roleIds = new StringBuilder();
                for (DynamicObject role : roles_old) {
                    if (role.getDynamicObject("fbasedataid") == null) continue;
                    roleIds.append((Long)role.getDynamicObject("fbasedataid").getPkValue()).append(',');
                }
                this.getView().getPageCache().put(roleFilterKey, roleIds.length() > 1 ? roleIds.deleteCharAt(roleIds.length() - 1).toString() : null);
            } else {
                this.getView().getPageCache().put(roleFilterKey, null);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        if (e.getOperationResult().isSuccess()) {
            String opkey;
            switch (opkey = e.getOperateKey()) {
                case "recalculate": {
                    if (this.checkIsExistLastUnsavedResult()) {
                        ConfirmCallBackListener recalConfirmCallBack = new ConfirmCallBackListener("recal", (IFormPlugin)this);
                        HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>();
                        btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u8fd4\u56de\u786e\u8ba4", (String)"RecalculateNewEditPlugin_3", (String)"scmc-ccm-formplugin", (Object[])new Object[0]));
                        btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u7ee7\u7eed\u91cd\u7b97", (String)"RecalculateNewEditPlugin_4", (String)"scmc-ccm-formplugin", (Object[])new Object[0]));
                        MessageBoxOptions options1 = MessageBoxOptions.OKCancel;
                        this.getView().showConfirm(ResManager.loadKDString((String)"\u4e0a\u6b21\u91cd\u7b97\u7ed3\u679c\u672a\u786e\u8ba4\uff0c\u7ee7\u7eed\u91cd\u7b97\u5c06\u6e05\u9664\u4e0a\u6b21\u91cd\u7b97\u7ed3\u679c\uff0c\u662f\u5426\u7ee7\u7eed\u91cd\u7b97\uff1f", (String)"RecalculateNewEditPlugin_5", (String)"scmc-ccm-formplugin", (Object[])new Object[0]), "", options1, ConfirmTypes.Default, recalConfirmCallBack, btnNameMaps);
                        break;
                    }
                    this.recalculate();
                    break;
                }
                case "confirm": {
                    if (!this.checkMustRecalFirst()) break;
                    ConfirmCallBackListener confirmCallBack = new ConfirmCallBackListener("confirm", (IFormPlugin)this);
                    MessageBoxOptions options2 = MessageBoxOptions.OKCancel;
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u4fe1\u7528\u91cd\u7b97\u7ed3\u679c\u5c06\u8986\u76d6\u539f\u5148\u7684\u4fe1\u7528\u6d41\u6c34\u548c\u6863\u6848\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"RecalculateNewEditPlugin_7", (String)"scmc-ccm-formplugin", (Object[])new Object[0]), options2, ConfirmTypes.Default, confirmCallBack);
                    break;
                }
            }
        }
    }

    public void beforeItemClick(BeforeItemClickEvent e) {
        super.beforeItemClick(e);
        String barItemKey = e.getItemKey();
        if ("bar_close".equals(barItemKey) && this.checkIsExistLastUnsavedResult()) {
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("close", (IFormPlugin)this);
            MessageBoxOptions options = MessageBoxOptions.YesNo;
            this.getView().showConfirm(ResManager.loadKDString((String)"\u60a8\u4e0a\u6b21\u91cd\u7b97\u7ed3\u679c\u672a\u786e\u8ba4\uff0c\u9000\u51fa\u5c06\u6e05\u9664\u4e0a\u6b21\u91cd\u7b97\u7ed3\u679c\uff0c\u662f\u5426\u7ee7\u7eed\u9000\u51fa\uff1f", (String)"RecalculateNewEditPlugin_6", (String)"scmc-ccm-formplugin", (Object[])new Object[0]), options, ConfirmTypes.Default, confirmCallBacks);
            e.setCancel(true);
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        List<String> filterRoleControlKeys = this.getAllFilterControlKeys();
        String callBackId = e.getCallBackId();
        if ("recal".equals(callBackId)) {
            if (!e.getResult().equals((Object)MessageBoxResult.Yes)) return;
            this.clearLastUnsavedResult();
            this.recalculate();
            return;
        } else if ("confirm".equals(callBackId)) {
            if (!e.getResult().equals((Object)MessageBoxResult.Yes)) return;
            this.confirm();
            return;
        } else if (e.getCallBackId().equals("close")) {
            if (!e.getResult().equals((Object)MessageBoxResult.Yes)) return;
            this.clearLastUnsavedResult();
            this.getView().close();
            return;
        } else if ("changeScheme".equals(callBackId)) {
            if (e.getResult().equals((Object)MessageBoxResult.Yes)) {
                this.clearLastUnsavedResult();
                this.resetRecalParam("scheme");
                return;
            } else {
                String schemeID = this.getView().getPageCache().get(CACHE_SCHEME);
                this.getModel().beginInit();
                this.getModel().setValue("scheme", schemeID == null ? null : Long.valueOf(Long.parseLong(schemeID)));
                this.getModel().endInit();
                this.getView().updateView("scheme");
            }
            return;
        } else if ("changeDimensionRMode".equals(callBackId)) {
            if (e.getResult().equals((Object)MessageBoxResult.Yes)) {
                this.clearLastUnsavedResult();
                this.resetRecalParam("dimensionrangemode");
                return;
            } else {
                String dimensionMode = this.getView().getPageCache().get(CACHE_DIMENSIONRMODE);
                this.getModel().beginInit();
                this.getModel().setValue("dimensionrangemode", (Object)(dimensionMode == null ? null : dimensionMode));
                this.getModel().endInit();
                this.getView().updateView("dimensionrangemode");
            }
            return;
        } else {
            if (!filterRoleControlKeys.contains(callBackId)) return;
            if (e.getResult().equals((Object)MessageBoxResult.Yes)) {
                this.clearLastUnsavedResult();
                return;
            } else {
                String roleids_old = this.getView().getPageCache().get(callBackId);
                this.getModel().beginInit();
                if (roleids_old == null) {
                    this.getModel().setValue(callBackId, null);
                } else {
                    String[] roleidStrs = roleids_old.split(",");
                    MulBasedataProp roleMulPro = (MulBasedataProp)this.getModel().getProperty(callBackId);
                    roleMulPro.getBaseEntityId();
                    this.getModel().setValue(callBackId, (Object)roleidStrs);
                }
                this.getModel().endInit();
                this.getView().updateView(callBackId);
            }
        }
    }

    private void resetRecalParam(String paramKey) {
        switch (paramKey) {
            case "scheme": {
                DynamicObject scheme = (DynamicObject)this.getModel().getValue("scheme");
                if (scheme == null) {
                    this.getModel().setValue("dimension", null);
                } else {
                    this.getModel().setValue("dimension", (Object)scheme.getLong("dimension.id"));
                }
                this.getModel().setValue("dimensionrangemode", (Object)"ALL");
                break;
            }
            case "dimensionrangemode": {
                this.setDimensionControlsVisibility();
                this.clearDimensionRoleValue();
            }
        }
    }

    private void recalculate() {
        DynamicObject rawScheme = (DynamicObject)this.getModel().getValue("scheme");
        if (rawScheme == null) {
            return;
        }
        long schemeId = rawScheme.getLong("id");
        CreditScheme scheme = this.schemeReader.getScheme(schemeId);
        if (!this.checkRolesValidate(scheme)) {
            return;
        }
        try (TXHandle tx = TX.requiresNew();){
            try {
                List<DimensionValue> dimensionValues = this.getDimensionValues(scheme);
                String dimensionRangeMode = this.getDimensionRangeMode();
                Date beginDate = (Date)this.getModel().getValue("begindate");
                Map recalResult = this.serviceFacade.recalculateNew(scheme, dimensionRangeMode, dimensionValues, beginDate);
                this.showResults(recalResult);
                if (recalResult != null && !recalResult.isEmpty()) {
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u8ba1\u7b97\u5b8c\u6210\u3002", (String)"RecalculateNewEditPlugin_8", (String)"scmc-ccm-formplugin", (Object[])new Object[0]));
                }
            }
            catch (Exception e) {
                tx.markRollback();
                throw e;
            }
        }
    }

    private void confirm() {
        try (TXHandle tx = TX.requiresNew();){
            String currentArchives = this.getPageCache().getBigObject("currentArchives");
            if (kd.bos.util.StringUtils.isBlank((String)currentArchives)) {
                return;
            }
            try {
                DynamicObject rawScheme = (DynamicObject)this.getModel().getValue("scheme");
                long schemeId = rawScheme.getLong("id");
                CreditScheme scheme = this.schemeReader.getScheme(schemeId);
                List<DimensionValue> dimensionValues = this.getDimensionValues(scheme);
                String dimensionRangeMode = this.getDimensionRangeMode();
                Long currentRecalRecordID = (Long)this.getModel().getValue("recrecordid");
                if (this.serviceFacade.recalculateConfirm(currentRecalRecordID, scheme, dimensionRangeMode, dimensionValues)) {
                    this.getModel().setValue("recrecordid", (Object)0L);
                    this.getModel().deleteEntryData("entry");
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u786e\u8ba4\u5b8c\u6210\u3002", (String)"RecalculateNewEditPlugin_9", (String)"scmc-ccm-formplugin", (Object[])new Object[0]));
                }
            }
            catch (Exception e) {
                tx.markRollback();
                throw e;
            }
        }
    }

    private void clearLastUnsavedResult() {
        long lastRecordID = (Long)this.getModel().getValue("recrecordid");
        if (lastRecordID > 0L) {
            DeleteServiceHelper.delete((String)"ccm_recalculatedetail", (QFilter[])new QFilter[]{new QFilter("recrecordid", "=", (Object)lastRecordID)});
            DeleteServiceHelper.delete((String)"ccm_recalculaterecord", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)lastRecordID)});
            this.getModel().setValue("recrecordid", (Object)0L);
        }
        this.getModel().deleteEntryData("entry");
        this.getView().updateView();
    }

    private boolean checkIsExistLastUnsavedResult() {
        long lastRecordID = (Long)this.getModel().getValue("recrecordid");
        if (lastRecordID > 0L) {
            QFilter qFilter1 = new QFilter("id", "=", (Object)lastRecordID);
            QFilter qFilter2 = new QFilter("recstatus", "=", (Object)"A");
            return QueryServiceHelper.exists((String)"ccm_recalculaterecord", (QFilter[])new QFilter[]{qFilter1, qFilter2});
        }
        return false;
    }

    private void showResults(Map<Long, List<CreditArchive>> recalResult) {
        this.getModel().deleteEntryData("entry");
        if (recalResult == null || recalResult.isEmpty()) {
            return;
        }
        DynamicObject dimension = (DynamicObject)this.getModel().getValue("dimension");
        DimensionEntryFieldMapper roleFieldMapper = new DimensionEntryFieldMapper(dimension.getPkValue());
        for (Map.Entry<Long, List<CreditArchive>> entry : recalResult.entrySet()) {
            this.getModel().setValue("recrecordid", (Object)entry.getKey());
            List<CreditArchive> allArchives = entry.getValue();
            if (allArchives != null && allArchives.size() > 0) {
                this.getModel().batchCreateNewEntryRow("entry", allArchives.size());
                for (int i = 0; i < allArchives.size(); ++i) {
                    CreditArchive archive = allArchives.get(i);
                    DimensionValue dimensionValue = archive.getDimensionValue();
                    List roles = dimensionValue.getDimension().getRoles();
                    this.getModel().setValue("dimensionvalue", (Object)dimensionValue.getValue(), i);
                    this.getModel().setValue("quota", (Object)archive.getQuota(), i);
                    this.getModel().setValue("currency", (Object)archive.getUnit(), i);
                    this.getModel().setValue("oldbalance", (Object)archive.getOldBalance(), i);
                    this.getModel().setValue("newbalance", (Object)archive.getBalance(), i);
                    for (Role role : roles) {
                        String fieldKey = roleFieldMapper.getRoleFieldKey(role.getRoleType());
                        Object roleValue = dimensionValue.getValue(role);
                        this.getModel().setValue(fieldKey, (Object)Long.valueOf(roleValue.toString()), i);
                    }
                }
            }
            this.getPageCache().putBigObject("currentArchives", SerializationUtils.toJsonString(allArchives));
        }
    }

    private String getDimensionRangeMode() {
        return (String)this.getModel().getValue("dimensionrangemode");
    }

    private List<DimensionValue> getDimensionValues(CreditScheme scheme) {
        LinkedList<DimensionValue> dimensionValues = new LinkedList<DimensionValue>();
        if ("ALL".equals(this.getDimensionRangeMode())) {
            return dimensionValues;
        }
        DynamicObject dimensionObj = scheme.getRawScheme().getDynamicObject("dimension");
        DimensionEntryFieldMapper roleFieldMapper = new DimensionEntryFieldMapper(dimensionObj.getPkValue());
        List roleTypes = roleFieldMapper.getRoleNumbers();
        Dimension dimension = scheme.getDimension();
        if (roleTypes.size() == 1) {
            String roleFilterKey = roleFieldMapper.getRoleFilterKey((String)roleTypes.get(0));
            DynamicObjectCollection dimensionValueObjs = (DynamicObjectCollection)this.getModel().getValue(roleFilterKey);
            if (dimensionValueObjs.size() == 0) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7ef4\u5ea6\u53d6\u503c\u3002", (String)"RecalculateNewEditPlugin_10", (String)"scmc-ccm-formplugin", (Object[])new Object[0]));
            }
            for (DynamicObject customer : dimensionValueObjs) {
                DimensionValue dimensionValue = new DimensionValue(dimension);
                dimensionValue.setValue(customer.getString("fbasedataid.masterid"));
                dimensionValues.add(dimensionValue);
            }
        } else {
            DimensionValue dimensionValue = new DimensionValue(dimension);
            for (Role role : dimension.getRoles()) {
                String roleFilterKey = roleFieldMapper.getRoleFilterKey(role.getRoleType());
                DynamicObjectCollection dimensionValueObjs = (DynamicObjectCollection)this.getModel().getValue(roleFilterKey);
                if (dimensionValueObjs.size() == 0) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7ef4\u5ea6\u53d6\u503c\u3002", (String)"RecalculateNewEditPlugin_10", (String)"scmc-ccm-formplugin", (Object[])new Object[0]));
                }
                if (dimensionValueObjs.size() > 1) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u7ec4\u5408\u7ef4\u5ea6\u53ea\u80fd\u9009\u62e9\u4e00\u4e2a\u3002", (String)"RecalculateNewEditPlugin_11", (String)"scmc-ccm-formplugin", (Object[])new Object[0]));
                }
                dimensionValue.putValue(role, (Object)((DynamicObject)dimensionValueObjs.get(0)).getString("fbasedataid.masterid"));
            }
            dimensionValues.add(dimensionValue);
        }
        return dimensionValues;
    }

    private boolean checkRolesValidate(CreditScheme scheme) {
        if ("ALL".equals(this.getDimensionRangeMode()) || scheme == null) {
            return true;
        }
        DynamicObject dimensionObj = scheme.getRawScheme().getDynamicObject("dimension");
        if (dimensionObj == null) {
            return true;
        }
        DimensionEntryFieldMapper roleFieldMapper = new DimensionEntryFieldMapper(dimensionObj.getPkValue());
        List roleTypes = roleFieldMapper.getRoleNumbers();
        Dimension dimension = scheme.getDimension();
        if (roleTypes.size() == 1) {
            String roleFilterKey = roleFieldMapper.getRoleFilterKey((String)roleTypes.get(0));
            DynamicObjectCollection dimensionValueObjs = (DynamicObjectCollection)this.getModel().getValue(roleFilterKey);
            if (dimensionValueObjs.size() == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7ef4\u5ea6\u53d6\u503c\u3002", (String)"RecalculateNewEditPlugin_10", (String)"scmc-ccm-formplugin", (Object[])new Object[0]));
                return false;
            }
        } else {
            for (Role role : dimension.getRoles()) {
                String roleFilterKey = roleFieldMapper.getRoleFilterKey(role.getRoleType());
                DynamicObjectCollection dimensionValueObjs = (DynamicObjectCollection)this.getModel().getValue(roleFilterKey);
                if (dimensionValueObjs.size() == 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7ef4\u5ea6\u53d6\u503c\u3002", (String)"RecalculateNewEditPlugin_10", (String)"scmc-ccm-formplugin", (Object[])new Object[0]));
                    return false;
                }
                if (dimensionValueObjs.size() <= 1) continue;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ec4\u5408\u7ef4\u5ea6\u53ea\u80fd\u9009\u62e9\u4e00\u4e2a\u3002", (String)"RecalculateNewEditPlugin_11", (String)"scmc-ccm-formplugin", (Object[])new Object[0]));
                return false;
            }
        }
        return true;
    }

    private boolean checkMustRecalFirst() {
        if (this.getModel().getEntryEntity("entry") == null || this.getModel().getEntryEntity("entry").getRowCount() < 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u91cd\u7b97\u7ed3\u679c\u4e3a\u7a7a\uff0c\u8bf7\u5148\u8fdb\u884c\u201c\u91cd\u7b97\u201d\u3002", (String)"RecalculateNewEditPlugin_14", (String)"scmc-ccm-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private void clearDimensionRoleValue() {
        List<String> filterRoleControlKeys = this.getAllFilterControlKeys();
        for (String roleProKey : filterRoleControlKeys) {
            this.getModel().setValue(roleProKey, null);
        }
    }

    private void setDimensionControlsVisibility() {
        LinkedList<String> hideableKeys = new LinkedList<String>();
        LinkedList<String> visiableKeys = new LinkedList<String>();
        List<String> filterControlKeys = this.getAllFilterControlKeys();
        hideableKeys.addAll(filterControlKeys);
        String[] allRoleFields = BillEntityHelper.getAllRoleFields();
        hideableKeys.addAll(Arrays.asList(allRoleFields));
        DynamicObject dimension = (DynamicObject)this.getModel().getValue("dimension");
        String dimensionRangeMode = this.getDimensionRangeMode();
        if (dimension != null) {
            DimensionEntryFieldMapper roleFieldMapper = new DimensionEntryFieldMapper(dimension.getPkValue());
            List roleTypes = roleFieldMapper.getRoleNumbers();
            if (!"ALL".equals(dimensionRangeMode)) {
                String[] visiableFilterKeys = new String[roleTypes.size()];
                for (int i = 0; i < roleTypes.size(); ++i) {
                    String roleType = (String)roleTypes.get(i);
                    String roleFilterKey = roleFieldMapper.getRoleFilterKey(roleType);
                    FieldEdit control = (FieldEdit)this.getControl(roleFilterKey);
                    control.setCaption(roleFieldMapper.getRoleDisplayName(roleFieldMapper.getRoleFieldKey(roleType)));
                    visiableFilterKeys[i] = roleFilterKey;
                    hideableKeys.remove(roleFilterKey);
                    visiableKeys.add(roleFilterKey);
                }
            }
            for (String roleType : roleTypes) {
                String fieldKey = roleFieldMapper.getRoleFieldKey(roleType);
                FieldEdit control = (FieldEdit)this.getControl(fieldKey);
                control.setCaption(roleFieldMapper.getRoleDisplayName(fieldKey));
                hideableKeys.remove(fieldKey);
                visiableKeys.add(fieldKey);
            }
        }
        if (!hideableKeys.isEmpty()) {
            this.getView().setVisible(Boolean.FALSE, hideableKeys.toArray(new String[0]));
        }
        if (!visiableKeys.isEmpty()) {
            this.getView().setVisible(Boolean.TRUE, visiableKeys.toArray(new String[0]));
        }
    }

    private List<String> getAllFilterControlKeys() {
        LinkedList<String> filterControlKeys = new LinkedList<String>();
        MainEntityType dataEntityType = this.getModel().getDataEntityType();
        DataEntityPropertyCollection properties = dataEntityType.getProperties();
        for (IDataEntityProperty prop : properties) {
            if (!(prop instanceof MulBasedataProp) || !prop.getName().endsWith("_s")) continue;
            filterControlKeys.add(prop.getName());
        }
        filterControlKeys.remove("mulbasedatafield");
        return filterControlKeys;
    }

    public void hyperLinkClick(HyperLinkClickEvent arg0) {
        FormShowParameter fsp = new FormShowParameter();
        fsp.setFormId("ccm_recdetailpreview");
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        int rowIndex = arg0.getRowIndex();
        DynamicObject scheme = (DynamicObject)this.getModel().getValue("scheme");
        String dimensionValue = (String)this.getModel().getValue("dimensionvalue", rowIndex);
        fsp.setCustomParam("schemeid", (Object)scheme.getString("id"));
        long recrecordid = (Long)this.getModel().getValue("recrecordid");
        fsp.setCustomParam("dimensionid", (Object)this.getPageCache().get("dimensionid"));
        fsp.setCustomParam("dimensionvalue", (Object)dimensionValue);
        fsp.setCustomParam("recrecordid", (Object)String.valueOf(recrecordid));
        this.getView().showForm(fsp);
        this.getView().showForm(fsp);
    }

    public void getEntityType(GetEntityTypeEventArgs e) {
        super.getEntityType(e);
        MainEntityType originalEntityType = e.getOriginalEntityType();
        String dimensionIdStr = this.getPageCache().get("dimensionid");
        if (StringUtils.isBlank((CharSequence)dimensionIdStr)) {
            return;
        }
        MainEntityType newEntityType = null;
        try {
            newEntityType = (MainEntityType)originalEntityType.clone();
        }
        catch (CloneNotSupportedException e1) {
            throw new RuntimeException(e1);
        }
        DimensionEntryFieldMapper dimensionEntryFieldMapper = new DimensionEntryFieldMapper((Object)Long.valueOf(dimensionIdStr));
        List roleNumbers = dimensionEntryFieldMapper.getRoleNumbers();
        for (String roleNumber : roleNumbers) {
            String fieldTypeKey = dimensionEntryFieldMapper.getFieldTypeKey(roleNumber);
            String roleFieldKey = dimensionEntryFieldMapper.getRoleFieldKey(roleNumber);
            String baseDataKey = dimensionEntryFieldMapper.getBaseDataKey(fieldTypeKey);
            String roleFilterKey = dimensionEntryFieldMapper.getRoleFilterKey(roleNumber);
            MulBasedataProp prop = (MulBasedataProp)newEntityType.getProperty(roleFilterKey);
            prop.setBaseEntityId(baseDataKey);
            BasedataProp bPropMul = (BasedataProp)prop.getItemType().getProperties().get((Object)"fbasedataid");
            bPropMul.setBaseEntityId(baseDataKey);
            MainEntityType basedataType = EntityMetadataCache.getDataEntityType((String)baseDataKey);
            bPropMul.setComplexType((IDataEntityType)basedataType);
            DynamicProperty refProp = prop.getDynamicCollectionItemPropertyType().getProperty("fbasedataid_id");
            bPropMul.setRefIdProp((IDataEntityProperty)refProp);
            bPropMul.setRefIdPropName(refProp.getName());
            EntryProp entryProp = (EntryProp)newEntityType.getProperty("entry");
            BasedataProp roleProp = (BasedataProp)entryProp._collectionItemPropertyType.getProperty(roleFieldKey);
            roleProp.setBaseEntityId(baseDataKey);
            roleProp.setComplexType((IDataEntityType)basedataType);
        }
        e.setNewEntityType(newEntityType);
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key;
        switch (key = e.getProperty().getName()) {
            case "scheme": {
                QFilter filter = new QFilter("checktype.number", "=", (Object)"KZFW001");
                HasPermOrgResult permOrgResult = PermissionHelper.getAllPermOrgs((String)"ccm_recalculate_new", (String)"2PW4Y+SM8SOJ");
                if (!permOrgResult.hasAllOrgPerm()) {
                    filter.and("mainorg", "in", (Object)permOrgResult.getHasPermOrgs());
                }
                ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
                ListFilterParameter listFilterParameter = showParameter.getListFilterParameter();
                listFilterParameter.setFilter(filter);
                break;
            }
        }
    }
}

