/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ccm.formplugin.register;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.metadata.entity.commonfield.ComboField;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.FieldAp;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.util.StringUtils;
import kd.scmc.ccm.business.core.CreditElement;
import kd.scmc.ccm.business.setting.EntityConfig;
import kd.scmc.ccm.business.setting.EntityConfigReader;

public class BillRegisterEdit
extends AbstractFormPlugin
implements TreeNodeClickListener {
    private static final String Key_TreeView = "treeviewap";
    private static final String KEY_COMBOFIELDSCONTAINER = "flexpanelap3";

    public void loadCustomControlMetas(LoadCustomControlMetasArgs e) {
        FlexPanelAp headPanelAp = this.createComboFields();
        HashMap<String, String> mapHead = new HashMap<String, String>();
        mapHead.put("id", KEY_COMBOFIELDSCONTAINER);
        Object value = headPanelAp.createControl().get("items");
        mapHead.put("items", (String)value);
        e.getItems().add(mapHead);
    }

    public void getEntityType(GetEntityTypeEventArgs e) {
        MainEntityType newMainType;
        super.getEntityType(e);
        MainEntityType oldMainType = e.getOriginalEntityType();
        try {
            newMainType = (MainEntityType)oldMainType.clone();
        }
        catch (CloneNotSupportedException exp) {
            throw new KDException((Throwable)exp, new ErrorCode("BillRegisterEdit", exp.getMessage()), new Object[0]);
        }
        this.registDynamicProps(newMainType);
        e.setNewEntityType(newMainType);
    }

    private void registDynamicProps(MainEntityType newMainType) {
        for (DynamicObject role : this.getRoles()) {
            ComboProp comboProp = new ComboProp();
            comboProp.setName(role.getString("number").toLowerCase());
            comboProp.setDisplayName(new LocaleString(role.getString("name")));
            comboProp.setDbIgnore(true);
            comboProp.setAlias("");
            newMainType.registerSimpleProperty((DynamicSimpleProperty)comboProp);
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        TreeView tView = (TreeView)this.getControl(Key_TreeView);
        tView.addTreeNodeClickListener((TreeNodeClickListener)this);
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        FlexPanelAp dynamicPanel = this.createComboFields();
        Container panel = (Container)this.getView().getControl(KEY_COMBOFIELDSCONTAINER);
        panel.getItems().addAll(((Container)dynamicPanel.buildRuntimeControl()).getItems());
        this.getPageCache().put("panel", String.valueOf(panel.getItems().size()));
        this.getView().createControlIndex(panel.getItems());
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        String key = op.getOperateKey();
        if ("save".equals(key)) {
            String panel = this.getView().getPageCache().get("panel");
            DynamicObjectCollection roles = this.getRoles();
            if (roles.size() != Integer.parseInt(panel)) {
                args.setCancel(true);
            }
        }
    }

    private FlexPanelAp createComboFields() {
        FlexPanelAp headPanelAp = new FlexPanelAp();
        headPanelAp.setKey("flexpanelap1");
        for (DynamicObject role : this.getRoles()) {
            FieldAp comboFieldAp = new FieldAp();
            comboFieldAp.setId(role.getString("id"));
            comboFieldAp.setKey(role.getString("number").toLowerCase());
            comboFieldAp.setName(new LocaleString(role.getString("name")));
            comboFieldAp.setFireUpdEvt(true);
            ComboField comboField = new ComboField();
            comboField.setId(role.getString("id"));
            comboField.setKey(role.getString("number").toLowerCase());
            comboFieldAp.setField((Field)comboField);
            headPanelAp.getItems().add(comboFieldAp);
        }
        return headPanelAp;
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.initTree(this.getBillNumbersfromSetting());
    }

    public void onGetControl(OnGetControlArgs e) {
        for (DynamicObject role : this.getRoles()) {
            if (!role.getString("number").toLowerCase().equals(e.getKey())) continue;
            ComboEdit textEdit = new ComboEdit();
            textEdit.setKey(role.getString("number").toLowerCase());
            textEdit.setView(this.getView());
            e.setControl((Control)textEdit);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        if ("entity".equals(name)) {
            DynamicObject entity = (DynamicObject)this.getModel().getValue("entity");
            String entityKey = entity == null ? null : (String)entity.getPkValue();
            this.clearRoleFieldValue();
            this.setRoleFieldValue(entityKey);
        }
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        TreeView tView = (TreeView)this.getControl(Key_TreeView);
        String focusNodeId = tView.getTreeState().getFocusNodeId();
        if (focusNodeId.startsWith("cloud_") || focusNodeId.startsWith("app_")) {
            this.getModel().setValue("entity", null);
        } else {
            this.getModel().setValue("entity", (Object)focusNodeId);
        }
    }

    private void clearRoleFieldValue() {
        List<String> fieldKeys = this.getAllComboFieldKeys();
        for (String fieldKey : fieldKeys) {
            this.getModel().setValue(fieldKey, null);
        }
    }

    private void setRoleFieldValue(String entityKey) {
        this.setComboItemsByFocusEntity(entityKey);
        if (StringUtils.isEmpty((String)entityKey)) {
            return;
        }
        EntityConfigReader entityConfigReader = new EntityConfigReader();
        DynamicObject entityConfigObj = BusinessDataServiceHelper.loadSingleFromCache((Object)entityKey, (String)"ccm_entityconfig");
        if (entityConfigObj == null) {
            return;
        }
        EntityConfig config = entityConfigReader.toConfigObj(entityConfigObj);
        for (String fieldKey : this.getAllComboFieldKeys()) {
            kd.scmc.ccm.business.core.Field field;
            CreditElement creditElement = new CreditElement(CreditElement.ElementType.ROLE, fieldKey.toUpperCase());
            if ("org".equals(fieldKey)) {
                creditElement = CreditElement.ELEMENT_ORG;
            } else if ("currency".equals(fieldKey)) {
                creditElement = CreditElement.ELEMENT_CURRENCY;
            }
            if ((field = config.getField(creditElement)) == null) continue;
            String key = field.getKey();
            this.getModel().setValue(fieldKey, (Object)key);
        }
    }

    protected List<String> getAllComboFieldKeys() {
        LinkedList<String> fieldKeys = new LinkedList<String>();
        MainEntityType dataEntityType = this.getModel().getDataEntityType();
        DataEntityPropertyCollection properties = dataEntityType.getProperties();
        for (IDataEntityProperty prop : properties) {
            if (!(prop instanceof ComboProp)) continue;
            fieldKeys.add(prop.getName());
        }
        return fieldKeys;
    }

    private DynamicObjectCollection getRoles() {
        QFilter[] filters = new QFilter[]{new QFilter("status", "=", (Object)"C"), new QFilter("enable", "=", (Object)Boolean.TRUE)};
        return QueryServiceHelper.query((String)"ccm_role", (String)"id,number,name", (QFilter[])filters);
    }

    private void setComboItemsByFocusEntity(String entityKey) {
        ComboEdit currencyCombo;
        DataEntityPropertyCollection properties = new LinkedList();
        if (!StringUtils.isEmpty((String)entityKey)) {
            MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)entityKey);
            properties = dataEntityType.getProperties();
        }
        LinkedList<ComboItem> items = new LinkedList<ComboItem>();
        for (IDataEntityProperty prop : properties) {
            if (prop == null || prop instanceof ComboProp) continue;
            LocaleString displayName = prop.getDisplayName();
            String dbName = prop.getAlias();
            if (prop instanceof BasedataProp || prop instanceof LongProp || prop instanceof DecimalProp) {
                if (displayName == null || StringUtils.isEmpty((String)dbName)) continue;
                LocaleString dis = new LocaleString(displayName.getLocaleValue() + "(" + prop.getName() + ")");
                items.add(new ComboItem(dis, prop.getName()));
                continue;
            }
            if (!(prop instanceof EntryProp) || displayName == null) continue;
            DataEntityPropertyCollection entryProperties = ((EntryProp)prop)._collectionItemPropertyType.getProperties();
            for (IDataEntityProperty entryProp : entryProperties) {
                String entryPropAlias = entryProp.getAlias();
                LocaleString entryPropDisplayName = entryProp.getDisplayName();
                if (!(entryProp instanceof BasedataProp) && !(entryProp instanceof LongProp) && !(entryProp instanceof DecimalProp) || entryPropDisplayName == null || StringUtils.isEmpty((String)entryPropAlias)) continue;
                String string = entryProp.getName();
                LocaleString dis = new LocaleString(displayName.getLocaleValue() + "." + entryPropDisplayName.getLocaleValue() + "(" + string + ")");
                items.add(new ComboItem(dis, string));
            }
        }
        ComboEdit orgCombo = (ComboEdit)this.getControl("org");
        if (orgCombo != null) {
            orgCombo.setComboItems(items);
        }
        if ((currencyCombo = (ComboEdit)this.getControl("currency")) != null) {
            currencyCombo.setComboItems(items);
        }
        for (DynamicObject role : this.getRoles()) {
            ComboEdit roleCombo = (ComboEdit)this.getControl(role.getString("number").toLowerCase());
            if (roleCombo == null) continue;
            roleCombo.setComboItems(items);
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
        String itemKey = evt.getItemKey();
        if ("bar_delete".equals(itemKey) || "bar_save".equals(itemKey)) {
            TreeView tView = (TreeView)this.getControl(Key_TreeView);
            boolean isFocusBillTreeNode = true;
            if (tView == null || tView.getTreeState() == null || StringUtils.isEmpty((String)tView.getTreeState().getFocusNodeId())) {
                isFocusBillTreeNode = false;
            } else {
                String focusNodeId = tView.getTreeState().getFocusNodeId();
                if (focusNodeId.startsWith("cloud_") || focusNodeId.startsWith("app_")) {
                    isFocusBillTreeNode = false;
                }
            }
            if (!isFocusBillTreeNode) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5355\u636e\u3002", (String)"BillRegisterEdit_5", (String)"scmc-ccm-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if (!"bar_exit".equals(itemKey)) {
            String panel = this.getView().getPageCache().get("panel");
            DynamicObjectCollection roles = this.getRoles();
            if (roles.size() != Integer.parseInt(panel)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ef4\u5ea6\u6210\u5458\u53d1\u751f\u6539\u53d8\uff0c\u8bf7\u91cd\u65b0\u6253\u5f00\u5355\u636e\u6ce8\u518c\u3002", (String)"BillRegisterEdit_0", (String)"scmc-ccm-formplugin", (Object[])new Object[0]));
                return;
            }
        }
        if ("bar_delete".equals(itemKey)) {
            this.getView().invokeOperation("delete");
        } else if ("bar_refresh".equals(itemKey)) {
            this.refreshNode();
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5237\u65b0\u6210\u529f\u3002", (String)"BillRegisterEdit_1", (String)"scmc-ccm-formplugin", (Object[])new Object[0]));
        } else if ("bar_new".equals(itemKey)) {
            Long orgId = RequestContext.get().getOrgId();
            long userId = RequestContext.get().getCurrUserId();
            int checkPermission = PermissionServiceHelper.checkPermission((Long)userId, (Long)orgId, (String)"ccm", (String)"ccm_billregister", (String)"47156aff000000ac");
            if (checkPermission == 0) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u65b0\u589e\u6743\u9650\u3002", (String)"BillRegisterEdit_2", (String)"scmc-ccm-formplugin", (Object[])new Object[0]));
                return;
            }
            ListShowParameter lsp = ShowFormHelper.createShowListForm((String)"bos_billmainentity", (boolean)false, (int)2);
            List qFilters = lsp.getListFilterParameter().getQFilters();
            if (qFilters != null) {
                qFilters.add(new QFilter("modeltype", "=", (Object)"BillFormModel"));
            }
            lsp.setCaption(ResManager.loadKDString((String)"\u65b0\u589e\u5355\u636e\u6ce8\u518c", (String)"BillRegisterEdit_3", (String)"scmc-ccm-formplugin", (Object[])new Object[0]));
            CloseCallBack closeCallBack = new CloseCallBack(this.getPluginName(), "BillRegister");
            lsp.setCloseCallBack(closeCallBack);
            this.getView().showForm((FormShowParameter)lsp);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String id = closedCallBackEvent.getActionId();
        Object returnData = closedCallBackEvent.getReturnData();
        if ("BillRegister".equals(id)) {
            ListSelectedRowCollection billEntities = (ListSelectedRowCollection)returnData;
            if (ObjectUtils.isEmpty((Object)billEntities)) {
                return;
            }
            this.getModel().setValue("entity", billEntities.get(0).getPrimaryKeyValue());
            String billNumber = billEntities.get(0).getNumber();
            TreeView tView = (TreeView)this.getControl(Key_TreeView);
            tView.deleteAllNodes();
            this.initTree(this.getAllBillNumbers(billNumber));
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String op = afterDoOperationEventArgs.getOperateKey();
        OperationResult opRes = afterDoOperationEventArgs.getOperationResult();
        if (opRes != null && opRes.isSuccess() && "delete".equals(op)) {
            this.refreshNode();
        }
    }

    private void initTree(List<String> billNumbers) {
        TreeNode root = new TreeNode();
        root.setText(ResManager.loadKDString((String)"\u5168\u90e8", (String)"BillRegisterEdit_4", (String)"scmc-ccm-formplugin", (Object[])new Object[0]));
        root.setParentid("");
        root.setIsOpened(true);
        List<TreeNode> billNodes = this.getBillNodes(billNumbers);
        List<TreeNode> appNodes = this.getAppNodes();
        List<TreeNode> cloudNodes = this.getCloudNodes();
        Iterator<TreeNode> appNodesIterator = appNodes.iterator();
        while (appNodesIterator.hasNext()) {
            TreeNode appNode = appNodesIterator.next();
            this.addChildNode(appNode, billNodes);
            List children = appNode.getChildren();
            if (children != null && !children.isEmpty()) continue;
            appNodesIterator.remove();
        }
        Iterator<TreeNode> cloudNodesIterator = cloudNodes.iterator();
        while (cloudNodesIterator.hasNext()) {
            TreeNode cloudNode = cloudNodesIterator.next();
            this.addChildNode(cloudNode, appNodes);
            List children = cloudNode.getChildren();
            if (children != null && !children.isEmpty()) continue;
            cloudNodesIterator.remove();
        }
        root.addChildren(cloudNodes);
        TreeView tView = (TreeView)this.getControl(Key_TreeView);
        tView.addNode(root);
        DynamicObject entity = (DynamicObject)this.getModel().getValue("entity");
        if (entity != null) {
            String entityNodeID = entity.getString("number");
            tView.focusNode(root.getTreeNode(entityNodeID));
        } else {
            tView.focusNode(root);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<TreeNode> getBillNodes(List<String> numbers) {
        LinkedList<TreeNode> billNodes = new LinkedList<TreeNode>();
        String fields = "id, number, name, bizappid";
        String orderby = "bizappid asc";
        QFilter[] filters = new QFilter[2];
        QFilter typeFilter = new QFilter("modeltype", "in", (Object)new String[]{"BillFormModel"});
        QFilter nodeFilter = new QFilter("number", "in", numbers);
        filters[0] = typeFilter;
        filters[1] = nodeFilter;
        try (DataSet ds = ORM.create().queryDataSet("bos_billmainentity", "bos_billmainentity", fields, filters, orderby);){
            for (Row row : ds) {
                TreeNode node = new TreeNode();
                String nodeID = row.getString("id");
                node.setText(row.getString("name"));
                node.setParentid("app_" + row.getString("bizappid"));
                node.setId(nodeID);
                node.setData((Object)row.getString("number"));
                billNodes.add(node);
            }
        }
        return billNodes;
    }

    private List<String> getAllBillNumbers(String billNumber) {
        List<String> numbers = this.getBillNumbersfromSetting();
        numbers.add(billNumber);
        return numbers;
    }

    private List<String> getBillNumbersfromSetting() {
        DynamicObject[] entityConfigArray = BusinessDataServiceHelper.load((String)"ccm_entityconfig", (String)"number", null);
        ArrayList<String> billNumbers = new ArrayList<String>(entityConfigArray.length);
        for (DynamicObject entityConfig : entityConfigArray) {
            billNumbers.add(entityConfig.getString("number"));
        }
        return billNumbers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<TreeNode> getAppNodes() {
        ArrayList<TreeNode> appNodes = new ArrayList<TreeNode>();
        String fields = "id, number, name, bizcloud";
        QFilter[] filters = new QFilter[]{};
        try (DataSet ds = ORM.create().queryDataSet("bos_devportal_bizapp", "bos_devportal_bizapp", fields, filters, null);){
            for (Row row : ds) {
                TreeNode node = new TreeNode();
                String nodeID = "app_" + row.getString("id");
                node.setText(row.getString("name"));
                node.setParentid("cloud_" + row.getString("bizcloud"));
                node.setId(nodeID);
                node.setData((Object)"app");
                appNodes.add(node);
            }
        }
        return appNodes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<TreeNode> getCloudNodes() {
        ArrayList<TreeNode> cloudNode = new ArrayList<TreeNode>();
        String fields = "id, number, name";
        String orderby = "sequence asc";
        QFilter[] filters = new QFilter[]{};
        try (DataSet ds = ORM.create().queryDataSet("bos_devportal_bizcloud", "bos_devportal_bizcloud", fields, filters, orderby);){
            for (Row row : ds) {
                TreeNode node = new TreeNode();
                String nodeID = "cloud_" + row.getString("id");
                node.setText(row.getString("name"));
                node.setParentid("0");
                node.setId(nodeID);
                node.setData((Object)"cloud");
                cloudNode.add(node);
            }
        }
        return cloudNode;
    }

    private void addChildNode(TreeNode pnode, List<TreeNode> childNodes) {
        for (int i = 0; i < childNodes.size(); ++i) {
            TreeNode cnode = childNodes.get(i);
            String parentId = cnode.getParentid();
            if (!pnode.getId().equals(parentId)) continue;
            pnode.addChild(cnode);
        }
    }

    private void refreshNode() {
        this.getModel().setValue("entity", null);
        TreeView tView = (TreeView)this.getControl(Key_TreeView);
        tView.deleteAllNodes();
        this.initTree(this.getAllBillNumbers(null));
    }
}

