/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ccm.formplugin.role;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.scmc.ccm.formplugin.SimpleBasedataList;

public class RoleList
extends SimpleBasedataList {
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate source = (AbstractOperate)args.getSource();
        String key = source.getOperateKey();
        if ("setcontrol".equals(key) || "cancelcontrol".equals(key)) {
            BillList billList = (BillList)this.getControl("billlistap");
            ListSelectedRowCollection selectedRows = billList.getSelectedRows();
            HashSet<Object> roleIds = new HashSet<Object>(selectedRows.size());
            for (ListSelectedRow selectedRow : selectedRows) {
                roleIds.add(selectedRow.getPrimaryKeyValue());
            }
            DynamicObjectCollection roles = QueryServiceHelper.query((String)"ccm_role", (String)"number", (QFilter[])new QFilter[]{new QFilter("id", "in", roleIds)});
            for (DynamicObject role : roles) {
                if (!"CUSUNICODE".equals(role.get("number"))) continue;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5ba2\u6237\u7edf\u4e00\u7801\u4e0d\u652f\u6301\u8be5\u64cd\u4f5c\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"RoleList_3", (String)"scmc-ccm-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            if ("cancelcontrol".equals(key)) {
                this.deleteArchives();
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        if ("tblsetcontrol".equals(key)) {
            Long orgId = RequestContext.get().getOrgId();
            String userId = RequestContext.get().getUserId();
            int checkPermission = PermissionServiceHelper.checkPermission((Long)Long.valueOf(userId), (Long)orgId, (String)"ccm", (String)"ccm_role", (String)"47156aff000000ac");
            if (checkPermission == 0) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u65b0\u589e\u6743\u9650\u3002", (String)"RoleList_0", (String)"scmc-ccm-formplugin", (Object[])new Object[0]));
                return;
            }
            BillList billList = (BillList)this.getControl("billlistap");
            ListSelectedRowCollection selectedRows = billList.getSelectedRows();
            if (selectedRows.size() == 0 || selectedRows.size() > 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u6570\u636e\u8bbe\u7f6e\u8303\u56f4\u3002", (String)"RoleList_1", (String)"scmc-ccm-formplugin", (Object[])new Object[0]));
                return;
            }
            Object roleId = selectedRows.get(0).getPrimaryKeyValue();
            DynamicObject role = BusinessDataServiceHelper.loadSingle((Object)roleId, (String)"ccm_role");
            if ("CUSUNICODE".equals(role.get("number"))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5ba2\u6237\u7edf\u4e00\u7801\u4e0d\u652f\u6301\u8be5\u64cd\u4f5c\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"RoleList_3", (String)"scmc-ccm-formplugin", (Object[])new Object[0]));
                return;
            }
            if (role.getBoolean("iscontroled")) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5168\u90e8\u7ba1\u63a7\u7684\u6570\u636e\u4e0d\u80fd\u8bbe\u7f6e\u8303\u56f4\u3002", (String)"RoleList_2", (String)"scmc-ccm-formplugin", (Object[])new Object[0]));
                return;
            }
            String entityKey = role.getDynamicObject("basedata").getString("number");
            ListShowParameter lsp = ShowFormHelper.createShowListForm((String)entityKey, (boolean)false, (int)0, (boolean)false);
            IFormView parentView = this.getView();
            ShowType showType = parentView.getFormShowParameter().getFormConfig().getShowType();
            lsp.getOpenStyle().setShowType(showType);
            lsp.setAppId(parentView.getFormShowParameter().getAppId());
            lsp.setMultiSelect(true);
            lsp.setShowTitle(false);
            lsp.setHasRight(true);
            lsp.addCustPlugin("kd.bos.ext.scmc.creditcontrol.form.CreditDynamicRoleList");
            lsp.setCustomParam("roleid", roleId);
            this.getView().showForm((FormShowParameter)lsp);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        AbstractOperate source = (AbstractOperate)args.getSource();
        String key = source.getOperateKey();
        if ("setcontrol".equals(key) || "cancelcontrol".equals(key)) {
            this.getView().invokeOperation("refresh");
        }
    }

    private void deleteArchives() {
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        HashSet roleIdPks = new HashSet(selectedRows.size());
        selectedRows.stream().forEach(selectedRow -> roleIdPks.add(selectedRow.getPrimaryKeyValue()));
        DynamicObjectCollection roles = QueryServiceHelper.query((String)"ccm_role", (String)"number", (QFilter[])new QFilter[]{new QFilter("id", "in", roleIdPks)});
        HashSet<String> roleNumbers = new HashSet<String>(roles.size());
        roles.stream().forEach(role -> roleNumbers.add(role.getString("number")));
        List<Long> deleteArchiveIds = this.getDeleteArchiveIds(roleNumbers);
        if (!ObjectUtils.isEmpty(deleteArchiveIds)) {
            DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"ccm_archive"), (Object[])deleteArchiveIds.toArray(new Long[0]));
        }
    }

    private List<Long> getDeleteArchiveIds(Set<String> roleNumbers) {
        LinkedList<Long> deleteArchiveIds = new LinkedList<Long>();
        Object[] schemes = BusinessDataServiceHelper.load((String)"ccm_scheme", (String)"dimension", (QFilter[])new QFilter[]{new QFilter("autocreatearchive", "=", (Object)Boolean.TRUE)});
        if (ObjectUtils.isEmpty((Object[])schemes)) {
            return deleteArchiveIds;
        }
        HashSet<Long> schemeIds = new HashSet<Long>(schemes.length);
        for (Object scheme : schemes) {
            String dimensionRole;
            DynamicObjectCollection entry = scheme.getDynamicObject("dimension").getDynamicObjectCollection("entry");
            if (entry.size() != 1 || !roleNumbers.contains(dimensionRole = ((DynamicObject)entry.get(0)).getString("role.number"))) continue;
            schemeIds.add(scheme.getLong("id"));
        }
        QFilter filter = new QFilter("scheme", "in", schemeIds);
        filter.and(new QFilter("reducesum", "=", (Object)0));
        filter.and(new QFilter("increasesum", "=", (Object)0));
        DynamicObjectCollection archives = QueryServiceHelper.query((String)"ccm_archive", (String)"id", (QFilter[])new QFilter[]{filter});
        if (ObjectUtils.isEmpty((Object)archives)) {
            return deleteArchiveIds;
        }
        HashSet archiveIds = new HashSet(archives.size());
        archives.stream().forEach(archive -> archiveIds.add(archive.getLong("id")));
        DynamicObjectCollection archiveApplys = QueryServiceHelper.query((String)"ccm_archive_apply", (String)"entry.archiveid", (QFilter[])new QFilter[]{new QFilter("billstatus", "=", (Object)"C"), new QFilter("entry.archiveid", "in", archiveIds)});
        HashSet archiveIdsByApply = new HashSet(archiveApplys.size());
        archiveApplys.stream().forEach(archiveApply -> archiveIdsByApply.add(archiveApply.getLong("entry.archiveid")));
        LinkedList<Long> autoArchiveIds = new LinkedList<Long>();
        for (Long archive2 : archiveIds) {
            if (archiveIdsByApply.contains(archive2)) continue;
            autoArchiveIds.add(archive2);
        }
        DynamicObjectCollection journals = QueryServiceHelper.query((String)"ccm_journal", (String)"archiveid", (QFilter[])new QFilter[]{new QFilter("archiveid", "in", autoArchiveIds)});
        if (ObjectUtils.isEmpty((Object)journals)) {
            return autoArchiveIds;
        }
        HashSet archiveIdsByJournal = new HashSet(journals.size());
        journals.stream().forEach(journal -> archiveIdsByJournal.add(journal.getLong("archiveid")));
        for (Long autoArchiveId : autoArchiveIds) {
            if (archiveIdsByJournal.contains(autoArchiveId)) continue;
            deleteArchiveIds.add(autoArchiveId);
        }
        return deleteArchiveIds;
    }
}

