/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ccm.formplugin.scheme;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.DateEdit;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scmc.ccm.common.util.DateUtils;
import kd.scmc.ccm.common.util.MetadataUtils;

public class CreditSchemeEdit
extends AbstractBillPlugIn {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.billStrategyFilter();
        this.orgFilter();
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        String key = op.getOperateKey();
        if ("submit".equals(key)) {
            this.setEntryByBillStrategyIsNull();
        }
    }

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        int rowCount = this.getModel().getEntryRowCount("entry");
        for (int i = 0; i < rowCount; ++i) {
            this.setEntityOpNames(i);
        }
        this.getModel().setDataChanged(false);
        this.setMustInputOfYearBegindate();
        this.setMustInputOfEntryOrg();
        this.setVisableOfDefaultQuota();
        this.setVisibilityByExrateTable();
        this.setVisableOfDimension();
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.setMustInputOfYearBegindate();
        this.setMustInputOfEntryOrg();
        this.setVisableOfDefaultQuota();
        this.getModel().setValue("org", null, 0);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String stopChange = this.getPageCache().get("stopChange");
        if ("true".equals(stopChange)) {
            return;
        }
        String key = e.getProperty().getName();
        ChangeData[] changeDate = e.getChangeSet();
        Object newValue = changeDate[0].getNewValue();
        Object oldValue = changeDate[0].getOldValue();
        if ("singlecurcontrol".equals(key)) {
            boolean isChange = this.isFieldValueChangeCheck(oldValue, key, ResManager.loadKDString((String)"\u5e01\u79cd\u9694\u79bb", (String)"CreditSchemeEdit_7", (String)"scmc-ccm-formplugin", (Object[])new Object[0]));
            if (!isChange) {
                this.setVisibilityByExrateTable();
                boolean singleCurcontrol = (Boolean)this.getModel().getValue("singlecurcontrol");
                if (singleCurcontrol) {
                    this.getModel().setValue("exratetable", null);
                }
            }
        } else if ("billstrategy".equals(key)) {
            int rowIndex = changeDate[0].getRowIndex();
            this.setEntityOpNames(rowIndex);
        } else if ("orgscope".equals(key)) {
            boolean isChange = this.isFieldValueChangeCheck(oldValue, key, ResManager.loadKDString((String)"\u63a7\u5236\u7ec4\u7ec7\u8303\u56f4", (String)"CreditSchemeEdit_8", (String)"scmc-ccm-formplugin", (Object[])new Object[0]));
            if (!isChange) {
                String orgScope = String.valueOf(this.getModel().getValue("orgscope"));
                this.setMustInputOfEntryOrg();
                if ("GLOBAL".equals(orgScope)) {
                    this.getModel().deleteEntryData("orgentry");
                }
            }
        } else if ("checktype".equals(key)) {
            boolean isChange = this.isFieldValueChangeCheck(oldValue, key, ResManager.loadKDString((String)"\u4fe1\u7528\u63a7\u5236\u5f62\u5f0f", (String)"CreditSchemeEdit_9", (String)"scmc-ccm-formplugin", (Object[])new Object[0]));
            if (!isChange) {
                this.getModel().deleteEntryData("entry");
                this.getModel().createNewEntryRow("entry");
                this.setVisableOfDefaultQuota();
                this.getModel().setValue("defaultquota", (Object)BigDecimal.ZERO);
                this.getModel().setValue("defaultdays", (Object)0);
                this.getModel().setValue("autocreatearchive", (Object)Boolean.FALSE);
            }
        } else if ("validity".equals(key)) {
            boolean isChange = this.isFieldValueChangeCheck(oldValue, key, ResManager.loadKDString((String)"\u6709\u6548\u671f", (String)"CreditSchemeEdit_10", (String)"scmc-ccm-formplugin", (Object[])new Object[0]));
            if (!isChange) {
                this.setMustInputOfYearBegindate();
                if ("YEAR".equals(String.valueOf(newValue))) {
                    Date defaultBeginDate = DateUtils.getYearFirst((int)DateUtils.getDateYear((Date)new Date()));
                    this.getModel().setValue("yearbegindate", (Object)defaultBeginDate);
                    this.getModel().setValue("yearenddate", (Object)DateUtils.getYearsLaterDate((Date)defaultBeginDate, (int)1));
                } else {
                    this.getModel().setValue("yearbegindate", null);
                    this.getModel().setValue("yearenddate", null);
                }
            }
        } else if ("yearbegindate".equals(key)) {
            if (!ObjectUtils.isEmpty((Object)newValue)) {
                this.getModel().setValue("yearenddate", (Object)DateUtils.getYearsLaterDate((Date)((Date)newValue), (int)1));
            }
        } else if ("autocreatearchive".equals(key)) {
            this.setVisableOfDefaultQuota();
            if (!((Boolean)newValue).booleanValue()) {
                this.getModel().setValue("defaultquota", (Object)BigDecimal.ZERO);
                this.getModel().setValue("defaultdays", (Object)0);
            }
        } else if ("currency".equals(key)) {
            this.isFieldValueChangeCheck(oldValue, key, ResManager.loadKDString((String)"\u5e01\u79cd", (String)"CreditSchemeEdit_11", (String)"scmc-ccm-formplugin", (Object[])new Object[0]));
        } else if ("dimension".equals(key)) {
            this.isFieldValueChangeCheck(oldValue, key, ResManager.loadKDString((String)"\u4fe1\u7528\u63a7\u5236\u7ef4\u5ea6", (String)"CreditSchemeEdit_12", (String)"scmc-ccm-formplugin", (Object[])new Object[0]));
            this.setVisableOfDimension();
        }
    }

    public void afterCopyData(EventObject e) {
        super.afterCopyData(e);
        int rowCount = this.getModel().getEntryRowCount("entry");
        for (int i = 0; i < rowCount; ++i) {
            this.setEntityOpNames(i);
        }
        this.setMustInputOfYearBegindate();
        this.setVisableOfDefaultQuota();
        this.setVisableOfDimension();
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        String entryName = e.getEntryProp().getName();
        if ("orgentry".equals(entryName)) {
            int rowCount = this.getModel().getEntryRowCount("orgentry");
            this.getModel().setValue("org", null, rowCount - 1);
        }
    }

    private void setEntityOpNames(int rowIndex) {
        DynamicObject billStrategy = (DynamicObject)this.getModel().getValue("billstrategy", rowIndex);
        if (billStrategy == null) {
            this.getModel().setValue("checkopname", (Object)"", rowIndex);
            this.getModel().setValue("reduceopname", (Object)"", rowIndex);
            this.getModel().setValue("increaseopname", (Object)"", rowIndex);
            return;
        }
        String entityKey = billStrategy.getString("entity.id");
        String checkOpDisplayName = this.getOpDisplayName(entityKey, billStrategy.getString("checkops"));
        this.getModel().setValue("checkopname", (Object)checkOpDisplayName, rowIndex);
        String reduceOpDisplayName = this.getOpDisplayName(entityKey, billStrategy.getString("reduceops"));
        this.getModel().setValue("reduceopname", (Object)reduceOpDisplayName, rowIndex);
        String increaseOpDisplayName = this.getOpDisplayName(entityKey, billStrategy.getString("increaseops"));
        this.getModel().setValue("increaseopname", (Object)increaseOpDisplayName, rowIndex);
    }

    private String getOpDisplayName(String entityKey, String ops) {
        String[] splitedOps;
        LinkedList<String> displayOpNames = new LinkedList<String>();
        for (String op : splitedOps = ops.split(",")) {
            if (StringUtils.isEmpty((CharSequence)op)) continue;
            String opDisplayName = MetadataUtils.getOpDisplayName((String)entityKey, (String)op);
            displayOpNames.add(opDisplayName);
        }
        return String.join((CharSequence)"  ", displayOpNames);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.setVisibilityByExrateTable();
    }

    private void billStrategyFilter() {
        BasedataEdit billStrategyF7 = (BasedataEdit)this.getView().getControl("billstrategy");
        IDataModel model = this.getModel();
        billStrategyF7.addBeforeF7SelectListener(beforeF7SelectListener -> {
            DynamicObject checktype = (DynamicObject)model.getValue("checktype");
            long checkTypeId = 0L;
            if (ObjectUtils.isEmpty((Object)checktype)) {
                model.setValue("checktype", (Object)854840942480333824L);
                checkTypeId = 854840942480333824L;
            } else {
                checkTypeId = checktype.getLong("id");
            }
            QFilter filter = new QFilter("checktype", "=", (Object)checkTypeId);
            List<Long> fieldValueIds = this.getViewFieldValueIds("entry", "billstrategy");
            filter.and(new QFilter("id", "not in", fieldValueIds));
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectListener.getFormShowParameter();
            ListFilterParameter listFilterParameter = showParameter.getListFilterParameter();
            listFilterParameter.setFilter(filter);
        });
    }

    private void orgFilter() {
        BasedataEdit orgF7 = (BasedataEdit)this.getView().getControl("org");
        orgF7.addBeforeF7SelectListener(beforeF7SelectListener -> {
            List<Long> fieldValueIds = this.getViewFieldValueIds("orgentry", "org");
            QFilter filter = new QFilter("id", "not in", fieldValueIds);
            ListShowParameter formShowParameter = (ListShowParameter)beforeF7SelectListener.getFormShowParameter();
            ListFilterParameter listFilterParameter = formShowParameter.getListFilterParameter();
            listFilterParameter.setFilter(filter);
        });
    }

    private void setVisibilityByExrateTable() {
        boolean singleCurcontrol = (Boolean)this.getModel().getValue("singlecurcontrol");
        BasedataEdit exrateTable = (BasedataEdit)this.getView().getControl("exratetable");
        if (singleCurcontrol) {
            exrateTable.setMustInput(false);
            this.getView().setVisible(Boolean.FALSE, new String[]{"exratetable"});
        } else {
            exrateTable.setMustInput(true);
            this.getView().setVisible(Boolean.TRUE, new String[]{"exratetable"});
        }
    }

    private void setMustInputOfYearBegindate() {
        DateEdit control = (DateEdit)this.getControl("yearbegindate");
        String validity = (String)this.getModel().getValue("validity");
        if ("YEAR".equals(validity)) {
            control.setMustInput(true);
        } else {
            control.setMustInput(false);
        }
    }

    private void setMustInputOfEntryOrg() {
        String orgScope = (String)this.getModel().getValue("orgscope");
        BasedataEdit orgControl = (BasedataEdit)this.getControl("org");
        if ("SINGLE".equals(orgScope)) {
            orgControl.setMustInput(true);
        } else if ("GLOBAL".equals(orgScope)) {
            orgControl.setMustInput(false);
        }
    }

    private void setVisableOfDefaultQuota() {
        boolean isCreate = (Boolean)this.getModel().getValue("autocreatearchive");
        DynamicObject checkType = (DynamicObject)this.getModel().getValue("checktype");
        if (isCreate && !ObjectUtils.isEmpty((Object)checkType)) {
            if ("KZFW001".equals(checkType.getString("number"))) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"defaultquota"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"defaultdays"});
            } else if ("KZFW002".equals(checkType.getString("number"))) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"defaultquota"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"defaultdays"});
            }
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"defaultquota", "defaultdays"});
        }
    }

    private boolean isFieldValueChangeCheck(Object oldValue, String fieldName, String message) {
        Object pkValue = this.getModel().getDataEntity().getPkValue();
        if (OperationStatus.ADDNEW.equals((Object)this.getView().getFormShowParameter().getStatus())) {
            return false;
        }
        boolean isExistsArchive = QueryServiceHelper.exists((String)"ccm_archive", (QFilter[])new QFilter[]{new QFilter("scheme", "=", pkValue)});
        boolean isExistsArchiveApply = QueryServiceHelper.exists((String)"ccm_archive_apply", (QFilter[])new QFilter[]{new QFilter("scheme", "=", pkValue)});
        if (isExistsArchive || isExistsArchiveApply) {
            String tipMessage = ResManager.loadKDString((String)"\u540e\u53f0\u6863\u6848\u6216\u6863\u6848\u7533\u8bf7\u5355\u4e2d\u5b58\u5728\u4f7f\u7528\u8be5\u4fe1\u63a7\u65b9\u6848\u7684\u6570\u636e\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539%s\u3002", (String)"CreditSchemeEdit_13", (String)"scmc-ccm-formplugin", (Object[])new Object[0]);
            this.getView().showTipNotification(String.format(tipMessage, message));
            this.getPageCache().put("stopChange", "true");
            this.getModel().setValue(fieldName, oldValue);
            this.getPageCache().put("stopChange", "false");
            this.getView().updateView(fieldName);
            return true;
        }
        return false;
    }

    private List<Long> getViewFieldValueIds(String entryName, String fieldName) {
        LinkedList<Long> fieldValueIds = new LinkedList<Long>();
        int rowCount = this.getModel().getEntryRowCount(entryName);
        for (int i = 0; i < rowCount; ++i) {
            DynamicObject fieldValue = (DynamicObject)this.getModel().getValue(fieldName, i);
            if (fieldValue == null) continue;
            fieldValueIds.add(fieldValue.getLong("id"));
        }
        return fieldValueIds;
    }

    private void setEntryByBillStrategyIsNull() {
        int rowCount = this.getModel().getEntryRowCount("entry");
        ArrayList<Integer> deleteEntryRows = new ArrayList<Integer>(rowCount);
        for (int i = 0; i < rowCount; ++i) {
            DynamicObject billstrategy = (DynamicObject)this.getModel().getValue("billstrategy", i);
            if (!ObjectUtils.isEmpty((Object)billstrategy)) continue;
            deleteEntryRows.add(i);
        }
        if (!ObjectUtils.isEmpty(deleteEntryRows)) {
            this.getModel().deleteEntryRows("entry", deleteEntryRows.stream().mapToInt(Integer::intValue).toArray());
        }
    }

    private void setVisableOfDimension() {
        DynamicObject dimension = (DynamicObject)this.getModel().getValue("dimension");
        if (!ObjectUtils.isEmpty((Object)dimension)) {
            DynamicObjectCollection entry = dimension.getDynamicObjectCollection("entry");
            this.getView().setVisible(Boolean.TRUE, new String[]{"autocreatearchive"});
            HashSet<Long> roleIDSet = new HashSet<Long>(16);
            for (DynamicObject row : entry) {
                Long roleID = row.getLong("role.id");
                if (roleID == null || roleID <= 0L) continue;
                roleIDSet.add(roleID);
            }
            boolean isContainsCusUnicodeRole = QueryServiceHelper.exists((String)"ccm_role", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)roleIDSet.toArray()), new QFilter("basedata.id", "=", (Object)"ccm_cusunicode")});
            if (isContainsCusUnicodeRole) {
                this.getModel().setValue("autocreatearchive", (Object)Boolean.FALSE);
                this.getModel().setValue("defaultquota", (Object)BigDecimal.ZERO);
                this.getModel().setValue("defaultdays", (Object)0);
                this.getView().setVisible(Boolean.FALSE, new String[]{"autocreatearchive", "defaultquota", "defaultdays"});
            }
        }
    }
}

