/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ccm.formplugin.scheme;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.BeforeImportDataEventArgs;
import kd.bos.entity.datamodel.events.ImportDataEventArgs;
import kd.bos.entity.datamodel.events.InitImportDataEventArgs;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.org.OrgViewServiceHelper;
import kd.bos.util.StringUtils;
import kd.scmc.ccm.common.util.CommonUtils;
import kd.scmc.ccm.common.util.DateUtils;

public class CreditSchemeEditImportPlugin
extends AbstractBillPlugIn {
    private static final Log logger = LogFactory.getLog(CreditSchemeEditImportPlugin.class);
    private final Map<String, Object> tempCache = new HashMap<String, Object>();

    public void initImportData(InitImportDataEventArgs e) {
        List sourceDataList = e.getSourceDataList();
        if (sourceDataList.isEmpty()) {
            return;
        }
        IDataModel model = (IDataModel)e.getSource();
        List<Long> hasPermissionOrg = (List<Long>)this.tempCache.get("hasPermissionOrg");
        if (hasPermissionOrg == null) {
            hasPermissionOrg = CreditSchemeEditImportPlugin.getHasPermissionOrg(model.getDataEntityType().getName(), "10");
            this.tempCache.put("hasPermissionOrg", hasPermissionOrg);
        }
    }

    public void beforeImportData(BeforeImportDataEventArgs e) {
        List entrySourceData;
        Object defaultquota;
        Map<?, ?> propMap;
        Map sourceData = e.getSourceData();
        DynamicObject org = this.getOrgDataFromCache(sourceData);
        if (org == null) {
            return;
        }
        if (!CreditSchemeEditImportPlugin.checkOrgFunction((Long)org.getPkValue(), "10")) {
            e.setCancel(true);
            e.setCancelMessage(String.format(ResManager.loadKDString((String)"\u6388\u4fe1\u7ec4\u7ec7\u201c%1$s\u201d \u4e0d\u662f\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"CreditSchemeEditImportPlugin_10", (String)"scmc-ccm-formplugin", (Object[])new Object[0]), org.get("number")));
            e.setFireAfterImportData(false);
            return;
        }
        if ("0".equals(org.get("enable"))) {
            e.setCancel(true);
            e.setCancelMessage(String.format(ResManager.loadKDString((String)"\u201c\u6388\u4fe1\u7ec4\u7ec7\u201d\u4e0b\u201c\u6388\u4fe1\u7ec4\u7ec7\u7f16\u7801\uff1a%1$s\u201d\u5bfc\u5165\u5931\u8d25\u3002\u53ef\u80fd\u539f\u56e0\uff1a1. \u7f16\u7801\u9519\u8bef\uff1b2. \u4e0d\u7b26\u5408\u57fa\u7840\u8d44\u6599\u5b57\u6bb5\u67e5\u8be2\u6761\u4ef6\u3002", (String)"CreditSchemeEditImportPlugin_20", (String)"scmc-ccm-formplugin", (Object[])new Object[0]), org.get("number")));
            e.setFireAfterImportData(false);
            return;
        }
        List hasPermissionOrg = (List)this.tempCache.get("hasPermissionOrg");
        if (hasPermissionOrg == null || !hasPermissionOrg.contains((Long)org.getPkValue())) {
            e.setCancel(true);
            e.setCancelMessage(String.format(ResManager.loadKDString((String)"\u6388\u4fe1\u7ec4\u7ec7\u201c%1$s\u201d\u4e0d\u5b58\u5728\uff0c\u6216\u8005\u6ca1\u6709\u6743\u9650\u3002", (String)"CreditSchemeEditImportPlugin_9", (String)"scmc-ccm-formplugin", (Object[])new Object[0]), org.get("number")));
            e.setFireAfterImportData(false);
            return;
        }
        Object validity = sourceData.get("validity");
        Object yearBeginDate = sourceData.get("yearbegindate");
        if ("YEAR".equals(validity) && CommonUtils.isNull(yearBeginDate)) {
            e.setCancel(true);
            e.setCancelMessage(ResManager.loadKDString((String)"\u201c\u6709\u6548\u671f\u201d\u662f\u6309\u5e74\uff0c\u8bf7\u5f55\u5165\u201c\u5e74\u5ea6\u8d77\u59cb\u65e5\u201d\u3002", (String)"CreditSchemeEditImportPlugin_7", (String)"scmc-ccm-formplugin", (Object[])new Object[0]));
            e.setFireAfterImportData(false);
            return;
        }
        if ("PERPETUAL".equals(validity) && !CommonUtils.isNull(yearBeginDate)) {
            e.setCancel(true);
            e.setCancelMessage(ResManager.loadKDString((String)"\u201c\u6709\u6548\u671f\u201d\u662f\u6c38\u4e45\uff0c\u4e0d\u5141\u8bb8\u5f55\u5165\u201c\u5e74\u5ea6\u8d77\u59cb\u65e5\u201d\u3002", (String)"CreditSchemeEditImportPlugin_8", (String)"scmc-ccm-formplugin", (Object[])new Object[0]));
            e.setFireAfterImportData(false);
            return;
        }
        if (!CommonUtils.isNull(yearBeginDate)) {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
            try {
                Date dataBegin = format.parse((String)yearBeginDate);
                Date dataEnd = format.parse("2999-12-31");
                if (dataBegin.compareTo(dataEnd) > 0) {
                    e.setCancel(true);
                    e.setCancelMessage(String.format(ResManager.loadKDString((String)"\u5e74\u5ea6\u8d77\u59cb\u65e5\u7684\u503c \u201c%1$s\u201d\u8d85\u51fa\u7cfb\u7edf\u6700\u5927\u53ef\u9009\u65e5\u671f\u201c2999-12-31\u201d\u3002", (String)"CreditSchemeEditImportPlugin_21", (String)"scmc-ccm-formplugin", (Object[])new Object[0]), yearBeginDate));
                    e.setFireAfterImportData(false);
                    return;
                }
            }
            catch (ParseException exception) {
                logger.error(exception.getMessage());
            }
        }
        Boolean singlecurcontrol = (Boolean)sourceData.get("singlecurcontrol");
        Object exratetableObj = sourceData.get("exratetable");
        if (singlecurcontrol != null && !singlecurcontrol.booleanValue()) {
            if (exratetableObj == null) {
                e.setCancel(true);
                e.setCancelMessage(ResManager.loadKDString((String)"\u201c\u5e01\u79cd\u9694\u79bb\u201d\u672a\u5f00\u542f\uff0c\u8bf7\u5f55\u5165\u201c\u6c47\u7387\u8868\u201d\u3002", (String)"CreditSchemeEditImportPlugin_11", (String)"scmc-ccm-formplugin", (Object[])new Object[0]));
                e.setFireAfterImportData(false);
                return;
            }
        } else if (singlecurcontrol != null && exratetableObj != null) {
            e.setCancel(true);
            e.setCancelMessage(ResManager.loadKDString((String)"\u201c\u5e01\u79cd\u9694\u79bb\u201d\u5df2\u5f00\u542f\uff0c\u4e0d\u5141\u8bb8\u5f55\u5165\u201c\u6c47\u7387\u8868\u201d\u3002", (String)"CreditSchemeEditImportPlugin_12", (String)"scmc-ccm-formplugin", (Object[])new Object[0]));
            e.setFireAfterImportData(false);
            return;
        }
        if ((propMap = CreditSchemeEditImportPlugin.format4ImportAndApi(sourceData.get("checktype"))) == null) {
            return;
        }
        String checktypeNumber = (String)propMap.get("number");
        Boolean autocreatearchive = (Boolean)sourceData.get("autocreatearchive");
        if (Boolean.TRUE.equals(autocreatearchive)) {
            DynamicObjectCollection roleEntrys;
            String dimensionImportPro;
            DynamicObject dimensionDO;
            if (!"KZFW001".equals(checktypeNumber) && !"KZFW002".equals(checktypeNumber)) {
                e.setCancel(true);
                e.setCancelMessage(String.format(ResManager.loadKDString((String)"\u4fe1\u7528\u63a7\u5236\u5f62\u5f0f\u7f16\u7801\u4e3a\u201c%1$s\u201d\uff0c\u7981\u6b62\u81ea\u52a8\u521b\u5efa\u6863\u6848\u3002", (String)"CreditSchemeEditImportPlugin_13", (String)"scmc-ccm-formplugin", (Object[])new Object[0]), checktypeNumber));
                e.setFireAfterImportData(false);
                return;
            }
            Map<?, ?> dimensionMap = CreditSchemeEditImportPlugin.format4ImportAndApi(sourceData.get("dimension"));
            if (dimensionMap != null && (dimensionDO = BusinessDataServiceHelper.loadSingleFromCache((String)"ccm_dimension", (String)"id,number,entry.role", (QFilter[])new QFilter[]{new QFilter(dimensionImportPro = (String)dimensionMap.get("importprop"), "=", dimensionMap.get(dimensionImportPro))})) != null && (roleEntrys = dimensionDO.getDynamicObjectCollection("entry")) != null && roleEntrys.size() > 0) {
                for (DynamicObject row : roleEntrys) {
                    String basedataID = row.getString("role.basedata.id");
                    if (!"ccm_cusunicode".equals(basedataID)) continue;
                    e.setCancel(true);
                    e.setCancelMessage(ResManager.loadKDString((String)"\u4fe1\u63a7\u7ef4\u5ea6\u4e2d\u5305\u542b\u5ba2\u6237\u7edf\u4e00\u7801\u65f6\uff0c\u4e0d\u5141\u8bb8\u81ea\u52a8\u521b\u5efa\u6863\u6848\u3002", (String)"CreditSchemeEditImportPlugin_23", (String)"scmc-ccm-formplugin", (Object[])new Object[0]));
                    e.setFireAfterImportData(false);
                    return;
                }
            }
        }
        if (!((defaultquota = sourceData.get("defaultquota")) == null || defaultquota.equals("0") || !Boolean.FALSE.equals(autocreatearchive) && "KZFW001".equals(checktypeNumber))) {
            e.setCancel(true);
            e.setCancelMessage(ResManager.loadKDString((String)"\u4fe1\u7528\u63a7\u5236\u5f62\u5f0f\u4e3a\u68c0\u67e5\u4fe1\u7528\u989d\u5ea6\u4e14\u81ea\u52a8\u521b\u5efa\u6863\u6848\u65f6\uff0c\u65b9\u53ef\u5f55\u5165\u9ed8\u8ba4\u989d\u5ea6\u3002", (String)"CreditSchemeEditImportPlugin_14", (String)"scmc-ccm-formplugin", (Object[])new Object[0]));
            e.setFireAfterImportData(false);
            return;
        }
        Object defaultdays = sourceData.get("defaultdays");
        if (!(defaultdays == null || defaultdays.equals("0") || !Boolean.FALSE.equals(autocreatearchive) && "KZFW002".equals(checktypeNumber))) {
            e.setCancel(true);
            e.setCancelMessage(ResManager.loadKDString((String)"\u4fe1\u7528\u63a7\u5236\u5f62\u5f0f\u4e3a\u68c0\u67e5\u4fe1\u7528\u5929\u6570\u4e14\u81ea\u52a8\u521b\u5efa\u6863\u6848\u65f6\uff0c\u65b9\u53ef\u5f55\u5165\u9ed8\u8ba4\u4fe1\u7528\u5929\u6570\u3002", (String)"CreditSchemeEditImportPlugin_15", (String)"scmc-ccm-formplugin", (Object[])new Object[0]));
            e.setFireAfterImportData(false);
            return;
        }
        List orgEntrySourceData = (List)sourceData.get("orgentry");
        Object orgScope = sourceData.get("orgscope");
        if ("GLOBAL".equals(orgScope)) {
            if (orgEntrySourceData != null && orgEntrySourceData.size() > 0) {
                e.setCancel(true);
                e.setCancelMessage(ResManager.loadKDString((String)"\u63a7\u5236\u7ec4\u7ec7\u8303\u56f4\u662f\u201c\u96c6\u56e2\u8303\u56f4\u201d\u65f6\uff0c\u4e0d\u5141\u8bb8\u5f55\u5165\u989d\u5ea6\u5171\u4eab\u8303\u56f4\u7684\u201c\u7ec4\u7ec7\u201d\u3002", (String)"CreditSchemeEditImportPlugin_16", (String)"scmc-ccm-formplugin", (Object[])new Object[0]));
                e.setFireAfterImportData(false);
                return;
            }
        } else {
            if (orgEntrySourceData == null || orgEntrySourceData.size() == 0) {
                e.setCancel(true);
                e.setCancelMessage(ResManager.loadKDString((String)"\u63a7\u5236\u7ec4\u7ec7\u8303\u56f4\u662f\u201c\u4e1a\u52a1\u7ec4\u7ec7\u8303\u56f4\u201d\u65f6\uff0c\u8bf7\u5f55\u5165\u989d\u5ea6\u5171\u4eab\u8303\u56f4\u7684\u201d\u7ec4\u7ec7\u201d\u3002", (String)"CreditSchemeEditImportPlugin_24", (String)"scmc-ccm-formplugin", (Object[])new Object[0]));
                e.setFireAfterImportData(false);
                return;
            }
            ArrayList<String> orgNums = new ArrayList<String>(orgEntrySourceData.size());
            for (Object orgEntrySourceDatum : orgEntrySourceData) {
                if (!(orgEntrySourceDatum instanceof Map)) continue;
                Map orgEntryMap = (Map)orgEntrySourceDatum;
                Map orgMap = (Map)orgEntryMap.get("org");
                String orgNum = (String)orgMap.get("number");
                if (orgNums.contains(orgNum)) {
                    e.setCancel(true);
                    e.setCancelMessage(String.format(ResManager.loadKDString((String)"\u989d\u5ea6\u5171\u4eab\u8303\u56f4\u7684\u7ec4\u7ec7\u201c%1$s\u201d\u4e0d\u80fd\u91cd\u590d\u3002", (String)"CreditSchemeEditImportPlugin_17", (String)"scmc-ccm-formplugin", (Object[])new Object[0]), orgNum));
                    e.setFireAfterImportData(false);
                    return;
                }
                orgNums.add(orgNum);
            }
            QFilter[] filters = new QFilter[]{new QFilter("number", "in", orgNums)};
            Map bos_orgFromDB = BusinessDataServiceHelper.loadFromCache((String)"bos_org", (String)"enable,number", (QFilter[])filters);
            if (bos_orgFromDB == null || bos_orgFromDB.size() == 0) {
                return;
            }
            for (DynamicObject orgDyObj : bos_orgFromDB.values()) {
                if (CreditSchemeEditImportPlugin.checkOrgFunction((Long)orgDyObj.getPkValue(), "10")) continue;
                e.setCancel(true);
                e.setCancelMessage(String.format(ResManager.loadKDString((String)"\u989d\u5ea6\u5171\u4eab\u8303\u56f4\u7684\u7ec4\u7ec7\u201c%1$s\u201d\u4e0d\u662f\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"CreditSchemeEditImportPlugin_19", (String)"scmc-ccm-formplugin", (Object[])new Object[0]), orgDyObj.get("number")));
                e.setFireAfterImportData(false);
                return;
            }
        }
        if ((entrySourceData = (List)sourceData.get("entry")) != null && entrySourceData.size() > 0) {
            ArrayList<String> billStrategyNums = new ArrayList<String>(entrySourceData.size());
            for (Object entryObj : entrySourceData) {
                Map entryMap;
                Map billStrategyMap;
                if (!(entryObj instanceof Map) || CommonUtils.isNull((Object)(billStrategyMap = (Map)(entryMap = (Map)entryObj).get("billstrategy")))) continue;
                String billStrategyNum = (String)billStrategyMap.get("number");
                if (billStrategyNums.contains(billStrategyNum)) {
                    e.setCancel(true);
                    e.setCancelMessage(String.format(ResManager.loadKDString((String)"\u5355\u636e\u7b56\u7565\u7f16\u7801\u201c%1$s\u201d\u4e0d\u53ef\u91cd\u590d\u3002", (String)"CreditSchemeEditImportPlugin_18", (String)"scmc-ccm-formplugin", (Object[])new Object[0]), billStrategyNum));
                    e.setFireAfterImportData(false);
                    return;
                }
                billStrategyNums.add(billStrategyNum);
            }
            QFilter qFilter = new QFilter("number", "in", billStrategyNums);
            Map billsTrategyFromCache = BusinessDataServiceHelper.loadFromCache((String)"ccm_billstrategy", (String)"number,status,checktype.number,entity.number,forwardaction,reduceops,increaseops,checkops", (QFilter[])new QFilter[]{qFilter});
            if (billsTrategyFromCache == null || billsTrategyFromCache.size() == 0) {
                return;
            }
            for (DynamicObject billsTrategyObj : billsTrategyFromCache.values()) {
                String status = (String)billsTrategyObj.get("status");
                if (!"C".equals(status)) {
                    e.setCancel(true);
                    e.setCancelMessage(String.format(ResManager.loadKDString((String)"\u5355\u636e\u7b56\u7565\u201c%1$s\u201d\u4e0d\u53ef\u7528\u3002", (String)"CreditSchemeEditImportPlugin_22", (String)"scmc-ccm-formplugin", (Object[])new Object[0]), billsTrategyObj.get("number")));
                    e.setFireAfterImportData(false);
                    return;
                }
                String bschecktype = (String)billsTrategyObj.get("checktype.number");
                if (StringUtils.isNotEmpty((String)bschecktype) && !bschecktype.equals(checktypeNumber)) {
                    e.setCancel(true);
                    e.setCancelMessage(String.format(ResManager.loadKDString((String)"\u201c\u5355\u636e\u7b56\u7565\u201d\uff1a\u7f16\u7801\u201c%1$s\u201d\u7684\u4fe1\u7528\u63a7\u5236\u5f62\u5f0f\u4e0e\u5f53\u524d\u4fe1\u63a7\u65b9\u6848\u7684\u4fe1\u7528\u63a7\u5236\u5f62\u5f0f\u4e0d\u4e00\u81f4\uff0c\u8bf7\u4fee\u6539\u3002", (String)"CreditSchemeEditImportPlugin_25", (String)"scmc-ccm-formplugin", (Object[])new Object[0]), billsTrategyObj.get("number")));
                    e.setFireAfterImportData(false);
                    return;
                }
                for (DynamicObject otherBillsTrategyObj : billsTrategyFromCache.values()) {
                    if (billsTrategyObj.getPkValue().equals(otherBillsTrategyObj.getPkValue()) || !this.isSameBillStrategy(billsTrategyObj, otherBillsTrategyObj)) continue;
                    e.setCancel(true);
                    e.setCancelMessage(String.format(ResManager.loadKDString((String)"\u5b58\u5728\u540c\u4e00\u4e1a\u52a1\u5355\u636e\u4e14\u64cd\u4f5c\u76f8\u540c\uff08\u5360\u7528\u3001\u8fd4\u8fd8\u3001\u68c0\u67e5\uff09\u7684\u591a\u4e2a\u5355\u636e\u7b56\u7565\uff0c\u4e0d\u80fd\u5bfc\u5165\u3002", (String)"CreditSchemeEditImportPlugin_26", (String)"scmc-ccm-formplugin", (Object[])new Object[0]), billsTrategyObj.get("number")));
                    e.setFireAfterImportData(false);
                    return;
                }
            }
        }
    }

    private boolean isSameBillStrategy(DynamicObject billstrategy, DynamicObject otherBillstrategy) {
        if (billstrategy.getString("entity.number").equals(otherBillstrategy.getString("entity.number")) && billstrategy.getString("forwardaction").equals(otherBillstrategy.getString("forwardaction"))) {
            String forwardAction = billstrategy.getString("forwardaction");
            String reduceOps = billstrategy.getString("reduceops");
            String otherReduceops = otherBillstrategy.getString("reduceops");
            String increaseOps = billstrategy.getString("increaseops");
            String otherIncreaseOps = otherBillstrategy.getString("increaseops");
            boolean isReduceOpsEquals = false;
            boolean isIncreaseOpsEquals = false;
            if ("reduce".equals(forwardAction)) {
                if (StringUtils.isNotEmpty((String)reduceOps) && StringUtils.isNotEmpty((String)otherReduceops) && Objects.equals(reduceOps, otherReduceops)) {
                    isReduceOpsEquals = true;
                }
            } else if (StringUtils.isNotEmpty((String)increaseOps) && StringUtils.isNotEmpty((String)otherIncreaseOps) && Objects.equals(increaseOps, otherIncreaseOps)) {
                isIncreaseOpsEquals = true;
            }
            List checkops = Stream.of(billstrategy.getString("checkops").split(",")).filter(StringUtils::isNotEmpty).collect(Collectors.toList());
            List otherCheckOps = Stream.of(otherBillstrategy.getString("checkops").split(",")).filter(StringUtils::isNotEmpty).collect(Collectors.toList());
            if (isReduceOpsEquals || isIncreaseOpsEquals || !Collections.disjoint(checkops, otherCheckOps)) {
                return true;
            }
        }
        return false;
    }

    public void afterImportData(ImportDataEventArgs e) {
        DynamicObjectCollection bsEntryCol;
        IDataModel model = this.getModel();
        DynamicObject mainOrg = (DynamicObject)model.getValue("mainorg");
        if (mainOrg == null) {
            return;
        }
        String mainOrgNum = (String)mainOrg.get("number");
        DynamicObjectCollection orgEntrys = (DynamicObjectCollection)model.getValue("orgentry");
        if (orgEntrys == null || orgEntrys.size() == 0) {
            return;
        }
        ArrayList<String> orgNumFromBill = new ArrayList<String>(orgEntrys.size());
        boolean isEqual = false;
        for (DynamicObject orgEntry : orgEntrys) {
            DynamicObject org = (DynamicObject)orgEntry.get("org");
            if (org == null) continue;
            String number = (String)org.get("number");
            if (orgNumFromBill.contains(number)) {
                String errorMessage = String.format(ResManager.loadKDString((String)"\u989d\u5ea6\u5171\u4eab\u8303\u56f4\u7684\u7ec4\u7ec7\u201c%1$s\u201d\u4e0d\u80fd\u91cd\u590d\u3002", (String)"CreditSchemeEditImportPlugin_17", (String)"scmc-ccm-formplugin", (Object[])new Object[0]), number);
                throw new KDBizException(errorMessage);
            }
            if (number.equals(mainOrgNum)) {
                isEqual = true;
            }
            orgNumFromBill.add(number);
        }
        if (isEqual) {
            int row = this.getModel().createNewEntryRow("orgentry");
            model.setValue("org", (Object)mainOrg, row);
        }
        if ((bsEntryCol = (DynamicObjectCollection)model.getValue("entry")) != null && bsEntryCol.size() > 0) {
            ArrayList<String> billStrategyNums = new ArrayList<String>(bsEntryCol.size());
            for (DynamicObject billStrategyObj : bsEntryCol) {
                if (billStrategyObj == null || billStrategyObj.get("billstrategy") == null) continue;
                DynamicObject billstrategy = (DynamicObject)billStrategyObj.get("billstrategy");
                String billStrategyNum = billstrategy.getString("number");
                if (billStrategyNums.contains(billStrategyNum)) {
                    String errorMessage = String.format(ResManager.loadKDString((String)"\u5355\u636e\u7b56\u7565\u7f16\u7801\u201c%1$s\u201d\u4e0d\u53ef\u91cd\u590d\u3002", (String)"CreditSchemeEditImportPlugin_18", (String)"scmc-ccm-formplugin", (Object[])new Object[0]), billStrategyNum);
                    throw new KDBizException(errorMessage);
                }
                billStrategyNums.add(billStrategyNum);
            }
        }
        model.setValue("status", (Object)"A");
        model.setValue("orgfunc", (Object)"HSZZ");
        model.setValue("issys", (Object)Boolean.FALSE);
        Object validity = model.getValue("validity");
        if ("YEAR".equals(validity)) {
            Object yearbegindate = model.getValue("yearbegindate");
            if (!CommonUtils.isNull((Object)yearbegindate)) {
                model.setValue("yearenddate", (Object)DateUtils.getYearsLaterDate((Date)((Date)yearbegindate), (int)1));
            }
        } else if ("PERPETUAL".equals(validity)) {
            model.setValue("yearenddate", null);
            model.setValue("yearbegindate", null);
        }
    }

    private static Map<?, ?> format4ImportAndApi(Object sourceData) {
        if (sourceData instanceof JSONObject) {
            return (Map)SerializationUtils.fromJsonString((String)sourceData.toString(), Map.class);
        }
        if (sourceData instanceof Map) {
            Map propMap = (Map)sourceData;
            if (propMap.get("id") != null) {
                propMap.put("importprop", "id");
            } else if (propMap.get("number") != null) {
                propMap.put("importprop", "number");
            } else if (propMap.get("name") != null) {
                propMap.put("importprop", "name");
            }
            return (Map)sourceData;
        }
        if (sourceData instanceof JSONArray) {
            ArrayList<Object> list = new ArrayList<Object>(((JSONArray)sourceData).size());
            HashMap<String, ArrayList<Object>> propMap = new HashMap<String, ArrayList<Object>>(((JSONArray)sourceData).size());
            JSONArray Ids = (JSONArray)sourceData;
            for (int i = 0; i < Ids.size(); ++i) {
                Object obj1 = Ids.toArray()[i];
                list.add(obj1);
            }
            propMap.put("sourceData", list);
            return propMap;
        }
        if (sourceData instanceof ArrayList) {
            HashMap<String, Object> propMap = new HashMap<String, Object>(((ArrayList)sourceData).size());
            propMap.put("sourceData", sourceData);
            return propMap;
        }
        return null;
    }

    private DynamicObject getOrgDataFromCache(Map<String, Object> sourceData) {
        if (sourceData == null) {
            return null;
        }
        Map<?, ?> propMap = CreditSchemeEditImportPlugin.format4ImportAndApi(sourceData.get("mainorg"));
        String importProp = null;
        if (propMap != null) {
            importProp = (String)propMap.get("importprop");
            DynamicObject value = (DynamicObject)this.tempCache.get("mainorg_" + propMap.get(importProp));
            if (value == null && !"id".equals(importProp)) {
                QFilter[] qFilters = new QFilter[]{new QFilter(importProp, "=", propMap.get(importProp))};
                value = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_org", (String)"enable,number", (QFilter[])qFilters);
                this.tempCache.put("mainorg_" + propMap.get(importProp), value);
            }
            return value;
        }
        return null;
    }

    private static List<Long> getHasPermissionOrg(String entityName, String orgViewType) {
        List hasPermissionOrgs = OrgViewServiceHelper.getAllPermissionOrgs((String)entityName, (String)orgViewType);
        if (CommonUtils.isNull((Object)hasPermissionOrgs)) {
            return null;
        }
        ArrayList<Long> orgs = new ArrayList<Long>(hasPermissionOrgs.size());
        for (Map tempOrg : hasPermissionOrgs) {
            Long tempOrgId = Long.valueOf((String)tempOrg.get("id"));
            orgs.add(tempOrgId);
        }
        return orgs;
    }

    private static boolean checkOrgFunction(Long orgID, String orgType) {
        return OrgUnitServiceHelper.checkOrgFunction((Long)orgID, (String)orgType);
    }
}

