/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ccm.business;

import kd.bos.dataentity.entity.DynamicObject;
import kd.scmc.ccm.business.pojo.CreditScheme;
import kd.scmc.ccm.business.service.CreditCheckServiceImpl;
import kd.scmc.ccm.business.service.CreditUpdateServiceImpl;
import kd.scmc.ccm.business.service.ICreditService;
import kd.scmc.ccm.business.service.applylock.CreditSyncApplyService;
import kd.scmc.ccm.business.service.applylock.ICreditSyncApplyService;
import kd.scmc.ccm.business.service.archive.CreditArchiveServiceImpl;
import kd.scmc.ccm.business.service.archive.ICreditArchiveService;
import kd.scmc.ccm.business.service.archive.loader.DefaultArchiveLoader;
import kd.scmc.ccm.business.service.archive.loader.IArchiveLoader;
import kd.scmc.ccm.business.service.archive.loader.OverdueArchiveLoader;
import kd.scmc.ccm.business.service.checkexecutor.CreditChecker;
import kd.scmc.ccm.business.service.checkexecutor.CreditCheckerDecorator;
import kd.scmc.ccm.business.service.checkexecutor.OverdueAmountChecker;
import kd.scmc.ccm.business.service.checkexecutor.OverdueChecker;
import kd.scmc.ccm.business.service.checkexecutor.QuotaCreditChecker;
import kd.scmc.ccm.business.service.entityconfig.CreditEntityConServiceImpl;
import kd.scmc.ccm.business.service.entityconfig.ICreditEntityConService;
import kd.scmc.ccm.business.service.scheme.CreditSchemeServiceImpl;
import kd.scmc.ccm.business.service.scheme.ICreditSchemeService;
import kd.scmc.ccm.business.service.snapshot.CreditSnapshotCreateServiceImpl;
import kd.scmc.ccm.business.service.snapshot.ICreditSnapshotCreateService;

public abstract class CreditServiceFactory {
    public static ICreditService doCreateCheckService(DynamicObject[] bills, String operateKey) {
        return new CreditCheckServiceImpl(bills, operateKey);
    }

    public static ICreditService doCreateUpdateService(DynamicObject[] bills, String operateKey) {
        return new CreditUpdateServiceImpl(bills, operateKey);
    }

    public static ICreditSchemeService doCreateEffectiveCreditScheme(DynamicObject[] bills) {
        return new CreditSchemeServiceImpl(bills);
    }

    public static ICreditEntityConService doCreateCreditEntityConService() {
        return new CreditEntityConServiceImpl();
    }

    public static CreditChecker doCreateCreditChecker(String quotaType) {
        return CreditCheckerFactory.getCreditChecker(quotaType);
    }

    public static ICreditSnapshotCreateService doCreateCreditSnapshotCreateService(CreditScheme cs, boolean isReverse) {
        return new CreditSnapshotCreateServiceImpl(cs, isReverse);
    }

    public static ICreditSyncApplyService doCreateCreditSyncApplyService() {
        return CreditSyncApplyService.doCreate();
    }

    public static ICreditArchiveService doCreateCreditArchiveService() {
        return CreditArchiveServiceImpl.doCreate();
    }

    public static IArchiveLoader doCreateArchiveLoader(String quotaType) {
        return ArchiveLoaderFactory.getArchiveLoader(quotaType);
    }

    static class ArchiveLoaderFactory {
        ArchiveLoaderFactory() {
        }

        public static IArchiveLoader getArchiveLoader(String quotaType) {
            if ("amount".equals(quotaType) || "qty".equals(quotaType) || "privilegeamt".equals(quotaType) || "privilegeday".equals(quotaType)) {
                return new DefaultArchiveLoader();
            }
            if ("days".equals(quotaType) || "overdueamt".equals(quotaType)) {
                return new OverdueArchiveLoader();
            }
            return null;
        }
    }

    static class CreditCheckerFactory {
        CreditCheckerFactory() {
        }

        public static CreditChecker getCreditChecker(String quotaType) {
            if ("amount".equals(quotaType) || "qty".equals(quotaType) || "privilegeamt".equals(quotaType)) {
                return new CreditCheckerDecorator(new QuotaCreditChecker());
            }
            if ("days".equals(quotaType) || "privilegeday".equals(quotaType)) {
                return new OverdueChecker();
            }
            if ("overdueamt".equals(quotaType)) {
                return new OverdueAmountChecker();
            }
            return null;
        }
    }
}

