/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ccm.business.formulavalue;

import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.formula.FormulaEngine;
import kd.scmc.ccm.business.formulavalue.ValueGetter;
import kd.scmc.ccm.business.pojo.Field;
import kd.scmc.ccm.business.pojo.exprfilter.CreditFormula;

public class FormulaValueGetter
implements ValueGetter {
    private CreditFormula formula;
    private Field directValueGetField;

    public FormulaValueGetter(CreditFormula formula) {
        String expression;
        this.formula = formula;
        List<Field> fields = formula.getFields();
        if (fields.size() == 1 && Objects.equals(expression = formula.getExpression(), fields.get(0).getKey())) {
            this.directValueGetField = fields.get(0);
        }
    }

    @Override
    public Object get(DynamicObject source) {
        List<Field> fields = this.formula.getFields();
        if (this.directValueGetField != null) {
            return this.directValueGetField.getValue(source);
        }
        HashMap<String, Object> params = new HashMap<String, Object>(fields.size());
        for (Field field : fields) {
            Object value = field.getValue(source);
            if (field.getRefProp() != null) {
                params.put(field.getKey() + "." + field.getRefProp(), value);
                continue;
            }
            params.put(field.getKey(), value);
        }
        return FormulaEngine.execExcelFormula((String)this.formula.getExpression(), params);
    }
}

