/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ccm.business.helper;

import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.scmc.ccm.business.pojo.BillStrategy;
import kd.scmc.ccm.business.pojo.CreditScheme;
import kd.scmc.ccm.business.pojo.Dimension;
import kd.scmc.ccm.business.pojo.EntityConfig;
import kd.scmc.ccm.business.pojo.Field;
import kd.scmc.ccm.business.pojo.Role;

public class CreditSchemeValidatorHelper {
    public static void validate(List<CreditScheme> usefulSchemeList) {
        usefulSchemeList.stream().forEach(row -> CreditSchemeValidatorHelper.validate(row));
    }

    private static void validate(CreditScheme scheme) {
        CreditSchemeValidatorHelper.checkSchemeBizState(scheme);
        CreditSchemeValidatorHelper.checkSetting(scheme);
    }

    private static void checkSetting(CreditScheme scheme) {
        Dimension dimension = scheme.getDimension();
        List<Role> roles = dimension.getRoles();
        List<BillStrategy> billStrategies = scheme.getBillStrategies();
        for (BillStrategy billStrategy : billStrategies) {
            EntityConfig config = billStrategy.getConfig();
            for (Role role : roles) {
                Field roleField = config.getRoleField(role.getRoleType());
                if (roleField != null) continue;
                String entityKey = config.getEntityKey();
                MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)entityKey);
                String entityDisplayName = dataEntityType.getDisplayName().getLocaleValue();
                String tipMsg = String.format(ResManager.loadKDString((String)"\u4fe1\u7528\u7ba1\u7406\uff1a\u6ca1\u6709\u914d\u7f6e %1$s%2$s\u5b57\u6bb5\u6620\u5c04\uff0c\u8bf7\u524d\u5f80\u5355\u636e\u6ce8\u518c\u754c\u9762\u8fdb\u884c\u914d\u7f6e\u3002", (String)"CreditSchemeValidatorHelper_0", (String)"scmc-ccm", (Object[])new Object[0]), entityDisplayName, role.getRoleName());
                throw new KDBizException(tipMsg);
            }
        }
    }

    private static void checkSchemeBizState(CreditScheme scheme) {
        String bizstate = scheme.getBizstate();
        String name = scheme.getName();
        if ("initing".equals(bizstate)) {
            String tipMsg = String.format(ResManager.loadKDString((String)"\u4fe1\u7528\u65b9\u6848%s\u6b63\u5728\u91cd\u7b97\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"CreditSchemeValidatorHelper_1", (String)"scmc-ccm", (Object[])new Object[0]), name);
            throw new KDBizException(tipMsg);
        }
    }
}

