/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ccm.business.helper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.scmc.ccm.business.pojo.journal.Journal;
import kd.scmc.ccm.business.pojo.journal.JournalGroup;
import kd.scmc.ccm.business.service.CreditOpTxListener;
import kd.scmc.ccm.business.service.archive.CreditArchive;

public class CreditUpdateHelper {
    private static final Log logger = LogFactory.getLog(CreditOpTxListener.class);

    public static void exeCreditUpdate(List<JournalGroup> journalGroupList, List<CreditArchive> updateArchiveList, String opJournal) {
        try (TXHandle tx = TX.required();){
            try {
                if ("save".equals(opJournal)) {
                    CreditUpdateHelper.saveJournals(journalGroupList);
                } else {
                    CreditUpdateHelper.deleteJournals(journalGroupList);
                }
                CreditUpdateHelper.saveArchives(updateArchiveList);
            }
            catch (Exception e) {
                tx.markRollback();
                throw e;
            }
        }
    }

    private static void saveJournals(List<JournalGroup> journalGroups) {
        try (TraceSpan traceSpan = Tracer.create((String)"CreditOpTxListener", (String)"ccm.savejournals");){
            LinkedList<DynamicObject> dynJournals = new LinkedList<DynamicObject>();
            for (JournalGroup journalGroup : journalGroups) {
                for (Journal journal : journalGroup.getJournals()) {
                    if (journal.getArchiveId() == 0L) continue;
                    dynJournals.add(journal.toDynamicObject());
                }
            }
            if (!dynJournals.isEmpty()) {
                SaveServiceHelper.save((DynamicObject[])dynJournals.toArray(new DynamicObject[0]));
                logger.info("\u4fdd\u5b58\u6d41\u6c34\u6210\u529f");
            }
        }
    }

    private static void saveArchives(Collection<CreditArchive> archives) {
        try (TraceSpan traceSpan = Tracer.create((String)"CreditOpTxListener", (String)"ccm.savearchives");){
            ArrayList<DynamicObject> rawArchives = new ArrayList<DynamicObject>(archives.size());
            for (CreditArchive archive : archives) {
                rawArchives.addAll(archive.getRawArchives());
            }
            if (!rawArchives.isEmpty()) {
                SaveServiceHelper.save((DynamicObject[])rawArchives.toArray(new DynamicObject[0]));
            }
        }
    }

    private static void deleteJournals(List<JournalGroup> journalGroups) {
        try (TraceSpan traceSpan = Tracer.create((String)"CreditOpTxListener", (String)"ccm.deletejournals");){
            HashSet<Long> journalPks = new HashSet<Long>(16);
            for (JournalGroup journalGroup : journalGroups) {
                for (Journal journal : journalGroup.getJournals()) {
                    journalPks.add(journal.getJournalId());
                }
            }
            if (!journalPks.isEmpty()) {
                OperationResult operationResult = OperationServiceHelper.executeOperate((String)"delete", (String)"ccm_journal", (Object[])journalPks.toArray(new Long[0]), (OperateOption)OperateOption.create());
            }
        }
    }
}

