/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ccm.business.helper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scmc.ccm.business.pojo.CreditScheme;
import kd.scmc.ccm.business.pojo.DimensionValue;
import kd.scmc.ccm.business.pojo.Role;

public class DimensionValueControlledHelper {
    public static List<DimensionValue> getControlledDimensionValues(CreditScheme scheme, List<DimensionValue> dimensionValues) {
        List<Role> roles = scheme.getDimension().getRoles();
        for (Role role : roles) {
            if (!role.getIsControled()) continue;
            return new ArrayList<DimensionValue>(dimensionValues);
        }
        LinkedList<Long> roleValueIdList = new LinkedList<Long>();
        for (DimensionValue dimensionValue : dimensionValues) {
            for (Role role : roles) {
                String roleType = role.getRoleType();
                if ("CUSUNICODE".equals(roleType) || role.getIsControled()) continue;
                Object roleValue = dimensionValue.getValue(role);
                if (roleValue == null) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u4fe1\u7528\u7ba1\u7406\u5355\u636e\u6ce8\u518c%s\u5b57\u6bb5\u53d6\u4e0d\u5230\u503c\uff0c\u8bf7\u68c0\u67e5\u5355\u636e\u6ce8\u518c\u914d\u7f6e\u3002", (String)"DimensionValueControlledHelper_0", (String)"scmc-ccm", (Object[])new Object[]{role.getRoleName()}));
                }
                roleValueIdList.add(Long.valueOf(String.valueOf(roleValue)));
            }
        }
        DynamicObjectCollection dynamicObjectCollection = QueryServiceHelper.query((String)"ccm_controlstatus", (String)"role.basedata,rolevalueid", (QFilter[])new QFilter[]{new QFilter("rolevalueid", "in", roleValueIdList), new QFilter("controlstatus", "=", (Object)"1")});
        HashMap controlRoleIdMap = new HashMap(16);
        for (DynamicObject cs : dynamicObjectCollection) {
            if (cs == null) continue;
            String roleBaseType = cs.getString("role.basedata");
            Long roleValueID = cs.getLong("rolevalueid");
            if (!StringUtils.isBlank((CharSequence)roleBaseType) && controlRoleIdMap.get(roleBaseType) != null) {
                ((Set)controlRoleIdMap.get(roleBaseType)).add(roleValueID);
                continue;
            }
            if (StringUtils.isBlank((CharSequence)roleBaseType) || controlRoleIdMap.get(roleBaseType) != null) continue;
            HashSet<Long> controledRoleIds = new HashSet<Long>(16);
            controledRoleIds.add(roleValueID);
            controlRoleIdMap.put(roleBaseType, controledRoleIds);
        }
        ArrayList<DimensionValue> controlledDimensionValues = new ArrayList<DimensionValue>(dimensionValues.size());
        for (DimensionValue dimensionValue : dimensionValues) {
            boolean isControled = true;
            for (Role role : roles) {
                String roleType = role.getRoleType();
                String bdKey = role.getBasedataEntityKey();
                if (!"CUSUNICODE".equals(roleType) && !role.getIsControled()) {
                    Object roleValue = dimensionValue.getValue(role);
                    if (roleValue == null) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u5355\u636e\u6ce8\u518c\u201c%s\u201d\u914d\u7f6e\u6709\u8bef\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"DimensionValueControlledHelper_1", (String)"scmc-ccm", (Object[])new Object[]{role.getRoleName()}));
                    }
                    Set roleControledRoleIds = (Set)controlRoleIdMap.get(bdKey);
                    isControled = roleControledRoleIds != null ? (roleValue instanceof Long ? roleControledRoleIds.contains((Long)roleValue) : roleControledRoleIds.contains(Long.valueOf(roleValue.toString()))) : false;
                }
                if (isControled) continue;
                break;
            }
            if (!isControled) continue;
            controlledDimensionValues.add(dimensionValue);
        }
        return controlledDimensionValues;
    }
}

