/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ccm.business.helper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.LinkEntryProp;
import kd.bos.entity.property.MainOrgProp;
import kd.bos.servicehelper.MetadataServiceHelper;

public class MetaDataHelper {
    public static DynamicProperty getProperty(String entityKey, String key) {
        MainEntityType dt = MetadataServiceHelper.getDataEntityType((String)entityKey);
        return MetaDataHelper.getProperty(dt, key);
    }

    public static DynamicProperty getProperty(MainEntityType dt, String key) {
        DynamicProperty property = dt.getProperty(key);
        if (property == null) {
            List<EntryProp> entryProps = MetaDataHelper.getEntryProps((IDataEntityType)dt);
            for (EntryProp entryProp : entryProps) {
                property = entryProp._collectionItemPropertyType.getProperty(key);
                if (property == null) continue;
                return property;
            }
        }
        return property;
    }

    public static boolean containsProperty(IDataEntityType dataEntityType, String fieldName) {
        return MetaDataHelper.getProperty((MainEntityType)dataEntityType, fieldName) != null;
    }

    public static boolean containsEntryField(Collection<String> fields, MainEntityType dataEntityType) {
        for (String field : fields) {
            if (!MetaDataHelper.isEntryField(dataEntityType, field)) continue;
            return true;
        }
        return false;
    }

    public static boolean isEntryField(MainEntityType dt, String propName) {
        List<EntryProp> entryProps = MetaDataHelper.getEntryProps((IDataEntityType)dt);
        String prefix = MetaDataHelper.getPrefix(propName);
        for (EntryProp entryProp : entryProps) {
            if (!entryProp.getName().equalsIgnoreCase(prefix)) continue;
            return true;
        }
        DynamicProperty property = dt.getProperty(prefix);
        return property == null;
    }

    public static String getEntryKey(MainEntityType dt, String propName) {
        String prefix = MetaDataHelper.getPrefix(propName);
        List<EntryProp> entryProps = MetaDataHelper.getEntryProps((IDataEntityType)dt);
        for (EntryProp entryProp : entryProps) {
            if (entryProp._collectionItemPropertyType.getProperty(prefix) == null) continue;
            return entryProp.getName();
        }
        return null;
    }

    private static String getPrefix(String str) {
        int index = str.indexOf(46);
        index = index > 0 ? index : str.length();
        return str.substring(0, index);
    }

    public static List<String> getProperties(DynamicObject bill) {
        ArrayList<String> props = new ArrayList<String>();
        DataEntityPropertyCollection properties = bill.getDataEntityType().getProperties();
        for (IDataEntityProperty prop : properties) {
            if (prop instanceof EntryProp) {
                DataEntityPropertyCollection entryProperties = ((EntryProp)prop)._collectionItemPropertyType.getProperties();
                for (IDataEntityProperty eProp : entryProperties) {
                    props.add(eProp.getName());
                }
            }
            props.add(prop.getName());
        }
        return props;
    }

    public static List<IDataEntityProperty> getProperties(String entityKey) {
        MainEntityType journalEntityDataType = MetadataServiceHelper.getDataEntityType((String)entityKey);
        ArrayList<IDataEntityProperty> props = new ArrayList<IDataEntityProperty>();
        DataEntityPropertyCollection properties = journalEntityDataType.getProperties();
        for (IDataEntityProperty prop : properties) {
            if (prop instanceof EntryProp) {
                DataEntityPropertyCollection entryProperties = ((EntryProp)prop)._collectionItemPropertyType.getProperties();
                for (IDataEntityProperty eProp : entryProperties) {
                    props.add(eProp);
                }
                continue;
            }
            props.add(prop);
        }
        return props;
    }

    public static List<EntryProp> getEntryProps(IDataEntityType dataType) {
        ArrayList<EntryProp> entrys = new ArrayList<EntryProp>();
        DataEntityPropertyCollection properties = dataType.getProperties();
        for (IDataEntityProperty pro : properties) {
            if (!(pro instanceof EntryProp) || pro instanceof LinkEntryProp) continue;
            entrys.add((EntryProp)pro);
        }
        return entrys;
    }

    public static IDataEntityProperty getMainOrgProp(String entityKey) {
        MainEntityType dt = MetadataServiceHelper.getDataEntityType((String)entityKey);
        DataEntityPropertyCollection properties = dt.getProperties();
        for (IDataEntityProperty prop : properties) {
            if (!(prop instanceof MainOrgProp)) continue;
            return prop;
        }
        return null;
    }

    public static boolean isExistProperty(DynamicObject bill, String propertyName) {
        DynamicProperty property;
        boolean isExistProperty = false;
        DynamicObjectType dynamicObjectType = bill.getDynamicObjectType();
        if (dynamicObjectType != null && (property = dynamicObjectType.getProperty(propertyName)) != null) {
            isExistProperty = true;
        }
        return isExistProperty;
    }
}

