/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ccm.business.pojo;

import java.io.Serializable;
import java.math.BigDecimal;
import kd.scmc.ccm.business.pojo.CreditScheme;

public class CheckResult
implements Serializable {
    public static final String MESSAGE_TYPE_WARNING = "warning";
    public static final String MESSAGE_TYPE_ERROR = "error";
    private String billno;
    private boolean success;
    private String message;
    private String messageType;
    private String handler;
    private long schemeId;
    private BigDecimal balance;
    private BigDecimal amount;
    private long unit;
    private String direction;

    public CheckResult() {
    }

    public CheckResult(boolean success, String messageType, String message) {
        this.success = success;
        this.messageType = messageType;
        this.message = message;
    }

    public CheckResult(CreditScheme scheme, String entityKey) {
        this.schemeId = scheme.getId();
        String mode = scheme.getBillStrategy(entityKey).getMode();
        if (MESSAGE_TYPE_WARNING.equals(mode)) {
            this.messageType = MESSAGE_TYPE_WARNING;
        } else if ("cancel".equals(mode)) {
            this.messageType = MESSAGE_TYPE_ERROR;
        } else {
            throw new IllegalArgumentException("Unknown scheme mode:" + mode);
        }
    }

    public String getBillno() {
        return this.billno;
    }

    public void setBillno(String billno) {
        this.billno = billno;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getMessageType() {
        return this.messageType;
    }

    public void setMessageType(String messageType) {
        this.messageType = messageType;
    }

    public String getHandler() {
        return this.handler;
    }

    public void setHandler(String handler) {
        this.handler = handler;
    }

    public long getSchemeId() {
        return this.schemeId;
    }

    public void setSchemeId(long schemeId) {
        this.schemeId = schemeId;
    }

    public BigDecimal getBalance() {
        return this.balance;
    }

    public void setBalance(BigDecimal balance) {
        this.balance = balance;
    }

    public BigDecimal getAmount() {
        return this.amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public long getUnit() {
        return this.unit;
    }

    public void setUnit(long unit) {
        this.unit = unit;
    }

    public String getDirection() {
        return this.direction;
    }

    public void setDirection(String direction) {
        this.direction = direction;
    }

    public String toString() {
        return "CheckResult{billno='" + this.billno + '\'' + ", success=" + this.success + ", message='" + this.message + '\'' + ", messageType='" + this.messageType + '\'' + ", handler='" + this.handler + '\'' + ", schemeId=" + this.schemeId + ", balance=" + this.balance + ", amount=" + this.amount + ", unit=" + this.unit + ", direction='" + this.direction + '\'' + '}';
    }
}

