/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ccm.business.pojo;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import kd.scmc.ccm.business.formulavalue.ValueGetter;
import kd.scmc.ccm.business.pojo.BillStrategy;
import kd.scmc.ccm.business.pojo.CreditElement;
import kd.scmc.ccm.business.pojo.Dimension;
import kd.scmc.ccm.business.pojo.EntityConfig;
import kd.scmc.ccm.business.pojo.QuotaType;
import kd.scmc.ccm.business.pojo.exprfilter.Expression;
import kd.scmc.ccm.common.util.CreditContext;

public class CreditScheme
implements Serializable {
    private long id;
    private String number;
    private String name;
    private Dimension dimension;
    private long currency;
    private boolean singleCurrencyControl;
    private long exchangeRateTable;
    private QuotaType quotaType;
    private transient List<BillStrategy> billStrategies = new ArrayList<BillStrategy>();
    private boolean globalScheme;
    private List<Long> orgScopes = new LinkedList<Long>();
    private String bizstate;
    private String orgscope;
    private boolean autocreatearchive;
    private String checktypenumber;
    private String validity;
    private BigDecimal defaultquota;
    private BigDecimal defaultdays;
    private Date yearbegindate;

    public BillStrategy getBillStrategy(String entityKey) {
        for (BillStrategy billSetting : this.billStrategies) {
            if (!Objects.equals(billSetting.getEntityKey(), entityKey)) continue;
            return billSetting;
        }
        throw new IllegalArgumentException("Unsupported entityKey=" + entityKey);
    }

    public List<Expression> getExpressions(CreditContext context) {
        return this.getBillStrategy(context.getEntityKey()).getExpressions();
    }

    public ValueGetter getValueGetter(CreditContext context, CreditElement element) {
        BillStrategy billStrategy = this.getBillStrategy(context.getEntityKey());
        return billStrategy.getValueGetter(element);
    }

    public long getExchangeRateTable() {
        return this.exchangeRateTable;
    }

    public void setExchangeRateTable(long exchangeRateTable) {
        this.exchangeRateTable = exchangeRateTable;
    }

    public EntityConfig getEntityConfig(CreditContext context) {
        return this.getBillStrategy(context.getEntityKey()).getConfig();
    }

    public List<BillStrategy> getBillStrategies() {
        return this.billStrategies;
    }

    public void setBillStrategies(List<BillStrategy> billStrategies) {
        this.billStrategies = billStrategies;
    }

    public QuotaType getQuotaType() {
        return this.quotaType;
    }

    public void setQuotaType(QuotaType quotaType) {
        this.quotaType = quotaType;
    }

    public boolean isGlobalScheme() {
        return this.globalScheme;
    }

    public void setGlobalScheme(boolean globalScheme) {
        this.globalScheme = globalScheme;
    }

    public List<Long> getOrgScopes() {
        return this.orgScopes;
    }

    public void setOrgScopes(List<Long> orgScopes) {
        this.orgScopes = orgScopes;
    }

    public Dimension getDimension() {
        return this.dimension;
    }

    public void setDimension(Dimension dimension) {
        this.dimension = dimension;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public long getCurrency() {
        return this.currency;
    }

    public void setCurrency(long currency) {
        this.currency = currency;
    }

    public boolean isSingleCurrencyControl() {
        return this.singleCurrencyControl;
    }

    public void setSingleCurrencyControl(boolean singleCurrencyControl) {
        this.singleCurrencyControl = singleCurrencyControl;
    }

    public String getNumber() {
        return this.number;
    }

    public void setNumber(String number) {
        this.number = number;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getBizstate() {
        return this.bizstate;
    }

    public void setBizstate(String bizstate) {
        this.bizstate = bizstate;
    }

    public String getOrgscope() {
        return this.orgscope;
    }

    public void setOrgscope(String orgscope) {
        this.orgscope = orgscope;
    }

    public void setAutocreatearchive(boolean autocreatearchive) {
        this.autocreatearchive = autocreatearchive;
    }

    public String getChecktypenumber() {
        return this.checktypenumber;
    }

    public void setChecktypenumber(String checktypenumber) {
        this.checktypenumber = checktypenumber;
    }

    public boolean isAutocreatearchive() {
        return this.autocreatearchive;
    }

    public String getValidity() {
        return this.validity;
    }

    public void setValidity(String validity) {
        this.validity = validity;
    }

    public BigDecimal getDefaultquota() {
        return this.defaultquota;
    }

    public void setDefaultquota(BigDecimal defaultquota) {
        this.defaultquota = defaultquota;
    }

    public BigDecimal getDefaultdays() {
        return this.defaultdays;
    }

    public void setDefaultdays(BigDecimal defaultdays) {
        this.defaultdays = defaultdays;
    }

    public Date getYearbegindate() {
        return this.yearbegindate;
    }

    public void setYearbegindate(Date yearbegindate) {
        this.yearbegindate = yearbegindate;
    }

    public String toString() {
        return "{id=" + this.id + ", number='" + this.number + '\'' + ", name='" + this.name + '\'' + ", dimension=" + this.dimension + ", currency=" + this.currency + ", singleCurrencyControl=" + this.singleCurrencyControl + ", exchangeRateTable=" + this.exchangeRateTable + ", quotaType=" + this.quotaType + ", globalScheme=" + this.globalScheme + ", orgScopes=" + this.orgScopes + '}';
    }
}

